/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SubInputStream
extends FilterInputStream {
    private long bytesToRead;
    private boolean closeUnderlying;

    public SubInputStream(InputStream inputStream, long l, boolean bl) {
        super(inputStream);
        this.bytesToRead = l;
        this.closeUnderlying = bl;
    }

    public SubInputStream(InputStream inputStream, long l) {
        this(inputStream, l, false);
    }

    @Override
    public int read() throws IOException {
        if (this.bytesToRead > 0L) {
            int n = super.read();
            if (n >= 0) {
                --this.bytesToRead;
                return n;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesToRead == 0L) {
            return -1;
        }
        int n3 = (int)Math.min(this.bytesToRead, (long)n2);
        int n4 = super.read(byArray, n, n3);
        if (n4 >= 0) {
            this.bytesToRead -= (long)n4;
        }
        return n4;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = Math.min(this.bytesToRead, l);
        long l3 = super.skip(l2);
        this.bytesToRead -= l3;
        return l3;
    }

    @Override
    public void close() throws IOException {
        this.bytesToRead = 0L;
        if (this.closeUnderlying) {
            super.close();
        }
    }
}

