/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.PT;
import jspecview.api.JSVExporter;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.Spectrum;
import jspecview.export.JDXCompressor;
import jspecview.source.JDXReader;

public class JDXExporter
implements JSVExporter {
    public static final String newLine = System.getProperty("line.separator");
    private OC out;
    private ExportType type;
    private Spectrum spectrum;
    private JSViewer vwr;
    private static final double FACTOR_DIVISOR = 1000000.0;

    @Override
    public String exportTheSpectrum(JSViewer viewer, ExportType type, OC out, Spectrum spectrum, int startIndex, int endIndex, PanelData pd, boolean asBase64) throws IOException {
        this.out = out;
        this.type = type;
        this.spectrum = spectrum;
        this.vwr = viewer;
        this.toStringAux(startIndex, endIndex);
        out.closeChannel();
        return "OK " + out.getByteCount() + " bytes";
    }

    private void toStringAux(int startIndex, int endIndex) {
        Coordinate[] newXYCoords = this.spectrum.getXYCoords();
        String tabDataSet = "";
        String tmpDataClass = "XYDATA";
        if (this.spectrum.isHZtoPPM()) {
            Coordinate[] xyCoords = newXYCoords;
            newXYCoords = new Coordinate[xyCoords.length];
            for (int i = 0; i < xyCoords.length; ++i) {
                newXYCoords[i] = xyCoords[i].copy();
            }
            Coordinate.applyScale(newXYCoords, this.spectrum.getObservedFreq(), 1.0);
        }
        double xCompFactor = this.spectrum.getXFactor();
        boolean isIntegerX = JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, 1.0, true);
        if (!isIntegerX && !JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, xCompFactor, true)) {
            xCompFactor = 1.0;
        }
        double minY = Coordinate.getMinY(newXYCoords, startIndex, endIndex);
        double maxY = Coordinate.getMaxY(newXYCoords, startIndex, endIndex);
        double yCompFactor = this.spectrum.getYFactor();
        switch (this.type) {
            case XY: {
                yCompFactor = 1.0;
                tmpDataClass = this.spectrum.isContinuous() ? "XYDATA" : "XYPOINTS";
                break;
            }
            case PAC: {
                yCompFactor = 1.0;
                break;
            }
            default: {
                boolean isIntegerY = JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, 1.0, false);
                if (isIntegerY || JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, yCompFactor, false)) break;
                yCompFactor = (maxY - minY) / 1000000.0;
            }
        }
        int step = 1;
        if (this.spectrum.isExportXAxisLeftToRight() != this.spectrum.getFirstX() < this.spectrum.getLastX()) {
            int t = startIndex;
            startIndex = endIndex;
            endIndex = t;
            step = -1;
        }
        switch (this.type) {
            case DIF: 
            case DIFDUP: {
                tabDataSet = JDXCompressor.compressDIF(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor, this.type == ExportType.DIFDUP);
                break;
            }
            case FIX: {
                tabDataSet = JDXCompressor.compressFIX(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case PAC: {
                tabDataSet = JDXCompressor.compressPAC(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case SQZ: {
                tabDataSet = JDXCompressor.compressSQZ(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case XY: {
                tabDataSet = JDXCompressor.getXYList(newXYCoords, startIndex, endIndex, step);
                break;
            }
        }
        String varList = JDXReader.getVarList(tmpDataClass);
        this.getHeaderString(tmpDataClass, minY, maxY, xCompFactor, yCompFactor, startIndex, endIndex);
        this.out.append("##" + tmpDataClass + "= " + varList + newLine);
        this.out.append(tabDataSet);
        this.out.append("##END=");
    }

    private void getHeaderString(String tmpDataClass, double minY, double maxY, double tmpXFactor, double tmpYFactor, int startIndex, int endIndex) {
        this.out.append("##TITLE= ").append(this.spectrum.getTitle()).append(newLine);
        this.out.append("##JCAMP-DX= 5.01").append(newLine);
        this.out.append("##DATA TYPE= ").append(this.spectrum.getDataType()).append(newLine);
        this.out.append("##DATA CLASS= ").append(tmpDataClass).append(newLine);
        this.out.append("##ORIGIN= ").append(this.spectrum.getOrigin()).append(newLine);
        this.out.append("##OWNER= ").append(this.spectrum.getOwner()).append(newLine);
        String d = this.spectrum.getDate();
        String longdate = "";
        String currentTime = this.vwr.apiPlatform.getDateFormat(null);
        longdate = this.spectrum.getLongDate().equals("") || d.length() != 8 ? currentTime + " $$ export date from JSpecView" : (d.length() == 8 ? (d.charAt(0) < '5' ? "20" : "19") + d + " " + this.spectrum.getTime() : this.spectrum.getLongDate());
        this.out.append("##LONGDATE= ").append(longdate).append(newLine);
        Lst<String[]> headerTable = this.spectrum.getHeaderTable();
        for (int i = 0; i < headerTable.size(); ++i) {
            String[] entry = (String[])headerTable.get(i);
            String label = entry[0];
            String dataSet = entry[1];
            String nl = dataSet.startsWith("<") && dataSet.contains("</") ? newLine : "";
            this.out.append(label).append("= ").append(nl).append(dataSet).append(newLine);
        }
        double observedFreq = this.spectrum.getObservedFreq();
        if (!this.spectrum.is1D()) {
            this.out.append("##NUM DIM= ").append("" + this.spectrum.numDim).append(newLine);
        }
        if (observedFreq != Double.MAX_VALUE) {
            this.out.append("##.OBSERVE FREQUENCY= ").append("" + observedFreq).append(newLine);
        }
        if (this.spectrum.observedNucl != "") {
            this.out.append("##.OBSERVE NUCLEUS= ").append(this.spectrum.observedNucl).append(newLine);
        }
        this.out.append("##XUNITS= ").append(this.spectrum.isHZtoPPM() ? "HZ" : this.spectrum.getXUnits()).append(newLine);
        this.out.append("##YUNITS= ").append(this.spectrum.getYUnits()).append(newLine);
        this.out.append("##XFACTOR= ").append(JDXExporter.fixExponentInt(tmpXFactor)).append(newLine);
        this.out.append("##YFACTOR= ").append(JDXExporter.fixExponentInt(tmpYFactor)).append(newLine);
        double f = this.spectrum.isHZtoPPM() ? observedFreq : 1.0;
        Coordinate[] xyCoords = this.spectrum.getXYCoords();
        this.out.append("##FIRSTX= ").append(JDXExporter.fixExponentInt(xyCoords[startIndex].getXVal() * f)).append(newLine);
        this.out.append("##FIRSTY= ").append(JDXExporter.fixExponentInt(xyCoords[startIndex].getYVal())).append(newLine);
        this.out.append("##LASTX= ").append(JDXExporter.fixExponentInt(xyCoords[endIndex].getXVal() * f)).append(newLine);
        this.out.append("##NPOINTS= ").append("" + (Math.abs(endIndex - startIndex) + 1)).append(newLine);
        this.out.append("##MINY= ").append(JDXExporter.fixExponentInt(minY)).append(newLine);
        this.out.append("##MAXY= ").append(JDXExporter.fixExponentInt(maxY)).append(newLine);
    }

    private static boolean areIntegers(Coordinate[] xyCoords, int startIndex, int endIndex, double factor, boolean isX) {
        for (int i = startIndex; i <= endIndex; ++i) {
            double x = (isX ? xyCoords[i].getXVal() : xyCoords[i].getYVal()) / factor;
            if (!JDXExporter.isAlmostInteger(x)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlmostInteger(double x) {
        return x != 0.0 && Math.abs(x - Math.floor(x)) / x > 1.0E-8;
    }

    private static String fixExponentInt(double x) {
        return x == Math.floor(x) ? String.valueOf((int)x) : PT.rep((String)JDXExporter.fixExponent(x), (String)"E+00", (String)"");
    }

    private static String fixExponent(double x) {
        String s = DF.formatDecimalDbl((double)x, (int)-7);
        int pt = s.indexOf("E");
        if (pt < 0) {
            return s;
        }
        if (s.length() == pt + 3) {
            s = s.substring(0, pt + 2) + "0" + s.substring(pt + 2);
        }
        return s;
    }
}

