/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNEvent {
    private File myFile;
    private SVNNodeKind myNodeKind;
    private String myMimeType;
    private long myRevision;
    private long myPreviousRevision;
    private SVNURL myURL;
    private SVNURL myPreviousURL;
    private SVNStatusType myContentsStatus;
    private SVNStatusType myPropertiesStatus;
    private SVNStatusType myLockStatus;
    private SVNLock myLock;
    private SVNErrorMessage myErrorMessage;
    private SVNEventAction myAction;
    private SVNEventAction myExpectedAction;
    private String myChangelistName;
    private SVNMergeRange myRange;

    public SVNEvent(SVNErrorMessage errorMessage, SVNEventAction expected) {
        this.myErrorMessage = errorMessage;
        this.myAction = SVNEventAction.SKIP;
        this.myExpectedAction = expected;
    }

    public SVNEvent(File file, SVNNodeKind kind, String mimetype, long revision, SVNStatusType cstatus, SVNStatusType pstatus, SVNStatusType lstatus, SVNLock lock, SVNEventAction action, SVNEventAction expected, SVNErrorMessage error, SVNMergeRange range, String changelistName) {
        this.myFile = file != null ? file.getAbsoluteFile() : null;
        this.myNodeKind = kind == null ? SVNNodeKind.UNKNOWN : kind;
        this.myMimeType = mimetype;
        this.myRevision = revision;
        this.myContentsStatus = cstatus == null ? SVNStatusType.INAPPLICABLE : cstatus;
        this.myPropertiesStatus = pstatus == null ? SVNStatusType.INAPPLICABLE : pstatus;
        this.myLockStatus = lstatus == null ? SVNStatusType.INAPPLICABLE : lstatus;
        this.myLock = lock;
        this.myAction = action;
        this.myExpectedAction = expected == null ? action : expected;
        this.myErrorMessage = error;
        this.myRange = range;
        this.myChangelistName = changelistName;
        this.myPreviousRevision = -1L;
    }

    public File getFile() {
        return this.myFile;
    }

    public SVNEventAction getAction() {
        return this.myAction;
    }

    public SVNEventAction getExpectedAction() {
        return this.myExpectedAction;
    }

    public SVNStatusType getContentsStatus() {
        return this.myContentsStatus;
    }

    public SVNErrorMessage getErrorMessage() {
        return this.myErrorMessage;
    }

    public SVNLock getLock() {
        return this.myLock;
    }

    public SVNStatusType getLockStatus() {
        return this.myLockStatus;
    }

    public String getMimeType() {
        return this.myMimeType;
    }

    public SVNNodeKind getNodeKind() {
        return this.myNodeKind;
    }

    public SVNStatusType getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getPreviousRevision() {
        return this.myPreviousRevision;
    }

    public SVNURL getURL() {
        return this.myURL;
    }

    public SVNURL getPreviousURL() {
        return this.myPreviousURL;
    }

    public String getChangelistName() {
        return this.myChangelistName;
    }

    public SVNMergeRange getMergeRange() {
        return this.myRange;
    }

    public void setPreviousRevision(long previousRevision) {
        this.myPreviousRevision = previousRevision;
    }

    public void setURL(SVNURL url) {
        this.myURL = url;
    }

    public void setPreviousURL(SVNURL url) {
        this.myPreviousURL = url;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getAction() != null) {
            sb.append(this.getAction().toString());
        }
        if (this.getFile() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.getFile().toString());
        }
        if (this.getURL() != null) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(this.getURL().toString());
        }
        return sb.toString();
    }
}

