/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.Comment;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.grammars.CommentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class FileContents
implements CommentListener {
    private static final String MATCH_SINGLELINE_COMMENT_PAT = "^\\s*//.*$";
    private static final Pattern MATCH_SINGLELINE_COMMENT = Pattern.compile("^\\s*//.*$");
    private final String mFilename;
    private final FileText mText;
    private final Map<Integer, TextBlock> mJavadocComments = Maps.newHashMap();
    private final Map<Integer, TextBlock> mCPlusPlusComments = Maps.newHashMap();
    private final Map<Integer, List<TextBlock>> mCComments = Maps.newHashMap();

    @Deprecated
    public FileContents(String aFilename, String[] aLines) {
        this.mFilename = aFilename;
        this.mText = FileText.fromLines(new File(aFilename), Arrays.asList(aLines));
    }

    public FileContents(FileText aText) {
        this.mFilename = aText.getFile().toString();
        this.mText = aText;
    }

    @Override
    public void reportSingleLineComment(String aType, int aStartLineNo, int aStartColNo) {
        this.reportCppComment(aStartLineNo, aStartColNo);
    }

    @Override
    public void reportBlockComment(String aType, int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        this.reportCComment(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo);
    }

    public void reportCppComment(int aStartLineNo, int aStartColNo) {
        String line = this.line(aStartLineNo - 1);
        String[] txt = new String[]{line.substring(aStartColNo)};
        Comment comment = new Comment(txt, aStartColNo, aStartLineNo, line.length() - 1);
        this.mCPlusPlusComments.put(aStartLineNo, comment);
    }

    public ImmutableMap<Integer, TextBlock> getCppComments() {
        return ImmutableMap.copyOf(this.mCPlusPlusComments);
    }

    public void reportCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] cc = this.extractCComment(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo);
        Comment comment = new Comment(cc, aStartColNo, aEndLineNo, aEndColNo);
        if (this.mCComments.containsKey(aStartLineNo)) {
            List<TextBlock> entries = this.mCComments.get(aStartLineNo);
            entries.add(comment);
        } else {
            ArrayList entries = Lists.newArrayList();
            entries.add(comment);
            this.mCComments.put(aStartLineNo, entries);
        }
        if (this.line(aStartLineNo - 1).indexOf("/**", aStartColNo) != -1) {
            this.mJavadocComments.put(aEndLineNo - 1, comment);
        }
    }

    public ImmutableMap<Integer, List<TextBlock>> getCComments() {
        return ImmutableMap.copyOf(this.mCComments);
    }

    private String[] extractCComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        String[] retVal;
        if (aStartLineNo == aEndLineNo) {
            retVal = new String[]{this.line(aStartLineNo - 1).substring(aStartColNo, aEndColNo + 1)};
        } else {
            retVal = new String[aEndLineNo - aStartLineNo + 1];
            retVal[0] = this.line(aStartLineNo - 1).substring(aStartColNo);
            for (int i = aStartLineNo; i < aEndLineNo; ++i) {
                retVal[i - aStartLineNo + 1] = this.line(i);
            }
            retVal[retVal.length - 1] = this.line(aEndLineNo - 1).substring(0, aEndColNo + 1);
        }
        return retVal;
    }

    public TextBlock getJavadocBefore(int aLineNo) {
        int lineNo;
        for (lineNo = aLineNo - 2; lineNo > 0 && (this.lineIsBlank(lineNo) || this.lineIsComment(lineNo)); --lineNo) {
        }
        return this.mJavadocComments.get(lineNo);
    }

    private String line(int aLineNo) {
        return this.mText.get(aLineNo);
    }

    public FileText getText() {
        return this.mText;
    }

    public String[] getLines() {
        return this.mText.toLinesArray();
    }

    public String getLine(int aIndex) {
        return this.mText.get(aIndex);
    }

    public String getFilename() {
        return this.mFilename;
    }

    public boolean lineIsBlank(int aLineNo) {
        return "".equals(this.line(aLineNo).trim());
    }

    public boolean lineIsComment(int aLineNo) {
        return MATCH_SINGLELINE_COMMENT.matcher(this.line(aLineNo)).matches();
    }

    public boolean hasIntersectionWithComment(int aStartLineNo, int aStartColNo, int aEndLineNo, int aEndColNo) {
        Collection<List<TextBlock>> values = this.mCComments.values();
        for (List<TextBlock> row : values) {
            for (TextBlock comment : row) {
                if (!comment.intersects(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo)) continue;
                return true;
            }
        }
        for (int lineNumber = aStartLineNo; lineNumber <= aEndLineNo; ++lineNumber) {
            TextBlock comment = this.mCPlusPlusComments.get(lineNumber);
            if (comment == null || !comment.intersects(aStartLineNo, aStartColNo, aEndLineNo, aEndColNo)) continue;
            return true;
        }
        return false;
    }

    public boolean inPackageInfo() {
        return this.getFilename().endsWith("package-info.java");
    }
}

