/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;

public class FinalParametersCheck
extends Check {
    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8, 98, 160};
    }

    @Override
    public void visitToken(DetailAST aAST) {
        DetailAST container = aAST.getParent().getParent();
        if (container.getType() == 15) {
            return;
        }
        if (aAST.getType() == 98) {
            this.visitCatch(aAST);
        } else if (aAST.getType() == 160) {
            this.visitForEachClause(aAST);
        } else {
            this.visitMethod(aAST);
        }
    }

    private void visitMethod(DetailAST aMethod) {
        if (!aMethod.branchContains(21)) {
            return;
        }
        DetailAST modifiers = aMethod.findFirstToken(5);
        if (modifiers.branchContains(41)) {
            return;
        }
        DetailAST parameters = aMethod.findFirstToken(20);
        for (DetailAST child = parameters.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            this.checkParam(child);
        }
    }

    private void visitCatch(DetailAST aCatch) {
        this.checkParam(aCatch.findFirstToken(21));
    }

    private void visitForEachClause(DetailAST aForEachClause) {
        this.checkParam(aForEachClause.findFirstToken(10));
    }

    private void checkParam(DetailAST aParam) {
        if (!aParam.branchContains(40)) {
            DetailAST paramName = aParam.findFirstToken(59);
            DetailAST firstNode = CheckUtils.getFirstNode(aParam);
            this.log(firstNode.getLineNo(), firstNode.getColumnNo(), "final.parameter", paramName.getText());
        }
    }
}

