/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class ThrowsCountCheck
extends Check {
    private static final int DEFAULT_MAX = 1;
    private int mMax;

    public ThrowsCountCheck() {
        this.setMax(1);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{82};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int aMax) {
        this.mMax = aMax;
    }

    @Override
    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 82: {
                this.visitLiteralThrows(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitLiteralThrows(DetailAST aAST) {
        int count = (aAST.getChildCount() + 1) / 2;
        if (count > this.getMax()) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "throws.count", count, this.getMax());
        }
    }
}

