/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class LineLengthCheck
extends Check {
    private static final int DEFAULT_MAX_COLUMNS = 80;
    private int mMax = 80;
    private Pattern mIgnorePattern;

    public LineLengthCheck() {
        this.setIgnorePattern("^$");
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[0];
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
        String[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int realLength = Utils.lengthExpandedTabs(line, line.length(), this.getTabWidth());
            if (realLength <= this.mMax || this.mIgnorePattern.matcher(line).find()) continue;
            this.log(i + 1, "maxLineLen", this.mMax, realLength);
        }
    }

    public void setMax(int aLength) {
        this.mMax = aLength;
    }

    public void setIgnorePattern(String aFormat) throws ConversionException {
        try {
            this.mIgnorePattern = Utils.getPattern(aFormat);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, (Throwable)e);
        }
    }
}

