/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.gui.TreeTableModel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private static final long serialVersionUID = 8269213416115369275L;
    private final JTree mTree;
    private final TreeTableModel mTreeTableModel;

    public TreeTableModelAdapter(TreeTableModel aTreeTableModel, JTree aTree) {
        this.mTree = aTree;
        this.mTreeTableModel = aTreeTableModel;
        aTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        aTreeTableModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.delayedFireTableDataChanged();
            }
        });
    }

    @Override
    public int getColumnCount() {
        return this.mTreeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.mTreeTableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.mTreeTableModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.mTree.getRowCount();
    }

    protected Object nodeForRow(int row) {
        TreePath treePath = this.mTree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.mTreeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.mTreeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.mTreeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }

    protected void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }
}

