/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.document.impl.DocumentImplUtils;

public class FileDocument
implements Document {
    private final File file;
    private final String name;
    private final MetaData metaData = new MetaData();

    public FileDocument(File file) {
        this.file = file;
        this.name = DocumentImplUtils.toName(file);
    }

    public boolean isComposite() {
        return DocumentImplUtils.isZip(this.file);
    }

    public Reader reader() throws IOException {
        return new FileReader(this.file);
    }

    public String getName() {
        return this.name;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public InputStream inputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public String toString() {
        return "FileDocument ( file = " + this.file + " " + "name = " + this.name + " " + "metaData = " + this.metaData + " " + " )";
    }
}

