/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.SurefireReflectionException;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JUnit4Reflector {
    private static final Class[] PARAMS = new Class[]{Class.class};
    private static final Class[] IGNORE_PARAMS = new Class[]{Ignore.class};

    public Ignore getAnnotatedIgnore(Description description) {
        Method getAnnotation = ReflectionUtils.tryGetMethod(description.getClass(), (String)"getAnnotation", (Class[])PARAMS);
        if (getAnnotation == null) {
            return null;
        }
        return (Ignore)ReflectionUtils.invokeMethodWithArray((Object)description, (Method)getAnnotation, (Object[])IGNORE_PARAMS);
    }

    public String getAnnotatedIgnoreValue(Description description) {
        Ignore ignore = this.getAnnotatedIgnore(description);
        return ignore != null ? ignore.value() : null;
    }

    public Request createRequest(Class<?> ... classes) {
        try {
            return (Request)Request.class.getDeclaredMethod("classes", Class[].class).invoke(null, new Object[]{classes});
        }
        catch (NoSuchMethodException e) {
            return Request.classes(null, (Class[])classes);
        }
        catch (InvocationTargetException e) {
            throw new SurefireReflectionException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException((Throwable)e);
        }
    }
}

