/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.surefire.SpecificTestClassFilter;
import org.apache.maven.surefire.util.DirectoryScanner;
import org.apache.maven.surefire.util.ScannerFilter;
import org.apache.maven.surefire.util.TestsToRun;

public class DefaultDirectoryScanner
implements DirectoryScanner {
    private static final String FS = System.getProperty("file.separator");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String JAVA_SOURCE_FILE_EXTENSION = ".java";
    private static final String JAVA_CLASS_FILE_EXTENSION = ".class";
    private final File basedir;
    private final List includes;
    private final List excludes;
    private final List specificTests;
    private final List<Class> classesSkippedByValidation = new ArrayList<Class>();

    public DefaultDirectoryScanner(File basedir, List includes, List excludes, List specificTests) {
        this.basedir = basedir;
        this.includes = includes;
        this.excludes = excludes;
        this.specificTests = specificTests;
    }

    public TestsToRun locateTestClasses(ClassLoader classLoader, ScannerFilter scannerFilter) {
        String[] testClassNames = this.collectTests();
        ArrayList<Class> result = new ArrayList<Class>();
        String[] specific = this.specificTests == null ? new String[]{} : DefaultDirectoryScanner.processIncludesExcludes(this.specificTests);
        SpecificTestClassFilter specificTestFilter = new SpecificTestClassFilter(specific);
        for (String className : testClassNames) {
            Class testClass = DefaultDirectoryScanner.loadClass(classLoader, className);
            if (!specificTestFilter.accept(testClass)) continue;
            if (scannerFilter == null || scannerFilter.accept(testClass)) {
                result.add(testClass);
                continue;
            }
            this.classesSkippedByValidation.add(testClass);
        }
        return new TestsToRun(result);
    }

    private static Class loadClass(ClassLoader classLoader, String className) {
        Class<?> testClass;
        try {
            testClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to create test class '" + className + "'", e);
        }
        return testClass;
    }

    String[] collectTests() {
        String[] tests = EMPTY_STRING_ARRAY;
        if (this.basedir.exists()) {
            org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.DirectoryScanner scanner = new org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.DirectoryScanner();
            scanner.setBasedir(this.basedir);
            if (this.includes != null) {
                scanner.setIncludes(DefaultDirectoryScanner.processIncludesExcludes(this.includes));
            }
            if (this.excludes != null) {
                scanner.setExcludes(DefaultDirectoryScanner.processIncludesExcludes(this.excludes));
            }
            scanner.scan();
            tests = scanner.getIncludedFiles();
            for (int i = 0; i < tests.length; ++i) {
                String test = tests[i];
                test = test.substring(0, test.indexOf("."));
                tests[i] = test.replace(FS.charAt(0), '.');
            }
        }
        return tests;
    }

    private static String[] processIncludesExcludes(List list) {
        ArrayList newList = new ArrayList();
        for (Object aList : list) {
            String include = (String)aList;
            String[] includes = include.split(",");
            Collections.addAll(newList, includes);
        }
        String[] incs = new String[newList.size()];
        for (int i = 0; i < incs.length; ++i) {
            String inc = (String)newList.get(i);
            if (inc.endsWith(JAVA_SOURCE_FILE_EXTENSION)) {
                inc = inc.substring(0, inc.lastIndexOf(JAVA_SOURCE_FILE_EXTENSION)) + JAVA_CLASS_FILE_EXTENSION;
            }
            incs[i] = inc;
        }
        return incs;
    }
}

