/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util.internal;

import java.util.StringTokenizer;

public class StringUtils {
    private static final byte[] HEX_CHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String[] split(String text, String separator) {
        int max = -1;
        StringTokenizer tok = separator == null ? new StringTokenizer(text) : new StringTokenizer(text, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            int lastTokenBegin;
            if (max > 0 && i == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = text.indexOf(endToken, lastTokenEnd);
                list[i] = text.substring(lastTokenBegin);
                break;
            }
            list[i] = tok.nextToken();
            lastTokenBegin = text.indexOf(list[i], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i].length();
            ++i;
        }
        return list;
    }

    public static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static void escapeToPrintable(StringBuilder target, CharSequence str) {
        if (target == null) {
            throw new IllegalArgumentException("The target buffer must not be null");
        }
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c < ' ' || c > '~' || c == '\\' || c == ',') {
                target.append('\\');
                target.append((char)HEX_CHARS[(0xF000 & c) >> 12]);
                target.append((char)HEX_CHARS[(0xF00 & c) >> 8]);
                target.append((char)HEX_CHARS[(0xF0 & c) >> 4]);
                target.append((char)HEX_CHARS[0xF & c]);
                continue;
            }
            target.append(c);
        }
    }

    public static void unescapeString(StringBuilder target, CharSequence str) {
        if (target == null) {
            throw new IllegalArgumentException("The target buffer must not be null");
        }
        if (str == null) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                target.append((char)(StringUtils.digit(str.charAt(++i)) << 12 | StringUtils.digit(str.charAt(++i)) << 8 | StringUtils.digit(str.charAt(++i)) << 4 | StringUtils.digit(str.charAt(++i))));
                continue;
            }
            target.append(ch);
        }
    }

    private static int digit(char ch) {
        if (ch >= 'a') {
            return 10 + ch - 97;
        }
        if (ch >= 'A') {
            return 10 + ch - 65;
        }
        return ch - 48;
    }

    public static int escapeBytesToPrintable(byte[] out, int outoff, byte[] input, int off, int len) {
        if (out == null) {
            throw new IllegalArgumentException("The output array must not be null");
        }
        if (input == null || input.length == 0) {
            return 0;
        }
        int outputPos = outoff;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            byte b = input[i];
            if (b < 32 || b > 126 || b == 92 || b == 44) {
                int upper = (0xF0 & b) >> 4;
                int lower = 0xF & b;
                out[outputPos++] = 92;
                out[outputPos++] = HEX_CHARS[upper];
                out[outputPos++] = HEX_CHARS[lower];
                continue;
            }
            out[outputPos++] = b;
        }
        return outputPos - outoff;
    }

    public static int unescapeBytes(byte[] out, String str) {
        int outPos = 0;
        if (out == null) {
            throw new IllegalArgumentException("The output array must not be null");
        }
        if (str == null) {
            return 0;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                int upper = StringUtils.digit(str.charAt(++i));
                int lower = StringUtils.digit(str.charAt(++i));
                out[outPos++] = (byte)(upper << 4 | lower);
                continue;
            }
            out[outPos++] = (byte)ch;
        }
        return outPos;
    }
}

