/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;

public class Main
extends ClassFileVisitor {
    private boolean humanReadableName = false;
    private String maximumVersion = "00.0";
    private static final Map HUMAN_READABLE_NAME = new HashMap();

    public static void main(String[] args) throws IOException {
        int i;
        if (args.length == 0) {
            System.err.println("Usage: java -jar animal-sniffer.jar [JAR/CLASS FILES]");
            System.err.println("  -h   : show a human readable Java version number");
            System.err.println("  -t N : return exit code 1 if any file has a class file version number > N");
            System.exit(-1);
        }
        Main m = new Main();
        String threshold = null;
        ArrayList<File> files = new ArrayList<File>();
        block0: for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-h")) {
                m.humanReadableName = true;
                continue;
            }
            if (args[i].equals("-t")) {
                threshold = args[++i];
                for (Map.Entry v : HUMAN_READABLE_NAME.entrySet()) {
                    if (!v.getValue().equals(threshold)) continue;
                    threshold = (String)v.getKey();
                    continue block0;
                }
                continue;
            }
            files.add(new File(args[i]));
        }
        for (i = 0; i < files.size(); ++i) {
            m.process((File)files.get(i));
        }
        if (threshold != null && m.maximumVersion.compareTo(threshold) > 0) {
            System.exit(1);
        }
    }

    protected void process(String name, InputStream image) throws IOException {
        String hn;
        DataInputStream dis = new DataInputStream(image);
        byte[] buf = new byte[8];
        dis.readFully(buf);
        String v = Main.u2(buf[6], buf[7]) + "." + Main.u2(buf[4], buf[5]);
        if (this.maximumVersion.compareTo(v) < 0) {
            this.maximumVersion = v;
        }
        if (this.humanReadableName && (hn = (String)HUMAN_READABLE_NAME.get(v)) != null) {
            v = hn;
        }
        System.out.println(v + " " + name);
    }

    private static int u2(byte u, byte d) {
        return u * 256 + d;
    }

    static {
        HUMAN_READABLE_NAME.put("45.0", "Java1");
        HUMAN_READABLE_NAME.put("46.0", "Java2");
        HUMAN_READABLE_NAME.put("47.0", "Java3");
        HUMAN_READABLE_NAME.put("48.0", "Java4");
        HUMAN_READABLE_NAME.put("49.0", "Java5");
        HUMAN_READABLE_NAME.put("50.0", "Java6");
    }
}

