/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="testCompile", defaultPhase=LifecyclePhase.TEST_COMPILE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class TestCompilerMojo
extends AbstractCompilerMojo {
    @Parameter(property="maven.test.skip")
    private boolean skip;
    @Parameter(defaultValue="${project.testCompileSourceRoots}", readonly=true, required=true)
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.testClasspathElements}", required=true, readonly=true)
    private List<String> classpathElements;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    private File outputDirectory;
    @Parameter
    private Set<String> testIncludes = new HashSet<String>();
    @Parameter
    private Set<String> testExcludes = new HashSet<String>();
    @Parameter(property="maven.compiler.testSource")
    private String testSource;
    @Parameter(property="maven.compiler.testTarget")
    private String testTarget;
    @Parameter
    private Map<String, String> testCompilerArguments;
    @Parameter
    private String testCompilerArgument;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/test-annotations")
    private File generatedTestSourcesDirectory;

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Not compiling test sources");
        } else {
            super.execute();
        }
    }

    @Override
    protected List<String> getCompileSourceRoots() {
        return this.compileSourceRoots;
    }

    @Override
    protected List<String> getClasspathElements() {
        return this.classpathElements;
    }

    @Override
    protected File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(int staleMillis) {
        StaleSourceScanner scanner;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add("**/*.java");
            }
            scanner = new StaleSourceScanner((long)staleMillis, this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    @Override
    protected SourceInclusionScanner getSourceInclusionScanner(String inputFileEnding) {
        SimpleSourceInclusionScanner scanner;
        String defaultIncludePattern = "**/*" + (inputFileEnding.startsWith(".") ? "" : ".") + inputFileEnding;
        if (this.testIncludes.isEmpty() && this.testExcludes.isEmpty()) {
            this.testIncludes = Collections.singleton(defaultIncludePattern);
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, Collections.emptySet());
        } else {
            if (this.testIncludes.isEmpty()) {
                this.testIncludes.add(defaultIncludePattern);
            }
            scanner = new SimpleSourceInclusionScanner(this.testIncludes, this.testExcludes);
        }
        return scanner;
    }

    @Override
    protected String getSource() {
        return this.testSource == null ? this.source : this.testSource;
    }

    @Override
    protected String getTarget() {
        return this.testTarget == null ? this.target : this.testTarget;
    }

    @Override
    protected String getCompilerArgument() {
        return this.testCompilerArgument == null ? this.compilerArgument : this.testCompilerArgument;
    }

    @Override
    protected Map<String, String> getCompilerArguments() {
        return this.testCompilerArguments == null ? this.compilerArguments : this.testCompilerArguments;
    }

    @Override
    protected File getGeneratedSourcesDirectory() {
        return this.generatedTestSourcesDirectory;
    }

    @Override
    protected boolean isTestCompile() {
        return true;
    }
}

