// This file was generated by
//     go run gen*.go -url=http://www.unicode.org/Public/7.0.0/ucd
// DO NOT EDIT

package cases

// lookup returns the trie value for the first UTF-8 encoding in s and
// the width in bytes of this encoding. The size will be 0 if s does not
// hold enough bytes to complete the encoding. len(s) must be greater than 0.
func (t *caseTrie) lookup(s []byte) (v uint16, sz int) {
	c0 := s[0]
	switch {
	case c0 < 0x80: // is ASCII
		return caseValues[c0], 1
	case c0 < 0xC0:
		return 0, 1 // Illegal UTF-8: not a starter, not ASCII.
	case c0 < 0xE0: // 2-byte UTF-8
		if len(s) < 2 {
			return 0, 0
		}
		i := caseIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c1), 2
	case c0 < 0xF0: // 3-byte UTF-8
		if len(s) < 3 {
			return 0, 0
		}
		i := caseIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = caseIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c2), 3
	case c0 < 0xF8: // 4-byte UTF-8
		if len(s) < 4 {
			return 0, 0
		}
		i := caseIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = caseIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		o = uint32(i)<<6 + uint32(c2)
		i = caseIndex[o]
		c3 := s[3]
		if c3 < 0x80 || 0xC0 <= c3 {
			return 0, 3 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c3), 4
	}
	// Illegal rune
	return 0, 1
}

// lookupUnsafe returns the trie value for the first UTF-8 encoding in s.
// s must start with a full and valid UTF-8 encoded rune.
func (t *caseTrie) lookupUnsafe(s []byte) uint16 {
	c0 := s[0]
	if c0 < 0x80 { // is ASCII
		return caseValues[c0]
	}
	i := caseIndex[c0]
	if c0 < 0xE0 { // 2-byte UTF-8
		return t.lookupValue(uint32(i), s[1])
	}
	i = caseIndex[uint32(i)<<6+uint32(s[1])]
	if c0 < 0xF0 { // 3-byte UTF-8
		return t.lookupValue(uint32(i), s[2])
	}
	i = caseIndex[uint32(i)<<6+uint32(s[2])]
	if c0 < 0xF8 { // 4-byte UTF-8
		return t.lookupValue(uint32(i), s[3])
	}
	return 0
}

// lookupString returns the trie value for the first UTF-8 encoding in s and
// the width in bytes of this encoding. The size will be 0 if s does not
// hold enough bytes to complete the encoding. len(s) must be greater than 0.
func (t *caseTrie) lookupString(s string) (v uint16, sz int) {
	c0 := s[0]
	switch {
	case c0 < 0x80: // is ASCII
		return caseValues[c0], 1
	case c0 < 0xC0:
		return 0, 1 // Illegal UTF-8: not a starter, not ASCII.
	case c0 < 0xE0: // 2-byte UTF-8
		if len(s) < 2 {
			return 0, 0
		}
		i := caseIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c1), 2
	case c0 < 0xF0: // 3-byte UTF-8
		if len(s) < 3 {
			return 0, 0
		}
		i := caseIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = caseIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c2), 3
	case c0 < 0xF8: // 4-byte UTF-8
		if len(s) < 4 {
			return 0, 0
		}
		i := caseIndex[c0]
		c1 := s[1]
		if c1 < 0x80 || 0xC0 <= c1 {
			return 0, 1 // Illegal UTF-8: not a continuation byte.
		}
		o := uint32(i)<<6 + uint32(c1)
		i = caseIndex[o]
		c2 := s[2]
		if c2 < 0x80 || 0xC0 <= c2 {
			return 0, 2 // Illegal UTF-8: not a continuation byte.
		}
		o = uint32(i)<<6 + uint32(c2)
		i = caseIndex[o]
		c3 := s[3]
		if c3 < 0x80 || 0xC0 <= c3 {
			return 0, 3 // Illegal UTF-8: not a continuation byte.
		}
		return t.lookupValue(uint32(i), c3), 4
	}
	// Illegal rune
	return 0, 1
}

// lookupStringUnsafe returns the trie value for the first UTF-8 encoding in s.
// s must start with a full and valid UTF-8 encoded rune.
func (t *caseTrie) lookupStringUnsafe(s string) uint16 {
	c0 := s[0]
	if c0 < 0x80 { // is ASCII
		return caseValues[c0]
	}
	i := caseIndex[c0]
	if c0 < 0xE0 { // 2-byte UTF-8
		return t.lookupValue(uint32(i), s[1])
	}
	i = caseIndex[uint32(i)<<6+uint32(s[1])]
	if c0 < 0xF0 { // 3-byte UTF-8
		return t.lookupValue(uint32(i), s[2])
	}
	i = caseIndex[uint32(i)<<6+uint32(s[2])]
	if c0 < 0xF8 { // 4-byte UTF-8
		return t.lookupValue(uint32(i), s[3])
	}
	return 0
}

// caseTrie. Total size: 11144 bytes (10.88 KiB). Checksum: 68467a58f7a5d7d3.
type caseTrie struct{}

func newCaseTrie(i int) *caseTrie {
	return &caseTrie{}
}

// lookupValue determines the type of block n and looks up the value for b.
func (t *caseTrie) lookupValue(n uint32, b byte) uint16 {
	switch {
	case n < 18:
		return uint16(caseValues[n<<6+uint32(b)])
	default:
		n -= 18
		return uint16(sparse.lookup(n, b))
	}
}

// caseValues: 20 blocks, 1280 entries, 2560 bytes
// The third block is the zero block.
var caseValues = [1280]uint16{
	// Block 0x0, offset 0x0
	0x27: 0x0014,
	0x2e: 0x0014,
	0x30: 0x0010, 0x31: 0x0010, 0x32: 0x0010, 0x33: 0x0010, 0x34: 0x0010, 0x35: 0x0010,
	0x36: 0x0010, 0x37: 0x0010, 0x38: 0x0010, 0x39: 0x0010, 0x3a: 0x0014,
	// Block 0x1, offset 0x40
	0x41: 0x0813, 0x42: 0x0813, 0x43: 0x0813, 0x44: 0x0813, 0x45: 0x0813,
	0x46: 0x0813, 0x47: 0x0813, 0x48: 0x0813, 0x49: 0x0813, 0x4a: 0x0813, 0x4b: 0x0813,
	0x4c: 0x0813, 0x4d: 0x0813, 0x4e: 0x0813, 0x4f: 0x0813, 0x50: 0x0813, 0x51: 0x0813,
	0x52: 0x0813, 0x53: 0x0813, 0x54: 0x0813, 0x55: 0x0813, 0x56: 0x0813, 0x57: 0x0813,
	0x58: 0x0813, 0x59: 0x0813, 0x5a: 0x0813,
	0x5e: 0x0004, 0x5f: 0x0010, 0x60: 0x0004, 0x61: 0x0812, 0x62: 0x0812, 0x63: 0x0812,
	0x64: 0x0812, 0x65: 0x0812, 0x66: 0x0812, 0x67: 0x0812, 0x68: 0x0812, 0x69: 0x0812,
	0x6a: 0x0812, 0x6b: 0x0812, 0x6c: 0x0812, 0x6d: 0x0812, 0x6e: 0x0812, 0x6f: 0x0812,
	0x70: 0x0812, 0x71: 0x0812, 0x72: 0x0812, 0x73: 0x0812, 0x74: 0x0812, 0x75: 0x0812,
	0x76: 0x0812, 0x77: 0x0812, 0x78: 0x0812, 0x79: 0x0812, 0x7a: 0x0812,
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc0: 0xf0d2, 0xc1: 0xf493, 0xc2: 0x0053, 0xc3: 0x0052, 0xc4: 0x0053, 0xc5: 0x0052,
	0xc6: 0xf493, 0xc7: 0x03d3, 0xc8: 0x03d2, 0xc9: 0xf7d3, 0xca: 0xf753, 0xcb: 0x01d3,
	0xcc: 0x01d2, 0xcd: 0x0012, 0xce: 0x14d3, 0xcf: 0xf593, 0xd0: 0xf2d3, 0xd1: 0x00d3,
	0xd2: 0x00d2, 0xd3: 0xfcd3, 0xd4: 0xfdd3, 0xd5: 0x18d2, 0xd6: 0xffd3, 0xd7: 0xffd3,
	0xd8: 0x0053, 0xd9: 0x0052, 0xda: 0xe9d2, 0xdb: 0x0012, 0xdc: 0xfcd3, 0xdd: 0xfbd3,
	0xde: 0xef92, 0xdf: 0xfa93, 0xe0: 0x0053, 0xe1: 0x0052, 0xe2: 0x0053, 0xe3: 0x0052,
	0xe4: 0x0053, 0xe5: 0x0052, 0xe6: 0xc993, 0xe7: 0x03d3, 0xe8: 0x03d2, 0xe9: 0xca93,
	0xea: 0x0012, 0xeb: 0x0012, 0xec: 0x0053, 0xed: 0x0052, 0xee: 0xc993, 0xef: 0x07d3,
	0xf0: 0x07d2, 0xf1: 0xced3, 0xf2: 0xce53, 0xf3: 0x01d3, 0xf4: 0x01d2, 0xf5: 0x00d3,
	0xf6: 0x00d2, 0xf7: 0xc953, 0xf8: 0x0053, 0xf9: 0x0052, 0xfa: 0x0012, 0xfb: 0x0010,
	0xfc: 0x0053, 0xfd: 0x0052, 0xfe: 0x0012, 0xff: 0x1212,
	// Block 0x4, offset 0x100
	0x100: 0x0010, 0x101: 0x0010, 0x102: 0x0010, 0x103: 0x0010, 0x104: 0x02fb, 0x105: 0x03b9,
	0x106: 0x047a, 0x107: 0x053b, 0x108: 0x05f9, 0x109: 0x06ba, 0x10a: 0x077b, 0x10b: 0x0839,
	0x10c: 0x08fa, 0x10d: 0x00d3, 0x10e: 0x00d2, 0x10f: 0x07d3, 0x110: 0x07d2, 0x111: 0x00d3,
	0x112: 0x00d2, 0x113: 0x01d3, 0x114: 0x01d2, 0x115: 0x00d3, 0x116: 0x00d2, 0x117: 0x03d3,
	0x118: 0x03d2, 0x119: 0x00d3, 0x11a: 0x00d2, 0x11b: 0x01d3, 0x11c: 0x01d2, 0x11d: 0x14d2,
	0x11e: 0x0053, 0x11f: 0x0052, 0x120: 0x0053, 0x121: 0x0052, 0x122: 0x0053, 0x123: 0x0052,
	0x124: 0x0053, 0x125: 0x0052, 0x126: 0x0053, 0x127: 0x0052, 0x128: 0x0053, 0x129: 0x0052,
	0x12a: 0x0053, 0x12b: 0x0052, 0x12c: 0x0053, 0x12d: 0x0052, 0x12e: 0x0053, 0x12f: 0x0052,
	0x130: 0x09ba, 0x131: 0x0a5b, 0x132: 0x0b19, 0x133: 0x0bda, 0x134: 0x0053, 0x135: 0x0052,
	0x136: 0x18d3, 0x137: 0x1213, 0x138: 0x0053, 0x139: 0x0052, 0x13a: 0x0053, 0x13b: 0x0052,
	0x13c: 0x0053, 0x13d: 0x0052, 0x13e: 0x0053, 0x13f: 0x0052,
	// Block 0x5, offset 0x140
	0x140: 0x0e7a, 0x141: 0x00d3, 0x142: 0x00d2, 0x143: 0xf0d3, 0x144: 0x3353, 0x145: 0x3253,
	0x146: 0x0053, 0x147: 0x0052, 0x148: 0x0053, 0x149: 0x0052, 0x14a: 0x0053, 0x14b: 0x0052,
	0x14c: 0x0053, 0x14d: 0x0052, 0x14e: 0x0053, 0x14f: 0x0052, 0x150: 0x0f1a, 0x151: 0x0fba,
	0x152: 0x105a, 0x153: 0xf492, 0x154: 0xf492, 0x155: 0x0012, 0x156: 0xf7d2, 0x157: 0xf752,
	0x158: 0x0012, 0x159: 0xf592, 0x15a: 0x0012, 0x15b: 0xf2d2, 0x15c: 0x10fa, 0x15d: 0x0012,
	0x15e: 0x0012, 0x15f: 0x0012, 0x160: 0xfcd2, 0x161: 0x119a, 0x162: 0x0012, 0x163: 0xfdd2,
	0x164: 0x0012, 0x165: 0x123a, 0x166: 0x12da, 0x167: 0x0012, 0x168: 0xffd2, 0x169: 0xffd2,
	0x16a: 0x0012, 0x16b: 0x137a, 0x16c: 0x141a, 0x16d: 0x0012, 0x16e: 0x0012, 0x16f: 0xfcd2,
	0x170: 0x0012, 0x171: 0x14ba, 0x172: 0xfbd2, 0x173: 0x0012, 0x174: 0x0012, 0x175: 0xfa92,
	0x176: 0x0012, 0x177: 0x0012, 0x178: 0x0012, 0x179: 0x0012, 0x17a: 0x0012, 0x17b: 0x0012,
	0x17c: 0x0012, 0x17d: 0x155a, 0x17e: 0x0012, 0x17f: 0x0012,
	// Block 0x6, offset 0x180
	0x180: 0xc992, 0x181: 0x0012, 0x182: 0x0012, 0x183: 0xca92, 0x184: 0x0012, 0x185: 0x0012,
	0x186: 0x0012, 0x187: 0x15fa, 0x188: 0xc992, 0x189: 0x3352, 0x18a: 0xced2, 0x18b: 0xce52,
	0x18c: 0x3252, 0x18d: 0x0012, 0x18e: 0x0012, 0x18f: 0x0012, 0x190: 0x0012, 0x191: 0x0012,
	0x192: 0xc952, 0x193: 0x0012, 0x194: 0x0010, 0x195: 0x0012, 0x196: 0x0012, 0x197: 0x0012,
	0x198: 0x0012, 0x199: 0x0012, 0x19a: 0x0012, 0x19b: 0x0012, 0x19c: 0x0012, 0x19d: 0x0012,
	0x19e: 0x169a, 0x19f: 0x0012, 0x1a0: 0x0012, 0x1a1: 0x0012, 0x1a2: 0x0012, 0x1a3: 0x0012,
	0x1a4: 0x0012, 0x1a5: 0x0012, 0x1a6: 0x0012, 0x1a7: 0x0012, 0x1a8: 0x0012, 0x1a9: 0x0012,
	0x1aa: 0x0012, 0x1ab: 0x0012, 0x1ac: 0x0012, 0x1ad: 0x0012, 0x1ae: 0x0012, 0x1af: 0x0012,
	0x1b0: 0x0015, 0x1b1: 0x0015, 0x1b2: 0x0015, 0x1b3: 0x0015, 0x1b4: 0x0015, 0x1b5: 0x0015,
	0x1b6: 0x0015, 0x1b7: 0x0015, 0x1b8: 0x0015, 0x1b9: 0x0014, 0x1ba: 0x0014, 0x1bb: 0x0014,
	0x1bc: 0x0014, 0x1bd: 0x0014, 0x1be: 0x0014, 0x1bf: 0x0014,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x0024, 0x1c1: 0x0024, 0x1c2: 0x0024, 0x1c3: 0x0024, 0x1c4: 0x0024, 0x1c5: 0x3735,
	0x1c6: 0x0024, 0x1c7: 0x0034, 0x1c8: 0x0034, 0x1c9: 0x0034, 0x1ca: 0x0024, 0x1cb: 0x0024,
	0x1cc: 0x0024, 0x1cd: 0x0034, 0x1ce: 0x0034, 0x1cf: 0x0014, 0x1d0: 0x0024, 0x1d1: 0x0024,
	0x1d2: 0x0024, 0x1d3: 0x0034, 0x1d4: 0x0034, 0x1d5: 0x0034, 0x1d6: 0x0034, 0x1d7: 0x0024,
	0x1d8: 0x0034, 0x1d9: 0x0034, 0x1da: 0x0034, 0x1db: 0x0024, 0x1dc: 0x0034, 0x1dd: 0x0034,
	0x1de: 0x0034, 0x1df: 0x0034, 0x1e0: 0x0034, 0x1e1: 0x0034, 0x1e2: 0x0034, 0x1e3: 0x0024,
	0x1e4: 0x0024, 0x1e5: 0x0024, 0x1e6: 0x0024, 0x1e7: 0x0024, 0x1e8: 0x0024, 0x1e9: 0x0024,
	0x1ea: 0x0024, 0x1eb: 0x0024, 0x1ec: 0x0024, 0x1ed: 0x0024, 0x1ee: 0x0024, 0x1ef: 0x0024,
	0x1f0: 0x0053, 0x1f1: 0x0052, 0x1f2: 0x0053, 0x1f3: 0x0052, 0x1f4: 0x0014, 0x1f5: 0x0004,
	0x1f6: 0x0053, 0x1f7: 0x0052, 0x1fa: 0x0015, 0x1fb: 0x2192,
	0x1fc: 0x2092, 0x1fd: 0x2092, 0x1ff: 0x2313,
	// Block 0x8, offset 0x200
	0x204: 0x0004, 0x205: 0x0004,
	0x206: 0x0a93, 0x207: 0x0014, 0x208: 0x0953, 0x209: 0x09d3, 0x20a: 0x0953,
	0x20c: 0x1013, 0x20e: 0x10d3, 0x20f: 0x1053, 0x210: 0x173a, 0x211: 0x0813,
	0x212: 0x0813, 0x213: 0x0813, 0x214: 0x0813, 0x215: 0x0813, 0x216: 0x0813, 0x217: 0x0813,
	0x218: 0x0813, 0x219: 0x0813, 0x21a: 0x0813, 0x21b: 0x0813, 0x21c: 0x0813, 0x21d: 0x0813,
	0x21e: 0x0813, 0x21f: 0x0813, 0x220: 0x1813, 0x221: 0x1813, 0x223: 0x1813,
	0x224: 0x1813, 0x225: 0x1813, 0x226: 0x1813, 0x227: 0x1813, 0x228: 0x1813, 0x229: 0x1813,
	0x22a: 0x1813, 0x22b: 0x1813, 0x22c: 0x0a92, 0x22d: 0x0952, 0x22e: 0x09d2, 0x22f: 0x0952,
	0x230: 0x183a, 0x231: 0x0812, 0x232: 0x0812, 0x233: 0x0812, 0x234: 0x0812, 0x235: 0x0812,
	0x236: 0x0812, 0x237: 0x0812, 0x238: 0x0812, 0x239: 0x0812, 0x23a: 0x0812, 0x23b: 0x0812,
	0x23c: 0x0812, 0x23d: 0x0812, 0x23e: 0x0812, 0x23f: 0x0812,
	// Block 0x9, offset 0x240
	0x240: 0x1812, 0x241: 0x1812, 0x242: 0x1852, 0x243: 0x1812, 0x244: 0x1812, 0x245: 0x1812,
	0x246: 0x1812, 0x247: 0x1812, 0x248: 0x1812, 0x249: 0x1812, 0x24a: 0x1812, 0x24b: 0x1812,
	0x24c: 0x1012, 0x24d: 0x10d2, 0x24e: 0x1052, 0x24f: 0x0613, 0x250: 0x1092, 0x251: 0x1252,
	0x252: 0x0013, 0x253: 0x0013, 0x254: 0x0013, 0x255: 0x1cd2, 0x256: 0x1d92, 0x257: 0x0612,
	0x258: 0x0053, 0x259: 0x0052, 0x25a: 0x0053, 0x25b: 0x0052, 0x25c: 0x0053, 0x25d: 0x0052,
	0x25e: 0x0053, 0x25f: 0x0052, 0x260: 0x0053, 0x261: 0x0052, 0x262: 0x0053, 0x263: 0x0052,
	0x264: 0x0053, 0x265: 0x0052, 0x266: 0x0053, 0x267: 0x0052, 0x268: 0x0053, 0x269: 0x0052,
	0x26a: 0x0053, 0x26b: 0x0052, 0x26c: 0x0053, 0x26d: 0x0052, 0x26e: 0x0053, 0x26f: 0x0052,
	0x270: 0x1a92, 0x271: 0x1412, 0x272: 0x02d2, 0x273: 0x2312, 0x274: 0x1313, 0x275: 0x1812,
	0x277: 0x03d3, 0x278: 0x03d2, 0x279: 0x02d3, 0x27a: 0x0053, 0x27b: 0x0052,
	0x27c: 0x0012, 0x27d: 0x2193, 0x27e: 0x2093, 0x27f: 0x2093,
	// Block 0xa, offset 0x280
	0x282: 0x0014, 0x283: 0x0010, 0x284: 0x0010, 0x285: 0x0014,
	0x286: 0x0014, 0x287: 0x0010, 0x288: 0x0010, 0x289: 0x0010, 0x28a: 0x0010, 0x28b: 0x0010,
	0x28c: 0x0010, 0x28d: 0x0034, 0x28f: 0x0010, 0x290: 0x0010, 0x291: 0x0010,
	0x292: 0x0010, 0x293: 0x0010, 0x294: 0x0010, 0x295: 0x0010, 0x296: 0x0010, 0x297: 0x0010,
	0x298: 0x0010, 0x299: 0x0010, 0x29a: 0x0010, 0x29b: 0x0010, 0x29c: 0x0010, 0x29d: 0x0014,
	0x2a0: 0x1a7b, 0x2a1: 0x1b1b, 0x2a2: 0x1bbb, 0x2a3: 0x1c5b,
	0x2a4: 0x1cfb, 0x2a5: 0x1d9b, 0x2a6: 0x1e3b, 0x2a7: 0x1edb, 0x2a8: 0x1f7b, 0x2a9: 0x201b,
	0x2aa: 0x20bb, 0x2ab: 0x215b, 0x2ac: 0x21fb, 0x2ad: 0x229b, 0x2ae: 0x233b, 0x2af: 0x23db,
	0x2b0: 0x247b, 0x2b1: 0x251b, 0x2b2: 0x25bb, 0x2b3: 0x265b, 0x2b4: 0x26fb, 0x2b5: 0x279b,
	0x2b6: 0x283b, 0x2b7: 0x28db, 0x2b8: 0x297b, 0x2b9: 0x2a1b, 0x2ba: 0x2abb, 0x2bb: 0x2b5b,
	0x2bc: 0x2bfb, 0x2bd: 0x2c9b, 0x2be: 0x2d3b, 0x2bf: 0x2ddb,
	// Block 0xb, offset 0x2c0
	0x2c0: 0x0212, 0x2c1: 0x0212, 0x2c2: 0x0212, 0x2c3: 0x0212, 0x2c4: 0x0212, 0x2c5: 0x0212,
	0x2c8: 0x0213, 0x2c9: 0x0213, 0x2ca: 0x0213, 0x2cb: 0x0213,
	0x2cc: 0x0213, 0x2cd: 0x0213, 0x2d0: 0x385a, 0x2d1: 0x0212,
	0x2d2: 0x391a, 0x2d3: 0x0212, 0x2d4: 0x3a1a, 0x2d5: 0x0212, 0x2d6: 0x3b1a, 0x2d7: 0x0212,
	0x2d9: 0x0213, 0x2db: 0x0213, 0x2dd: 0x0213,
	0x2df: 0x0213, 0x2e0: 0x0212, 0x2e1: 0x0212, 0x2e2: 0x0212, 0x2e3: 0x0212,
	0x2e4: 0x0212, 0x2e5: 0x0212, 0x2e6: 0x0212, 0x2e7: 0x0212, 0x2e8: 0x0213, 0x2e9: 0x0213,
	0x2ea: 0x0213, 0x2eb: 0x0213, 0x2ec: 0x0213, 0x2ed: 0x0213, 0x2ee: 0x0213, 0x2ef: 0x0213,
	0x2f0: 0x3292, 0x2f1: 0x3292, 0x2f2: 0x2e92, 0x2f3: 0x2e92, 0x2f4: 0x2f92, 0x2f5: 0x2f92,
	0x2f6: 0x2b12, 0x2f7: 0x2b12, 0x2f8: 0x2012, 0x2f9: 0x2012, 0x2fa: 0x2412, 0x2fb: 0x2412,
	0x2fc: 0x2192, 0x2fd: 0x2192,
	// Block 0xc, offset 0x300
	0x300: 0x3c1a, 0x301: 0x3d5a, 0x302: 0x3e9a, 0x303: 0x3fda, 0x304: 0x411a, 0x305: 0x425a,
	0x306: 0x439a, 0x307: 0x44da, 0x308: 0x4619, 0x309: 0x4759, 0x30a: 0x4899, 0x30b: 0x49d9,
	0x30c: 0x4b19, 0x30d: 0x4c59, 0x30e: 0x4d99, 0x30f: 0x4ed9, 0x310: 0x501a, 0x311: 0x515a,
	0x312: 0x529a, 0x313: 0x53da, 0x314: 0x551a, 0x315: 0x565a, 0x316: 0x579a, 0x317: 0x58da,
	0x318: 0x5a19, 0x319: 0x5b59, 0x31a: 0x5c99, 0x31b: 0x5dd9, 0x31c: 0x5f19, 0x31d: 0x6059,
	0x31e: 0x6199, 0x31f: 0x62d9, 0x320: 0x641a, 0x321: 0x655a, 0x322: 0x669a, 0x323: 0x67da,
	0x324: 0x691a, 0x325: 0x6a5a, 0x326: 0x6b9a, 0x327: 0x6cda, 0x328: 0x6e19, 0x329: 0x6f59,
	0x32a: 0x7099, 0x32b: 0x71d9, 0x32c: 0x7319, 0x32d: 0x7459, 0x32e: 0x7599, 0x32f: 0x76d9,
	0x330: 0x0212, 0x331: 0x0212, 0x332: 0x781a, 0x333: 0x799a, 0x334: 0x7aba,
	0x336: 0x7bfa, 0x337: 0x7cba, 0x338: 0x0213, 0x339: 0x0213, 0x33a: 0x3293, 0x33b: 0x3293,
	0x33c: 0x7e79, 0x33d: 0x0004, 0x33e: 0x7f9a, 0x33f: 0x0004,
	// Block 0xd, offset 0x340
	0x340: 0x0004, 0x341: 0x0004, 0x342: 0x801a, 0x343: 0x819a, 0x344: 0x82ba,
	0x346: 0x83fa, 0x347: 0x84ba, 0x348: 0x2e93, 0x349: 0x2e93, 0x34a: 0x2f93, 0x34b: 0x2f93,
	0x34c: 0x8679, 0x34d: 0x0004, 0x34e: 0x0004, 0x34f: 0x0004, 0x350: 0x0212, 0x351: 0x0212,
	0x352: 0x879a, 0x353: 0x889a, 0x356: 0x899a, 0x357: 0x8a5a,
	0x358: 0x0213, 0x359: 0x0213, 0x35a: 0x2b13, 0x35b: 0x2b13, 0x35d: 0x0004,
	0x35e: 0x0004, 0x35f: 0x0004, 0x360: 0x0212, 0x361: 0x0212, 0x362: 0x8b5a, 0x363: 0x8c5a,
	0x364: 0x8d5a, 0x365: 0x0252, 0x366: 0x8e1a, 0x367: 0x8eda, 0x368: 0x0213, 0x369: 0x0213,
	0x36a: 0x2413, 0x36b: 0x2413, 0x36c: 0x0253, 0x36d: 0x0004, 0x36e: 0x0004, 0x36f: 0x0004,
	0x372: 0x8fda, 0x373: 0x915a, 0x374: 0x927a,
	0x376: 0x93ba, 0x377: 0x947a, 0x378: 0x2013, 0x379: 0x2013, 0x37a: 0x2193, 0x37b: 0x2193,
	0x37c: 0x9639, 0x37d: 0x0004, 0x37e: 0x0004,
	// Block 0xe, offset 0x380
	0x382: 0x0013,
	0x387: 0x0013, 0x38a: 0x0012, 0x38b: 0x0013,
	0x38c: 0x0013, 0x38d: 0x0013, 0x38e: 0x0012, 0x38f: 0x0012, 0x390: 0x0013, 0x391: 0x0013,
	0x392: 0x0013, 0x393: 0x0012, 0x395: 0x0013,
	0x399: 0x0013, 0x39a: 0x0013, 0x39b: 0x0013, 0x39c: 0x0013, 0x39d: 0x0013,
	0x3a4: 0x0013, 0x3a6: 0x975b, 0x3a8: 0x0013,
	0x3aa: 0x97db, 0x3ab: 0x983b, 0x3ac: 0x0013, 0x3ad: 0x0013, 0x3af: 0x0012,
	0x3b0: 0x0013, 0x3b1: 0x0013, 0x3b2: 0x1f13, 0x3b3: 0x0013, 0x3b4: 0x0012, 0x3b5: 0x0010,
	0x3b6: 0x0010, 0x3b7: 0x0010, 0x3b8: 0x0010, 0x3b9: 0x0012,
	0x3bc: 0x0012, 0x3bd: 0x0012, 0x3be: 0x0013, 0x3bf: 0x0013,
	// Block 0xf, offset 0x3c0
	0x3c0: 0x0693, 0x3c1: 0x0693, 0x3c2: 0x0793, 0x3c3: 0x0793, 0x3c4: 0x0693, 0x3c5: 0x0693,
	0x3c6: 0x0993, 0x3c7: 0x0993, 0x3c8: 0x0a93, 0x3c9: 0x0a93, 0x3ca: 0x0b93, 0x3cb: 0x0b93,
	0x3cc: 0x0a93, 0x3cd: 0x0a93, 0x3ce: 0x0993, 0x3cf: 0x0993, 0x3d0: 0x1992, 0x3d1: 0x1992,
	0x3d2: 0x1a92, 0x3d3: 0x1a92, 0x3d4: 0x1b92, 0x3d5: 0x1b92, 0x3d6: 0x1a92, 0x3d7: 0x1a92,
	0x3d8: 0x1992, 0x3d9: 0x1992, 0x3da: 0x0692, 0x3db: 0x0692, 0x3dc: 0x0792, 0x3dd: 0x0792,
	0x3de: 0x0692, 0x3df: 0x0692, 0x3e0: 0x0992, 0x3e1: 0x0992, 0x3e2: 0x0a92, 0x3e3: 0x0a92,
	0x3e4: 0x0b92, 0x3e5: 0x0b92, 0x3e6: 0x0a92, 0x3e7: 0x0a92, 0x3e8: 0x0992, 0x3e9: 0x0992,
	// Block 0x10, offset 0x400
	0x400: 0x1412, 0x401: 0x1412, 0x402: 0x1412, 0x403: 0x1412, 0x404: 0x1412, 0x405: 0x1412,
	0x406: 0x1412, 0x407: 0x1412, 0x408: 0x1412, 0x409: 0x1412, 0x40a: 0x1412, 0x40b: 0x1412,
	0x40c: 0x1412, 0x40d: 0x1412, 0x40e: 0x1412, 0x40f: 0x1412, 0x410: 0x1c12, 0x411: 0x1c12,
	0x412: 0x1c12, 0x413: 0x1c12, 0x414: 0x1c12, 0x415: 0x1c12, 0x416: 0x1c12, 0x417: 0x1c12,
	0x418: 0x1c12, 0x419: 0x1c12, 0x41a: 0x1c12, 0x41b: 0x1c12, 0x41c: 0x1c12, 0x41d: 0x1c12,
	0x41e: 0x1c12, 0x420: 0x0053, 0x421: 0x0052, 0x422: 0x98bb, 0x423: 0x993b,
	0x424: 0x99db, 0x425: 0x9a5a, 0x426: 0x9ada, 0x427: 0x03d3, 0x428: 0x03d2, 0x429: 0x00d3,
	0x42a: 0x00d2, 0x42b: 0x01d3, 0x42c: 0x01d2, 0x42d: 0x9b5b, 0x42e: 0x9bdb, 0x42f: 0x9c5b,
	0x430: 0x9cdb, 0x431: 0x0012, 0x432: 0x0053, 0x433: 0x0052, 0x434: 0x0012, 0x435: 0x00d3,
	0x436: 0x00d2, 0x437: 0x0012, 0x438: 0x0012, 0x439: 0x0012, 0x43a: 0x0012, 0x43b: 0x0012,
	0x43c: 0x0015, 0x43d: 0x0015, 0x43e: 0x9d5b, 0x43f: 0x9ddb,
	// Block 0x11, offset 0x440
	0x440: 0x9e5a, 0x441: 0x9efa, 0x442: 0x9f9a, 0x443: 0xa03a, 0x444: 0xa0da, 0x445: 0xa17a,
	0x446: 0xa21a, 0x447: 0xa2ba, 0x448: 0xa35a, 0x449: 0xa3fa, 0x44a: 0xa49a, 0x44b: 0xa53a,
	0x44c: 0xa5da, 0x44d: 0xa67a, 0x44e: 0xa71a, 0x44f: 0xa7ba, 0x450: 0xa85a, 0x451: 0xa8fa,
	0x452: 0xa99a, 0x453: 0xaa3a, 0x454: 0xaada, 0x455: 0xab7a, 0x456: 0xac1a, 0x457: 0xacba,
	0x458: 0xad5a, 0x459: 0xadfa, 0x45a: 0xae9a, 0x45b: 0xaf3a, 0x45c: 0xafda, 0x45d: 0xb07a,
	0x45e: 0xb11a, 0x45f: 0xb1ba, 0x460: 0xb25a, 0x461: 0xb2fa, 0x462: 0xb39a, 0x463: 0xb43a,
	0x464: 0xb4da, 0x465: 0xb57a, 0x467: 0xb61a,
	0x46d: 0xb6ba,
	0x470: 0x0010, 0x471: 0x0010, 0x472: 0x0010, 0x473: 0x0010, 0x474: 0x0010, 0x475: 0x0010,
	0x476: 0x0010, 0x477: 0x0010, 0x478: 0x0010, 0x479: 0x0010, 0x47a: 0x0010, 0x47b: 0x0010,
	0x47c: 0x0010, 0x47d: 0x0010, 0x47e: 0x0010, 0x47f: 0x0010,
	// Block 0x12, offset 0x480
	0x480: 0xbb7a, 0x481: 0xbc3a, 0x482: 0xbcfa, 0x483: 0xbdba, 0x484: 0xbeba, 0x485: 0xbfba,
	0x486: 0xc07a,
	0x493: 0xc13a, 0x494: 0xc27a, 0x495: 0xc3ba, 0x496: 0xc4fa, 0x497: 0xc63a,
	0x49d: 0x0010,
	0x49e: 0x0034, 0x49f: 0x0010, 0x4a0: 0x0010, 0x4a1: 0x0010, 0x4a2: 0x0010, 0x4a3: 0x0010,
	0x4a4: 0x0010, 0x4a5: 0x0010, 0x4a6: 0x0010, 0x4a7: 0x0010, 0x4a8: 0x0010,
	0x4aa: 0x0010, 0x4ab: 0x0010, 0x4ac: 0x0010, 0x4ad: 0x0010, 0x4ae: 0x0010, 0x4af: 0x0010,
	0x4b0: 0x0010, 0x4b1: 0x0010, 0x4b2: 0x0010, 0x4b3: 0x0010, 0x4b4: 0x0010, 0x4b5: 0x0010,
	0x4b6: 0x0010, 0x4b8: 0x0010, 0x4b9: 0x0010, 0x4ba: 0x0010, 0x4bb: 0x0010,
	0x4bc: 0x0010, 0x4be: 0x0010,
	// Block 0x13, offset 0x4c0
	0x4c2: 0x0010,
	0x4c7: 0x0010, 0x4c9: 0x0010, 0x4cb: 0x0010,
	0x4cd: 0x0010, 0x4ce: 0x0010, 0x4cf: 0x0010, 0x4d1: 0x0010,
	0x4d2: 0x0010, 0x4d4: 0x0010, 0x4d7: 0x0010,
	0x4d9: 0x0010, 0x4db: 0x0010, 0x4dd: 0x0010,
	0x4df: 0x0010, 0x4e1: 0x0010, 0x4e2: 0x0010,
	0x4e4: 0x0010, 0x4e7: 0x0010, 0x4e8: 0x0010, 0x4e9: 0x0010,
	0x4ea: 0x0010, 0x4ec: 0x0010, 0x4ed: 0x0010, 0x4ee: 0x0010, 0x4ef: 0x0010,
	0x4f0: 0x0010, 0x4f1: 0x0010, 0x4f2: 0x0010, 0x4f4: 0x0010, 0x4f5: 0x0010,
	0x4f6: 0x0010, 0x4f7: 0x0010, 0x4f9: 0x0010, 0x4fa: 0x0010, 0x4fb: 0x0010,
	0x4fc: 0x0010, 0x4fe: 0x0010,
}

// caseIndex: 24 blocks, 1536 entries, 3072 bytes
// Block 0 is the zero block.
var caseIndex = [1536]uint16{
	// Block 0x0, offset 0x0
	// Block 0x1, offset 0x40
	// Block 0x2, offset 0x80
	// Block 0x3, offset 0xc0
	0xc2: 0x12, 0xc3: 0x13, 0xc4: 0x14, 0xc5: 0x15, 0xc6: 0x01, 0xc7: 0x02,
	0xc8: 0x16, 0xc9: 0x03, 0xca: 0x04, 0xcb: 0x17, 0xcc: 0x18, 0xcd: 0x05, 0xce: 0x06, 0xcf: 0x07,
	0xd0: 0x19, 0xd1: 0x1a, 0xd2: 0x1b, 0xd3: 0x1c, 0xd4: 0x1d, 0xd5: 0x1e, 0xd6: 0x1f, 0xd7: 0x20,
	0xd8: 0x21, 0xd9: 0x22, 0xda: 0x23, 0xdb: 0x24, 0xdc: 0x25, 0xdd: 0x26, 0xde: 0x27, 0xdf: 0x28,
	0xe0: 0x02, 0xe1: 0x03, 0xe2: 0x04, 0xe3: 0x05,
	0xea: 0x06, 0xeb: 0x07, 0xec: 0x07, 0xed: 0x08, 0xef: 0x09,
	0xf0: 0x13, 0xf3: 0x15,
	// Block 0x4, offset 0x100
	0x120: 0x29, 0x121: 0x2a, 0x122: 0x2b, 0x123: 0x2c, 0x124: 0x2d, 0x125: 0x2e, 0x126: 0x2f, 0x127: 0x30,
	0x128: 0x31, 0x129: 0x32, 0x12a: 0x33, 0x12b: 0x34, 0x12c: 0x35, 0x12d: 0x36, 0x12e: 0x37, 0x12f: 0x38,
	0x130: 0x39, 0x131: 0x3a, 0x132: 0x3b, 0x133: 0x3c, 0x134: 0x3d, 0x135: 0x3e, 0x136: 0x3f, 0x137: 0x40,
	0x138: 0x41, 0x139: 0x42, 0x13a: 0x43, 0x13b: 0x44, 0x13c: 0x45, 0x13d: 0x46, 0x13e: 0x47, 0x13f: 0x48,
	// Block 0x5, offset 0x140
	0x140: 0x49, 0x141: 0x4a, 0x142: 0x08, 0x143: 0x4b, 0x144: 0x23, 0x145: 0x23, 0x146: 0x23, 0x147: 0x23,
	0x148: 0x23, 0x149: 0x4c, 0x14a: 0x4d, 0x14b: 0x4e, 0x14c: 0x4f, 0x14d: 0x50, 0x14e: 0x51, 0x14f: 0x52,
	0x150: 0x53, 0x151: 0x23, 0x152: 0x23, 0x153: 0x23, 0x154: 0x23, 0x155: 0x23, 0x156: 0x23, 0x157: 0x23,
	0x158: 0x23, 0x159: 0x54, 0x15a: 0x55, 0x15b: 0x56, 0x15c: 0x57, 0x15d: 0x58, 0x15e: 0x59, 0x15f: 0x5a,
	0x160: 0x5b, 0x161: 0x5c, 0x162: 0x5d, 0x163: 0x5e, 0x164: 0x5f, 0x165: 0x60, 0x166: 0x61, 0x167: 0x62,
	0x168: 0x63, 0x169: 0x64, 0x16a: 0x65, 0x16c: 0x66, 0x16d: 0x67, 0x16e: 0x68, 0x16f: 0x69,
	0x170: 0x6a, 0x171: 0x6b, 0x173: 0x6c, 0x174: 0x6d, 0x175: 0x6e, 0x176: 0x6f, 0x177: 0x70,
	0x178: 0x71, 0x179: 0x71, 0x17a: 0x72, 0x17b: 0x71, 0x17c: 0x73, 0x17d: 0x09, 0x17e: 0x0a, 0x17f: 0x0b,
	// Block 0x6, offset 0x180
	0x180: 0x74, 0x181: 0x75, 0x182: 0x76, 0x183: 0x77, 0x184: 0x0c, 0x185: 0x78, 0x186: 0x79,
	0x192: 0x7a, 0x193: 0x0d,
	0x1b0: 0x7b, 0x1b1: 0x0e, 0x1b2: 0x71, 0x1b3: 0x7c, 0x1b4: 0x0f, 0x1b5: 0x7d, 0x1b6: 0x7e, 0x1b7: 0x7f,
	0x1b8: 0x80,
	// Block 0x7, offset 0x1c0
	0x1c0: 0x81, 0x1c2: 0x82, 0x1c3: 0x83, 0x1c4: 0x84, 0x1c5: 0x23, 0x1c6: 0x85,
	// Block 0x8, offset 0x200
	0x200: 0x86, 0x201: 0x23, 0x202: 0x23, 0x203: 0x23, 0x204: 0x23, 0x205: 0x23, 0x206: 0x23, 0x207: 0x23,
	0x208: 0x23, 0x209: 0x23, 0x20a: 0x23, 0x20b: 0x23, 0x20c: 0x23, 0x20d: 0x23, 0x20e: 0x23, 0x20f: 0x23,
	0x210: 0x23, 0x211: 0x23, 0x212: 0x87, 0x213: 0x88, 0x214: 0x23, 0x215: 0x23, 0x216: 0x23, 0x217: 0x23,
	0x218: 0x89, 0x219: 0x8a, 0x21a: 0x8b, 0x21b: 0x8c, 0x21c: 0x8d, 0x21d: 0x8e, 0x21e: 0x8f, 0x21f: 0x90,
	0x220: 0x91, 0x221: 0x92, 0x222: 0x23, 0x223: 0x93, 0x224: 0x94, 0x225: 0x95, 0x226: 0x96, 0x227: 0x97,
	0x228: 0x98, 0x229: 0x99, 0x22a: 0x9a, 0x22b: 0x9b, 0x22c: 0x9c, 0x22d: 0x9d, 0x22f: 0x9e,
	0x230: 0x23, 0x231: 0x23, 0x232: 0x23, 0x233: 0x23, 0x234: 0x23, 0x235: 0x23, 0x236: 0x23, 0x237: 0x23,
	0x238: 0x23, 0x239: 0x23, 0x23a: 0x23, 0x23b: 0x23, 0x23c: 0x23, 0x23d: 0x23, 0x23e: 0x23, 0x23f: 0x23,
	// Block 0x9, offset 0x240
	0x240: 0x23, 0x241: 0x23, 0x242: 0x23, 0x243: 0x23, 0x244: 0x23, 0x245: 0x23, 0x246: 0x23, 0x247: 0x23,
	0x248: 0x23, 0x249: 0x23, 0x24a: 0x23, 0x24b: 0x23, 0x24c: 0x23, 0x24d: 0x23, 0x24e: 0x23, 0x24f: 0x23,
	0x250: 0x23, 0x251: 0x23, 0x252: 0x23, 0x253: 0x23, 0x254: 0x23, 0x255: 0x23, 0x256: 0x23, 0x257: 0x23,
	0x258: 0x23, 0x259: 0x23, 0x25a: 0x23, 0x25b: 0x23, 0x25c: 0x23, 0x25d: 0x23, 0x25e: 0x23, 0x25f: 0x23,
	0x260: 0x23, 0x261: 0x23, 0x262: 0x23, 0x263: 0x23, 0x264: 0x23, 0x265: 0x23, 0x266: 0x23, 0x267: 0x23,
	0x268: 0x23, 0x269: 0x23, 0x26a: 0x23, 0x26b: 0x23, 0x26c: 0x23, 0x26d: 0x23, 0x26e: 0x23, 0x26f: 0x23,
	0x270: 0x23, 0x271: 0x23, 0x272: 0x23, 0x273: 0x23, 0x274: 0x23, 0x275: 0x23, 0x276: 0x23, 0x277: 0x23,
	0x278: 0x23, 0x279: 0x23, 0x27a: 0x23, 0x27b: 0x23, 0x27c: 0x23, 0x27d: 0x23, 0x27e: 0x23, 0x27f: 0x23,
	// Block 0xa, offset 0x280
	0x280: 0x23, 0x281: 0x23, 0x282: 0x23, 0x283: 0x23, 0x284: 0x23, 0x285: 0x23, 0x286: 0x23, 0x287: 0x23,
	0x288: 0x23, 0x289: 0x23, 0x28a: 0x23, 0x28b: 0x23, 0x28c: 0x23, 0x28d: 0x23, 0x28e: 0x23, 0x28f: 0x23,
	0x290: 0x23, 0x291: 0x23, 0x292: 0x23, 0x293: 0x23, 0x294: 0x23, 0x295: 0x23, 0x296: 0x23, 0x297: 0x23,
	0x298: 0x23, 0x299: 0x23, 0x29a: 0x23, 0x29b: 0x23, 0x29c: 0x23, 0x29d: 0x23, 0x29e: 0x9f, 0x29f: 0xa0,
	// Block 0xb, offset 0x2c0
	0x2ec: 0x10, 0x2ed: 0xa1, 0x2ee: 0xa2, 0x2ef: 0xa3,
	0x2f0: 0x23, 0x2f1: 0x23, 0x2f2: 0x23, 0x2f3: 0x23, 0x2f4: 0xa4, 0x2f5: 0xa5, 0x2f6: 0xa6, 0x2f7: 0xa7,
	0x2f8: 0xa8, 0x2f9: 0xa9, 0x2fa: 0x23, 0x2fb: 0xaa, 0x2fc: 0xab, 0x2fd: 0xac, 0x2fe: 0xad, 0x2ff: 0xae,
	// Block 0xc, offset 0x300
	0x300: 0xaf, 0x301: 0xb0, 0x302: 0x23, 0x303: 0xb1, 0x305: 0x52, 0x307: 0xb2,
	0x30a: 0xb3, 0x30b: 0xb4, 0x30c: 0xb5, 0x30d: 0xb6, 0x30e: 0xb7, 0x30f: 0xb8,
	0x310: 0xb9, 0x311: 0xba, 0x312: 0xbb, 0x314: 0xbc, 0x315: 0xbd,
	0x318: 0x23, 0x319: 0x23, 0x31a: 0x23, 0x31b: 0x23, 0x31c: 0xbe, 0x31d: 0xbf,
	0x320: 0xc0, 0x321: 0xc1, 0x322: 0xc2, 0x324: 0xc3, 0x326: 0xc4,
	0x328: 0xc5, 0x329: 0xc6, 0x32a: 0xc7, 0x32b: 0xc8, 0x32c: 0x5e, 0x32d: 0xc9, 0x32e: 0xca,
	0x330: 0x23, 0x331: 0xcb,
	// Block 0xd, offset 0x340
	0x340: 0xcc, 0x341: 0xcd, 0x342: 0xce, 0x343: 0xcf, 0x344: 0xd0, 0x345: 0xd1, 0x346: 0xd2, 0x347: 0xd3,
	0x348: 0xd4, 0x34a: 0x61, 0x34b: 0xd5, 0x34c: 0xd6, 0x34d: 0xd7,
	0x352: 0xd8, 0x353: 0xd9, 0x356: 0xda, 0x357: 0xdb,
	0x358: 0xdc, 0x359: 0xdd, 0x35a: 0xde, 0x35b: 0xdf,
	0x362: 0xe0, 0x363: 0xe1,
	0x36b: 0xe2,
	// Block 0xe, offset 0x380
	0x380: 0x23, 0x381: 0x23, 0x382: 0x23, 0x383: 0x23, 0x384: 0x23, 0x385: 0x23, 0x386: 0x23, 0x387: 0x23,
	0x388: 0x23, 0x389: 0x23, 0x38a: 0x23, 0x38b: 0x23, 0x38c: 0x23, 0x38d: 0x23, 0x38e: 0xe3,
	0x390: 0x23, 0x391: 0xe4,
	// Block 0xf, offset 0x3c0
	0x3c0: 0x23, 0x3c1: 0x23, 0x3c2: 0x23, 0x3c3: 0x23, 0x3c4: 0x23, 0x3c5: 0x23, 0x3c6: 0x23, 0x3c7: 0x23,
	0x3c8: 0x23, 0x3c9: 0x23, 0x3ca: 0x23, 0x3cb: 0x23, 0x3cc: 0x23, 0x3cd: 0x23, 0x3ce: 0x23, 0x3cf: 0x23,
	0x3d0: 0xe4,
	// Block 0x10, offset 0x400
	0x420: 0x23, 0x421: 0x23, 0x422: 0x23, 0x423: 0x23, 0x424: 0x23, 0x425: 0x23, 0x426: 0x23, 0x427: 0x23,
	0x428: 0xe2, 0x429: 0xe5, 0x42b: 0xe6, 0x42c: 0xe7, 0x42d: 0xe8, 0x42e: 0xe9,
	0x43c: 0x23, 0x43d: 0xea, 0x43e: 0xeb,
	// Block 0x11, offset 0x440
	0x470: 0x23, 0x471: 0xec, 0x472: 0xed,
	// Block 0x12, offset 0x480
	0x485: 0xee, 0x486: 0xef,
	0x489: 0xf0,
	0x490: 0xf1, 0x491: 0xf2, 0x492: 0xf3, 0x493: 0xf4, 0x494: 0xf5, 0x495: 0xf6, 0x496: 0xf7, 0x497: 0xf8,
	0x498: 0xf9, 0x499: 0xfa, 0x49a: 0xfb, 0x49b: 0xfc, 0x49c: 0xfd, 0x49d: 0xfe, 0x49e: 0xff, 0x49f: 0x100,
	// Block 0x13, offset 0x4c0
	0x4e0: 0x23, 0x4e1: 0x23, 0x4e2: 0x23, 0x4e3: 0x101,
	0x4f8: 0x102, 0x4f9: 0x11, 0x4fa: 0x103,
	// Block 0x14, offset 0x500
	0x504: 0x104, 0x505: 0x105, 0x506: 0x106,
	// Block 0x15, offset 0x540
	0x550: 0x0a, 0x551: 0x0b, 0x552: 0x0c, 0x553: 0x0d, 0x556: 0x0e,
	0x55b: 0x0f, 0x55d: 0x10, 0x55e: 0x11, 0x55f: 0x12,
	// Block 0x16, offset 0x580
	0x580: 0x107, 0x581: 0x108, 0x584: 0x108, 0x585: 0x108, 0x586: 0x108, 0x587: 0x109,
	// Block 0x17, offset 0x5c0
	0x5e0: 0x14,
}

// sparseOffsets: 249 entries, 498 bytes
var sparseOffsets = []uint16{0x0, 0x9, 0xf, 0x18, 0x24, 0x2e, 0x3a, 0x3d, 0x41, 0x44, 0x48, 0x52, 0x54, 0x59, 0x69, 0x70, 0x75, 0x83, 0x84, 0x92, 0xa1, 0xab, 0xae, 0xb4, 0xbc, 0xbe, 0xbf, 0xca, 0xd0, 0xde, 0xe9, 0xf4, 0xff, 0x10b, 0x115, 0x11f, 0x12a, 0x136, 0x142, 0x14a, 0x152, 0x15c, 0x166, 0x172, 0x178, 0x183, 0x188, 0x190, 0x193, 0x198, 0x19c, 0x1a0, 0x1a7, 0x1b0, 0x1b8, 0x1b9, 0x1c2, 0x1c9, 0x1d4, 0x1da, 0x1df, 0x1e3, 0x1e6, 0x1e8, 0x1ea, 0x1eb, 0x1ec, 0x1ee, 0x1f0, 0x1f2, 0x1f9, 0x1fe, 0x202, 0x20b, 0x20e, 0x211, 0x215, 0x216, 0x221, 0x222, 0x223, 0x226, 0x22b, 0x238, 0x240, 0x248, 0x251, 0x25a, 0x263, 0x268, 0x26b, 0x278, 0x27a, 0x281, 0x283, 0x28d, 0x28e, 0x299, 0x2a1, 0x2a8, 0x2ae, 0x2af, 0x2bd, 0x2c2, 0x2c5, 0x2ca, 0x2ce, 0x2d4, 0x2d7, 0x2dc, 0x2e1, 0x2e2, 0x2e8, 0x2ea, 0x2eb, 0x2ed, 0x2ef, 0x2f2, 0x2f3, 0x2f5, 0x2f8, 0x2fe, 0x302, 0x304, 0x30a, 0x311, 0x320, 0x324, 0x32d, 0x32e, 0x334, 0x338, 0x33d, 0x345, 0x34b, 0x351, 0x35b, 0x360, 0x369, 0x36f, 0x373, 0x37b, 0x37d, 0x37f, 0x382, 0x384, 0x386, 0x387, 0x388, 0x38a, 0x38c, 0x391, 0x396, 0x398, 0x39e, 0x3a1, 0x3a3, 0x3a9, 0x3ae, 0x3b0, 0x3b1, 0x3b2, 0x3b4, 0x3b6, 0x3b8, 0x3bb, 0x3bd, 0x3c0, 0x3c8, 0x3cb, 0x3cd, 0x3cf, 0x3d0, 0x3d1, 0x3d3, 0x3d9, 0x3db, 0x3dc, 0x3de, 0x3e0, 0x3ed, 0x3ee, 0x3ef, 0x3f3, 0x3f5, 0x3f6, 0x3f7, 0x3fb, 0x3ff, 0x405, 0x407, 0x40e, 0x411, 0x415, 0x418, 0x420, 0x426, 0x430, 0x439, 0x43f, 0x445, 0x44b, 0x44c, 0x452, 0x455, 0x45d, 0x45e, 0x45f, 0x462, 0x463, 0x464, 0x465, 0x467, 0x469, 0x46b, 0x46f, 0x470, 0x472, 0x473, 0x475, 0x47a, 0x47f, 0x483, 0x484, 0x487, 0x48b, 0x496, 0x49a, 0x4a2, 0x4a7, 0x4ab, 0x4ae, 0x4b2, 0x4b5, 0x4b8, 0x4bd, 0x4c1, 0x4c5, 0x4c9, 0x4cd, 0x4cf, 0x4d8, 0x4dd, 0x4de, 0x4e1, 0x4e2, 0x4e4, 0x4e5, 0x4e6}

// sparseValues: 1254 entries, 5016 bytes
var sparseValues = [1254]valueRange{
	// Block 0x0, offset 0x0
	{value: 0x0004, lo: 0xa8, hi: 0xa8},
	{value: 0x0012, lo: 0xaa, hi: 0xaa},
	{value: 0x0014, lo: 0xad, hi: 0xad},
	{value: 0x0004, lo: 0xaf, hi: 0xaf},
	{value: 0x0004, lo: 0xb4, hi: 0xb4},
	{value: 0xca52, lo: 0xb5, hi: 0xb5},
	{value: 0x0014, lo: 0xb7, hi: 0xb7},
	{value: 0x0004, lo: 0xb8, hi: 0xb8},
	{value: 0x0012, lo: 0xba, hi: 0xba},
	// Block 0x1, offset 0x9
	{value: 0x0813, lo: 0x80, hi: 0x96},
	{value: 0x0813, lo: 0x98, hi: 0x9e},
	{value: 0x003a, lo: 0x9f, hi: 0x9f},
	{value: 0x0812, lo: 0xa0, hi: 0xb6},
	{value: 0x0812, lo: 0xb8, hi: 0xbe},
	{value: 0x61d2, lo: 0xbf, hi: 0xbf},
	// Block 0x2, offset 0xf
	{value: 0x0057, lo: 0x80, hi: 0xaf},
	{value: 0x00fb, lo: 0xb0, hi: 0xb0},
	{value: 0x019a, lo: 0xb1, hi: 0xb1},
	{value: 0x0057, lo: 0xb2, hi: 0xb7},
	{value: 0x0012, lo: 0xb8, hi: 0xb8},
	{value: 0x00d6, lo: 0xb9, hi: 0xba},
	{value: 0x01d6, lo: 0xbb, hi: 0xbc},
	{value: 0x00d6, lo: 0xbd, hi: 0xbe},
	{value: 0x1fd3, lo: 0xbf, hi: 0xbf},
	// Block 0x3, offset 0x18
	{value: 0x1fd2, lo: 0x80, hi: 0x80},
	{value: 0x00d6, lo: 0x81, hi: 0x82},
	{value: 0x01d6, lo: 0x83, hi: 0x84},
	{value: 0x00d6, lo: 0x85, hi: 0x86},
	{value: 0x03d6, lo: 0x87, hi: 0x88},
	{value: 0x01fa, lo: 0x89, hi: 0x89},
	{value: 0x0057, lo: 0x8a, hi: 0xb7},
	{value: 0x61d3, lo: 0xb8, hi: 0xb8},
	{value: 0x00d6, lo: 0xb9, hi: 0xba},
	{value: 0x01d6, lo: 0xbb, hi: 0xbc},
	{value: 0x00d6, lo: 0xbd, hi: 0xbe},
	{value: 0x029a, lo: 0xbf, hi: 0xbf},
	// Block 0x4, offset 0x24
	{value: 0x0057, lo: 0x80, hi: 0x9f},
	{value: 0xef93, lo: 0xa0, hi: 0xa0},
	{value: 0x0012, lo: 0xa1, hi: 0xa1},
	{value: 0x0057, lo: 0xa2, hi: 0xb3},
	{value: 0x0012, lo: 0xb4, hi: 0xb9},
	{value: 0x0c9b, lo: 0xba, hi: 0xba},
	{value: 0x01d6, lo: 0xbb, hi: 0xbc},
	{value: 0xe9d3, lo: 0xbd, hi: 0xbd},
	{value: 0x0d3b, lo: 0xbe, hi: 0xbe},
	{value: 0x0dda, lo: 0xbf, hi: 0xbf},
	// Block 0x5, offset 0x2e
	{value: 0x0015, lo: 0x80, hi: 0x81},
	{value: 0x0004, lo: 0x82, hi: 0x85},
	{value: 0x0014, lo: 0x86, hi: 0x91},
	{value: 0x0004, lo: 0x92, hi: 0x96},
	{value: 0x0014, lo: 0x97, hi: 0x97},
	{value: 0x0004, lo: 0x98, hi: 0x9f},
	{value: 0x0015, lo: 0xa0, hi: 0xa4},
	{value: 0x0004, lo: 0xa5, hi: 0xab},
	{value: 0x0014, lo: 0xac, hi: 0xac},
	{value: 0x0004, lo: 0xad, hi: 0xad},
	{value: 0x0014, lo: 0xae, hi: 0xae},
	{value: 0x0004, lo: 0xaf, hi: 0xbf},
	// Block 0x6, offset 0x3a
	{value: 0x0024, lo: 0x80, hi: 0x94},
	{value: 0x0034, lo: 0x95, hi: 0xbc},
	{value: 0x0024, lo: 0xbd, hi: 0xbf},
	// Block 0x7, offset 0x3d
	{value: 0x1413, lo: 0x80, hi: 0x8f},
	{value: 0x0813, lo: 0x90, hi: 0x9f},
	{value: 0x1813, lo: 0xa0, hi: 0xaf},
	{value: 0x0812, lo: 0xb0, hi: 0xbf},
	// Block 0x8, offset 0x41
	{value: 0x1812, lo: 0x80, hi: 0x8f},
	{value: 0x1412, lo: 0x90, hi: 0x9f},
	{value: 0x0057, lo: 0xa0, hi: 0xbf},
	// Block 0x9, offset 0x44
	{value: 0x0057, lo: 0x80, hi: 0x81},
	{value: 0x0024, lo: 0x83, hi: 0x87},
	{value: 0x0014, lo: 0x88, hi: 0x89},
	{value: 0x0057, lo: 0x8a, hi: 0xbf},
	// Block 0xa, offset 0x48
	{value: 0x03d3, lo: 0x80, hi: 0x80},
	{value: 0x00d6, lo: 0x81, hi: 0x82},
	{value: 0x01d6, lo: 0x83, hi: 0x84},
	{value: 0x00d6, lo: 0x85, hi: 0x86},
	{value: 0x03d6, lo: 0x87, hi: 0x88},
	{value: 0x00d6, lo: 0x89, hi: 0x8a},
	{value: 0x01d6, lo: 0x8b, hi: 0x8c},
	{value: 0x00d6, lo: 0x8d, hi: 0x8e},
	{value: 0x03d2, lo: 0x8f, hi: 0x8f},
	{value: 0x0057, lo: 0x90, hi: 0xbf},
	// Block 0xb, offset 0x52
	{value: 0x0057, lo: 0x80, hi: 0xaf},
	{value: 0x1413, lo: 0xb1, hi: 0xbf},
	// Block 0xc, offset 0x54
	{value: 0x0c13, lo: 0x80, hi: 0x8f},
	{value: 0x3413, lo: 0x90, hi: 0x96},
	{value: 0x0014, lo: 0x99, hi: 0x99},
	{value: 0x1412, lo: 0xa1, hi: 0xaf},
	{value: 0x0c12, lo: 0xb0, hi: 0xbf},
	// Block 0xd, offset 0x59
	{value: 0x3412, lo: 0x80, hi: 0x86},
	{value: 0x193a, lo: 0x87, hi: 0x87},
	{value: 0x0034, lo: 0x91, hi: 0x91},
	{value: 0x0024, lo: 0x92, hi: 0x95},
	{value: 0x0034, lo: 0x96, hi: 0x96},
	{value: 0x0024, lo: 0x97, hi: 0x99},
	{value: 0x0034, lo: 0x9a, hi: 0x9b},
	{value: 0x0024, lo: 0x9c, hi: 0xa1},
	{value: 0x0034, lo: 0xa2, hi: 0xa7},
	{value: 0x0024, lo: 0xa8, hi: 0xa9},
	{value: 0x0034, lo: 0xaa, hi: 0xaa},
	{value: 0x0024, lo: 0xab, hi: 0xac},
	{value: 0x0034, lo: 0xad, hi: 0xae},
	{value: 0x0024, lo: 0xaf, hi: 0xaf},
	{value: 0x0034, lo: 0xb0, hi: 0xbd},
	{value: 0x0034, lo: 0xbf, hi: 0xbf},
	// Block 0xe, offset 0x69
	{value: 0x0034, lo: 0x81, hi: 0x82},
	{value: 0x0024, lo: 0x84, hi: 0x84},
	{value: 0x0034, lo: 0x85, hi: 0x85},
	{value: 0x0034, lo: 0x87, hi: 0x87},
	{value: 0x0010, lo: 0x90, hi: 0xaa},
	{value: 0x0010, lo: 0xb0, hi: 0xb3},
	{value: 0x0014, lo: 0xb4, hi: 0xb4},
	// Block 0xf, offset 0x70
	{value: 0x0014, lo: 0x80, hi: 0x85},
	{value: 0x0024, lo: 0x90, hi: 0x97},
	{value: 0x0034, lo: 0x98, hi: 0x9a},
	{value: 0x0014, lo: 0x9c, hi: 0x9c},
	{value: 0x0010, lo: 0xa0, hi: 0xbf},
	// Block 0x10, offset 0x75
	{value: 0x0014, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x81, hi: 0x8a},
	{value: 0x0034, lo: 0x8b, hi: 0x92},
	{value: 0x0024, lo: 0x93, hi: 0x94},
	{value: 0x0034, lo: 0x95, hi: 0x96},
	{value: 0x0024, lo: 0x97, hi: 0x9b},
	{value: 0x0034, lo: 0x9c, hi: 0x9c},
	{value: 0x0024, lo: 0x9d, hi: 0x9e},
	{value: 0x0034, lo: 0x9f, hi: 0x9f},
	{value: 0x0010, lo: 0xa0, hi: 0xa9},
	{value: 0x0010, lo: 0xab, hi: 0xab},
	{value: 0x0010, lo: 0xae, hi: 0xaf},
	{value: 0x0034, lo: 0xb0, hi: 0xb0},
	{value: 0x0010, lo: 0xb1, hi: 0xbf},
	// Block 0x11, offset 0x83
	{value: 0x0010, lo: 0x80, hi: 0xbf},
	// Block 0x12, offset 0x84
	{value: 0x0010, lo: 0x80, hi: 0x93},
	{value: 0x0010, lo: 0x95, hi: 0x95},
	{value: 0x0024, lo: 0x96, hi: 0x9c},
	{value: 0x0014, lo: 0x9d, hi: 0x9d},
	{value: 0x0024, lo: 0x9f, hi: 0xa2},
	{value: 0x0034, lo: 0xa3, hi: 0xa3},
	{value: 0x0024, lo: 0xa4, hi: 0xa4},
	{value: 0x0014, lo: 0xa5, hi: 0xa6},
	{value: 0x0024, lo: 0xa7, hi: 0xa8},
	{value: 0x0034, lo: 0xaa, hi: 0xaa},
	{value: 0x0024, lo: 0xab, hi: 0xac},
	{value: 0x0034, lo: 0xad, hi: 0xad},
	{value: 0x0010, lo: 0xae, hi: 0xbc},
	{value: 0x0010, lo: 0xbf, hi: 0xbf},
	// Block 0x13, offset 0x92
	{value: 0x0014, lo: 0x8f, hi: 0x8f},
	{value: 0x0010, lo: 0x90, hi: 0x90},
	{value: 0x0034, lo: 0x91, hi: 0x91},
	{value: 0x0010, lo: 0x92, hi: 0xaf},
	{value: 0x0024, lo: 0xb0, hi: 0xb0},
	{value: 0x0034, lo: 0xb1, hi: 0xb1},
	{value: 0x0024, lo: 0xb2, hi: 0xb3},
	{value: 0x0034, lo: 0xb4, hi: 0xb4},
	{value: 0x0024, lo: 0xb5, hi: 0xb6},
	{value: 0x0034, lo: 0xb7, hi: 0xb9},
	{value: 0x0024, lo: 0xba, hi: 0xba},
	{value: 0x0034, lo: 0xbb, hi: 0xbc},
	{value: 0x0024, lo: 0xbd, hi: 0xbd},
	{value: 0x0034, lo: 0xbe, hi: 0xbe},
	{value: 0x0024, lo: 0xbf, hi: 0xbf},
	// Block 0x14, offset 0xa1
	{value: 0x0024, lo: 0x80, hi: 0x81},
	{value: 0x0034, lo: 0x82, hi: 0x82},
	{value: 0x0024, lo: 0x83, hi: 0x83},
	{value: 0x0034, lo: 0x84, hi: 0x84},
	{value: 0x0024, lo: 0x85, hi: 0x85},
	{value: 0x0034, lo: 0x86, hi: 0x86},
	{value: 0x0024, lo: 0x87, hi: 0x87},
	{value: 0x0034, lo: 0x88, hi: 0x88},
	{value: 0x0024, lo: 0x89, hi: 0x8a},
	{value: 0x0010, lo: 0x8d, hi: 0xbf},
	// Block 0x15, offset 0xab
	{value: 0x0010, lo: 0x80, hi: 0xa5},
	{value: 0x0014, lo: 0xa6, hi: 0xb0},
	{value: 0x0010, lo: 0xb1, hi: 0xb1},
	// Block 0x16, offset 0xae
	{value: 0x0010, lo: 0x80, hi: 0xaa},
	{value: 0x0024, lo: 0xab, hi: 0xb1},
	{value: 0x0034, lo: 0xb2, hi: 0xb2},
	{value: 0x0024, lo: 0xb3, hi: 0xb3},
	{value: 0x0014, lo: 0xb4, hi: 0xb5},
	{value: 0x0014, lo: 0xba, hi: 0xba},
	// Block 0x17, offset 0xb4
	{value: 0x0010, lo: 0x80, hi: 0x95},
	{value: 0x0024, lo: 0x96, hi: 0x99},
	{value: 0x0014, lo: 0x9a, hi: 0x9a},
	{value: 0x0024, lo: 0x9b, hi: 0xa3},
	{value: 0x0014, lo: 0xa4, hi: 0xa4},
	{value: 0x0024, lo: 0xa5, hi: 0xa7},
	{value: 0x0014, lo: 0xa8, hi: 0xa8},
	{value: 0x0024, lo: 0xa9, hi: 0xad},
	// Block 0x18, offset 0xbc
	{value: 0x0010, lo: 0x80, hi: 0x98},
	{value: 0x0034, lo: 0x99, hi: 0x9b},
	// Block 0x19, offset 0xbe
	{value: 0x0010, lo: 0xa0, hi: 0xb2},
	// Block 0x1a, offset 0xbf
	{value: 0x0024, lo: 0xa4, hi: 0xa5},
	{value: 0x0034, lo: 0xa6, hi: 0xa6},
	{value: 0x0024, lo: 0xa7, hi: 0xa8},
	{value: 0x0034, lo: 0xa9, hi: 0xa9},
	{value: 0x0024, lo: 0xaa, hi: 0xac},
	{value: 0x0034, lo: 0xad, hi: 0xb2},
	{value: 0x0024, lo: 0xb3, hi: 0xb5},
	{value: 0x0034, lo: 0xb6, hi: 0xb6},
	{value: 0x0024, lo: 0xb7, hi: 0xb8},
	{value: 0x0034, lo: 0xb9, hi: 0xba},
	{value: 0x0024, lo: 0xbb, hi: 0xbf},
	// Block 0x1b, offset 0xca
	{value: 0x0014, lo: 0x80, hi: 0x82},
	{value: 0x0010, lo: 0x83, hi: 0xb9},
	{value: 0x0014, lo: 0xba, hi: 0xba},
	{value: 0x0010, lo: 0xbb, hi: 0xbb},
	{value: 0x0034, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0x1c, offset 0xd0
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x88},
	{value: 0x0010, lo: 0x89, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x8e, hi: 0x90},
	{value: 0x0024, lo: 0x91, hi: 0x91},
	{value: 0x0034, lo: 0x92, hi: 0x92},
	{value: 0x0024, lo: 0x93, hi: 0x94},
	{value: 0x0014, lo: 0x95, hi: 0x97},
	{value: 0x0010, lo: 0x98, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa3},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	{value: 0x0014, lo: 0xb1, hi: 0xb1},
	{value: 0x0010, lo: 0xb2, hi: 0xbf},
	// Block 0x1d, offset 0xde
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8c},
	{value: 0x0010, lo: 0x8f, hi: 0x90},
	{value: 0x0010, lo: 0x93, hi: 0xa8},
	{value: 0x0010, lo: 0xaa, hi: 0xb0},
	{value: 0x0010, lo: 0xb2, hi: 0xb2},
	{value: 0x0010, lo: 0xb6, hi: 0xb9},
	{value: 0x0034, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0x1e, offset 0xe9
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x84},
	{value: 0x0010, lo: 0x87, hi: 0x88},
	{value: 0x0010, lo: 0x8b, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x8e, hi: 0x8e},
	{value: 0x0010, lo: 0x97, hi: 0x97},
	{value: 0x0010, lo: 0x9c, hi: 0x9d},
	{value: 0x0010, lo: 0x9f, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa3},
	{value: 0x0010, lo: 0xa6, hi: 0xb1},
	// Block 0x1f, offset 0xf4
	{value: 0x0014, lo: 0x81, hi: 0x82},
	{value: 0x0010, lo: 0x83, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8a},
	{value: 0x0010, lo: 0x8f, hi: 0x90},
	{value: 0x0010, lo: 0x93, hi: 0xa8},
	{value: 0x0010, lo: 0xaa, hi: 0xb0},
	{value: 0x0010, lo: 0xb2, hi: 0xb3},
	{value: 0x0010, lo: 0xb5, hi: 0xb6},
	{value: 0x0010, lo: 0xb8, hi: 0xb9},
	{value: 0x0034, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbe, hi: 0xbf},
	// Block 0x20, offset 0xff
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x82},
	{value: 0x0014, lo: 0x87, hi: 0x88},
	{value: 0x0014, lo: 0x8b, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0014, lo: 0x91, hi: 0x91},
	{value: 0x0010, lo: 0x99, hi: 0x9c},
	{value: 0x0010, lo: 0x9e, hi: 0x9e},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	{value: 0x0014, lo: 0xb0, hi: 0xb1},
	{value: 0x0010, lo: 0xb2, hi: 0xb4},
	{value: 0x0014, lo: 0xb5, hi: 0xb5},
	// Block 0x21, offset 0x10b
	{value: 0x0014, lo: 0x81, hi: 0x82},
	{value: 0x0010, lo: 0x83, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8d},
	{value: 0x0010, lo: 0x8f, hi: 0x91},
	{value: 0x0010, lo: 0x93, hi: 0xa8},
	{value: 0x0010, lo: 0xaa, hi: 0xb0},
	{value: 0x0010, lo: 0xb2, hi: 0xb3},
	{value: 0x0010, lo: 0xb5, hi: 0xb9},
	{value: 0x0034, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0x22, offset 0x115
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x85},
	{value: 0x0014, lo: 0x87, hi: 0x88},
	{value: 0x0010, lo: 0x89, hi: 0x89},
	{value: 0x0010, lo: 0x8b, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x90, hi: 0x90},
	{value: 0x0010, lo: 0xa0, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa3},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	// Block 0x23, offset 0x11f
	{value: 0x0014, lo: 0x81, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8c},
	{value: 0x0010, lo: 0x8f, hi: 0x90},
	{value: 0x0010, lo: 0x93, hi: 0xa8},
	{value: 0x0010, lo: 0xaa, hi: 0xb0},
	{value: 0x0010, lo: 0xb2, hi: 0xb3},
	{value: 0x0010, lo: 0xb5, hi: 0xb9},
	{value: 0x0034, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbe},
	{value: 0x0014, lo: 0xbf, hi: 0xbf},
	// Block 0x24, offset 0x12a
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x84},
	{value: 0x0010, lo: 0x87, hi: 0x88},
	{value: 0x0010, lo: 0x8b, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0014, lo: 0x96, hi: 0x96},
	{value: 0x0010, lo: 0x97, hi: 0x97},
	{value: 0x0010, lo: 0x9c, hi: 0x9d},
	{value: 0x0010, lo: 0x9f, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa3},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	{value: 0x0010, lo: 0xb1, hi: 0xb1},
	// Block 0x25, offset 0x136
	{value: 0x0014, lo: 0x82, hi: 0x82},
	{value: 0x0010, lo: 0x83, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8a},
	{value: 0x0010, lo: 0x8e, hi: 0x90},
	{value: 0x0010, lo: 0x92, hi: 0x95},
	{value: 0x0010, lo: 0x99, hi: 0x9a},
	{value: 0x0010, lo: 0x9c, hi: 0x9c},
	{value: 0x0010, lo: 0x9e, hi: 0x9f},
	{value: 0x0010, lo: 0xa3, hi: 0xa4},
	{value: 0x0010, lo: 0xa8, hi: 0xaa},
	{value: 0x0010, lo: 0xae, hi: 0xb9},
	{value: 0x0010, lo: 0xbe, hi: 0xbf},
	// Block 0x26, offset 0x142
	{value: 0x0014, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x81, hi: 0x82},
	{value: 0x0010, lo: 0x86, hi: 0x88},
	{value: 0x0010, lo: 0x8a, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x90, hi: 0x90},
	{value: 0x0010, lo: 0x97, hi: 0x97},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	// Block 0x27, offset 0x14a
	{value: 0x0014, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x81, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8c},
	{value: 0x0010, lo: 0x8e, hi: 0x90},
	{value: 0x0010, lo: 0x92, hi: 0xa8},
	{value: 0x0010, lo: 0xaa, hi: 0xb9},
	{value: 0x0010, lo: 0xbd, hi: 0xbd},
	{value: 0x0014, lo: 0xbe, hi: 0xbf},
	// Block 0x28, offset 0x152
	{value: 0x0014, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x81, hi: 0x84},
	{value: 0x0014, lo: 0x86, hi: 0x88},
	{value: 0x0014, lo: 0x8a, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0034, lo: 0x95, hi: 0x96},
	{value: 0x0010, lo: 0x98, hi: 0x99},
	{value: 0x0010, lo: 0xa0, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa3},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	// Block 0x29, offset 0x15c
	{value: 0x0014, lo: 0x81, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8c},
	{value: 0x0010, lo: 0x8e, hi: 0x90},
	{value: 0x0010, lo: 0x92, hi: 0xa8},
	{value: 0x0010, lo: 0xaa, hi: 0xb3},
	{value: 0x0010, lo: 0xb5, hi: 0xb9},
	{value: 0x0034, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbe},
	{value: 0x0014, lo: 0xbf, hi: 0xbf},
	// Block 0x2a, offset 0x166
	{value: 0x0010, lo: 0x80, hi: 0x84},
	{value: 0x0014, lo: 0x86, hi: 0x86},
	{value: 0x0010, lo: 0x87, hi: 0x88},
	{value: 0x0010, lo: 0x8a, hi: 0x8b},
	{value: 0x0014, lo: 0x8c, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x95, hi: 0x96},
	{value: 0x0010, lo: 0x9e, hi: 0x9e},
	{value: 0x0010, lo: 0xa0, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa3},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	{value: 0x0010, lo: 0xb1, hi: 0xb2},
	// Block 0x2b, offset 0x172
	{value: 0x0014, lo: 0x81, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8c},
	{value: 0x0010, lo: 0x8e, hi: 0x90},
	{value: 0x0010, lo: 0x92, hi: 0xba},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0x2c, offset 0x178
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x84},
	{value: 0x0010, lo: 0x86, hi: 0x88},
	{value: 0x0010, lo: 0x8a, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x8e, hi: 0x8e},
	{value: 0x0010, lo: 0x97, hi: 0x97},
	{value: 0x0010, lo: 0xa0, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa3},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	{value: 0x0010, lo: 0xba, hi: 0xbf},
	// Block 0x2d, offset 0x183
	{value: 0x0010, lo: 0x82, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x96},
	{value: 0x0010, lo: 0x9a, hi: 0xb1},
	{value: 0x0010, lo: 0xb3, hi: 0xbb},
	{value: 0x0010, lo: 0xbd, hi: 0xbd},
	// Block 0x2e, offset 0x188
	{value: 0x0010, lo: 0x80, hi: 0x86},
	{value: 0x0034, lo: 0x8a, hi: 0x8a},
	{value: 0x0010, lo: 0x8f, hi: 0x91},
	{value: 0x0014, lo: 0x92, hi: 0x94},
	{value: 0x0014, lo: 0x96, hi: 0x96},
	{value: 0x0010, lo: 0x98, hi: 0x9f},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	{value: 0x0010, lo: 0xb2, hi: 0xb3},
	// Block 0x2f, offset 0x190
	{value: 0x0014, lo: 0xb1, hi: 0xb1},
	{value: 0x0014, lo: 0xb4, hi: 0xb7},
	{value: 0x0034, lo: 0xb8, hi: 0xba},
	// Block 0x30, offset 0x193
	{value: 0x0004, lo: 0x86, hi: 0x86},
	{value: 0x0014, lo: 0x87, hi: 0x87},
	{value: 0x0034, lo: 0x88, hi: 0x8b},
	{value: 0x0014, lo: 0x8c, hi: 0x8e},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	// Block 0x31, offset 0x198
	{value: 0x0014, lo: 0xb1, hi: 0xb1},
	{value: 0x0014, lo: 0xb4, hi: 0xb7},
	{value: 0x0034, lo: 0xb8, hi: 0xb9},
	{value: 0x0014, lo: 0xbb, hi: 0xbc},
	// Block 0x32, offset 0x19c
	{value: 0x0004, lo: 0x86, hi: 0x86},
	{value: 0x0034, lo: 0x88, hi: 0x8b},
	{value: 0x0014, lo: 0x8c, hi: 0x8d},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	// Block 0x33, offset 0x1a0
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0034, lo: 0x98, hi: 0x99},
	{value: 0x0010, lo: 0xa0, hi: 0xa9},
	{value: 0x0034, lo: 0xb5, hi: 0xb5},
	{value: 0x0034, lo: 0xb7, hi: 0xb7},
	{value: 0x0034, lo: 0xb9, hi: 0xb9},
	{value: 0x0010, lo: 0xbe, hi: 0xbf},
	// Block 0x34, offset 0x1a7
	{value: 0x0010, lo: 0x80, hi: 0x87},
	{value: 0x0010, lo: 0x89, hi: 0xac},
	{value: 0x0034, lo: 0xb1, hi: 0xb2},
	{value: 0x0014, lo: 0xb3, hi: 0xb3},
	{value: 0x0034, lo: 0xb4, hi: 0xb4},
	{value: 0x0014, lo: 0xb5, hi: 0xb9},
	{value: 0x0034, lo: 0xba, hi: 0xbd},
	{value: 0x0014, lo: 0xbe, hi: 0xbe},
	{value: 0x0010, lo: 0xbf, hi: 0xbf},
	// Block 0x35, offset 0x1b0
	{value: 0x0034, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x81},
	{value: 0x0024, lo: 0x82, hi: 0x83},
	{value: 0x0034, lo: 0x84, hi: 0x84},
	{value: 0x0024, lo: 0x86, hi: 0x87},
	{value: 0x0010, lo: 0x88, hi: 0x8c},
	{value: 0x0014, lo: 0x8d, hi: 0x97},
	{value: 0x0014, lo: 0x99, hi: 0xbc},
	// Block 0x36, offset 0x1b8
	{value: 0x0034, lo: 0x86, hi: 0x86},
	// Block 0x37, offset 0x1b9
	{value: 0x0010, lo: 0xab, hi: 0xac},
	{value: 0x0014, lo: 0xad, hi: 0xb0},
	{value: 0x0010, lo: 0xb1, hi: 0xb1},
	{value: 0x0014, lo: 0xb2, hi: 0xb6},
	{value: 0x0034, lo: 0xb7, hi: 0xb7},
	{value: 0x0010, lo: 0xb8, hi: 0xb8},
	{value: 0x0034, lo: 0xb9, hi: 0xba},
	{value: 0x0010, lo: 0xbb, hi: 0xbc},
	{value: 0x0014, lo: 0xbd, hi: 0xbe},
	// Block 0x38, offset 0x1c2
	{value: 0x0010, lo: 0x80, hi: 0x89},
	{value: 0x0010, lo: 0x96, hi: 0x97},
	{value: 0x0014, lo: 0x98, hi: 0x99},
	{value: 0x0014, lo: 0x9e, hi: 0xa0},
	{value: 0x0010, lo: 0xa2, hi: 0xa4},
	{value: 0x0010, lo: 0xa7, hi: 0xad},
	{value: 0x0014, lo: 0xb1, hi: 0xb4},
	// Block 0x39, offset 0x1c9
	{value: 0x2e7b, lo: 0x80, hi: 0x80},
	{value: 0x2f1b, lo: 0x81, hi: 0x81},
	{value: 0x2fbb, lo: 0x82, hi: 0x82},
	{value: 0x305b, lo: 0x83, hi: 0x83},
	{value: 0x30fb, lo: 0x84, hi: 0x84},
	{value: 0x319b, lo: 0x85, hi: 0x85},
	{value: 0x323b, lo: 0x87, hi: 0x87},
	{value: 0x32db, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x90, hi: 0xba},
	{value: 0x0014, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0x3a, offset 0x1d4
	{value: 0x0010, lo: 0x80, hi: 0x88},
	{value: 0x0010, lo: 0x8a, hi: 0x8d},
	{value: 0x0010, lo: 0x90, hi: 0x96},
	{value: 0x0010, lo: 0x98, hi: 0x98},
	{value: 0x0010, lo: 0x9a, hi: 0x9d},
	{value: 0x0010, lo: 0xa0, hi: 0xbf},
	// Block 0x3b, offset 0x1da
	{value: 0x0010, lo: 0x80, hi: 0x88},
	{value: 0x0010, lo: 0x8a, hi: 0x8d},
	{value: 0x0010, lo: 0x90, hi: 0xb0},
	{value: 0x0010, lo: 0xb2, hi: 0xb5},
	{value: 0x0010, lo: 0xb8, hi: 0xbe},
	// Block 0x3c, offset 0x1df
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x82, hi: 0x85},
	{value: 0x0010, lo: 0x88, hi: 0x96},
	{value: 0x0010, lo: 0x98, hi: 0xbf},
	// Block 0x3d, offset 0x1e3
	{value: 0x0010, lo: 0x80, hi: 0x90},
	{value: 0x0010, lo: 0x92, hi: 0x95},
	{value: 0x0010, lo: 0x98, hi: 0xbf},
	// Block 0x3e, offset 0x1e6
	{value: 0x0010, lo: 0x80, hi: 0x9a},
	{value: 0x0024, lo: 0x9d, hi: 0x9f},
	// Block 0x3f, offset 0x1e8
	{value: 0x0010, lo: 0x80, hi: 0x8f},
	{value: 0x0010, lo: 0xa0, hi: 0xbf},
	// Block 0x40, offset 0x1ea
	{value: 0x0010, lo: 0x80, hi: 0xb4},
	// Block 0x41, offset 0x1eb
	{value: 0x0010, lo: 0x81, hi: 0xbf},
	// Block 0x42, offset 0x1ec
	{value: 0x0010, lo: 0x80, hi: 0xac},
	{value: 0x0010, lo: 0xaf, hi: 0xbf},
	// Block 0x43, offset 0x1ee
	{value: 0x0010, lo: 0x81, hi: 0x9a},
	{value: 0x0010, lo: 0xa0, hi: 0xbf},
	// Block 0x44, offset 0x1f0
	{value: 0x0010, lo: 0x80, hi: 0xaa},
	{value: 0x0010, lo: 0xae, hi: 0xb8},
	// Block 0x45, offset 0x1f2
	{value: 0x0010, lo: 0x80, hi: 0x8c},
	{value: 0x0010, lo: 0x8e, hi: 0x91},
	{value: 0x0014, lo: 0x92, hi: 0x93},
	{value: 0x0034, lo: 0x94, hi: 0x94},
	{value: 0x0010, lo: 0xa0, hi: 0xb1},
	{value: 0x0014, lo: 0xb2, hi: 0xb3},
	{value: 0x0034, lo: 0xb4, hi: 0xb4},
	// Block 0x46, offset 0x1f9
	{value: 0x0010, lo: 0x80, hi: 0x91},
	{value: 0x0014, lo: 0x92, hi: 0x93},
	{value: 0x0010, lo: 0xa0, hi: 0xac},
	{value: 0x0010, lo: 0xae, hi: 0xb0},
	{value: 0x0014, lo: 0xb2, hi: 0xb3},
	// Block 0x47, offset 0x1fe
	{value: 0x0014, lo: 0xb4, hi: 0xb5},
	{value: 0x0010, lo: 0xb6, hi: 0xb6},
	{value: 0x0014, lo: 0xb7, hi: 0xbd},
	{value: 0x0010, lo: 0xbe, hi: 0xbf},
	// Block 0x48, offset 0x202
	{value: 0x0010, lo: 0x80, hi: 0x85},
	{value: 0x0014, lo: 0x86, hi: 0x86},
	{value: 0x0010, lo: 0x87, hi: 0x88},
	{value: 0x0014, lo: 0x89, hi: 0x91},
	{value: 0x0034, lo: 0x92, hi: 0x92},
	{value: 0x0014, lo: 0x93, hi: 0x93},
	{value: 0x0004, lo: 0x97, hi: 0x97},
	{value: 0x0024, lo: 0x9d, hi: 0x9d},
	{value: 0x0010, lo: 0xa0, hi: 0xa9},
	// Block 0x49, offset 0x20b
	{value: 0x0014, lo: 0x8b, hi: 0x8e},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	{value: 0x0010, lo: 0xa0, hi: 0xbf},
	// Block 0x4a, offset 0x20e
	{value: 0x0010, lo: 0x80, hi: 0x82},
	{value: 0x0014, lo: 0x83, hi: 0x83},
	{value: 0x0010, lo: 0x84, hi: 0xb7},
	// Block 0x4b, offset 0x211
	{value: 0x0010, lo: 0x80, hi: 0xa8},
	{value: 0x0034, lo: 0xa9, hi: 0xa9},
	{value: 0x0010, lo: 0xaa, hi: 0xaa},
	{value: 0x0010, lo: 0xb0, hi: 0xbf},
	// Block 0x4c, offset 0x215
	{value: 0x0010, lo: 0x80, hi: 0xb5},
	// Block 0x4d, offset 0x216
	{value: 0x0010, lo: 0x80, hi: 0x9e},
	{value: 0x0014, lo: 0xa0, hi: 0xa2},
	{value: 0x0010, lo: 0xa3, hi: 0xa6},
	{value: 0x0014, lo: 0xa7, hi: 0xa8},
	{value: 0x0010, lo: 0xa9, hi: 0xab},
	{value: 0x0010, lo: 0xb0, hi: 0xb1},
	{value: 0x0014, lo: 0xb2, hi: 0xb2},
	{value: 0x0010, lo: 0xb3, hi: 0xb8},
	{value: 0x0034, lo: 0xb9, hi: 0xb9},
	{value: 0x0024, lo: 0xba, hi: 0xba},
	{value: 0x0034, lo: 0xbb, hi: 0xbb},
	// Block 0x4e, offset 0x221
	{value: 0x0010, lo: 0x86, hi: 0x8f},
	// Block 0x4f, offset 0x222
	{value: 0x0010, lo: 0xb0, hi: 0xbf},
	// Block 0x50, offset 0x223
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x88, hi: 0x89},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	// Block 0x51, offset 0x226
	{value: 0x0010, lo: 0x80, hi: 0x96},
	{value: 0x0024, lo: 0x97, hi: 0x97},
	{value: 0x0034, lo: 0x98, hi: 0x98},
	{value: 0x0010, lo: 0x99, hi: 0x9a},
	{value: 0x0014, lo: 0x9b, hi: 0x9b},
	// Block 0x52, offset 0x22b
	{value: 0x0010, lo: 0x95, hi: 0x95},
	{value: 0x0014, lo: 0x96, hi: 0x96},
	{value: 0x0010, lo: 0x97, hi: 0x97},
	{value: 0x0014, lo: 0x98, hi: 0x9e},
	{value: 0x0034, lo: 0xa0, hi: 0xa0},
	{value: 0x0010, lo: 0xa1, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa2},
	{value: 0x0010, lo: 0xa3, hi: 0xa4},
	{value: 0x0014, lo: 0xa5, hi: 0xac},
	{value: 0x0010, lo: 0xad, hi: 0xb2},
	{value: 0x0014, lo: 0xb3, hi: 0xb4},
	{value: 0x0024, lo: 0xb5, hi: 0xbc},
	{value: 0x0034, lo: 0xbf, hi: 0xbf},
	// Block 0x53, offset 0x238
	{value: 0x0010, lo: 0x80, hi: 0x89},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	{value: 0x0004, lo: 0xa7, hi: 0xa7},
	{value: 0x0024, lo: 0xb0, hi: 0xb4},
	{value: 0x0034, lo: 0xb5, hi: 0xba},
	{value: 0x0024, lo: 0xbb, hi: 0xbc},
	{value: 0x0034, lo: 0xbd, hi: 0xbd},
	{value: 0x0014, lo: 0xbe, hi: 0xbe},
	// Block 0x54, offset 0x240
	{value: 0x0014, lo: 0x80, hi: 0x83},
	{value: 0x0010, lo: 0x84, hi: 0xb3},
	{value: 0x0034, lo: 0xb4, hi: 0xb4},
	{value: 0x0010, lo: 0xb5, hi: 0xb5},
	{value: 0x0014, lo: 0xb6, hi: 0xba},
	{value: 0x0010, lo: 0xbb, hi: 0xbb},
	{value: 0x0014, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0x55, offset 0x248
	{value: 0x0010, lo: 0x80, hi: 0x81},
	{value: 0x0014, lo: 0x82, hi: 0x82},
	{value: 0x0010, lo: 0x83, hi: 0x83},
	{value: 0x0030, lo: 0x84, hi: 0x84},
	{value: 0x0010, lo: 0x85, hi: 0x8b},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	{value: 0x0024, lo: 0xab, hi: 0xab},
	{value: 0x0034, lo: 0xac, hi: 0xac},
	{value: 0x0024, lo: 0xad, hi: 0xb3},
	// Block 0x56, offset 0x251
	{value: 0x0014, lo: 0x80, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa5},
	{value: 0x0010, lo: 0xa6, hi: 0xa7},
	{value: 0x0014, lo: 0xa8, hi: 0xa9},
	{value: 0x0030, lo: 0xaa, hi: 0xaa},
	{value: 0x0034, lo: 0xab, hi: 0xab},
	{value: 0x0014, lo: 0xac, hi: 0xad},
	{value: 0x0010, lo: 0xae, hi: 0xbf},
	// Block 0x57, offset 0x25a
	{value: 0x0010, lo: 0x80, hi: 0xa5},
	{value: 0x0034, lo: 0xa6, hi: 0xa6},
	{value: 0x0010, lo: 0xa7, hi: 0xa7},
	{value: 0x0014, lo: 0xa8, hi: 0xa9},
	{value: 0x0010, lo: 0xaa, hi: 0xac},
	{value: 0x0014, lo: 0xad, hi: 0xad},
	{value: 0x0010, lo: 0xae, hi: 0xae},
	{value: 0x0014, lo: 0xaf, hi: 0xb1},
	{value: 0x0030, lo: 0xb2, hi: 0xb3},
	// Block 0x58, offset 0x263
	{value: 0x0010, lo: 0x80, hi: 0xab},
	{value: 0x0014, lo: 0xac, hi: 0xb3},
	{value: 0x0010, lo: 0xb4, hi: 0xb5},
	{value: 0x0014, lo: 0xb6, hi: 0xb6},
	{value: 0x0034, lo: 0xb7, hi: 0xb7},
	// Block 0x59, offset 0x268
	{value: 0x0010, lo: 0x80, hi: 0x89},
	{value: 0x0010, lo: 0x8d, hi: 0xb7},
	{value: 0x0014, lo: 0xb8, hi: 0xbd},
	// Block 0x5a, offset 0x26b
	{value: 0x0024, lo: 0x90, hi: 0x92},
	{value: 0x0034, lo: 0x94, hi: 0x99},
	{value: 0x0024, lo: 0x9a, hi: 0x9b},
	{value: 0x0034, lo: 0x9c, hi: 0x9f},
	{value: 0x0024, lo: 0xa0, hi: 0xa0},
	{value: 0x0010, lo: 0xa1, hi: 0xa1},
	{value: 0x0034, lo: 0xa2, hi: 0xa8},
	{value: 0x0010, lo: 0xa9, hi: 0xac},
	{value: 0x0034, lo: 0xad, hi: 0xad},
	{value: 0x0010, lo: 0xae, hi: 0xb3},
	{value: 0x0024, lo: 0xb4, hi: 0xb4},
	{value: 0x0010, lo: 0xb5, hi: 0xb6},
	{value: 0x0024, lo: 0xb8, hi: 0xb9},
	// Block 0x5b, offset 0x278
	{value: 0x0012, lo: 0x80, hi: 0xab},
	{value: 0x0015, lo: 0xac, hi: 0xbf},
	// Block 0x5c, offset 0x27a
	{value: 0x0015, lo: 0x80, hi: 0xaa},
	{value: 0x0012, lo: 0xab, hi: 0xb7},
	{value: 0x0015, lo: 0xb8, hi: 0xb8},
	{value: 0x337a, lo: 0xb9, hi: 0xb9},
	{value: 0x0012, lo: 0xba, hi: 0xbc},
	{value: 0x341a, lo: 0xbd, hi: 0xbd},
	{value: 0x0012, lo: 0xbe, hi: 0xbf},
	// Block 0x5d, offset 0x281
	{value: 0x0012, lo: 0x80, hi: 0x9a},
	{value: 0x0015, lo: 0x9b, hi: 0xbf},
	// Block 0x5e, offset 0x283
	{value: 0x0024, lo: 0x80, hi: 0x81},
	{value: 0x0034, lo: 0x82, hi: 0x82},
	{value: 0x0024, lo: 0x83, hi: 0x89},
	{value: 0x0034, lo: 0x8a, hi: 0x8a},
	{value: 0x0024, lo: 0x8b, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x90},
	{value: 0x0024, lo: 0x91, hi: 0xb5},
	{value: 0x0034, lo: 0xbc, hi: 0xbd},
	{value: 0x0024, lo: 0xbe, hi: 0xbe},
	{value: 0x0034, lo: 0xbf, hi: 0xbf},
	// Block 0x5f, offset 0x28d
	{value: 0x0057, lo: 0x80, hi: 0xbf},
	// Block 0x60, offset 0x28e
	{value: 0x0057, lo: 0x80, hi: 0x95},
	{value: 0x34ba, lo: 0x96, hi: 0x96},
	{value: 0x355a, lo: 0x97, hi: 0x97},
	{value: 0x35fa, lo: 0x98, hi: 0x98},
	{value: 0x369a, lo: 0x99, hi: 0x99},
	{value: 0x373a, lo: 0x9a, hi: 0x9a},
	{value: 0x3ed2, lo: 0x9b, hi: 0x9b},
	{value: 0x0012, lo: 0x9c, hi: 0x9d},
	{value: 0x37db, lo: 0x9e, hi: 0x9e},
	{value: 0x0012, lo: 0x9f, hi: 0x9f},
	{value: 0x0057, lo: 0xa0, hi: 0xbf},
	// Block 0x61, offset 0x299
	{value: 0x0212, lo: 0x80, hi: 0x87},
	{value: 0x0213, lo: 0x88, hi: 0x8f},
	{value: 0x0212, lo: 0x90, hi: 0x95},
	{value: 0x0213, lo: 0x98, hi: 0x9d},
	{value: 0x0212, lo: 0xa0, hi: 0xa7},
	{value: 0x0213, lo: 0xa8, hi: 0xaf},
	{value: 0x0212, lo: 0xb0, hi: 0xb7},
	{value: 0x0213, lo: 0xb8, hi: 0xbf},
	// Block 0x62, offset 0x2a1
	{value: 0x0004, lo: 0x8b, hi: 0x8b},
	{value: 0x0014, lo: 0x8c, hi: 0x8f},
	{value: 0x0014, lo: 0x98, hi: 0x99},
	{value: 0x0014, lo: 0xa4, hi: 0xa4},
	{value: 0x0014, lo: 0xa7, hi: 0xa7},
	{value: 0x0014, lo: 0xaa, hi: 0xae},
	{value: 0x0010, lo: 0xbf, hi: 0xbf},
	// Block 0x63, offset 0x2a8
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x94, hi: 0x94},
	{value: 0x0014, lo: 0xa0, hi: 0xa4},
	{value: 0x0014, lo: 0xa6, hi: 0xaf},
	{value: 0x0015, lo: 0xb1, hi: 0xb1},
	{value: 0x0015, lo: 0xbf, hi: 0xbf},
	// Block 0x64, offset 0x2ae
	{value: 0x0015, lo: 0x90, hi: 0x9c},
	// Block 0x65, offset 0x2af
	{value: 0x0024, lo: 0x90, hi: 0x91},
	{value: 0x0034, lo: 0x92, hi: 0x93},
	{value: 0x0024, lo: 0x94, hi: 0x97},
	{value: 0x0034, lo: 0x98, hi: 0x9a},
	{value: 0x0024, lo: 0x9b, hi: 0x9c},
	{value: 0x0014, lo: 0x9d, hi: 0xa0},
	{value: 0x0024, lo: 0xa1, hi: 0xa1},
	{value: 0x0014, lo: 0xa2, hi: 0xa4},
	{value: 0x0034, lo: 0xa5, hi: 0xa6},
	{value: 0x0024, lo: 0xa7, hi: 0xa7},
	{value: 0x0034, lo: 0xa8, hi: 0xa8},
	{value: 0x0024, lo: 0xa9, hi: 0xa9},
	{value: 0x0034, lo: 0xaa, hi: 0xaf},
	{value: 0x0024, lo: 0xb0, hi: 0xb0},
	// Block 0x66, offset 0x2bd
	{value: 0x0016, lo: 0x85, hi: 0x86},
	{value: 0x0012, lo: 0x87, hi: 0x89},
	{value: 0x1f12, lo: 0x8e, hi: 0x8e},
	{value: 0x0413, lo: 0xa0, hi: 0xaf},
	{value: 0x0412, lo: 0xb0, hi: 0xbf},
	// Block 0x67, offset 0x2c2
	{value: 0x0010, lo: 0x80, hi: 0x82},
	{value: 0x01d6, lo: 0x83, hi: 0x84},
	{value: 0x0010, lo: 0x85, hi: 0x88},
	// Block 0x68, offset 0x2c5
	{value: 0x1993, lo: 0xb6, hi: 0xb7},
	{value: 0x1a93, lo: 0xb8, hi: 0xb9},
	{value: 0x1b93, lo: 0xba, hi: 0xbb},
	{value: 0x1a93, lo: 0xbc, hi: 0xbd},
	{value: 0x1993, lo: 0xbe, hi: 0xbf},
	// Block 0x69, offset 0x2ca
	{value: 0x0c13, lo: 0x80, hi: 0x8f},
	{value: 0x1413, lo: 0x90, hi: 0x9f},
	{value: 0x1c13, lo: 0xa0, hi: 0xae},
	{value: 0x0c12, lo: 0xb0, hi: 0xbf},
	// Block 0x6a, offset 0x2ce
	{value: 0x0057, lo: 0x80, hi: 0xa3},
	{value: 0x0012, lo: 0xa4, hi: 0xa4},
	{value: 0x01d6, lo: 0xab, hi: 0xac},
	{value: 0x00d6, lo: 0xad, hi: 0xae},
	{value: 0x0024, lo: 0xaf, hi: 0xb1},
	{value: 0x0057, lo: 0xb2, hi: 0xb3},
	// Block 0x6b, offset 0x2d4
	{value: 0x0010, lo: 0x80, hi: 0xa7},
	{value: 0x0014, lo: 0xaf, hi: 0xaf},
	{value: 0x0034, lo: 0xbf, hi: 0xbf},
	// Block 0x6c, offset 0x2d7
	{value: 0x0010, lo: 0x80, hi: 0x96},
	{value: 0x0010, lo: 0xa0, hi: 0xa6},
	{value: 0x0010, lo: 0xa8, hi: 0xae},
	{value: 0x0010, lo: 0xb0, hi: 0xb6},
	{value: 0x0010, lo: 0xb8, hi: 0xbe},
	// Block 0x6d, offset 0x2dc
	{value: 0x0010, lo: 0x80, hi: 0x86},
	{value: 0x0010, lo: 0x88, hi: 0x8e},
	{value: 0x0010, lo: 0x90, hi: 0x96},
	{value: 0x0010, lo: 0x98, hi: 0x9e},
	{value: 0x0024, lo: 0xa0, hi: 0xbf},
	// Block 0x6e, offset 0x2e1
	{value: 0x0014, lo: 0xaf, hi: 0xaf},
	// Block 0x6f, offset 0x2e2
	{value: 0x0014, lo: 0x85, hi: 0x85},
	{value: 0x0034, lo: 0xaa, hi: 0xad},
	{value: 0x0030, lo: 0xae, hi: 0xaf},
	{value: 0x0004, lo: 0xb1, hi: 0xb5},
	{value: 0x0014, lo: 0xbb, hi: 0xbb},
	{value: 0x0010, lo: 0xbc, hi: 0xbc},
	// Block 0x70, offset 0x2e8
	{value: 0x0034, lo: 0x99, hi: 0x9a},
	{value: 0x0004, lo: 0x9b, hi: 0x9e},
	// Block 0x71, offset 0x2ea
	{value: 0x0004, lo: 0xbc, hi: 0xbe},
	// Block 0x72, offset 0x2eb
	{value: 0x0010, lo: 0x85, hi: 0xad},
	{value: 0x0010, lo: 0xb1, hi: 0xbf},
	// Block 0x73, offset 0x2ed
	{value: 0x0010, lo: 0x80, hi: 0x8e},
	{value: 0x0010, lo: 0xa0, hi: 0xba},
	// Block 0x74, offset 0x2ef
	{value: 0x0010, lo: 0x80, hi: 0x94},
	{value: 0x0014, lo: 0x95, hi: 0x95},
	{value: 0x0010, lo: 0x96, hi: 0xbf},
	// Block 0x75, offset 0x2f2
	{value: 0x0010, lo: 0x80, hi: 0x8c},
	// Block 0x76, offset 0x2f3
	{value: 0x0010, lo: 0x90, hi: 0xb7},
	{value: 0x0014, lo: 0xb8, hi: 0xbd},
	// Block 0x77, offset 0x2f5
	{value: 0x0010, lo: 0x80, hi: 0x8b},
	{value: 0x0014, lo: 0x8c, hi: 0x8c},
	{value: 0x0010, lo: 0x90, hi: 0xab},
	// Block 0x78, offset 0x2f8
	{value: 0x0057, lo: 0x80, hi: 0xad},
	{value: 0x0010, lo: 0xae, hi: 0xae},
	{value: 0x0024, lo: 0xaf, hi: 0xaf},
	{value: 0x0014, lo: 0xb0, hi: 0xb2},
	{value: 0x0024, lo: 0xb4, hi: 0xbd},
	{value: 0x0014, lo: 0xbf, hi: 0xbf},
	// Block 0x79, offset 0x2fe
	{value: 0x0057, lo: 0x80, hi: 0x9b},
	{value: 0x0015, lo: 0x9c, hi: 0x9d},
	{value: 0x0024, lo: 0x9f, hi: 0x9f},
	{value: 0x0010, lo: 0xa0, hi: 0xbf},
	// Block 0x7a, offset 0x302
	{value: 0x0010, lo: 0x80, hi: 0xaf},
	{value: 0x0024, lo: 0xb0, hi: 0xb1},
	// Block 0x7b, offset 0x304
	{value: 0x0004, lo: 0x80, hi: 0x96},
	{value: 0x0014, lo: 0x97, hi: 0x9f},
	{value: 0x0004, lo: 0xa0, hi: 0xa1},
	{value: 0x0057, lo: 0xa2, hi: 0xaf},
	{value: 0x0012, lo: 0xb0, hi: 0xb1},
	{value: 0x0057, lo: 0xb2, hi: 0xbf},
	// Block 0x7c, offset 0x30a
	{value: 0x0057, lo: 0x80, hi: 0xaf},
	{value: 0x0015, lo: 0xb0, hi: 0xb0},
	{value: 0x0012, lo: 0xb1, hi: 0xb8},
	{value: 0x00d6, lo: 0xb9, hi: 0xba},
	{value: 0x01d6, lo: 0xbb, hi: 0xbc},
	{value: 0xb75b, lo: 0xbd, hi: 0xbd},
	{value: 0x0057, lo: 0xbe, hi: 0xbf},
	// Block 0x7d, offset 0x311
	{value: 0x0057, lo: 0x80, hi: 0x87},
	{value: 0x0014, lo: 0x88, hi: 0x88},
	{value: 0x0004, lo: 0x89, hi: 0x8a},
	{value: 0x01d6, lo: 0x8b, hi: 0x8c},
	{value: 0xb7fb, lo: 0x8d, hi: 0x8d},
	{value: 0x0012, lo: 0x8e, hi: 0x8e},
	{value: 0x0057, lo: 0x90, hi: 0x93},
	{value: 0x0012, lo: 0x94, hi: 0x95},
	{value: 0x0057, lo: 0x96, hi: 0xa9},
	{value: 0xb87b, lo: 0xaa, hi: 0xaa},
	{value: 0xb8fb, lo: 0xab, hi: 0xab},
	{value: 0xb97b, lo: 0xac, hi: 0xac},
	{value: 0xb9fb, lo: 0xad, hi: 0xad},
	{value: 0xba7b, lo: 0xb0, hi: 0xb0},
	{value: 0xbafb, lo: 0xb1, hi: 0xb1},
	// Block 0x7e, offset 0x320
	{value: 0x0010, lo: 0xb7, hi: 0xb7},
	{value: 0x0015, lo: 0xb8, hi: 0xb9},
	{value: 0x0012, lo: 0xba, hi: 0xba},
	{value: 0x0010, lo: 0xbb, hi: 0xbf},
	// Block 0x7f, offset 0x324
	{value: 0x0010, lo: 0x80, hi: 0x81},
	{value: 0x0014, lo: 0x82, hi: 0x82},
	{value: 0x0010, lo: 0x83, hi: 0x85},
	{value: 0x0034, lo: 0x86, hi: 0x86},
	{value: 0x0010, lo: 0x87, hi: 0x8a},
	{value: 0x0014, lo: 0x8b, hi: 0x8b},
	{value: 0x0010, lo: 0x8c, hi: 0xa4},
	{value: 0x0014, lo: 0xa5, hi: 0xa6},
	{value: 0x0010, lo: 0xa7, hi: 0xa7},
	// Block 0x80, offset 0x32d
	{value: 0x0010, lo: 0x80, hi: 0xb3},
	// Block 0x81, offset 0x32e
	{value: 0x0010, lo: 0x80, hi: 0x83},
	{value: 0x0034, lo: 0x84, hi: 0x84},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	{value: 0x0024, lo: 0xa0, hi: 0xb1},
	{value: 0x0010, lo: 0xb2, hi: 0xb7},
	{value: 0x0010, lo: 0xbb, hi: 0xbb},
	// Block 0x82, offset 0x334
	{value: 0x0010, lo: 0x80, hi: 0xa5},
	{value: 0x0014, lo: 0xa6, hi: 0xaa},
	{value: 0x0034, lo: 0xab, hi: 0xad},
	{value: 0x0010, lo: 0xb0, hi: 0xbf},
	// Block 0x83, offset 0x338
	{value: 0x0010, lo: 0x80, hi: 0x86},
	{value: 0x0014, lo: 0x87, hi: 0x91},
	{value: 0x0010, lo: 0x92, hi: 0x92},
	{value: 0x0030, lo: 0x93, hi: 0x93},
	{value: 0x0010, lo: 0xa0, hi: 0xbc},
	// Block 0x84, offset 0x33d
	{value: 0x0014, lo: 0x80, hi: 0x82},
	{value: 0x0010, lo: 0x83, hi: 0xb2},
	{value: 0x0034, lo: 0xb3, hi: 0xb3},
	{value: 0x0010, lo: 0xb4, hi: 0xb5},
	{value: 0x0014, lo: 0xb6, hi: 0xb9},
	{value: 0x0010, lo: 0xba, hi: 0xbb},
	{value: 0x0014, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0x85, offset 0x345
	{value: 0x0030, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x8f, hi: 0x8f},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	{value: 0x0014, lo: 0xa5, hi: 0xa5},
	{value: 0x0004, lo: 0xa6, hi: 0xa6},
	{value: 0x0010, lo: 0xb0, hi: 0xb9},
	// Block 0x86, offset 0x34b
	{value: 0x0010, lo: 0x80, hi: 0xa8},
	{value: 0x0014, lo: 0xa9, hi: 0xae},
	{value: 0x0010, lo: 0xaf, hi: 0xb0},
	{value: 0x0014, lo: 0xb1, hi: 0xb2},
	{value: 0x0010, lo: 0xb3, hi: 0xb4},
	{value: 0x0014, lo: 0xb5, hi: 0xb6},
	// Block 0x87, offset 0x351
	{value: 0x0010, lo: 0x80, hi: 0x82},
	{value: 0x0014, lo: 0x83, hi: 0x83},
	{value: 0x0010, lo: 0x84, hi: 0x8b},
	{value: 0x0014, lo: 0x8c, hi: 0x8c},
	{value: 0x0010, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	{value: 0x0004, lo: 0xb0, hi: 0xb0},
	{value: 0x0010, lo: 0xbb, hi: 0xbb},
	{value: 0x0014, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbd},
	// Block 0x88, offset 0x35b
	{value: 0x0024, lo: 0xb0, hi: 0xb0},
	{value: 0x0024, lo: 0xb2, hi: 0xb3},
	{value: 0x0034, lo: 0xb4, hi: 0xb4},
	{value: 0x0024, lo: 0xb7, hi: 0xb8},
	{value: 0x0024, lo: 0xbe, hi: 0xbf},
	// Block 0x89, offset 0x360
	{value: 0x0024, lo: 0x81, hi: 0x81},
	{value: 0x0004, lo: 0x9d, hi: 0x9d},
	{value: 0x0010, lo: 0xa0, hi: 0xab},
	{value: 0x0014, lo: 0xac, hi: 0xad},
	{value: 0x0010, lo: 0xae, hi: 0xaf},
	{value: 0x0010, lo: 0xb2, hi: 0xb2},
	{value: 0x0014, lo: 0xb3, hi: 0xb4},
	{value: 0x0010, lo: 0xb5, hi: 0xb5},
	{value: 0x0034, lo: 0xb6, hi: 0xb6},
	// Block 0x8a, offset 0x369
	{value: 0x0010, lo: 0x81, hi: 0x86},
	{value: 0x0010, lo: 0x89, hi: 0x8e},
	{value: 0x0010, lo: 0x91, hi: 0x96},
	{value: 0x0010, lo: 0xa0, hi: 0xa6},
	{value: 0x0010, lo: 0xa8, hi: 0xae},
	{value: 0x0012, lo: 0xb0, hi: 0xbf},
	// Block 0x8b, offset 0x36f
	{value: 0x0012, lo: 0x80, hi: 0x9a},
	{value: 0x0004, lo: 0x9b, hi: 0x9b},
	{value: 0x0015, lo: 0x9c, hi: 0x9f},
	{value: 0x0012, lo: 0xa4, hi: 0xa5},
	// Block 0x8c, offset 0x373
	{value: 0x0010, lo: 0x80, hi: 0xa4},
	{value: 0x0014, lo: 0xa5, hi: 0xa5},
	{value: 0x0010, lo: 0xa6, hi: 0xa7},
	{value: 0x0014, lo: 0xa8, hi: 0xa8},
	{value: 0x0010, lo: 0xa9, hi: 0xaa},
	{value: 0x0010, lo: 0xac, hi: 0xac},
	{value: 0x0034, lo: 0xad, hi: 0xad},
	{value: 0x0010, lo: 0xb0, hi: 0xb9},
	// Block 0x8d, offset 0x37b
	{value: 0x0010, lo: 0x80, hi: 0xa3},
	{value: 0x0010, lo: 0xb0, hi: 0xbf},
	// Block 0x8e, offset 0x37d
	{value: 0x0010, lo: 0x80, hi: 0x86},
	{value: 0x0010, lo: 0x8b, hi: 0xbb},
	// Block 0x8f, offset 0x37f
	{value: 0x0010, lo: 0x80, hi: 0x81},
	{value: 0x0010, lo: 0x83, hi: 0x84},
	{value: 0x0010, lo: 0x86, hi: 0xbf},
	// Block 0x90, offset 0x382
	{value: 0x0010, lo: 0x80, hi: 0xb1},
	{value: 0x0004, lo: 0xb2, hi: 0xbf},
	// Block 0x91, offset 0x384
	{value: 0x0004, lo: 0x80, hi: 0x81},
	{value: 0x0010, lo: 0x93, hi: 0xbf},
	// Block 0x92, offset 0x386
	{value: 0x0010, lo: 0x80, hi: 0xbd},
	// Block 0x93, offset 0x387
	{value: 0x0010, lo: 0x90, hi: 0xbf},
	// Block 0x94, offset 0x388
	{value: 0x0010, lo: 0x80, hi: 0x8f},
	{value: 0x0010, lo: 0x92, hi: 0xbf},
	// Block 0x95, offset 0x38a
	{value: 0x0010, lo: 0x80, hi: 0x87},
	{value: 0x0010, lo: 0xb0, hi: 0xbb},
	// Block 0x96, offset 0x38c
	{value: 0x0014, lo: 0x80, hi: 0x8f},
	{value: 0x0014, lo: 0x93, hi: 0x93},
	{value: 0x0024, lo: 0xa0, hi: 0xa6},
	{value: 0x0034, lo: 0xa7, hi: 0xad},
	{value: 0x0010, lo: 0xb3, hi: 0xb4},
	// Block 0x97, offset 0x391
	{value: 0x0010, lo: 0x8d, hi: 0x8f},
	{value: 0x0014, lo: 0x92, hi: 0x92},
	{value: 0x0014, lo: 0x95, hi: 0x95},
	{value: 0x0010, lo: 0xb0, hi: 0xb4},
	{value: 0x0010, lo: 0xb6, hi: 0xbf},
	// Block 0x98, offset 0x396
	{value: 0x0010, lo: 0x80, hi: 0xbc},
	{value: 0x0014, lo: 0xbf, hi: 0xbf},
	// Block 0x99, offset 0x398
	{value: 0x0014, lo: 0x87, hi: 0x87},
	{value: 0x0014, lo: 0x8e, hi: 0x8e},
	{value: 0x0014, lo: 0x9a, hi: 0x9a},
	{value: 0x1813, lo: 0xa1, hi: 0xba},
	{value: 0x0004, lo: 0xbe, hi: 0xbe},
	{value: 0x0010, lo: 0xbf, hi: 0xbf},
	// Block 0x9a, offset 0x39e
	{value: 0x0004, lo: 0x80, hi: 0x80},
	{value: 0x1812, lo: 0x81, hi: 0x9a},
	{value: 0x0004, lo: 0xb0, hi: 0xb0},
	// Block 0x9b, offset 0x3a1
	{value: 0x0014, lo: 0x9e, hi: 0x9f},
	{value: 0x0010, lo: 0xa0, hi: 0xbe},
	// Block 0x9c, offset 0x3a3
	{value: 0x0010, lo: 0x82, hi: 0x87},
	{value: 0x0010, lo: 0x8a, hi: 0x8f},
	{value: 0x0010, lo: 0x92, hi: 0x97},
	{value: 0x0010, lo: 0x9a, hi: 0x9c},
	{value: 0x0004, lo: 0xa3, hi: 0xa3},
	{value: 0x0014, lo: 0xb9, hi: 0xbb},
	// Block 0x9d, offset 0x3a9
	{value: 0x0010, lo: 0x80, hi: 0x8b},
	{value: 0x0010, lo: 0x8d, hi: 0xa6},
	{value: 0x0010, lo: 0xa8, hi: 0xba},
	{value: 0x0010, lo: 0xbc, hi: 0xbd},
	{value: 0x0010, lo: 0xbf, hi: 0xbf},
	// Block 0x9e, offset 0x3ae
	{value: 0x0010, lo: 0x80, hi: 0x8d},
	{value: 0x0010, lo: 0x90, hi: 0x9d},
	// Block 0x9f, offset 0x3b0
	{value: 0x0010, lo: 0x80, hi: 0xba},
	// Block 0xa0, offset 0x3b1
	{value: 0x0034, lo: 0xbd, hi: 0xbd},
	// Block 0xa1, offset 0x3b2
	{value: 0x0010, lo: 0x80, hi: 0x9c},
	{value: 0x0010, lo: 0xa0, hi: 0xbf},
	// Block 0xa2, offset 0x3b4
	{value: 0x0010, lo: 0x80, hi: 0x90},
	{value: 0x0034, lo: 0xa0, hi: 0xa0},
	// Block 0xa3, offset 0x3b6
	{value: 0x0010, lo: 0x80, hi: 0x9f},
	{value: 0x0010, lo: 0xb0, hi: 0xbf},
	// Block 0xa4, offset 0x3b8
	{value: 0x0010, lo: 0x80, hi: 0x8a},
	{value: 0x0010, lo: 0x90, hi: 0xb5},
	{value: 0x0024, lo: 0xb6, hi: 0xba},
	// Block 0xa5, offset 0x3bb
	{value: 0x0010, lo: 0x80, hi: 0x9d},
	{value: 0x0010, lo: 0xa0, hi: 0xbf},
	// Block 0xa6, offset 0x3bd
	{value: 0x0010, lo: 0x80, hi: 0x83},
	{value: 0x0010, lo: 0x88, hi: 0x8f},
	{value: 0x0010, lo: 0x91, hi: 0x95},
	// Block 0xa7, offset 0x3c0
	{value: 0x0a13, lo: 0x80, hi: 0x87},
	{value: 0x0e13, lo: 0x88, hi: 0x8f},
	{value: 0x0a13, lo: 0x90, hi: 0x97},
	{value: 0x1613, lo: 0x98, hi: 0x9f},
	{value: 0x1a13, lo: 0xa0, hi: 0xa7},
	{value: 0x0a12, lo: 0xa8, hi: 0xaf},
	{value: 0x0e12, lo: 0xb0, hi: 0xb7},
	{value: 0x0a12, lo: 0xb8, hi: 0xbf},
	// Block 0xa8, offset 0x3c8
	{value: 0x1612, lo: 0x80, hi: 0x87},
	{value: 0x1a12, lo: 0x88, hi: 0x8f},
	{value: 0x0010, lo: 0x90, hi: 0xbf},
	// Block 0xa9, offset 0x3cb
	{value: 0x0010, lo: 0x80, hi: 0x9d},
	{value: 0x0010, lo: 0xa0, hi: 0xa9},
	// Block 0xaa, offset 0x3cd
	{value: 0x0010, lo: 0x80, hi: 0xa7},
	{value: 0x0010, lo: 0xb0, hi: 0xbf},
	// Block 0xab, offset 0x3cf
	{value: 0x0010, lo: 0x80, hi: 0xa3},
	// Block 0xac, offset 0x3d0
	{value: 0x0010, lo: 0x80, hi: 0xb6},
	// Block 0xad, offset 0x3d1
	{value: 0x0010, lo: 0x80, hi: 0x95},
	{value: 0x0010, lo: 0xa0, hi: 0xa7},
	// Block 0xae, offset 0x3d3
	{value: 0x0010, lo: 0x80, hi: 0x85},
	{value: 0x0010, lo: 0x88, hi: 0x88},
	{value: 0x0010, lo: 0x8a, hi: 0xb5},
	{value: 0x0010, lo: 0xb7, hi: 0xb8},
	{value: 0x0010, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbf, hi: 0xbf},
	// Block 0xaf, offset 0x3d9
	{value: 0x0010, lo: 0x80, hi: 0x95},
	{value: 0x0010, lo: 0xa0, hi: 0xb6},
	// Block 0xb0, offset 0x3db
	{value: 0x0010, lo: 0x80, hi: 0x9e},
	// Block 0xb1, offset 0x3dc
	{value: 0x0010, lo: 0x80, hi: 0x95},
	{value: 0x0010, lo: 0xa0, hi: 0xb9},
	// Block 0xb2, offset 0x3de
	{value: 0x0010, lo: 0x80, hi: 0xb7},
	{value: 0x0010, lo: 0xbe, hi: 0xbf},
	// Block 0xb3, offset 0x3e0
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x83},
	{value: 0x0014, lo: 0x85, hi: 0x86},
	{value: 0x0014, lo: 0x8c, hi: 0x8c},
	{value: 0x0034, lo: 0x8d, hi: 0x8d},
	{value: 0x0014, lo: 0x8e, hi: 0x8e},
	{value: 0x0024, lo: 0x8f, hi: 0x8f},
	{value: 0x0010, lo: 0x90, hi: 0x93},
	{value: 0x0010, lo: 0x95, hi: 0x97},
	{value: 0x0010, lo: 0x99, hi: 0xb3},
	{value: 0x0024, lo: 0xb8, hi: 0xb8},
	{value: 0x0034, lo: 0xb9, hi: 0xba},
	{value: 0x0034, lo: 0xbf, hi: 0xbf},
	// Block 0xb4, offset 0x3ed
	{value: 0x0010, lo: 0xa0, hi: 0xbc},
	// Block 0xb5, offset 0x3ee
	{value: 0x0010, lo: 0x80, hi: 0x9c},
	// Block 0xb6, offset 0x3ef
	{value: 0x0010, lo: 0x80, hi: 0x87},
	{value: 0x0010, lo: 0x89, hi: 0xa4},
	{value: 0x0024, lo: 0xa5, hi: 0xa5},
	{value: 0x0034, lo: 0xa6, hi: 0xa6},
	// Block 0xb7, offset 0x3f3
	{value: 0x0010, lo: 0x80, hi: 0x95},
	{value: 0x0010, lo: 0xa0, hi: 0xb2},
	// Block 0xb8, offset 0x3f5
	{value: 0x0010, lo: 0x80, hi: 0x91},
	// Block 0xb9, offset 0x3f6
	{value: 0x0010, lo: 0x80, hi: 0x88},
	// Block 0xba, offset 0x3f7
	{value: 0x0010, lo: 0x80, hi: 0x80},
	{value: 0x0014, lo: 0x81, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0xb7},
	{value: 0x0014, lo: 0xb8, hi: 0xbf},
	// Block 0xbb, offset 0x3fb
	{value: 0x0014, lo: 0x80, hi: 0x85},
	{value: 0x0034, lo: 0x86, hi: 0x86},
	{value: 0x0010, lo: 0xa6, hi: 0xaf},
	{value: 0x0034, lo: 0xbf, hi: 0xbf},
	// Block 0xbc, offset 0x3ff
	{value: 0x0014, lo: 0x80, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0xb2},
	{value: 0x0014, lo: 0xb3, hi: 0xb6},
	{value: 0x0010, lo: 0xb7, hi: 0xb8},
	{value: 0x0034, lo: 0xb9, hi: 0xba},
	{value: 0x0014, lo: 0xbd, hi: 0xbd},
	// Block 0xbd, offset 0x405
	{value: 0x0010, lo: 0x90, hi: 0xa8},
	{value: 0x0010, lo: 0xb0, hi: 0xb9},
	// Block 0xbe, offset 0x407
	{value: 0x0024, lo: 0x80, hi: 0x82},
	{value: 0x0010, lo: 0x83, hi: 0xa6},
	{value: 0x0014, lo: 0xa7, hi: 0xab},
	{value: 0x0010, lo: 0xac, hi: 0xac},
	{value: 0x0014, lo: 0xad, hi: 0xb2},
	{value: 0x0034, lo: 0xb3, hi: 0xb4},
	{value: 0x0010, lo: 0xb6, hi: 0xbf},
	// Block 0xbf, offset 0x40e
	{value: 0x0010, lo: 0x90, hi: 0xb2},
	{value: 0x0034, lo: 0xb3, hi: 0xb3},
	{value: 0x0010, lo: 0xb6, hi: 0xb6},
	// Block 0xc0, offset 0x411
	{value: 0x0014, lo: 0x80, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0xb5},
	{value: 0x0014, lo: 0xb6, hi: 0xbe},
	{value: 0x0010, lo: 0xbf, hi: 0xbf},
	// Block 0xc1, offset 0x415
	{value: 0x0030, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x81, hi: 0x84},
	{value: 0x0010, lo: 0x90, hi: 0x9a},
	// Block 0xc2, offset 0x418
	{value: 0x0010, lo: 0x80, hi: 0x91},
	{value: 0x0010, lo: 0x93, hi: 0xae},
	{value: 0x0014, lo: 0xaf, hi: 0xb1},
	{value: 0x0010, lo: 0xb2, hi: 0xb3},
	{value: 0x0014, lo: 0xb4, hi: 0xb4},
	{value: 0x0030, lo: 0xb5, hi: 0xb5},
	{value: 0x0034, lo: 0xb6, hi: 0xb6},
	{value: 0x0014, lo: 0xb7, hi: 0xb7},
	// Block 0xc3, offset 0x420
	{value: 0x0010, lo: 0x80, hi: 0x9e},
	{value: 0x0014, lo: 0x9f, hi: 0x9f},
	{value: 0x0010, lo: 0xa0, hi: 0xa2},
	{value: 0x0014, lo: 0xa3, hi: 0xa8},
	{value: 0x0034, lo: 0xa9, hi: 0xaa},
	{value: 0x0010, lo: 0xb0, hi: 0xb9},
	// Block 0xc4, offset 0x426
	{value: 0x0014, lo: 0x81, hi: 0x81},
	{value: 0x0010, lo: 0x82, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x8c},
	{value: 0x0010, lo: 0x8f, hi: 0x90},
	{value: 0x0010, lo: 0x93, hi: 0xa8},
	{value: 0x0010, lo: 0xaa, hi: 0xb0},
	{value: 0x0010, lo: 0xb2, hi: 0xb3},
	{value: 0x0010, lo: 0xb5, hi: 0xb9},
	{value: 0x0034, lo: 0xbc, hi: 0xbc},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0xc5, offset 0x430
	{value: 0x0014, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x81, hi: 0x84},
	{value: 0x0010, lo: 0x87, hi: 0x88},
	{value: 0x0010, lo: 0x8b, hi: 0x8c},
	{value: 0x0030, lo: 0x8d, hi: 0x8d},
	{value: 0x0010, lo: 0x97, hi: 0x97},
	{value: 0x0010, lo: 0x9d, hi: 0xa3},
	{value: 0x0024, lo: 0xa6, hi: 0xac},
	{value: 0x0024, lo: 0xb0, hi: 0xb4},
	// Block 0xc6, offset 0x439
	{value: 0x0010, lo: 0x80, hi: 0xb2},
	{value: 0x0014, lo: 0xb3, hi: 0xb8},
	{value: 0x0010, lo: 0xb9, hi: 0xb9},
	{value: 0x0014, lo: 0xba, hi: 0xba},
	{value: 0x0010, lo: 0xbb, hi: 0xbe},
	{value: 0x0014, lo: 0xbf, hi: 0xbf},
	// Block 0xc7, offset 0x43f
	{value: 0x0014, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x81, hi: 0x81},
	{value: 0x0034, lo: 0x82, hi: 0x83},
	{value: 0x0010, lo: 0x84, hi: 0x85},
	{value: 0x0010, lo: 0x87, hi: 0x87},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	// Block 0xc8, offset 0x445
	{value: 0x0010, lo: 0x80, hi: 0xb1},
	{value: 0x0014, lo: 0xb2, hi: 0xb5},
	{value: 0x0010, lo: 0xb8, hi: 0xbb},
	{value: 0x0014, lo: 0xbc, hi: 0xbd},
	{value: 0x0010, lo: 0xbe, hi: 0xbe},
	{value: 0x0034, lo: 0xbf, hi: 0xbf},
	// Block 0xc9, offset 0x44b
	{value: 0x0034, lo: 0x80, hi: 0x80},
	// Block 0xca, offset 0x44c
	{value: 0x0010, lo: 0x80, hi: 0xb2},
	{value: 0x0014, lo: 0xb3, hi: 0xba},
	{value: 0x0010, lo: 0xbb, hi: 0xbc},
	{value: 0x0014, lo: 0xbd, hi: 0xbd},
	{value: 0x0010, lo: 0xbe, hi: 0xbe},
	{value: 0x0034, lo: 0xbf, hi: 0xbf},
	// Block 0xcb, offset 0x452
	{value: 0x0014, lo: 0x80, hi: 0x80},
	{value: 0x0010, lo: 0x84, hi: 0x84},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	// Block 0xcc, offset 0x455
	{value: 0x0010, lo: 0x80, hi: 0xaa},
	{value: 0x0014, lo: 0xab, hi: 0xab},
	{value: 0x0010, lo: 0xac, hi: 0xac},
	{value: 0x0014, lo: 0xad, hi: 0xad},
	{value: 0x0010, lo: 0xae, hi: 0xaf},
	{value: 0x0014, lo: 0xb0, hi: 0xb5},
	{value: 0x0030, lo: 0xb6, hi: 0xb6},
	{value: 0x0034, lo: 0xb7, hi: 0xb7},
	// Block 0xcd, offset 0x45d
	{value: 0x0010, lo: 0x80, hi: 0x89},
	// Block 0xce, offset 0x45e
	{value: 0x1813, lo: 0xa0, hi: 0xbf},
	// Block 0xcf, offset 0x45f
	{value: 0x1812, lo: 0x80, hi: 0x9f},
	{value: 0x0010, lo: 0xa0, hi: 0xa9},
	{value: 0x0010, lo: 0xbf, hi: 0xbf},
	// Block 0xd0, offset 0x462
	{value: 0x0010, lo: 0x80, hi: 0xb8},
	// Block 0xd1, offset 0x463
	{value: 0x0010, lo: 0x80, hi: 0x98},
	// Block 0xd2, offset 0x464
	{value: 0x0010, lo: 0x80, hi: 0xae},
	// Block 0xd3, offset 0x465
	{value: 0x0010, lo: 0x80, hi: 0x9e},
	{value: 0x0010, lo: 0xa0, hi: 0xa9},
	// Block 0xd4, offset 0x467
	{value: 0x0010, lo: 0x90, hi: 0xad},
	{value: 0x0034, lo: 0xb0, hi: 0xb4},
	// Block 0xd5, offset 0x469
	{value: 0x0010, lo: 0x80, hi: 0xaf},
	{value: 0x0024, lo: 0xb0, hi: 0xb6},
	// Block 0xd6, offset 0x46b
	{value: 0x0014, lo: 0x80, hi: 0x83},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	{value: 0x0010, lo: 0xa3, hi: 0xb7},
	{value: 0x0010, lo: 0xbd, hi: 0xbf},
	// Block 0xd7, offset 0x46f
	{value: 0x0010, lo: 0x80, hi: 0x8f},
	// Block 0xd8, offset 0x470
	{value: 0x0010, lo: 0x80, hi: 0x84},
	{value: 0x0010, lo: 0x90, hi: 0xbe},
	// Block 0xd9, offset 0x472
	{value: 0x0014, lo: 0x8f, hi: 0x9f},
	// Block 0xda, offset 0x473
	{value: 0x0010, lo: 0x80, hi: 0xaa},
	{value: 0x0010, lo: 0xb0, hi: 0xbc},
	// Block 0xdb, offset 0x475
	{value: 0x0010, lo: 0x80, hi: 0x88},
	{value: 0x0010, lo: 0x90, hi: 0x99},
	{value: 0x0014, lo: 0x9d, hi: 0x9d},
	{value: 0x0034, lo: 0x9e, hi: 0x9e},
	{value: 0x0014, lo: 0xa0, hi: 0xa3},
	// Block 0xdc, offset 0x47a
	{value: 0x0030, lo: 0xa5, hi: 0xa6},
	{value: 0x0034, lo: 0xa7, hi: 0xa9},
	{value: 0x0030, lo: 0xad, hi: 0xb2},
	{value: 0x0014, lo: 0xb3, hi: 0xba},
	{value: 0x0034, lo: 0xbb, hi: 0xbf},
	// Block 0xdd, offset 0x47f
	{value: 0x0034, lo: 0x80, hi: 0x82},
	{value: 0x0024, lo: 0x85, hi: 0x89},
	{value: 0x0034, lo: 0x8a, hi: 0x8b},
	{value: 0x0024, lo: 0xaa, hi: 0xad},
	// Block 0xde, offset 0x483
	{value: 0x0024, lo: 0x82, hi: 0x84},
	// Block 0xdf, offset 0x484
	{value: 0x0013, lo: 0x80, hi: 0x99},
	{value: 0x0012, lo: 0x9a, hi: 0xb3},
	{value: 0x0013, lo: 0xb4, hi: 0xbf},
	// Block 0xe0, offset 0x487
	{value: 0x0013, lo: 0x80, hi: 0x8d},
	{value: 0x0012, lo: 0x8e, hi: 0x94},
	{value: 0x0012, lo: 0x96, hi: 0xa7},
	{value: 0x0013, lo: 0xa8, hi: 0xbf},
	// Block 0xe1, offset 0x48b
	{value: 0x0013, lo: 0x80, hi: 0x81},
	{value: 0x0012, lo: 0x82, hi: 0x9b},
	{value: 0x0013, lo: 0x9c, hi: 0x9c},
	{value: 0x0013, lo: 0x9e, hi: 0x9f},
	{value: 0x0013, lo: 0xa2, hi: 0xa2},
	{value: 0x0013, lo: 0xa5, hi: 0xa6},
	{value: 0x0013, lo: 0xa9, hi: 0xac},
	{value: 0x0013, lo: 0xae, hi: 0xb5},
	{value: 0x0012, lo: 0xb6, hi: 0xb9},
	{value: 0x0012, lo: 0xbb, hi: 0xbb},
	{value: 0x0012, lo: 0xbd, hi: 0xbf},
	// Block 0xe2, offset 0x496
	{value: 0x0012, lo: 0x80, hi: 0x83},
	{value: 0x0012, lo: 0x85, hi: 0x8f},
	{value: 0x0013, lo: 0x90, hi: 0xa9},
	{value: 0x0012, lo: 0xaa, hi: 0xbf},
	// Block 0xe3, offset 0x49a
	{value: 0x0012, lo: 0x80, hi: 0x83},
	{value: 0x0013, lo: 0x84, hi: 0x85},
	{value: 0x0013, lo: 0x87, hi: 0x8a},
	{value: 0x0013, lo: 0x8d, hi: 0x94},
	{value: 0x0013, lo: 0x96, hi: 0x9c},
	{value: 0x0012, lo: 0x9e, hi: 0xb7},
	{value: 0x0013, lo: 0xb8, hi: 0xb9},
	{value: 0x0013, lo: 0xbb, hi: 0xbe},
	// Block 0xe4, offset 0x4a2
	{value: 0x0013, lo: 0x80, hi: 0x84},
	{value: 0x0013, lo: 0x86, hi: 0x86},
	{value: 0x0013, lo: 0x8a, hi: 0x90},
	{value: 0x0012, lo: 0x92, hi: 0xab},
	{value: 0x0013, lo: 0xac, hi: 0xbf},
	// Block 0xe5, offset 0x4a7
	{value: 0x0013, lo: 0x80, hi: 0x85},
	{value: 0x0012, lo: 0x86, hi: 0x9f},
	{value: 0x0013, lo: 0xa0, hi: 0xb9},
	{value: 0x0012, lo: 0xba, hi: 0xbf},
	// Block 0xe6, offset 0x4ab
	{value: 0x0012, lo: 0x80, hi: 0x93},
	{value: 0x0013, lo: 0x94, hi: 0xad},
	{value: 0x0012, lo: 0xae, hi: 0xbf},
	// Block 0xe7, offset 0x4ae
	{value: 0x0012, lo: 0x80, hi: 0x87},
	{value: 0x0013, lo: 0x88, hi: 0xa1},
	{value: 0x0012, lo: 0xa2, hi: 0xbb},
	{value: 0x0013, lo: 0xbc, hi: 0xbf},
	// Block 0xe8, offset 0x4b2
	{value: 0x0013, lo: 0x80, hi: 0x95},
	{value: 0x0012, lo: 0x96, hi: 0xaf},
	{value: 0x0013, lo: 0xb0, hi: 0xbf},
	// Block 0xe9, offset 0x4b5
	{value: 0x0013, lo: 0x80, hi: 0x89},
	{value: 0x0012, lo: 0x8a, hi: 0xa5},
	{value: 0x0013, lo: 0xa8, hi: 0xbf},
	// Block 0xea, offset 0x4b8
	{value: 0x0013, lo: 0x80, hi: 0x80},
	{value: 0x0012, lo: 0x82, hi: 0x9a},
	{value: 0x0012, lo: 0x9c, hi: 0xa1},
	{value: 0x0013, lo: 0xa2, hi: 0xba},
	{value: 0x0012, lo: 0xbc, hi: 0xbf},
	// Block 0xeb, offset 0x4bd
	{value: 0x0012, lo: 0x80, hi: 0x94},
	{value: 0x0012, lo: 0x96, hi: 0x9b},
	{value: 0x0013, lo: 0x9c, hi: 0xb4},
	{value: 0x0012, lo: 0xb6, hi: 0xbf},
	// Block 0xec, offset 0x4c1
	{value: 0x0012, lo: 0x80, hi: 0x8e},
	{value: 0x0012, lo: 0x90, hi: 0x95},
	{value: 0x0013, lo: 0x96, hi: 0xae},
	{value: 0x0012, lo: 0xb0, hi: 0xbf},
	// Block 0xed, offset 0x4c5
	{value: 0x0012, lo: 0x80, hi: 0x88},
	{value: 0x0012, lo: 0x8a, hi: 0x8f},
	{value: 0x0013, lo: 0x90, hi: 0xa8},
	{value: 0x0012, lo: 0xaa, hi: 0xbf},
	// Block 0xee, offset 0x4c9
	{value: 0x0012, lo: 0x80, hi: 0x82},
	{value: 0x0012, lo: 0x84, hi: 0x89},
	{value: 0x0017, lo: 0x8a, hi: 0x8b},
	{value: 0x0010, lo: 0x8e, hi: 0xbf},
	// Block 0xef, offset 0x4cd
	{value: 0x0010, lo: 0x80, hi: 0x84},
	{value: 0x0034, lo: 0x90, hi: 0x96},
	// Block 0xf0, offset 0x4cf
	{value: 0x0010, lo: 0x80, hi: 0x83},
	{value: 0x0010, lo: 0x85, hi: 0x9f},
	{value: 0x0010, lo: 0xa1, hi: 0xa2},
	{value: 0x0010, lo: 0xa4, hi: 0xa4},
	{value: 0x0010, lo: 0xa7, hi: 0xa7},
	{value: 0x0010, lo: 0xa9, hi: 0xb2},
	{value: 0x0010, lo: 0xb4, hi: 0xb7},
	{value: 0x0010, lo: 0xb9, hi: 0xb9},
	{value: 0x0010, lo: 0xbb, hi: 0xbb},
	// Block 0xf1, offset 0x4d8
	{value: 0x0010, lo: 0x80, hi: 0x89},
	{value: 0x0010, lo: 0x8b, hi: 0x9b},
	{value: 0x0010, lo: 0xa1, hi: 0xa3},
	{value: 0x0010, lo: 0xa5, hi: 0xa9},
	{value: 0x0010, lo: 0xab, hi: 0xbb},
	// Block 0xf2, offset 0x4dd
	{value: 0x0013, lo: 0xb0, hi: 0xbf},
	// Block 0xf3, offset 0x4de
	{value: 0x0013, lo: 0x80, hi: 0x89},
	{value: 0x0013, lo: 0x90, hi: 0xa9},
	{value: 0x0013, lo: 0xb0, hi: 0xbf},
	// Block 0xf4, offset 0x4e1
	{value: 0x0013, lo: 0x80, hi: 0x89},
	// Block 0xf5, offset 0x4e2
	{value: 0x0014, lo: 0x81, hi: 0x81},
	{value: 0x0014, lo: 0xa0, hi: 0xbf},
	// Block 0xf6, offset 0x4e4
	{value: 0x0014, lo: 0x80, hi: 0xbf},
	// Block 0xf7, offset 0x4e5
	{value: 0x0014, lo: 0x80, hi: 0xaf},
}

// exceptions: 1595 bytes
var exceptions = "\x00\x00\x12SSSs\x00\x18i̇\x00\bI\x00\x18ʼN\x00\bS\x00\x12ǆǅ\x00\x12ǆǄ\x00\x12Ǆǅ\x00\x12ǉǈ\x00\x12ǉǇ\x00\x12Ǉǈ\x00\x12ǌǋ\x00\x12ǌǊ\x00\x12Ǌǋ\x00\x18J̌\x00\x12ǳǲ\x00\x12ǳǱ\x00\x12Ǳǲ\x00\x18ⱥ\x00\x18ⱦ\x00\x18Ȿ\x00\x18Ɀ\x00\x18Ɐ\x00\x18Ɑ\x00\x18Ɒ\x00\x18Ɜ\x00\x18Ɡ\x00\x18Ɥ\x00\x18Ɦ\x00\x18Ɫ\x00\x18Ɬ\x00\x18Ɱ\x00\x18Ɽ\x00\x18Ʇ\x00\x18Ʞ\x000Ϊ́\x000Ϋ́\x00$ԵՒԵւ\x00\x18ⴀ\x00\x18ⴁ\x00\x18ⴂ\x00\x18ⴃ\x00\x18ⴄ\x00\x18ⴅ\x00\x18ⴆ\x00\x18ⴇ\x00\x18ⴈ\x00\x18ⴉ\x00\x18ⴊ\x00\x18ⴋ\x00\x18ⴌ\x00\x18ⴍ\x00\x18ⴎ\x00\x18ⴏ\x00\x18ⴐ\x00\x18ⴑ\x00\x18ⴒ\x00\x18ⴓ\x00\x18ⴔ\x00\x18ⴕ\x00\x18ⴖ\x00\x18ⴗ\x00\x18ⴘ\x00\x18ⴙ\x00\x18ⴚ\x00\x18ⴛ\x00\x18ⴜ\x00\x18ⴝ\x00\x18ⴞ\x00\x18ⴟ\x00\x18ⴠ\x00\x18ⴡ\x00\x18ⴢ\x00\x18ⴣ\x00\x18ⴤ\x00\x18ⴥ\x00\x18ⴧ\x00\x18ⴭ\x00\x18Ᵹ\x00\x18Ᵽ\x00\x18H̱\x00\x18T̈\x00\x18W̊\x00\x18Y̊\x00\x18Aʾ\x00\x10ß\x00 Υ̓\x000Υ̓̀\x000Υ̓́\x000Υ̓͂\x00+ἈΙᾈ\x00+ἉΙᾉ\x00+ἊΙᾊ\x00+ἋΙᾋ\x00+ἌΙᾌ\x00+ἍΙᾍ\x00+ἎΙᾎ\x00+ἏΙᾏ\x00\x1dᾀἈΙ\x00\x1dᾁἉΙ\x00\x1dᾂἊΙ\x00\x1dᾃἋΙ\x00\x1dᾄἌΙ\x00\x1dᾅἍΙ\x00\x1dᾆἎΙ\x00\x1dᾇἏΙ\x00+ἨΙᾘ\x00+ἩΙᾙ\x00+ἪΙᾚ\x00+ἫΙᾛ\x00+ἬΙᾜ\x00+ἭΙᾝ\x00+ἮΙᾞ\x00+ἯΙᾟ\x00\x1dᾐἨΙ\x00\x1dᾑἩΙ\x00\x1dᾒἪΙ\x00\x1dᾓἫΙ\x00\x1dᾔἬΙ\x00\x1dᾕἭΙ\x00\x1dᾖἮΙ\x00\x1dᾗἯΙ\x00+ὨΙᾨ\x00+ὩΙᾩ\x00+ὪΙᾪ\x00+ὫΙᾫ\x00+ὬΙᾬ\x00+ὭΙᾭ\x00+ὮΙᾮ\x00+ὯΙᾯ\x00\x1dᾠὨΙ\x00\x1dᾡὩΙ\x00\x1dᾢὪΙ\x00\x1dᾣὫΙ\x00\x1dᾤὬΙ\x00\x1dᾥὭΙ\x00\x1dᾦὮΙ\x00\x1dᾧὯΙ\x00-ᾺΙᾺͅ\x00#ΑΙᾼ\x00$ΆΙΆͅ\x00 Α͂\x006Α͂Ιᾼ͂\x00\x1cᾳΑΙ\x00\x10Ι\x00-ῊΙῊͅ\x00#ΗΙῌ\x00$ΉΙΉͅ\x00 Η͂\x006Η͂Ιῌ͂\x00\x1cῃΗΙ\x000Ϊ̀\x000Ϊ́\x00 Ι͂\x000Ϊ͂\x000Ϋ̀\x000Ϋ́\x00 Ρ̓\x00 Υ͂\x000Ϋ͂\x00-ῺΙῺͅ\x00#ΩΙῼ\x00$ΏΙΏͅ\x00 Ω͂\x006Ω͂Ιῼ͂\x00\x1cῳΩΙ\x00\x10ω\x00\bk\x00\x10å\x00\x10ɫ\x00\x18ᵽ\x00\x10ɽ\x00\x10Ⱥ\x00\x10Ⱦ\x00\x10ɑ\x00\x10ɱ\x00\x10ɐ\x00\x10ɒ\x00\x10ȿ\x00\x10ɀ\x00\x18Ⴀ\x00\x18Ⴁ\x00\x18Ⴂ\x00\x18Ⴃ\x00\x18Ⴄ\x00\x18Ⴅ\x00\x18Ⴆ\x00\x18Ⴇ\x00\x18Ⴈ\x00\x18Ⴉ\x00\x18Ⴊ\x00\x18Ⴋ\x00\x18Ⴌ\x00\x18Ⴍ\x00\x18Ⴎ\x00\x18Ⴏ\x00\x18Ⴐ\x00\x18Ⴑ\x00\x18Ⴒ\x00\x18Ⴓ\x00\x18Ⴔ\x00\x18Ⴕ\x00\x18Ⴖ\x00\x18Ⴗ\x00\x18Ⴘ\x00\x18Ⴙ\x00\x18Ⴚ\x00\x18Ⴛ\x00\x18Ⴜ\x00\x18Ⴝ\x00\x18Ⴞ\x00\x18Ⴟ\x00\x18Ⴠ\x00\x18Ⴡ\x00\x18Ⴢ\x00\x18Ⴣ\x00\x18Ⴤ\x00\x18Ⴥ\x00\x18Ⴧ\x00\x18Ⴭ\x00\x18ᵹ\x00\x10ɥ\x00\x10ɦ\x00\x10ɜ\x00\x10ɡ\x00\x10ɬ\x00\x10ʞ\x00\x10ʇ\x00\x12FFFf\x00\x12FIFi\x00\x12FLFl\x00\x1bFFIFfi\x00\x1bFFLFfl\x00\x12STSt\x00\x12STSt\x00$ՄՆՄն\x00$ՄԵՄե\x00$ՄԻՄի\x00$ՎՆՎն\x00$ՄԽՄխ"

// Total table size 12739 bytes (12KiB)
