// Generated by running
//		maketables -url=http://www.unicode.org/Public/cldr/26/core.zip -iana=http://www.iana.org/assignments/language-subtag-registry -tld=http://www.iana.org/domains/root/db
// automatically with go generate.
// DO NOT EDIT

package language

// Version is the version of CLDR used to generate the data in this package.
const Version = "26"

const numLanguages = 8620

const numScripts = 217

const numRegions = 354

type fromTo struct {
	from uint16
	to   uint16
}

const nonCanonicalUnd = 624
const (
	_af  = 9
	_am  = 15
	_ar  = 19
	_az  = 33
	_bg  = 53
	_bn  = 71
	_ca  = 93
	_cs  = 116
	_da  = 123
	_de  = 127
	_el  = 147
	_en  = 148
	_es  = 150
	_et  = 152
	_fa  = 157
	_fi  = 161
	_fil = 162
	_fr  = 167
	_gu  = 201
	_he  = 213
	_hi  = 214
	_hr  = 226
	_hu  = 230
	_hy  = 231
	_id  = 235
	_is  = 245
	_it  = 246
	_ja  = 250
	_ka  = 259
	_kk  = 288
	_km  = 292
	_kn  = 294
	_ko  = 295
	_ky  = 318
	_lo  = 342
	_lt  = 346
	_lv  = 353
	_mk  = 381
	_ml  = 382
	_mn  = 383
	_mo  = 386
	_mr  = 390
	_ms  = 394
	_mul = 398
	_my  = 404
	_nb  = 413
	_ne  = 418
	_nl  = 427
	_no  = 431
	_pa  = 451
	_pl  = 467
	_pt  = 475
	_ro  = 495
	_ru  = 499
	_sh  = 528
	_si  = 531
	_sk  = 533
	_sl  = 535
	_sq  = 548
	_sr  = 549
	_sv  = 561
	_sw  = 562
	_ta  = 570
	_te  = 577
	_th  = 582
	_tl  = 593
	_tn  = 596
	_tr  = 599
	_uk  = 621
	_ur  = 627
	_uz  = 628
	_vi  = 633
	_zh  = 678
	_zu  = 680
	_jbo = 6807
	_ami = 1003
	_bnn = 1710
	_hak = 210
	_tlh = 13820
	_lb  = 325
	_nv  = 440
	_pwn = 11408
	_tao = 13541
	_tay = 13551
	_tsu = 14015
	_nn  = 429
	_sfb = 12982
	_vgt = 15054
	_sgg = 13013
	_cmn = 2360
	_nan = 410
	_hsn = 228
)

const langPrivateStart = 11499

const langPrivateEnd = 12018

// lang holds an alphabetically sorted list of ISO-639 language identifiers.
// All entries are 4 bytes. The index of the identifier (divided by 4) is the language tag.
// For 2-byte language identifiers, the two successive bytes have the following meaning:
//     - if the first letter of the 2- and 3-letter ISO codes are the same:
//       the second and third letter of the 3-letter ISO code.
//     - otherwise: a 0 and a by 2 bits right-shifted index into altLangISO3.
// For 3-byte language identifiers the 4th byte is 0.
// Size: 2752 bytes
var lang string = "" +
	"---\x00aaarabbkabr\x00ace\x00ach\x00ady\x00aeveaeb\x00affrag" +
	"q\x00akkaakk\x00aln\x00alt\x00ammhamo\x00anrgaoz\x00arraarc" +
	"\x00arn\x00aro\x00arq\x00ary\x00arz\x00assmasa\x00ast\x00atj" +
	"\x00avvaawa\x00ayymazzeazb\x00baakbal\x00ban\x00bap\x00bar" +
	"\x00bas\x00bax\x00bbc\x00bbj\x00bci\x00beelbem\x00bew\x00bez" +
	"\x00bfd\x00bfq\x00bft\x00bfy\x00bgulbgc\x00bgx\x00bhihbhb" +
	"\x00bhi\x00bhk\x00bho\x00biisbik\x00bin\x00bjj\x00bjn\x00bkm" +
	"\x00bku\x00blt\x00bmambmq\x00bnenboodbpy\x00bqi\x00bqv\x00br" +
	"rebra\x00brh\x00brx\x00bsosbsq\x00bss\x00bto\x00btv\x00bua" +
	"\x00buc\x00bug\x00bum\x00bvb\x00byn\x00byv\x00bze\x00caatcch" +
	"\x00ccp\x00ceheceb\x00cgg\x00chhachk\x00chm\x00chp\x00chr" +
	"\x00cja\x00cjm\x00ckb\x00cooscop\x00cps\x00crrecrj\x00crk" +
	"\x00crl\x00crm\x00crs\x00csescsb\x00csw\x00ctd\x00cuhucvhvcy" +
	"ymdaandar\x00dav\x00dcc\x00deeuden\x00dgr\x00dje\x00dnj\x00d" +
	"oi\x00dsb\x00dtm\x00dtp\x00dua\x00dvivdyo\x00dyu\x00dzzoebu" +
	"\x00eeweefi\x00egl\x00egy\x00eky\x00elllenngeopoes\x00\x05es" +
	"u\x00etstett\x00euusewo\x00ext\x00faasfan\x00ffulffm\x00fiin" +
	"fil\x00fit\x00fjijfoaofon\x00frrafrc\x00frp\x00frr\x00frs" +
	"\x00fud\x00fuq\x00fur\x00fuv\x00fyrygalegaa\x00gag\x00gan" +
	"\x00gbm\x00gbz\x00gcr\x00gdlagez\x00ggn\x00gil\x00gjk\x00gju" +
	"\x00gllgglk\x00gnrngom\x00gon\x00gor\x00gos\x00got\x00grc" +
	"\x00grt\x00gsw\x00guujgub\x00guc\x00gur\x00guz\x00gvlvgvr" +
	"\x00gwi\x00haauhak\x00haw\x00haz\x00heebhiinhif\x00hil\x00hm" +
	"d\x00hnd\x00hne\x00hnj\x00hnn\x00hno\x00homohoc\x00hoj\x00hr" +
	"rvhsb\x00hsn\x00htathuunhyyehzerianaibb\x00idndieleigboiiiii" +
	"kpkikt\x00ilo\x00inndinh\x00iodoisslittaiukuiw\x00\x03izh" +
	"\x00japnjam\x00jgo\x00ji\x00\x06jmc\x00jml\x00jut\x00jvavjwa" +
	"vkaatkaa\x00kab\x00kaj\x00kam\x00kao\x00kbd\x00kcg\x00kck" +
	"\x00kde\x00kdt\x00kea\x00ken\x00kfo\x00kfr\x00kfy\x00kgonkge" +
	"\x00kgp\x00kha\x00khb\x00khn\x00khq\x00kht\x00khw\x00kiikkiu" +
	"\x00kjuakjg\x00kkazkkj\x00klalkln\x00kmhmkmb\x00knankoorkoi" +
	"\x00kok\x00kos\x00kpe\x00kraukrc\x00kri\x00krj\x00krl\x00kru" +
	"\x00ksasksb\x00ksf\x00ksh\x00kuurkum\x00kvomkvr\x00kvx\x00kw" +
	"\x00\x01kxm\x00kxp\x00kyirlaatlab\x00lad\x00lag\x00lah\x00la" +
	"j\x00lbtzlbe\x00lbw\x00lcp\x00lep\x00lez\x00lgugliimlif\x00l" +
	"ij\x00lis\x00ljp\x00lki\x00lkt\x00lmn\x00lmo\x00lninloaolol" +
	"\x00loz\x00lrc\x00ltitltg\x00luublua\x00luo\x00luy\x00luz" +
	"\x00lvavlwl\x00lzh\x00lzz\x00mad\x00maf\x00mag\x00mai\x00mak" +
	"\x00man\x00mas\x00maz\x00mdf\x00mdh\x00mdr\x00men\x00mer\x00" +
	"mfa\x00mfe\x00mglgmgh\x00mgo\x00mgp\x00mgy\x00mhahmirimin" +
	"\x00mis\x00mkkdmlalmnonmni\x00mnw\x00moolmoe\x00moh\x00mos" +
	"\x00mrarmrd\x00mrj\x00mru\x00mssamtltmtr\x00mua\x00mul\x00mv" +
	"y\x00mwk\x00mwr\x00mwv\x00mxc\x00myyamyv\x00myx\x00myz\x00mz" +
	"n\x00naaunan\x00nap\x00naq\x00nbobnch\x00nddendc\x00nds\x00n" +
	"eepnew\x00ngdongl\x00nhe\x00nhw\x00nij\x00niu\x00njo\x00nlld" +
	"nmg\x00nnnonnh\x00noornod\x00noe\x00non\x00nqo\x00nrblnsk" +
	"\x00nso\x00nus\x00nvavnxq\x00nyyanym\x00nyn\x00occiojjiomrmo" +
	"rriosssotk\x00paanpag\x00pal\x00pam\x00pap\x00pau\x00pcd\x00" +
	"pcm\x00pdc\x00pdt\x00peo\x00pfl\x00phn\x00pilipka\x00pko\x00" +
	"plolpms\x00pnt\x00pon\x00pra\x00prd\x00prg\x00psusptorpuu" +
	"\x00quuequc\x00qug\x00raj\x00rcf\x00rej\x00rgn\x00ria\x00rif" +
	"\x00rjs\x00rkt\x00rmohrmf\x00rmo\x00rmt\x00rmu\x00rnunrng" +
	"\x00roonrob\x00rof\x00rtm\x00ruusrue\x00rug\x00rw\x00\x04rwk" +
	"\x00ryu\x00saansaf\x00sah\x00saq\x00sas\x00sat\x00saz\x00sbp" +
	"\x00scrdsck\x00scn\x00sco\x00scs\x00sdndsdc\x00semesef\x00se" +
	"h\x00sei\x00ses\x00sgagsga\x00sgs\x00sh\x00\x02shi\x00shn" +
	"\x00siinsid\x00sklkskr\x00sllvsli\x00sly\x00smmosma\x00smj" +
	"\x00smn\x00smp\x00sms\x00snnasnk\x00soomsou\x00sqqisrrpsrb" +
	"\x00srn\x00srr\x00srx\x00ssswssy\x00stotstq\x00suunsuk\x00su" +
	"s\x00svweswwaswb\x00swc\x00swv\x00sxn\x00syl\x00syr\x00szl" +
	"\x00taamtaj\x00tbw\x00tcy\x00tdd\x00tdg\x00tdh\x00teeltem" +
	"\x00teo\x00tet\x00tggkthhathl\x00thq\x00thr\x00tiirtig\x00ti" +
	"v\x00tkuktkl\x00tkr\x00tkt\x00tlgltly\x00tmh\x00tnsntoontpi" +
	"\x00trurtru\x00trv\x00tssotsd\x00tsf\x00tsg\x00tsj\x00ttattt" +
	"j\x00tts\x00ttt\x00tum\x00tvl\x00twwitwq\x00tyahtyv\x00tzm" +
	"\x00udm\x00ugiguga\x00ukkruli\x00umb\x00und\x00unr\x00unx" +
	"\x00urrduzzbvai\x00veenvec\x00vep\x00viievic\x00vls\x00vmf" +
	"\x00vmw\x00voolvro\x00vun\x00walnwae\x00wal\x00war\x00wbq" +
	"\x00wbr\x00wls\x00woolwtm\x00wuu\x00xav\x00xcr\x00xhhoxlc" +
	"\x00xld\x00xmf\x00xmn\x00xmr\x00xna\x00xnr\x00xog\x00xpr\x00" +
	"xsa\x00xsr\x00yao\x00yap\x00yav\x00ybb\x00yiidyooryrl\x00yua" +
	"\x00zahazbl\x00zdj\x00zea\x00zgh\x00zhhozmi\x00zuulzxx\x00zz" +
	"a\x00\xff\xff\xff\xff"

const langNoIndexOffset = 683

// langNoIndex is a bit vector of all 3-letter language codes that are not used as an index
// in lookup tables. The language ids for these language codes are derived directly
// from the letters and are not consecutive.
// Size: 2197 bytes, 2197 elements
var langNoIndex = [2197]uint8{
	255, 253, 253, 254, 239, 247, 191, 210, 251, 255, 254, 250,
	183, 29, 60, 87, 111, 151, 115, 248, 255, 239, 255, 112,
	191, 3, 255, 255, 207, 5, 133, 98, 233, 191, 253, 255,
	255, 247, 253, 119, 191, 255, 255, 255, 255, 255, 255, 227,
	201, 255, 255, 255, 77, 184, 10, 106, 126, 250, 227, 255,
	126, 255, 119, 255, 255, 255, 255, 223, 43, 244, 241, 224,
	93, 231, 159, 20, 7, 32, 223, 237, 159, 55, 201, 33,
	248, 63, 148, 247, 126, 255, 255, 255, 254, 127, 255, 255,
	255, 255, 127, 252, 219, 253, 191, 181, 123, 255, 127, 247,
	235, 254, 255, 167, 189, 255, 127, 247, 255, 239, 239, 239,
	255, 255, 159, 255, 255, 239, 255, 223, 255, 255, 243, 255,
	251, 47, 255, 255, 251, 238, 255, 189, 219, 255, 223, 247,
	255, 250, 253, 255, 126, 175, 123, 254, 127, 255, 255, 254,
	255, 255, 223, 255, 255, 223, 251, 255, 253, 252, 251, 255,
	255, 255, 255, 247, 127, 191, 249, 213, 165, 119, 64, 255,
	156, 193, 65, 44, 8, 36, 65, 0, 80, 64, 0, 128,
	251, 90, 242, 159, 180, 66, 65, 150, 155, 20, 136, 246,
	123, 231, 23, 86, 85, 125, 14, 28, 55, 113, 243, 239,
	151, 255, 93, 56, 100, 8, 0, 16, 188, 135, 175, 223,
	255, 247, 115, 53, 62, 135, 199, 223, 255, 0, 129, 0,
	176, 5, 128, 0, 0, 0, 0, 3, 64, 0, 64, 146,
	33, 208, 255, 93, 253, 222, 254, 94, 0, 0, 2, 100,
	141, 25, 193, 223, 121, 34, 0, 0, 0, 223, 109, 220,
	38, 229, 217, 243, 254, 255, 253, 203, 159, 20, 1, 12,
	134, 0, 209, 0, 240, 197, 103, 95, 86, 137, 94, 183,
	236, 239, 3, 0, 2, 0, 0, 0, 192, 119, 218, 87,
	144, 105, 1, 44, 22, 121, 228, 255, 255, 127, 0, 0,
	0, 1, 8, 70, 0, 0, 0, 176, 20, 3, 80, 22,
	10, 0, 1, 0, 0, 0, 17, 9, 0, 0, 96, 16,
	0, 0, 0, 16, 0, 0, 68, 0, 0, 16, 0, 4,
	8, 0, 0, 4, 0, 128, 40, 4, 0, 0, 80, 213,
	45, 0, 100, 53, 36, 83, 245, 212, 189, 226, 205, 3,
	0, 128, 0, 64, 0, 0, 0, 0, 0, 4, 23, 57,
	1, 217, 87, 152, 33, 152, 165, 0, 0, 1, 64, 130,
	0, 0, 0, 0, 0, 0, 0, 0, 1, 64, 0, 68,
	0, 0, 176, 254, 169, 57, 0, 2, 0, 0, 0, 4,
	0, 0, 0, 0, 0, 32, 0, 64, 0, 0, 0, 0,
	2, 0, 0, 0, 16, 1, 40, 5, 0, 0, 0, 0,
	4, 32, 4, 166, 8, 4, 0, 8, 1, 80, 0, 0,
	8, 17, 134, 64, 0, 0, 0, 0, 64, 0, 6, 85,
	2, 16, 8, 4, 0, 0, 0, 96, 59, 131, 17, 0,
	128, 0, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 190, 223, 255, 255, 191, 223, 199, 131, 130,
	192, 255, 223, 39, 207, 95, 231, 1, 16, 32, 178, 197,
	164, 69, 37, 155, 3, 207, 240, 223, 3, 196, 0, 16,
	1, 14, 0, 227, 146, 84, 219, 56, 241, 127, 247, 109,
	249, 255, 28, 125, 4, 8, 0, 1, 33, 18, 108, 95,
	221, 15, 133, 79, 64, 64, 0, 4, 249, 253, 253, 212,
	232, 19, 244, 39, 163, 13, 0, 0, 32, 123, 57, 2,
	5, 132, 0, 240, 191, 127, 218, 0, 24, 4, 129, 0,
	0, 0, 128, 16, 148, 28, 1, 0, 0, 0, 0, 0,
	16, 64, 0, 4, 8, 180, 124, 165, 12, 64, 0, 0,
	17, 4, 4, 108, 0, 96, 112, 255, 251, 127, 96, 0,
	5, 155, 221, 110, 3, 0, 17, 0, 0, 0, 64, 5,
	181, 182, 128, 8, 4, 0, 4, 81, 226, 255, 253, 63,
	5, 9, 8, 5, 64, 0, 0, 0, 0, 16, 0, 0,
	8, 0, 0, 0, 0, 161, 2, 100, 229, 72, 20, 137,
	32, 192, 71, 128, 7, 0, 0, 0, 204, 80, 64, 36,
	133, 71, 132, 64, 32, 16, 0, 32, 2, 80, 136, 17,
	0, 209, 44, 238, 80, 3, 29, 17, 105, 6, 89, 233,
	51, 8, 0, 32, 5, 64, 16, 0, 0, 0, 80, 68,
	150, 73, 214, 93, 167, 129, 69, 151, 251, 0, 16, 0,
	8, 0, 128, 0, 64, 69, 0, 1, 2, 0, 1, 64,
	128, 0, 4, 8, 248, 235, 246, 57, 196, 153, 22, 0,
	0, 12, 4, 1, 32, 32, 221, 162, 1, 0, 0, 0,
	18, 4, 0, 0, 4, 16, 240, 157, 149, 19, 0, 128,
	0, 0, 208, 18, 64, 0, 16, 176, 16, 98, 76, 210,
	2, 1, 10, 0, 70, 4, 0, 8, 2, 0, 32, 192,
	0, 128, 6, 0, 8, 0, 0, 0, 0, 240, 216, 111,
	21, 2, 8, 0, 0, 1, 0, 0, 0, 0, 16, 1,
	0, 16, 0, 0, 0, 252, 133, 227, 221, 255, 255, 255,
	187, 255, 127, 251, 255, 252, 254, 223, 255, 255, 255, 246,
	251, 254, 247, 31, 255, 179, 237, 255, 219, 237, 255, 254,
	127, 254, 223, 255, 255, 255, 247, 255, 253, 255, 255, 255,
	253, 255, 223, 175, 156, 255, 251, 255, 255, 255, 255, 255,
	239, 210, 187, 223, 245, 255, 255, 255, 255, 255, 254, 239,
	253, 255, 255, 247, 253, 255, 255, 255, 239, 219, 255, 255,
	255, 255, 255, 255, 255, 95, 211, 123, 253, 217, 223, 239,
	188, 24, 5, 44, 255, 7, 240, 255, 247, 95, 0, 8,
	0, 195, 61, 27, 6, 230, 114, 240, 221, 60, 127, 68,
	2, 48, 159, 122, 22, 253, 255, 87, 242, 255, 57, 255,
	242, 30, 149, 247, 247, 255, 69, 128, 1, 2, 0, 0,
	64, 84, 159, 138, 217, 217, 14, 17, 132, 81, 192, 243,
	251, 71, 0, 1, 5, 209, 80, 88, 0, 0, 0, 16,
	4, 2, 0, 0, 10, 0, 23, 210, 249, 253, 254, 255,
	255, 255, 255, 255, 215, 111, 255, 255, 223, 125, 187, 255,
	255, 255, 247, 243, 239, 255, 255, 247, 255, 223, 219, 119,
	255, 255, 127, 255, 255, 255, 239, 255, 189, 255, 255, 251,
	255, 251, 255, 222, 118, 189, 255, 247, 255, 255, 247, 255,
	255, 223, 243, 191, 239, 255, 255, 255, 255, 127, 127, 222,
	247, 191, 239, 247, 255, 251, 191, 223, 253, 254, 255, 255,
	254, 255, 95, 125, 127, 255, 255, 255, 229, 252, 255, 253,
	127, 127, 255, 158, 174, 255, 238, 255, 127, 247, 123, 2,
	130, 4, 255, 247, 255, 191, 215, 239, 254, 223, 247, 254,
	226, 142, 231, 255, 247, 255, 86, 189, 205, 255, 251, 255,
	255, 223, 239, 255, 229, 223, 125, 15, 167, 81, 4, 68,
	19, 208, 85, 175, 166, 253, 185, 255, 67, 93, 91, 255,
	255, 191, 63, 32, 20, 0, 87, 81, 130, 101, 245, 72,
	226, 255, 252, 223, 64, 5, 197, 5, 0, 34, 0, 116,
	105, 16, 8, 4, 65, 0, 1, 6, 0, 0, 0, 0,
	0, 81, 96, 5, 4, 1, 0, 0, 6, 1, 32, 0,
	24, 1, 146, 177, 253, 103, 75, 6, 149, 2, 87, 237,
	251, 76, 157, 123, 131, 4, 98, 64, 0, 21, 66, 0,
	0, 0, 84, 131, 249, 95, 16, 140, 201, 70, 222, 247,
	19, 49, 0, 0, 0, 0, 0, 144, 0, 0, 0, 0,
	0, 10, 16, 0, 1, 64, 0, 240, 91, 244, 190, 125,
	186, 207, 247, 175, 66, 4, 132, 65, 176, 255, 121, 122,
	4, 0, 0, 65, 45, 20, 37, 119, 237, 241, 191, 239,
	63, 0, 0, 2, 198, 160, 30, 252, 187, 255, 253, 251,
	183, 253, 245, 255, 253, 252, 213, 237, 71, 244, 127, 16,
	1, 1, 132, 109, 255, 247, 221, 249, 95, 5, 134, 239,
	245, 119, 189, 60, 0, 0, 0, 67, 113, 66, 0, 64,
	0, 0, 1, 67, 25, 0, 8, 0, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	255, 171, 189, 231, 87, 238, 19, 93, 9, 193, 64, 33,
	250, 23, 1, 128, 0, 0, 0, 0, 240, 222, 255, 191,
	0, 35, 0, 0, 0, 0, 8, 0, 0, 48, 149, 227,
	16, 0, 0, 0, 17, 4, 22, 0, 1, 2, 0, 129,
	163, 1, 80, 0, 0, 131, 17, 64, 0, 0, 0, 240,
	221, 123, 126, 2, 170, 16, 93, 216, 82, 0, 128, 32,
	0, 0, 0, 0, 64, 16, 2, 2, 9, 0, 16, 2,
	0, 97, 90, 157, 49, 0, 0, 0, 1, 80, 2, 32,
	0, 0, 1, 0, 66, 0, 0, 0, 0, 31, 223, 242,
	253, 255, 253, 63, 159, 24, 207, 188, 191, 175, 95, 254,
	123, 75, 64, 16, 225, 253, 175, 253, 183, 247, 255, 243,
	223, 255, 111, 241, 123, 241, 127, 223, 127, 191, 254, 183,
	238, 29, 251, 219, 239, 223, 255, 253, 126, 190, 87, 255,
	111, 129, 118, 31, 212, 119, 245, 253, 255, 255, 235, 254,
	191, 95, 87, 27, 235, 95, 80, 24, 2, 254, 255, 157,
	21, 151, 21, 15, 117, 68, 125, 129, 130, 241, 215, 126,
	255, 255, 255, 239, 255, 253, 221, 222, 188, 253, 246, 95,
	122, 31, 64, 152, 2, 255, 227, 255, 243, 214, 242, 255,
	251, 223, 125, 80, 30, 21, 123, 180, 245, 190, 255, 255,
	243, 247, 255, 247, 127, 255, 255, 254, 219, 247, 215, 249,
	239, 47, 128, 191, 197, 255, 255, 243, 151, 157, 255, 255,
	247, 207, 253, 191, 222, 127, 6, 29, 87, 255, 248, 218,
	93, 199, 125, 22, 185, 234, 105, 160, 26, 32, 0, 48,
	2, 4, 36, 72, 4, 0, 0, 64, 212, 2, 4, 0,
	0, 4, 0, 4, 0, 32, 1, 6, 80, 0, 8, 0,
	0, 0, 36, 0, 4, 0, 16, 140, 88, 213, 13, 15,
	20, 77, 241, 22, 68, 209, 66, 8, 64, 0, 0, 64,
	0, 8, 0, 0, 0, 220, 255, 235, 31, 88, 8, 65,
	4, 160, 4, 0, 48, 18, 64, 34, 0, 16, 0, 0,
	0, 0, 0, 0, 1, 0, 0, 0, 128, 16, 16, 175,
	111, 147, 0, 1, 0, 0, 0, 0, 0, 0, 0, 128,
	128, 37, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0,
	128, 134, 194, 2, 0, 0, 0, 1, 223, 24, 0, 0,
	2, 240, 253, 121, 59, 0, 37, 0, 0, 0, 10, 0,
	0, 0, 0, 0, 0, 64, 0, 0, 3, 0, 9, 32,
	0, 0, 1, 0, 0, 129, 0, 0, 0, 0, 1, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239,
	247, 253, 207, 126, 162, 17, 16, 0, 0, 146, 1, 68,
	205, 249, 94, 0, 1, 0, 48, 20, 4, 85, 16, 1,
	4, 246, 63, 122, 5, 4, 0, 176, 128, 0, 85, 85,
	151, 124, 159, 113, 204, 120, 213, 67, 245, 87, 103, 20,
	1, 0, 0, 0, 0, 0, 44, 247, 219, 31, 80, 96,
	3, 104, 1, 16, 139, 56, 170, 1, 0, 0, 48, 0,
	36, 68, 0, 0, 16, 3, 17, 2, 1, 0, 0, 240,
	181, 255, 213, 215, 188, 112, 214, 120, 120, 21, 80, 0,
	164, 132, 233, 65, 0, 0, 0, 107, 57, 82, 116, 0,
	232, 48, 144, 106, 146, 0, 0, 2, 255, 239, 255, 79,
	133, 83, 244, 237, 221, 191, 114, 25, 199, 12, 245, 66,
	84, 221, 119, 20, 0, 128, 192, 86, 204, 22, 158, 251,
	53, 125, 239, 255, 189, 164, 175, 1, 68, 24, 1, 93,
	78, 74, 8, 80, 40, 48, 224, 128, 16, 32, 36, 0,
	255, 63, 223, 103, 254, 1, 6, 136, 10, 64, 22, 1,
	1, 21, 43, 62, 1, 0, 0, 16, 144, 105, 69, 2,
	2, 0, 225, 191, 191, 3, 0, 0, 16, 212, 167, 209,
	84, 158, 68, 223, 253, 143, 102, 179, 85, 32, 212, 195,
	216, 48, 61, 128, 0, 0, 0, 76, 212, 16, 197, 132,
	110, 80, 0, 34, 80, 126, 191, 219, 7, 0, 32, 16,
	132, 178, 69, 16, 6, 68, 0, 0, 18, 2, 17, 0,
	240, 255, 253, 63, 5, 0, 18, 129, 0, 0, 0, 0,
	0, 0, 12, 2, 0, 0, 0, 0, 3, 48, 2, 40,
	132, 0, 51, 192, 35, 36, 0, 0, 0, 203, 228, 58,
	66, 200, 20, 241, 239, 255, 127, 22, 1, 1, 132, 80,
	7, 252, 255, 255, 15, 1, 0, 64, 16, 56, 1, 1,
	28, 18, 64, 225, 118, 22, 8, 3, 16, 0, 0, 0,
	1, 0, 0, 0, 0, 0, 32, 36, 10, 0, 128, 0,
	0,
}

// altLangISO3 holds an alphabetically sorted list of 3-letter language code alternatives
// to 2-letter language codes that cannot be derived using the method described above.
// Each 3-letter code is followed by its 1-byte langID.
// Size: 48 bytes
var altLangISO3 string = "---\x00cor\x00hbs\x01heb\x02kin\x03spa\x04yid\x05\xff\xff\xff\xff"

// altLangIndex is used to convert indexes in altLangISO3 to langIDs.
// Size: 12 bytes, 6 elements
var altLangIndex = [6]uint16{
	315, 528, 248, 502, 150, 253,
}

// langAliasMap maps langIDs to their suggested replacements.
// Size: 484 bytes, 121 elements
var langAliasMap = [121]fromTo{
	{from: 0xf2, to: 0xeb},
	{from: 0xf8, to: 0xd5},
	{from: 0xfd, to: 0x29d},
	{from: 0x102, to: 0x101},
	{from: 0x182, to: 0x1ef},
	{from: 0x19d, to: 0x1af},
	{from: 0x210, to: 0x225},
	{from: 0x251, to: 0xa2},
	{from: 0x265, to: 0xb},
	{from: 0x3a9, to: 0x1c2a},
	{from: 0x3ca, to: 0x224},
	{from: 0x3db, to: 0x224},
	{from: 0x466, to: 0x13},
	{from: 0x471, to: 0xe7},
	{from: 0x52c, to: 0x20},
	{from: 0x532, to: 0x2714},
	{from: 0x53e, to: 0x21},
	{from: 0x55f, to: 0x9a},
	{from: 0x585, to: 0x24},
	{from: 0x58e, to: 0x3e},
	{from: 0x63c, to: 0xc5c},
	{from: 0x768, to: 0x194},
	{from: 0x7af, to: 0x15f},
	{from: 0x7b6, to: 0x55},
	{from: 0x837, to: 0x309b},
	{from: 0x8b1, to: 0x2a6},
	{from: 0x8ee, to: 0x23d3},
	{from: 0x8f7, to: 0x93c},
	{from: 0x914, to: 0x238},
	{from: 0x935, to: 0x3fa2},
	{from: 0x938, to: 0x2a6},
	{from: 0xa32, to: 0x6e},
	{from: 0xa81, to: 0x74},
	{from: 0xb41, to: 0x84},
	{from: 0xb50, to: 0x191},
	{from: 0xb71, to: 0xb74},
	{from: 0xb77, to: 0x2aa},
	{from: 0xc58, to: 0x1dd3},
	{from: 0xc67, to: 0x2c13},
	{from: 0xcb2, to: 0x1ab},
	{from: 0xe49, to: 0x98},
	{from: 0xe7d, to: 0x16a},
	{from: 0xf19, to: 0xef},
	{from: 0xff2, to: 0xb},
	{from: 0x119d, to: 0xa7},
	{from: 0x11e9, to: 0x9f},
	{from: 0x1298, to: 0xb14},
	{from: 0x129c, to: 0x1bf},
	{from: 0x12ab, to: 0x143e},
	{from: 0x12f9, to: 0x103},
	{from: 0x12fc, to: 0x7f},
	{from: 0x13e3, to: 0xc2},
	{from: 0x1441, to: 0x93},
	{from: 0x1491, to: 0xc0},
	{from: 0x14f3, to: 0x129d},
	{from: 0x1582, to: 0x152f},
	{from: 0x158f, to: 0x166c},
	{from: 0x1603, to: 0x229},
	{from: 0x16f2, to: 0x1a7a},
	{from: 0x17ed, to: 0x2929},
	{from: 0x1803, to: 0xf5},
	{from: 0x18d3, to: 0xf7},
	{from: 0x18ff, to: 0x128e},
	{from: 0x1db6, to: 0x1e56},
	{from: 0x1dd3, to: 0x17f},
	{from: 0x1e5c, to: 0x136},
	{from: 0x1e67, to: 0x12c},
	{from: 0x1e6b, to: 0x113},
	{from: 0x1e72, to: 0x129},
	{from: 0x1eae, to: 0x138},
	{from: 0x1fdb, to: 0x6a3},
	{from: 0x20fb, to: 0x30de},
	{from: 0x21eb, to: 0x161},
	{from: 0x225d, to: 0x17d},
	{from: 0x2269, to: 0x17a},
	{from: 0x2273, to: 0x18a},
	{from: 0x22c9, to: 0x8d4},
	{from: 0x2322, to: 0x65},
	{from: 0x23b7, to: 0x16a},
	{from: 0x2442, to: 0x242d},
	{from: 0x2472, to: 0x1e0},
	{from: 0x24de, to: 0x242d},
	{from: 0x268d, to: 0x1a2},
	{from: 0x2893, to: 0x1be},
	{from: 0x2975, to: 0x1c0},
	{from: 0x2a75, to: 0x1da},
	{from: 0x2a8c, to: 0x310},
	{from: 0x2ac0, to: 0x9d},
	{from: 0x2ac1, to: 0x9d},
	{from: 0x2b78, to: 0x174},
	{from: 0x2b9a, to: 0x143},
	{from: 0x2bde, to: 0x1ffb},
	{from: 0x2c68, to: 0x2c50},
	{from: 0x2f0c, to: 0x1dd},
	{from: 0x30df, to: 0x3107},
	{from: 0x31a3, to: 0x1ef},
	{from: 0x3267, to: 0x1649},
	{from: 0x335f, to: 0x215},
	{from: 0x33d1, to: 0x123},
	{from: 0x33ef, to: 0x201},
	{from: 0x3476, to: 0x232},
	{from: 0x35a8, to: 0x48},
	{from: 0x35ab, to: 0x2fa1},
	{from: 0x35e5, to: 0x371f},
	{from: 0x360b, to: 0x3d39},
	{from: 0x362e, to: 0x2c13},
	{from: 0x36d5, to: 0x253},
	{from: 0x38c7, to: 0xb0a},
	{from: 0x3a12, to: 0x274},
	{from: 0x3d36, to: 0x7a},
	{from: 0x4037, to: 0x2ec},
	{from: 0x40f1, to: 0x12b},
	{from: 0x4146, to: 0x80},
	{from: 0x4228, to: 0x309b},
	{from: 0x425c, to: 0x29d},
	{from: 0x4343, to: 0x2182},
	{from: 0x4389, to: 0x4627},
	{from: 0x4427, to: 0x4419},
	{from: 0x44b7, to: 0x44be},
	{from: 0x468f, to: 0x18a},
	{from: 0x4720, to: 0x2a1},
}

// Size: 121 bytes, 121 elements
var langAliasTypes = [121]langAliasType{
	0, 0, 0, 0, 0, 1, 2, 2, 1, 1, 2, 1,
	1, 2, 1, 0, 1, 2, 1, 1, 0, 2, 1, 1,
	0, 2, 0, 0, 1, 0, 1, 1, 2, 1, 1, 1,
	1, 0, 0, 2, 1, 1, 1, 1, 2, 1, 0, 1,
	1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 0, 0,
	2, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0,
	1, 2, 2, 2, 0, 1, 1, 0, 1, 0, 1, 1,
	1, 1, 0, 2, 1, 1, 1, 0, 0, 1, 1, 2,
	0, 2, 1, 1, 1, 2, 0, 0, 0, 0, 1, 1,
	1, 2, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1,
	1,
}

const (
	_Latn = 75
	_Hani = 46
	_Hans = 48
	_Hant = 49
	_Qaaa = 119
	_Qaai = 127
	_Qabx = 168
	_Zinh = 212
	_Zyyy = 216
	_Zzzz = 217
)

// script is an alphabetically sorted list of ISO 15924 codes. The index
// of the script in the string, divided by 4, is the internal scriptID.
// Size: 892 bytes
var script string = "" +
	"----AfakAghbAhomArabArmiArmnAvstBaliBamuBassBatkBengBlisBopo" +
	"BrahBraiBugiBuhdCakmCansCariChamCherCirtCoptCprtCyrlCyrsDeva" +
	"DsrtDuplEgydEgyhEgypElbaEthiGeokGeorGlagGothGranGrekGujrGuru" +
	"HangHaniHanoHansHantHatrHebrHiraHluwHmngHrktHungIndsItalJava" +
	"JpanJurcKaliKanaKharKhmrKhojKndaKoreKpelKthiLanaLaooLatfLatg" +
	"LatnLepcLimbLinaLinbLisuLomaLyciLydiMahjMandManiMayaMendMerc" +
	"MeroMlymModiMongMoonMrooMteiMultMymrNarbNbatNkgbNkooNshuOgam" +
	"OlckOrkhOryaOsmaPalmPaucPermPhagPhliPhlpPhlvPhnxPlrdPrtiQaaa" +
	"QaabQaacQaadQaaeQaafQaagQaahQaaiQaajQaakQaalQaamQaanQaaoQaap" +
	"QaaqQaarQaasQaatQaauQaavQaawQaaxQaayQaazQabaQabbQabcQabdQabe" +
	"QabfQabgQabhQabiQabjQabkQablQabmQabnQaboQabpQabqQabrQabsQabt" +
	"QabuQabvQabwQabxRjngRoroRunrSamrSaraSarbSaurSgnwShawShrdSidd" +
	"SindSinhSoraSundSyloSyrcSyreSyrjSyrnTagbTakrTaleTaluTamlTang" +
	"TavtTeluTengTfngTglgThaaThaiTibtTirhUgarVaiiVispWaraWoleXpeo" +
	"XsuxYiiiZinhZmthZsymZxxxZyyyZzzz\xff\xff\xff\xff"

// suppressScript is an index from langID to the dominant script for that language,
// if it exists.  If a script is given, it should be suppressed from the language tag.
// Size: 683 bytes, 683 elements
var suppressScript = [683]uint8{
	0, 0, 27, 0, 0, 0, 0, 0, 0, 75, 0, 0,
	0, 0, 0, 36, 0, 0, 0, 4, 0, 0, 0, 0,
	0, 0, 12, 0, 0, 0, 0, 0, 75, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0,
	0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12,
	0, 0, 0, 0, 0, 0, 0, 0, 75, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 0, 0,
	0, 0, 0, 75, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 75, 0, 0, 0,
	0, 0, 75, 75, 0, 0, 0, 75, 0, 0, 0, 0,
	0, 75, 0, 0, 0, 200, 0, 0, 202, 0, 0, 0,
	0, 0, 0, 42, 75, 75, 75, 0, 75, 0, 75, 0,
	0, 4, 0, 0, 0, 75, 0, 0, 75, 75, 0, 75,
	0, 0, 75, 75, 0, 0, 0, 0, 75, 75, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 0,
	75, 0, 0, 0, 0, 0, 0, 0, 75, 43, 0, 0,
	0, 0, 75, 0, 0, 0, 0, 0, 0, 51, 29, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 75,
	0, 75, 75, 6, 0, 0, 0, 75, 0, 0, 0, 0,
	0, 0, 75, 0, 0, 75, 75, 0, 51, 0, 60, 0,
	0, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	27, 0, 75, 0, 65, 0, 67, 68, 0, 29, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 75, 0, 0, 0, 0,
	0, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 75, 72, 0, 0, 0, 75, 0,
	0, 0, 0, 0, 0, 75, 0, 0, 0, 0, 0, 0,
	29, 0, 0, 0, 0, 0, 0, 0, 75, 0, 0, 0,
	75, 0, 0, 0, 0, 75, 0, 0, 0, 27, 91, 0,
	0, 0, 75, 0, 0, 0, 29, 0, 0, 0, 75, 75,
	0, 0, 0, 0, 0, 0, 0, 0, 98, 0, 0, 0,
	0, 75, 0, 0, 0, 75, 0, 75, 0, 75, 29, 0,
	0, 0, 0, 0, 0, 75, 0, 75, 0, 75, 0, 75,
	0, 0, 0, 102, 75, 0, 75, 0, 0, 0, 75, 0,
	0, 0, 0, 75, 107, 0, 0, 44, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75,
	0, 0, 0, 0, 0, 0, 4, 75, 0, 75, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 75, 0, 0, 0,
	0, 75, 0, 75, 0, 0, 0, 27, 0, 0, 75, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 0, 0,
	0, 0, 0, 181, 0, 75, 0, 75, 0, 0, 75, 0,
	0, 0, 0, 0, 0, 0, 75, 0, 75, 0, 0, 0,
	0, 0, 75, 0, 75, 0, 0, 0, 0, 75, 75, 0,
	0, 0, 0, 0, 0, 0, 193, 0, 0, 0, 0, 0,
	0, 196, 75, 0, 0, 0, 201, 0, 0, 0, 36, 0,
	0, 0, 75, 0, 0, 75, 0, 75, 75, 75, 75, 75,
	0, 0, 75, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	75, 0, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0,
	0, 0, 0, 4, 0, 0, 75, 0, 0, 75, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 75, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 0, 0,
	0, 0, 13, 0, 0, 0, 0, 0, 75, 0, 0,
}

const (
	_001 = 1
	_419 = 30
	_BR  = 64
	_CA  = 72
	_ES  = 109
	_GB  = 121
	_MD  = 186
	_PT  = 236
	_UK  = 304
	_US  = 306
	_ZZ  = 354
	_XA  = 320
	_XC  = 322
	_XK  = 330
)

// isoRegionOffset needs to be added to the index of regionISO to obtain the regionID
// for 2-letter ISO codes. (The first isoRegionOffset regionIDs are reserved for
// the UN.M49 codes used for groups.)
const isoRegionOffset = 31

// regionTypes defines the status of a region for various standards.
// Size: 355 bytes, 355 elements
var regionTypes = [355]uint8{
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 5, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	4, 6, 4, 0, 6, 6, 6, 6, 6, 6, 4, 6,
	4, 6, 6, 6, 6, 0, 6, 4, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 6, 4,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 0, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 0, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 0,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 6, 6,
	6, 6, 0, 6, 4, 6, 6, 6, 6, 0, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 0, 6, 6,
	0, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 6, 0, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6,
	6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
	6, 6, 6, 6, 2, 6, 6, 6, 6, 6, 6, 0,
	6, 6, 6, 6, 6, 6, 0, 6, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 6,
	6, 4, 6, 6, 4, 6, 5,
}

// regionISO holds a list of alphabetically sorted 2-letter ISO region codes.
// Each 2-letter codes is followed by two bytes with the following meaning:
//     - [A-Z}{2}: the first letter of the 2-letter code plus these two
//                 letters form the 3-letter ISO code.
//     - 0, n:     index into altRegionISO3.
// Size: 1316 bytes
var regionISO string = "" +
	"AAAAACSCADNDAEREAFFGAGTGAIIAALLBAMRMANNTAOGOAQTAARRGASSMATUT" +
	"AUUSAWBWAXLAAZZEBAIHBBRBBDGDBEELBFFABGGRBHHRBIDIBJENBLLMBMMU" +
	"BNRNBOOLBQESBRRABSHSBTTNBUURBVVTBWWABYLRBZLZCAANCCCKCDODCFAF" +
	"CGOGCHHECIIVCKOKCLHLCMMRCNHNCOOLCPPTCRRICS\x00\x00CTTECUUBCV" +
	"PVCWUWCXXRCYYPCZZEDDDRDEEUDGGADJJIDKNKDMMADOOMDYHYDZZAEA  EC" +
	"CUEESTEGGYEHSHERRIESSPETTHEU\x00\x03FIINFJJIFKLKFMSMFOROFQ" +
	"\x00\x18FRRAFXXXGAABGBBRGDRDGEEOGFUFGGGYGHHAGIIBGLRLGMMBGNIN" +
	"GPLPGQNQGRRCGS\x00\x06GTTMGUUMGWNBGYUYHKKGHMMDHNNDHRRVHTTIHU" +
	"UNHVVOIC  IDDNIERLILSRIMMNINNDIOOTIQRQIRRNISSLITTAJEEYJMAMJO" +
	"ORJPPNJTTNKEENKGGZKHHMKIIRKM\x00\tKNNAKP\x00\fKRORKWWTKY\x00" +
	"\x0fKZAZLAAOLBBNLCCALIIELKKALRBRLSSOLTTULUUXLVVALYBYMAARMCCO" +
	"MDDAMENEMFAFMGDGMHHLMIIDMKKDMLLIMMMRMNNGMOACMPNPMQTQMRRTMSSR" +
	"MTLTMUUSMVDVMWWIMXEXMYYSMZOZNAAMNCCLNEERNFFKNGGANHHBNIICNLLD" +
	"NOORNPPLNQ\x00\x1eNRRUNTTZNUIUNZZLOMMNPAANPCCIPEERPFYFPGNGPH" +
	"HLPKAKPLOLPM\x00\x12PNCNPRRIPSSEPTRTPUUSPWLWPYRYPZCZQAATQMMM" +
	"QNNNQOOOQPPPQQQQQRRRQSSSQTTTQU\x00\x03QVVVQWWWQXXXQYYYQZZZRE" +
	"EURHHOROOURS\x00\x15RUUSRWWASAAUSBLBSCYCSDDNSEWESGGPSHHNSIVN" +
	"SJJMSKVKSLLESMMRSNENSOOMSRURSSSDSTTPSUUNSVLVSXXMSYYRSZWZTAAA" +
	"TCCATDCDTF\x00\x18TGGOTHHATJJKTKKLTLLSTMKMTNUNTOONTPMPTRURTT" +
	"TOTVUVTWWNTZZAUAKRUGGAUK  UMMIUSSAUYRYUZZBVAATVCCTVDDRVEENVG" +
	"GBVIIRVNNMVUUTWFLFWKAKWSSMXAAAXBBBXCCCXDDDXEEEXFFFXGGGXHHHXI" +
	"IIXJJJXKKKXLLLXMMMXNNNXOOOXPPPXQQQXRRRXSSSXTTTXUUUXVVVXWWWXX" +
	"XXXYYYXZZZYDMDYEEMYT\x00\x1bYUUGZAAFZMMBZRARZWWEZZZZ\xff\xff" +
	"\xff\xff"

// altRegionISO3 holds a list of 3-letter region codes that cannot be
// mapped to 2-letter codes using the default algorithm. This is a short list.
// Size: 49 bytes
var altRegionISO3 string = "SCGQUUSGSCOMPRKCYMSPMSRBATFMYTATN"

// altRegionIDs holds a list of regionIDs the positions of which match those
// of the 3-letter ISO codes in altRegionISO3.
// Size: 22 bytes, 11 elements
var altRegionIDs = [11]uint16{
	86, 111, 134, 166, 168, 171, 232, 259, 287, 348, 218,
}

// Size: 80 bytes, 20 elements
var regionOldMap = [20]fromTo{
	{from: 0x43, to: 0xc2},
	{from: 0x57, to: 0xa5},
	{from: 0x5e, to: 0x5f},
	{from: 0x65, to: 0x3a},
	{from: 0x77, to: 0x76},
	{from: 0x91, to: 0x36},
	{from: 0xa1, to: 0x131},
	{from: 0xbf, to: 0x131},
	{from: 0xd5, to: 0x13c},
	{from: 0xda, to: 0x2a},
	{from: 0xed, to: 0x131},
	{from: 0xf0, to: 0xe0},
	{from: 0xfa, to: 0x6f},
	{from: 0x101, to: 0x161},
	{from: 0x128, to: 0x124},
	{from: 0x130, to: 0x79},
	{from: 0x137, to: 0x13b},
	{from: 0x13e, to: 0x131},
	{from: 0x15a, to: 0x15b},
	{from: 0x160, to: 0x4a},
}

// m49 maps regionIDs to UN.M49 codes. The first isoRegionOffset entries are
// codes indicating collections of regions.
// Size: 710 bytes, 355 elements
var m49 = [355]uint16{
	0, 1, 2, 3, 5, 9, 11, 13, 14, 15, 17, 18,
	19, 21, 29, 30, 34, 35, 39, 53, 54, 57, 61, 142,
	143, 145, 150, 151, 154, 155, 419, 958, 0, 20, 784, 4,
	28, 660, 8, 51, 530, 24, 10, 32, 16, 40, 36, 533,
	248, 31, 70, 52, 50, 56, 854, 100, 48, 108, 204, 652,
	60, 96, 68, 535, 76, 44, 64, 104, 74, 72, 112, 84,
	124, 166, 180, 140, 178, 756, 384, 184, 152, 120, 156, 170,
	0, 188, 891, 296, 192, 132, 531, 162, 196, 203, 278, 276,
	0, 262, 208, 212, 214, 204, 12, 0, 218, 233, 818, 732,
	232, 724, 231, 967, 246, 242, 238, 583, 234, 0, 250, 249,
	266, 826, 308, 268, 254, 831, 288, 292, 304, 270, 324, 312,
	226, 300, 239, 320, 316, 624, 328, 344, 334, 340, 191, 332,
	348, 854, 0, 360, 372, 376, 833, 356, 86, 368, 364, 352,
	380, 832, 388, 400, 392, 581, 404, 417, 116, 296, 174, 659,
	408, 410, 414, 136, 398, 418, 422, 662, 438, 144, 430, 426,
	440, 442, 428, 434, 504, 492, 498, 499, 663, 450, 584, 581,
	807, 466, 104, 496, 446, 580, 474, 478, 500, 470, 480, 462,
	454, 484, 458, 508, 516, 540, 562, 574, 566, 548, 558, 528,
	578, 524, 10, 520, 536, 570, 554, 512, 591, 0, 604, 258,
	598, 608, 586, 616, 666, 612, 630, 275, 620, 581, 585, 600,
	591, 634, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968,
	969, 970, 971, 972, 638, 716, 642, 688, 643, 646, 682, 90,
	690, 729, 752, 702, 654, 705, 744, 703, 694, 674, 686, 706,
	740, 728, 678, 810, 222, 534, 760, 748, 0, 796, 148, 260,
	768, 764, 762, 772, 626, 795, 788, 776, 626, 792, 780, 798,
	158, 834, 804, 800, 826, 581, 840, 858, 860, 336, 670, 704,
	862, 92, 850, 704, 548, 876, 581, 882, 973, 974, 975, 976,
	977, 978, 979, 980, 981, 982, 983, 984, 985, 986, 987, 988,
	989, 990, 991, 992, 993, 994, 995, 996, 997, 998, 720, 887,
	175, 891, 710, 894, 180, 716, 999,
}

// m49Index gives indexes into fromM49 based on the three most significant bits
// of a 10-bit UN.M49 code. To search an UN.M49 code in fromM49, search in
//    fromM49[m49Index[msb39(code)]:m49Index[msb3(code)+1]]
// for an entry where the first 7 bits match the 7 lsb of the UN.M49 code.
// The region code is stored in the 9 lsb of the indexed value.
// Size: 18 bytes, 9 elements
var m49Index = [9]uint16{
	0, 59, 107, 142, 180, 219, 258, 290, 332,
}

// fromM49 contains entries to map UN.M49 codes to regions. See m49Index for details.
// Size: 664 bytes, 332 elements
var fromM49 = [332]uint16{
	513, 1026, 1539, 2083, 2564, 4134, 4613, 5162, 5638, 6246, 6663, 7176,
	7689, 8236, 8714, 9227, 9740, 10273, 10765, 12329, 14372, 14862, 15375, 15921,
	16427, 17424, 17937, 18478, 19986, 20525, 22593, 24632, 25652, 26151, 26675, 27155,
	27668, 28725, 29205, 30780, 31254, 32834, 34878, 35890, 36933, 37956, 38976, 43079,
	44184, 46343, 47417, 49213, 51255, 53442, 55353, 57414, 59556, 61521, 63560, 2137,
	4267, 6219, 7191, 7704, 8369, 8729, 10526, 11290, 11803, 12368, 13340, 13853,
	14418, 15660, 17499, 19529, 21587, 23718, 24412, 25676, 26698, 28751, 30805, 32398,
	32856, 34908, 38493, 38970, 41058, 43107, 44132, 46184, 48408, 50308, 52334, 52846,
	53356, 53865, 54388, 56434, 56966, 58481, 60528, 61488, 62071, 62582, 64636, 1251,
	2335, 3169, 5240, 6267, 7297, 9963, 10335, 11358, 12383, 16510, 18559, 20645,
	22661, 24704, 26746, 28803, 30856, 32903, 34946, 37002, 39055, 40076, 41269, 43149,
	45195, 47248, 49307, 51351, 53395, 55450, 57497, 59540, 61589, 63644, 78, 2206,
	4256, 7340, 8351, 10402, 12456, 13481, 15530, 17059, 17581, 17950, 19630, 21683,
	22710, 23730, 25783, 27824, 28852, 29877, 31940, 33981, 36044, 38094, 40139, 42177,
	44233, 46278, 48327, 49354, 51405, 55481, 57539, 58554, 59067, 59592, 61624, 63695,
	223, 2256, 4315, 6361, 8407, 9256, 9818, 10799, 11545, 11839, 12508, 14545,
	18748, 21726, 23766, 25810, 27860, 29917, 31955, 34008, 35013, 35633, 36467, 37054,
	37614, 38118, 40672, 44260, 45295, 47330, 49381, 51433, 53479, 55532, 57481, 58660,
	60650, 62705, 64768, 1282, 1796, 3333, 6203, 7436, 9895, 10277, 11439, 11964,
	13544, 15670, 17681, 19734, 21766, 23826, 24835, 25864, 27920, 32011, 32527, 33083,
	33549, 34067, 36190, 39265, 41306, 43117, 45333, 45833, 47211, 49417, 51476, 53518,
	55579, 57610, 59469, 61722, 62754, 63777, 288, 2339, 4391, 6442, 8226, 10534,
	12585, 14117, 14621, 15659, 16687, 18734, 20160, 21783, 25706, 29817, 32381, 32925,
	33430, 34093, 37170, 42298, 44086, 46387, 47412, 48440, 55613, 58687, 60763, 61275,
	63062, 64863, 31775, 32498, 33011, 33524, 34037, 34550, 35063, 35576, 36089, 36463,
	37115, 37628, 38141, 38654, 39167, 39744, 40257, 40770, 41283, 41796, 42309, 42822,
	43335, 43848, 44361, 44874, 45387, 45900, 46413, 46926, 47439, 47952, 48465, 48978,
	49491, 50004, 50517, 51030, 51543, 52056, 52569, 53090,
}

// Size: 1273 bytes
var variantIndex = map[string]uint8{
	"1606nict": 0x0,
	"1694acad": 0x1,
	"1901":     0x2,
	"1959acad": 0x3,
	"1994":     0x3d,
	"1996":     0x4,
	"alalc97":  0x3f,
	"aluku":    0x5,
	"arevela":  0x6,
	"arevmda":  0x7,
	"baku1926": 0x8,
	"balanka":  0x9,
	"barla":    0xa,
	"bauddha":  0xb,
	"biscayan": 0xc,
	"biske":    0x38,
	"bohoric":  0xd,
	"boont":    0xe,
	"dajnko":   0xf,
	"ekavsk":   0x10,
	"emodeng":  0x11,
	"fonipa":   0x40,
	"fonupa":   0x41,
	"fonxsamp": 0x42,
	"hepburn":  0x12,
	"heploc":   0x3e,
	"hognorsk": 0x13,
	"ijekavsk": 0x14,
	"itihasa":  0x15,
	"jauer":    0x16,
	"jyutping": 0x17,
	"kkcor":    0x18,
	"kscor":    0x19,
	"laukika":  0x1a,
	"lipaw":    0x39,
	"luna1918": 0x1b,
	"metelko":  0x1c,
	"monoton":  0x1d,
	"ndyuka":   0x1e,
	"nedis":    0x1f,
	"njiva":    0x3a,
	"nulik":    0x20,
	"osojs":    0x3b,
	"pamaka":   0x21,
	"petr1708": 0x22,
	"pinyin":   0x23,
	"polyton":  0x24,
	"puter":    0x25,
	"rigik":    0x26,
	"rozaj":    0x27,
	"rumgr":    0x28,
	"scotland": 0x29,
	"scouse":   0x2a,
	"solba":    0x3c,
	"sotav":    0x2b,
	"surmiran": 0x2c,
	"sursilv":  0x2d,
	"sutsilv":  0x2e,
	"tarask":   0x2f,
	"uccor":    0x30,
	"ucrcor":   0x31,
	"ulster":   0x32,
	"unifon":   0x33,
	"vaidika":  0x34,
	"valencia": 0x35,
	"vallader": 0x36,
	"wadegile": 0x37,
}

// variantNumSpecialized is the number of specialized variants in variants.
const variantNumSpecialized = 63
const (
	_XTS = 279
	_XXX = 281
)

// currency holds an alphabetically sorted list of canonical 3-letter currency identifiers.
// Each identifier is followed by a byte of which the 6 most significant bits
// indicated the rounding and the least 2 significant bits indicate the
// number of decimal positions.
// Size: 1208 bytes
var currency string = "" +
	"---\nADP\bAED\nAFA\nAFN\bALK\nALL\bAMD\bANG\nAOA\nAOK\nAON\n" +
	"AOR\nARA\nARL\nARM\nARP\nARS\nATS\nAUD\nAWG\nAZM\nAZN\nBAD\n" +
	"BAM\nBAN\nBBD\nBDT\nBEC\nBEF\nBEL\nBGL\nBGM\nBGN\nBGO\nBHD\v" +
	"BIF\bBMD\nBND\nBOB\nBOL\nBOP\nBOV\nBRB\nBRC\nBRE\nBRL\nBRN\n" +
	"BRR\nBRZ\nBSD\nBTN\nBUK\nBWP\nBYB\nBYR\bBZD\nCAD\nCDF\nCHE\n" +
	"CHF\nCHW\nCLE\nCLF\fCLP\bCNX\nCNY\nCOP\bCOU\nCRC\bCSD\nCSK\n" +
	"CUC\nCUP\nCVE\nCYP\nCZK\nDDM\nDEM\nDJF\bDKK\nDOP\nDZD\nECS\n" +
	"ECV\nEEK\nEGP\nERN\nESA\nESB\nESP\bETB\nEUR\nFIM\nFJD\nFKP\n" +
	"FRF\nGBP\nGEK\nGEL\nGHC\nGHS\nGIP\nGMD\nGNF\bGNS\nGQE\nGRD\n" +
	"GTQ\nGWE\nGWP\nGYD\bHKD\nHNL\nHRD\nHRK\nHTG\nHUF\nIDR\bIEP\n" +
	"ILP\nILR\nILS\nINR\nIQD\bIRR\bISJ\nISK\bITL\bJMD\nJOD\vJPY\b" +
	"KES\nKGS\nKHR\nKMF\bKPW\bKRH\nKRO\nKRW\bKWD\vKYD\nKZT\nLAK\b" +
	"LBP\bLKR\nLRD\nLSL\nLTL\nLTT\nLUC\nLUF\bLUL\nLVL\nLVR\nLYD\v" +
	"MAD\nMAF\nMCF\nMDC\nMDL\nMGA\bMGF\bMKD\nMKN\nMLF\nMMK\bMNT\b" +
	"MOP\nMRO\bMTL\nMTP\nMUR\bMVR\nMWK\nMXN\nMXP\nMXV\nMYR\nMZE\n" +
	"MZM\nMZN\nNAD\nNGN\nNIC\nNIO\nNLG\nNOK\nNPR\nNZD\nOMR\vPAB\n" +
	"PEI\nPEN\nPES\nPGK\nPHP\nPKR\bPLN\nPLZ\nPTE\nPYG\bQAR\nRHD\n" +
	"ROL\nRON\nRSD\bRUB\nRUR\nRWF\bSAR\nSBD\nSCR\nSDD\nSDG\nSDP\n" +
	"SEK\nSGD\nSHP\nSIT\nSKK\nSLL\bSOS\bSRD\nSRG\nSSP\nSTD\bSUR\n" +
	"SVC\nSYP\bSZL\nTHB\nTJR\nTJS\nTMM\bTMT\nTND\vTOP\nTPE\nTRL\b" +
	"TRY\nTTD\nTWD\nTZS\bUAH\nUAK\nUGS\nUGX\bUSD\nUSN\nUSS\nUYI\b" +
	"UYP\nUYU\nUZS\bVEB\nVEF\nVND\bVNN\nVUV\bWST\nXAF\bXAG\nXAU\n" +
	"XBA\nXBB\nXBC\nXBD\nXCD\nXDR\nXEU\nXFO\nXFU\nXOF\bXPD\nXPF\b" +
	"XPT\nXRE\nXSU\nXTS\nXUA\nXXX\nYDD\nYER\bYUD\nYUM\nYUN\nYUR\n" +
	"ZAL\nZAR\nZMK\bZMW\nZRN\nZRZ\nZWD\bZWL\nZWR\n\xff\xff\xff" +
	"\xff"

// nRegionGroups is the number of region groups.
const nRegionGroups = 32

type likelyLangRegion struct {
	lang   uint16
	region uint16
}

// likelyScript is a lookup table, indexed by scriptID, for the most likely
// languages and regions given a script.
// Size: 876 bytes, 219 elements
var likelyScript = [219]likelyLangRegion{
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x14a, region: 0x104},
	{lang: 0x0, region: 0x0},
	{lang: 0x13, region: 0x6a},
	{lang: 0x14, region: 0x9a},
	{lang: 0xe7, region: 0x27},
	{lang: 0x7, region: 0x9a},
	{lang: 0x25, region: 0x93},
	{lang: 0x29, region: 0x51},
	{lang: 0x51, region: 0xb2},
	{lang: 0x2a, region: 0x93},
	{lang: 0x47, region: 0x34},
	{lang: 0x0, region: 0x0},
	{lang: 0x2a6, region: 0x12c},
	{lang: 0x1d1, region: 0x97},
	{lang: 0xa7, region: 0x76},
	{lang: 0x57, region: 0x93},
	{lang: 0x43, region: 0xe5},
	{lang: 0x5f, region: 0x34},
	{lang: 0x6e, region: 0x48},
	{lang: 0x28c, region: 0x129},
	{lang: 0x69, region: 0x13b},
	{lang: 0x67, region: 0x132},
	{lang: 0x0, region: 0x0},
	{lang: 0x6c, region: 0x6a},
	{lang: 0xc6, region: 0x5c},
	{lang: 0x1f3, region: 0x104},
	{lang: 0x0, region: 0x0},
	{lang: 0xd6, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0xa7, region: 0x76},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x91, region: 0x6a},
	{lang: 0x224, region: 0x26},
	{lang: 0xf, region: 0x6e},
	{lang: 0x0, region: 0x0},
	{lang: 0x103, region: 0x7b},
	{lang: 0x78, region: 0x37},
	{lang: 0xc5, region: 0x12e},
	{lang: 0x1f9, region: 0x97},
	{lang: 0x93, region: 0x85},
	{lang: 0xc9, region: 0x97},
	{lang: 0x1c3, region: 0x97},
	{lang: 0x127, region: 0xa9},
	{lang: 0x2a6, region: 0x52},
	{lang: 0xdd, region: 0xe5},
	{lang: 0x2a6, region: 0x52},
	{lang: 0x2a6, region: 0x12c},
	{lang: 0x0, region: 0x0},
	{lang: 0xd5, region: 0x95},
	{lang: 0xfa, region: 0xa0},
	{lang: 0x0, region: 0x0},
	{lang: 0xdc, region: 0xad},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x99, region: 0x9c},
	{lang: 0x101, region: 0x93},
	{lang: 0xfa, region: 0xa0},
	{lang: 0x0, region: 0x0},
	{lang: 0x92, region: 0xc2},
	{lang: 0xfa, region: 0xa0},
	{lang: 0x1d7, region: 0xe6},
	{lang: 0x124, region: 0xa4},
	{lang: 0x206, region: 0x97},
	{lang: 0x126, region: 0x97},
	{lang: 0x127, region: 0xa9},
	{lang: 0x0, region: 0x0},
	{lang: 0x38, region: 0x97},
	{lang: 0x1b0, region: 0x121},
	{lang: 0x156, region: 0xad},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x149, region: 0x97},
	{lang: 0x14d, region: 0x97},
	{lang: 0x140, region: 0x85},
	{lang: 0xc6, region: 0x85},
	{lang: 0x14f, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x28e, region: 0x129},
	{lang: 0x28f, region: 0x129},
	{lang: 0xd6, region: 0x97},
	{lang: 0x197, region: 0x9a},
	{lang: 0x291, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x170, region: 0x110},
	{lang: 0x292, region: 0x109},
	{lang: 0x292, region: 0x109},
	{lang: 0x17e, region: 0x97},
	{lang: 0x186, region: 0x97},
	{lang: 0x17f, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x189, region: 0x34},
	{lang: 0x180, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x194, region: 0xc2},
	{lang: 0x293, region: 0x106},
	{lang: 0x14, region: 0x9f},
	{lang: 0x0, region: 0x0},
	{lang: 0x16a, region: 0x82},
	{lang: 0x0, region: 0x0},
	{lang: 0x20e, region: 0x94},
	{lang: 0x1fe, region: 0x97},
	{lang: 0x1c2, region: 0xc3},
	{lang: 0x1c0, region: 0x97},
	{lang: 0x222, region: 0x113},
	{lang: 0x14, region: 0x11a},
	{lang: 0x77, region: 0xc2},
	{lang: 0x138, region: 0x104},
	{lang: 0x163, region: 0x52},
	{lang: 0x1c5, region: 0x9a},
	{lang: 0x1c5, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x1cf, region: 0xae},
	{lang: 0xd9, region: 0x52},
	{lang: 0x296, region: 0x9a},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x1e2, region: 0x93},
	{lang: 0x0, region: 0x0},
	{lang: 0x1b2, region: 0x10a},
	{lang: 0x21e, region: 0x95},
	{lang: 0x0, region: 0x0},
	{lang: 0x297, region: 0x15b},
	{lang: 0x1ff, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x94, region: 0x79},
	{lang: 0x1f9, region: 0x97},
	{lang: 0x1f9, region: 0x97},
	{lang: 0x206, region: 0x97},
	{lang: 0x213, region: 0xb1},
	{lang: 0x226, region: 0x97},
	{lang: 0x22e, region: 0x93},
	{lang: 0x237, region: 0x34},
	{lang: 0x238, region: 0x99},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x23c, region: 0xe5},
	{lang: 0x84, region: 0x97},
	{lang: 0x23e, region: 0x52},
	{lang: 0x117, region: 0x52},
	{lang: 0x23a, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x44, region: 0x13b},
	{lang: 0x241, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x2a5, region: 0xb8},
	{lang: 0xa2, region: 0xe5},
	{lang: 0x89, region: 0xcb},
	{lang: 0x246, region: 0x121},
	{lang: 0x48, region: 0x52},
	{lang: 0x168, region: 0x97},
	{lang: 0x26c, region: 0x11a},
	{lang: 0x275, region: 0xb2},
	{lang: 0x0, region: 0x0},
	{lang: 0xe0, region: 0x97},
	{lang: 0x0, region: 0x0},
	{lang: 0x1cd, region: 0x9a},
	{lang: 0xc, region: 0x99},
	{lang: 0xee, region: 0x52},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
	{lang: 0x0, region: 0x0},
}

type likelyScriptRegion struct {
	region uint16
	script uint8
	flags  uint8
}

// likelyLang is a lookup table, indexed by langID, for the most likely
// scripts and regions given incomplete information. If more entries exist for a
// given language, region and script are the index and size respectively
// of the list in likelyLangList.
// Size: 2732 bytes, 683 elements
var likelyLang = [683]likelyScriptRegion{
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x6e, script: 0x4b, flags: 0x0},
	{region: 0x7b, script: 0x1b, flags: 0x0},
	{region: 0x7e, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x9a, script: 0x7, flags: 0x0},
	{region: 0x126, script: 0x4, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x7e, script: 0x4b, flags: 0x0},
	{region: 0x99, script: 0xd2, flags: 0x0},
	{region: 0x14a, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x6e, script: 0x24, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x6a, script: 0x4, flags: 0x0},
	{region: 0x0, script: 0x3, flags: 0x1},
	{region: 0x50, script: 0x4b, flags: 0x0},
	{region: 0x3e, script: 0x4b, flags: 0x0},
	{region: 0x66, script: 0x4, flags: 0x0},
	{region: 0xb8, script: 0x4, flags: 0x0},
	{region: 0x6a, script: 0x4, flags: 0x0},
	{region: 0x97, script: 0xc, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x6d, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x3e, script: 0x4b, flags: 0x0},
	{region: 0x3, script: 0x4, flags: 0x1},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x2d, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x9, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x4e, script: 0x4b, flags: 0x0},
	{region: 0x46, script: 0x1b, flags: 0x0},
	{region: 0x15f, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0xc1, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x37, script: 0x1b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x129, script: 0x2a, flags: 0x0},
	{region: 0x97, script: 0x46, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x13c, script: 0x4b, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x13b, script: 0xc3, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0x34, script: 0xc, flags: 0x0},
	{region: 0x52, script: 0xca, flags: 0x0},
	{region: 0x97, script: 0xc, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0x4e, script: 0x4b, flags: 0x0},
	{region: 0x76, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x32, script: 0x4b, flags: 0x0},
	{region: 0xb2, script: 0xa, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0xe6, script: 0x1d, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x15c, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x84, script: 0x4b, flags: 0x0},
	{region: 0x6c, script: 0x24, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0x6d, script: 0x4b, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x7, script: 0x2, flags: 0x1},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0x88, script: 0x4b, flags: 0x0},
	{region: 0x73, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0x132, script: 0x17, flags: 0x0},
	{region: 0xa4, script: 0x4, flags: 0x0},
	{region: 0x13b, script: 0x16, flags: 0x0},
	{region: 0x99, script: 0x4, flags: 0x0},
	{region: 0x76, script: 0x4b, flags: 0x0},
	{region: 0x6a, script: 0x19, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x14, flags: 0x0},
	{region: 0x48, script: 0x14, flags: 0x0},
	{region: 0x48, script: 0x14, flags: 0x0},
	{region: 0x48, script: 0x14, flags: 0x0},
	{region: 0x48, script: 0x14, flags: 0x0},
	{region: 0x108, script: 0x4b, flags: 0x0},
	{region: 0x5d, script: 0x4b, flags: 0x0},
	{region: 0xe7, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x14, flags: 0x0},
	{region: 0xc2, script: 0x6e, flags: 0x0},
	{region: 0x9, script: 0x2, flags: 0x1},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x79, script: 0x4b, flags: 0x0},
	{region: 0x62, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x4, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0xd2, script: 0x4b, flags: 0x0},
	{region: 0x4e, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x4, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0xce, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0xcb, script: 0xc8, flags: 0x0},
	{region: 0x112, script: 0x4b, flags: 0x0},
	{region: 0x36, script: 0x4b, flags: 0x0},
	{region: 0x42, script: 0xca, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0x7e, script: 0x4b, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x6a, script: 0x22, flags: 0x0},
	{region: 0xc2, script: 0x3e, flags: 0x0},
	{region: 0x85, script: 0x2a, flags: 0x0},
	{region: 0xb, script: 0x2, flags: 0x1},
	{region: 0x1, script: 0x4b, flags: 0x0},
	{region: 0x6d, script: 0x4b, flags: 0x0},
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x69, script: 0x4b, flags: 0x0},
	{region: 0x9c, script: 0x3a, flags: 0x0},
	{region: 0x6d, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x6d, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0x84, script: 0x4b, flags: 0x0},
	{region: 0x112, script: 0x4b, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0x70, script: 0x4b, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x10a, script: 0x4b, flags: 0x0},
	{region: 0x71, script: 0x4b, flags: 0x0},
	{region: 0x74, script: 0x4b, flags: 0x0},
	{region: 0x3a, script: 0x4b, flags: 0x0},
	{region: 0x76, script: 0x4b, flags: 0x0},
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x76, script: 0x4b, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0x13d, script: 0x4b, flags: 0x0},
	{region: 0xd2, script: 0x4b, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0xd7, script: 0x4b, flags: 0x0},
	{region: 0x94, script: 0x4b, flags: 0x0},
	{region: 0x7e, script: 0x4b, flags: 0x0},
	{region: 0xba, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0x30, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0x7c, script: 0x4b, flags: 0x0},
	{region: 0x79, script: 0x4b, flags: 0x0},
	{region: 0x6e, script: 0x24, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xa5, script: 0x4b, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x6d, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0xef, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0xc4, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0xd7, script: 0x4b, flags: 0x0},
	{region: 0x12e, script: 0x28, flags: 0x0},
	{region: 0xd, script: 0x2, flags: 0x1},
	{region: 0x97, script: 0xc, flags: 0x0},
	{region: 0x4d, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x2b, flags: 0x0},
	{region: 0x40, script: 0x4b, flags: 0x0},
	{region: 0x53, script: 0x4b, flags: 0x0},
	{region: 0x7e, script: 0x4b, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0x96, script: 0x4b, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0xf, script: 0x3, flags: 0x1},
	{region: 0x52, script: 0x30, flags: 0x0},
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x23, script: 0x4, flags: 0x0},
	{region: 0x95, script: 0x33, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x71, script: 0x1d, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0x75, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0xad, script: 0x36, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0xe4, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x8e, script: 0x4b, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0x30, flags: 0x0},
	{region: 0x8f, script: 0x4b, flags: 0x0},
	{region: 0x90, script: 0x4b, flags: 0x0},
	{region: 0x27, script: 0x6, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x76, script: 0x4b, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0xd3, flags: 0x0},
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x9b, script: 0x4b, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x14, flags: 0x0},
	{region: 0x95, script: 0x33, flags: 0x0},
	{region: 0x104, script: 0x4b, flags: 0x0},
	{region: 0xa0, script: 0x3c, flags: 0x0},
	{region: 0x9e, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x12e, script: 0x33, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x62, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x7b, script: 0x26, flags: 0x0},
	{region: 0x134, script: 0x1b, flags: 0x0},
	{region: 0x66, script: 0x4b, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x161, script: 0x4b, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x121, script: 0xc9, flags: 0x0},
	{region: 0x59, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x4e, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x4a, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x40, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0xc0, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x62, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0x129, script: 0x4b, flags: 0x0},
	{region: 0xd0, script: 0x4b, flags: 0x0},
	{region: 0xad, script: 0x48, flags: 0x0},
	{region: 0x12, script: 0x6, flags: 0x1},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x80, script: 0x4b, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0xa4, script: 0x41, flags: 0x0},
	{region: 0x29, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x43, flags: 0x0},
	{region: 0xa9, script: 0x44, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x73, script: 0x4b, flags: 0x0},
	{region: 0xb2, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x110, script: 0x4b, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x4, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0x18, script: 0x3, flags: 0x1},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x79, script: 0x4b, flags: 0x0},
	{region: 0x121, script: 0xc9, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x1b, script: 0x5, flags: 0x1},
	{region: 0x135, script: 0x4b, flags: 0x0},
	{region: 0x85, script: 0x4e, flags: 0x0},
	{region: 0x95, script: 0x33, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0xb5, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0xc9, flags: 0x0},
	{region: 0x97, script: 0x4c, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0xd7, script: 0x4b, flags: 0x0},
	{region: 0x20, script: 0x2, flags: 0x1},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0x50, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0xc4, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x4a, script: 0x4b, flags: 0x0},
	{region: 0xad, script: 0x48, flags: 0x0},
	{region: 0x4a, script: 0x4b, flags: 0x0},
	{region: 0x15f, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0xb4, script: 0x4b, flags: 0x0},
	{region: 0xb6, script: 0x4b, flags: 0x0},
	{region: 0x4a, script: 0x4b, flags: 0x0},
	{region: 0x4a, script: 0x4b, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0xb6, script: 0x4b, flags: 0x0},
	{region: 0x121, script: 0xc9, flags: 0x0},
	{region: 0x52, script: 0x30, flags: 0x0},
	{region: 0x129, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x22, script: 0x3, flags: 0x1},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0xcd, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x110, script: 0x4b, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0x121, script: 0x4, flags: 0x0},
	{region: 0xca, script: 0x4b, flags: 0x0},
	{region: 0xbd, script: 0x4b, flags: 0x0},
	{region: 0xcf, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0xbe, script: 0x4b, flags: 0x0},
	{region: 0xde, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xc0, script: 0x1b, flags: 0x0},
	{region: 0x97, script: 0x5b, flags: 0x0},
	{region: 0x25, script: 0x3, flags: 0x1},
	{region: 0x97, script: 0xc, flags: 0x0},
	{region: 0xc2, script: 0x62, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0x36, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x34, script: 0x5f, flags: 0x0},
	{region: 0x28, script: 0x3, flags: 0x1},
	{region: 0xc9, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x161, script: 0x4b, flags: 0x0},
	{region: 0xc2, script: 0x62, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x55, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0xdb, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0x30, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0xd0, script: 0x4b, flags: 0x0},
	{region: 0xd8, script: 0x4b, flags: 0x0},
	{region: 0xcd, script: 0x4b, flags: 0x0},
	{region: 0x161, script: 0x4b, flags: 0x0},
	{region: 0xcf, script: 0x4b, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xd0, script: 0x4b, flags: 0x0},
	{region: 0xcf, script: 0x4b, flags: 0x0},
	{region: 0xcd, script: 0x4b, flags: 0x0},
	{region: 0xcd, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0xdd, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x4b, flags: 0x0},
	{region: 0xd7, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0xd8, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0xd8, script: 0x4b, flags: 0x0},
	{region: 0x121, script: 0x47, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x10a, script: 0xab, flags: 0x0},
	{region: 0x82, script: 0x66, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x14, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x109, script: 0x4b, flags: 0x0},
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0x4b, flags: 0x0},
	{region: 0xcc, script: 0x4b, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0x76, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x6e, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x6b, flags: 0x0},
	{region: 0x7b, script: 0x1b, flags: 0x0},
	{region: 0xc3, script: 0x6a, flags: 0x0},
	{region: 0x2b, script: 0x3, flags: 0x1},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x2e, script: 0x2, flags: 0x1},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x2f, script: 0x4b, flags: 0x0},
	{region: 0xee, script: 0x4b, flags: 0x0},
	{region: 0x76, script: 0x4b, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0xd1, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0xae, script: 0x74, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x97, script: 0xf, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0xe7, script: 0x4b, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x85, script: 0x2a, flags: 0x0},
	{region: 0x73, script: 0x4b, flags: 0x0},
	{region: 0xe6, script: 0x40, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0x1, script: 0x4b, flags: 0x0},
	{region: 0x23, script: 0x4, flags: 0x0},
	{region: 0x40, script: 0x4b, flags: 0x0},
	{region: 0x78, script: 0x4b, flags: 0x0},
	{region: 0xe2, script: 0x4b, flags: 0x0},
	{region: 0x87, script: 0x4b, flags: 0x0},
	{region: 0x68, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x4b, flags: 0x0},
	{region: 0x100, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x4b, flags: 0x0},
	{region: 0x30, script: 0x2, flags: 0x1},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x34, script: 0xc, flags: 0x0},
	{region: 0x4d, script: 0x4b, flags: 0x0},
	{region: 0x70, script: 0x4b, flags: 0x0},
	{region: 0x4d, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x0},
	{region: 0x10a, script: 0x4b, flags: 0x0},
	{region: 0x39, script: 0x4b, flags: 0x0},
	{region: 0xcf, script: 0x4b, flags: 0x0},
	{region: 0x102, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x71, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x12e, script: 0x1b, flags: 0x0},
	{region: 0x107, script: 0x4b, flags: 0x0},
	{region: 0x105, script: 0x4b, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0xa0, script: 0x3f, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x7e, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0xa2, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0xaf, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x79, script: 0x4b, flags: 0x0},
	{region: 0x48, script: 0x4b, flags: 0x0},
	{region: 0x32, script: 0x4, flags: 0x1},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0xd8, script: 0x4b, flags: 0x0},
	{region: 0x4e, script: 0x4b, flags: 0x0},
	{region: 0xcf, script: 0x4b, flags: 0x0},
	{region: 0xcd, script: 0x4b, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0x4b, script: 0x4b, flags: 0x0},
	{region: 0x94, script: 0x68, flags: 0x0},
	{region: 0xb4, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xb8, script: 0xc6, flags: 0x0},
	{region: 0xc2, script: 0x62, flags: 0x0},
	{region: 0xb1, script: 0xb5, flags: 0x0},
	{region: 0x6e, script: 0x4b, flags: 0x0},
	{region: 0x10f, script: 0x4b, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x10d, script: 0x4b, flags: 0x0},
	{region: 0xe7, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x13f, script: 0x4b, flags: 0x0},
	{region: 0x10a, script: 0x4b, flags: 0x0},
	{region: 0x10a, script: 0x4b, flags: 0x0},
	{region: 0x70, script: 0x4b, flags: 0x0},
	{region: 0x95, script: 0xac, flags: 0x0},
	{region: 0x70, script: 0x4b, flags: 0x0},
	{region: 0x161, script: 0x4b, flags: 0x0},
	{region: 0xc1, script: 0x4b, flags: 0x0},
	{region: 0x113, script: 0x4b, flags: 0x0},
	{region: 0x121, script: 0xc9, flags: 0x0},
	{region: 0x26, script: 0x4b, flags: 0x0},
	{region: 0x36, script: 0x5, flags: 0x1},
	{region: 0x97, script: 0xb6, flags: 0x0},
	{region: 0x114, script: 0x4b, flags: 0x0},
	{region: 0x112, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x6c, script: 0x4b, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x82, script: 0x4b, flags: 0x0},
	{region: 0x10a, script: 0x4b, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x15c, script: 0x4, flags: 0x0},
	{region: 0x4a, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x93, script: 0x4b, flags: 0x0},
	{region: 0x34, script: 0xc, flags: 0x0},
	{region: 0x99, script: 0xb9, flags: 0x0},
	{region: 0xe7, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0xc1, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x43, flags: 0x0},
	{region: 0x52, script: 0xbf, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0xc4, flags: 0x0},
	{region: 0x110, script: 0x4b, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0x124, script: 0x4b, flags: 0x0},
	{region: 0x3b, script: 0x3, flags: 0x1},
	{region: 0x121, script: 0xc9, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x6e, script: 0x24, flags: 0x0},
	{region: 0x6c, script: 0x24, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x125, script: 0x4b, flags: 0x0},
	{region: 0x123, script: 0x4b, flags: 0x0},
	{region: 0x31, script: 0x4b, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x31, script: 0x4b, flags: 0x0},
	{region: 0xd2, script: 0x4b, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x127, script: 0x4b, flags: 0x0},
	{region: 0xe4, script: 0x4b, flags: 0x0},
	{region: 0x129, script: 0x4b, flags: 0x0},
	{region: 0x129, script: 0x4b, flags: 0x0},
	{region: 0x12c, script: 0x4b, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x85, script: 0x2a, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x42, script: 0xca, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0x121, script: 0xc9, flags: 0x0},
	{region: 0x31, script: 0x4b, flags: 0x0},
	{region: 0xcc, script: 0x4b, flags: 0x0},
	{region: 0x12b, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xd2, script: 0x4b, flags: 0x0},
	{region: 0xe3, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0xb8, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x3e, script: 0x4, flags: 0x1},
	{region: 0x11a, script: 0xcc, flags: 0x0},
	{region: 0x12e, script: 0x1b, flags: 0x0},
	{region: 0x73, script: 0x4b, flags: 0x0},
	{region: 0x29, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x42, script: 0x3, flags: 0x1},
	{region: 0x97, script: 0xc, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x45, script: 0x4, flags: 0x1},
	{region: 0xb2, script: 0xcd, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x9c, script: 0x4b, flags: 0x0},
	{region: 0x104, script: 0x4b, flags: 0x0},
	{region: 0x13b, script: 0x4b, flags: 0x0},
	{region: 0x119, script: 0x4b, flags: 0x0},
	{region: 0x35, script: 0x4b, flags: 0x0},
	{region: 0x5f, script: 0x4b, flags: 0x0},
	{region: 0xcf, script: 0x4b, flags: 0x0},
	{region: 0x1, script: 0x4b, flags: 0x0},
	{region: 0x69, script: 0x4b, flags: 0x0},
	{region: 0x12d, script: 0x4b, flags: 0x0},
	{region: 0x35, script: 0x4b, flags: 0x0},
	{region: 0x4d, script: 0x4b, flags: 0x0},
	{region: 0x6e, script: 0x24, flags: 0x0},
	{region: 0xe5, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0xc4, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x13d, script: 0x4b, flags: 0x0},
	{region: 0x112, script: 0x4b, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x52, script: 0x30, flags: 0x0},
	{region: 0x40, script: 0x4b, flags: 0x0},
	{region: 0x129, script: 0x15, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x129, script: 0x52, flags: 0x0},
	{region: 0x129, script: 0x53, flags: 0x0},
	{region: 0x7b, script: 0x26, flags: 0x0},
	{region: 0x52, script: 0x56, flags: 0x0},
	{region: 0x109, script: 0x59, flags: 0x0},
	{region: 0x106, script: 0x63, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x0},
	{region: 0x12f, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x76, flags: 0x0},
	{region: 0x15b, script: 0xae, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0xcf, script: 0x4b, flags: 0x0},
	{region: 0x73, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4b, flags: 0x0},
	{region: 0x1, script: 0x33, flags: 0x0},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x40, script: 0x4b, flags: 0x0},
	{region: 0xcd, script: 0x4b, flags: 0x0},
	{region: 0x52, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0xa6, script: 0x4, flags: 0x0},
	{region: 0xd7, script: 0x4b, flags: 0x0},
	{region: 0xb8, script: 0xc6, flags: 0x0},
	{region: 0x49, script: 0x13, flags: 0x1},
	{region: 0xce, script: 0x4b, flags: 0x0},
	{region: 0x15e, script: 0x4b, flags: 0x0},
	{region: 0x0, script: 0x0, flags: 0x0},
	{region: 0x129, script: 0x4b, flags: 0x0},
}

// likelyLangList holds lists info associated with likelyLang.
// Size: 368 bytes, 92 elements
var likelyLangList = [92]likelyScriptRegion{
	{region: 0x9a, script: 0x5, flags: 0x0},
	{region: 0x9f, script: 0x64, flags: 0x2},
	{region: 0x11a, script: 0x6d, flags: 0x2},
	{region: 0x31, script: 0x4b, flags: 0x0},
	{region: 0x9a, script: 0x4, flags: 0x4},
	{region: 0x104, script: 0x1b, flags: 0x4},
	{region: 0x9a, script: 0x4, flags: 0x2},
	{region: 0x97, script: 0xc, flags: 0x0},
	{region: 0x34, script: 0x13, flags: 0x2},
	{region: 0x104, script: 0x1b, flags: 0x0},
	{region: 0x37, script: 0x27, flags: 0x2},
	{region: 0x132, script: 0x4b, flags: 0x0},
	{region: 0x79, script: 0xb1, flags: 0x2},
	{region: 0x5c, script: 0x1a, flags: 0x0},
	{region: 0x85, script: 0x4f, flags: 0x2},
	{region: 0xd4, script: 0x4b, flags: 0x0},
	{region: 0x51, script: 0x4, flags: 0x4},
	{region: 0x109, script: 0x4, flags: 0x4},
	{region: 0xac, script: 0x1b, flags: 0x0},
	{region: 0x23, script: 0x4, flags: 0x4},
	{region: 0x52, script: 0x4, flags: 0x4},
	{region: 0x9a, script: 0x4, flags: 0x4},
	{region: 0xc3, script: 0x4, flags: 0x4},
	{region: 0x52, script: 0x4, flags: 0x2},
	{region: 0x129, script: 0x4b, flags: 0x0},
	{region: 0xae, script: 0x4, flags: 0x4},
	{region: 0x99, script: 0x4, flags: 0x2},
	{region: 0xa3, script: 0x1b, flags: 0x0},
	{region: 0x52, script: 0x4, flags: 0x4},
	{region: 0x129, script: 0x4b, flags: 0x4},
	{region: 0x52, script: 0x4, flags: 0x2},
	{region: 0x129, script: 0x4b, flags: 0x2},
	{region: 0xd9, script: 0x1d, flags: 0x0},
	{region: 0x97, script: 0x4d, flags: 0x2},
	{region: 0x81, script: 0x4b, flags: 0x0},
	{region: 0x82, script: 0x66, flags: 0x4},
	{region: 0x82, script: 0x66, flags: 0x2},
	{region: 0xc3, script: 0x1b, flags: 0x0},
	{region: 0x52, script: 0x5d, flags: 0x4},
	{region: 0x52, script: 0x5d, flags: 0x2},
	{region: 0xce, script: 0x4b, flags: 0x0},
	{region: 0x49, script: 0x4, flags: 0x4},
	{region: 0x93, script: 0x4, flags: 0x4},
	{region: 0x97, script: 0x2c, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x4},
	{region: 0xe6, script: 0x4, flags: 0x2},
	{region: 0x9a, script: 0x71, flags: 0x0},
	{region: 0x52, script: 0x72, flags: 0x2},
	{region: 0xb8, script: 0xc6, flags: 0x0},
	{region: 0xd7, script: 0x4b, flags: 0x4},
	{region: 0xe6, script: 0x4, flags: 0x0},
	{region: 0x97, script: 0x1d, flags: 0x2},
	{region: 0x97, script: 0x42, flags: 0x2},
	{region: 0x97, script: 0xb4, flags: 0x2},
	{region: 0x103, script: 0x1b, flags: 0x0},
	{region: 0xbb, script: 0x4b, flags: 0x4},
	{region: 0x102, script: 0x4b, flags: 0x4},
	{region: 0x104, script: 0x4b, flags: 0x4},
	{region: 0x129, script: 0x4b, flags: 0x4},
	{region: 0x122, script: 0x1b, flags: 0x0},
	{region: 0xe6, script: 0x4, flags: 0x4},
	{region: 0xe6, script: 0x4, flags: 0x2},
	{region: 0x52, script: 0x4, flags: 0x0},
	{region: 0xac, script: 0x1b, flags: 0x4},
	{region: 0xc3, script: 0x1b, flags: 0x4},
	{region: 0xac, script: 0x1b, flags: 0x2},
	{region: 0x97, script: 0xc, flags: 0x0},
	{region: 0xd9, script: 0x1d, flags: 0x4},
	{region: 0xd9, script: 0x1d, flags: 0x2},
	{region: 0x134, script: 0x4b, flags: 0x0},
	{region: 0x23, script: 0x4, flags: 0x4},
	{region: 0x52, script: 0x1b, flags: 0x4},
	{region: 0x23, script: 0x4, flags: 0x2},
	{region: 0x52, script: 0x30, flags: 0x0},
	{region: 0x2e, script: 0x31, flags: 0x4},
	{region: 0x3d, script: 0x31, flags: 0x4},
	{region: 0x79, script: 0x31, flags: 0x4},
	{region: 0x7c, script: 0x31, flags: 0x4},
	{region: 0x8b, script: 0x31, flags: 0x4},
	{region: 0x93, script: 0x31, flags: 0x4},
	{region: 0xc4, script: 0x31, flags: 0x4},
	{region: 0xce, script: 0x31, flags: 0x4},
	{region: 0xe0, script: 0x31, flags: 0x4},
	{region: 0xe3, script: 0x31, flags: 0x4},
	{region: 0xe5, script: 0x31, flags: 0x4},
	{region: 0x114, script: 0x31, flags: 0x4},
	{region: 0x121, script: 0x31, flags: 0x4},
	{region: 0x12c, script: 0x31, flags: 0x4},
	{region: 0x132, script: 0x31, flags: 0x4},
	{region: 0x13b, script: 0x31, flags: 0x4},
	{region: 0x12c, script: 0xe, flags: 0x2},
	{region: 0x12c, script: 0x31, flags: 0x2},
}

type likelyLangScript struct {
	lang   uint16
	script uint8
	flags  uint8
}

// likelyRegion is a lookup table, indexed by regionID, for the most likely
// languages and scripts given incomplete information. If more entries exist
// for a given regionID, lang and script are the index and size respectively
// of the list in likelyRegionList.
// TODO: exclude containers and user-definable regions from the list.
// Size: 1420 bytes, 355 elements
var likelyRegion = [355]likelyLangScript{
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x5d, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x0, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2, script: 0x2, flags: 0x1},
	{lang: 0x4, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x4b, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x21a, script: 0x4b, flags: 0x0},
	{lang: 0x7f, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1ab, script: 0x4b, flags: 0x0},
	{lang: 0x231, script: 0x4b, flags: 0x0},
	{lang: 0x21, script: 0x4b, flags: 0x0},
	{lang: 0x6, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x47, script: 0xc, flags: 0x0},
	{lang: 0x1ab, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x8, script: 0x2, flags: 0x1},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x1ed, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x18a, script: 0x4b, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x1c7, script: 0x4b, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2d, script: 0x1b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x29d, script: 0x33, flags: 0x2},
	{lang: 0x18a, script: 0x4, flags: 0x2},
	{lang: 0x232, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x7f, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0xc, script: 0x4, flags: 0x1},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x4b, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x1c7, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x10, script: 0x2, flags: 0x1},
	{lang: 0x74, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x7f, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1, script: 0x4b, flags: 0x0},
	{lang: 0x7b, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x12, script: 0x2, flags: 0x1},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x98, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x24a, script: 0x24, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x14, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa1, script: 0x4b, flags: 0x0},
	{lang: 0xd7, script: 0x1d, flags: 0x2},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x64, script: 0x4b, flags: 0x0},
	{lang: 0xa5, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x16, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x18, script: 0x3, flags: 0x1},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xb, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x122, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x1b, script: 0x3, flags: 0x1},
	{lang: 0x0, script: 0x4b, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2a6, script: 0x31, flags: 0x0},
	{lang: 0x0, script: 0x4b, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0xe2, script: 0x4b, flags: 0x0},
	{lang: 0xe5, script: 0x4b, flags: 0x0},
	{lang: 0xe6, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x1e, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x20, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x22, script: 0x3, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x25, script: 0x2, flags: 0x1},
	{lang: 0xf5, script: 0x4b, flags: 0x0},
	{lang: 0xf6, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0xfa, script: 0x3c, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x13e, script: 0x1b, flags: 0x0},
	{lang: 0x27, script: 0x3, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2a, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x127, script: 0x44, flags: 0x0},
	{lang: 0x127, script: 0x44, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x2c, script: 0x2, flags: 0x1},
	{lang: 0x2e, script: 0x2, flags: 0x1},
	{lang: 0x30, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x7f, script: 0x4b, flags: 0x0},
	{lang: 0x213, script: 0xb5, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x22c, script: 0x4b, flags: 0x0},
	{lang: 0x15a, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x161, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x32, script: 0x2, flags: 0x1},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x34, script: 0x2, flags: 0x1},
	{lang: 0x225, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x174, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x36, script: 0x2, flags: 0x1},
	{lang: 0x45, script: 0x4b, flags: 0x0},
	{lang: 0x194, script: 0x62, flags: 0x0},
	{lang: 0x38, script: 0x2, flags: 0x1},
	{lang: 0x3a, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x3c, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x18b, script: 0x4b, flags: 0x0},
	{lang: 0x3e, script: 0x3, flags: 0x1},
	{lang: 0x89, script: 0xc8, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x18a, script: 0x4b, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x9, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0xd1, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xd1, script: 0x4, flags: 0x2},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x1ab, script: 0x4b, flags: 0x0},
	{lang: 0x19d, script: 0x4b, flags: 0x0},
	{lang: 0x1a2, script: 0x1d, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x256, script: 0x4b, flags: 0x0},
	{lang: 0xa2, script: 0x4b, flags: 0x0},
	{lang: 0x41, script: 0x3, flags: 0x1},
	{lang: 0x44, script: 0x2, flags: 0x1},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1c8, script: 0x4b, flags: 0x0},
	{lang: 0xc0, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x46, script: 0x2, flags: 0x1},
	{lang: 0x225, script: 0x1b, flags: 0x0},
	{lang: 0x48, script: 0x2, flags: 0x1},
	{lang: 0x1f6, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x4a, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x217, script: 0x4b, flags: 0x0},
	{lang: 0x19d, script: 0x4b, flags: 0x0},
	{lang: 0x4c, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xf6, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x222, script: 0x4b, flags: 0x0},
	{lang: 0x1ab, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x4e, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x50, script: 0x3, flags: 0x1},
	{lang: 0x53, script: 0x2, flags: 0x1},
	{lang: 0x24e, script: 0x4b, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x24d, script: 0x4b, flags: 0x0},
	{lang: 0x55, script: 0x2, flags: 0x1},
	{lang: 0x255, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x57, script: 0x3, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x264, script: 0x4b, flags: 0x0},
	{lang: 0x5a, script: 0x2, flags: 0x1},
	{lang: 0x232, script: 0x4b, flags: 0x0},
	{lang: 0x5c, script: 0x3, flags: 0x1},
	{lang: 0x232, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x29d, script: 0x33, flags: 0x2},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x274, script: 0x4b, flags: 0x0},
	{lang: 0xf6, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x96, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x279, script: 0x4b, flags: 0x0},
	{lang: 0x3d, script: 0x4b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x21a, script: 0x4b, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x5f, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0x61, script: 0x2, flags: 0x1},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
	{lang: 0x0, script: 0x0, flags: 0x0},
}

// likelyRegionList holds lists info associated with likelyRegion.
// Size: 396 bytes, 99 elements
var likelyRegionList = [99]likelyLangScript{
	{lang: 0x9d, script: 0x4, flags: 0x0},
	{lang: 0x24d, script: 0x4b, flags: 0x0},
	{lang: 0x224, script: 0x4b, flags: 0x0},
	{lang: 0x17d, script: 0x1b, flags: 0x0},
	{lang: 0xe7, script: 0x6, flags: 0x0},
	{lang: 0x136, script: 0x4b, flags: 0x0},
	{lang: 0x50, script: 0x4b, flags: 0x0},
	{lang: 0x225, script: 0x1b, flags: 0x0},
	{lang: 0x35, script: 0x1b, flags: 0x0},
	{lang: 0x257, script: 0x4b, flags: 0x0},
	{lang: 0x8c, script: 0xca, flags: 0x0},
	{lang: 0x1a2, script: 0x1d, flags: 0x0},
	{lang: 0x2a6, script: 0x30, flags: 0x0},
	{lang: 0x26b, script: 0x4, flags: 0x0},
	{lang: 0x2a1, script: 0x4b, flags: 0x0},
	{lang: 0x148, script: 0xc9, flags: 0x0},
	{lang: 0x93, script: 0x2a, flags: 0x0},
	{lang: 0x257, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0xf, script: 0x24, flags: 0x0},
	{lang: 0x94, script: 0x4b, flags: 0x0},
	{lang: 0x132, script: 0x4, flags: 0x2},
	{lang: 0x29d, script: 0x33, flags: 0x2},
	{lang: 0x103, script: 0x26, flags: 0x0},
	{lang: 0x2, script: 0x1b, flags: 0x0},
	{lang: 0x136, script: 0x4b, flags: 0x0},
	{lang: 0x93, script: 0x2a, flags: 0x0},
	{lang: 0x17d, script: 0x1b, flags: 0x0},
	{lang: 0x257, script: 0x4b, flags: 0x0},
	{lang: 0xeb, script: 0x4b, flags: 0x0},
	{lang: 0x18a, script: 0x4, flags: 0x0},
	{lang: 0xd5, script: 0x33, flags: 0x0},
	{lang: 0x1ef, script: 0x4b, flags: 0x0},
	{lang: 0xd6, script: 0x1d, flags: 0x0},
	{lang: 0x273, script: 0x4, flags: 0x0},
	{lang: 0x11a, script: 0x62, flags: 0x0},
	{lang: 0x9d, script: 0x4, flags: 0x0},
	{lang: 0x24d, script: 0x4b, flags: 0x0},
	{lang: 0x124, script: 0x41, flags: 0x0},
	{lang: 0x68, script: 0x4, flags: 0x0},
	{lang: 0x10d, script: 0xc9, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x1f3, script: 0x1b, flags: 0x0},
	{lang: 0x7f, script: 0x4b, flags: 0x0},
	{lang: 0x156, script: 0x48, flags: 0x0},
	{lang: 0x10d, script: 0xc9, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x1ef, script: 0x4b, flags: 0x0},
	{lang: 0x26d, script: 0x1b, flags: 0x0},
	{lang: 0x17d, script: 0x1b, flags: 0x0},
	{lang: 0x224, script: 0x4b, flags: 0x0},
	{lang: 0x17f, script: 0x1b, flags: 0x0},
	{lang: 0x120, script: 0x4, flags: 0x0},
	{lang: 0x2a6, script: 0x31, flags: 0x0},
	{lang: 0x1db, script: 0x4b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x173, script: 0x4b, flags: 0x0},
	{lang: 0x273, script: 0x4, flags: 0x0},
	{lang: 0x3c, script: 0x1d, flags: 0x0},
	{lang: 0x273, script: 0x4, flags: 0x0},
	{lang: 0x273, script: 0x4, flags: 0x0},
	{lang: 0x54, script: 0x1d, flags: 0x0},
	{lang: 0x1d3, script: 0x4b, flags: 0x0},
	{lang: 0x2d, script: 0x1b, flags: 0x0},
	{lang: 0x1ef, script: 0x4b, flags: 0x0},
	{lang: 0x35, script: 0x1b, flags: 0x0},
	{lang: 0x1f3, script: 0x1b, flags: 0x0},
	{lang: 0x130, script: 0x4b, flags: 0x0},
	{lang: 0x231, script: 0x4b, flags: 0x0},
	{lang: 0x29d, script: 0x33, flags: 0x0},
	{lang: 0x215, script: 0x4b, flags: 0x0},
	{lang: 0x26d, script: 0x1b, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x246, script: 0xc9, flags: 0x0},
	{lang: 0x172, script: 0x4, flags: 0x0},
	{lang: 0x181, script: 0x62, flags: 0x0},
	{lang: 0x245, script: 0x1b, flags: 0x0},
	{lang: 0x9d, script: 0x4, flags: 0x0},
	{lang: 0x13, script: 0x4, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x257, script: 0x4b, flags: 0x0},
	{lang: 0x109, script: 0x1b, flags: 0x0},
	{lang: 0x37, script: 0x2a, flags: 0x0},
	{lang: 0x2a6, script: 0x31, flags: 0x0},
	{lang: 0x259, script: 0x4b, flags: 0x0},
	{lang: 0x26d, script: 0x1b, flags: 0x0},
	{lang: 0x29d, script: 0x33, flags: 0x0},
	{lang: 0x1d3, script: 0x4b, flags: 0x0},
	{lang: 0x224, script: 0x4b, flags: 0x0},
	{lang: 0x225, script: 0x1b, flags: 0x0},
	{lang: 0xa7, script: 0x4b, flags: 0x0},
	{lang: 0x233, script: 0x4, flags: 0x0},
}

type likelyTag struct {
	lang   uint16
	region uint16
	script uint8
}

// Size: 192 bytes, 32 elements
var likelyRegionGroup = [32]likelyTag{
	{lang: 0x0, region: 0x0, script: 0x0},
	{lang: 0x94, region: 0xd4, script: 0x4b},
	{lang: 0x94, region: 0x132, script: 0x4b},
	{lang: 0x1db, region: 0x40, script: 0x4b},
	{lang: 0x94, region: 0x2e, script: 0x4b},
	{lang: 0x94, region: 0xd4, script: 0x4b},
	{lang: 0x96, region: 0xcd, script: 0x4b},
	{lang: 0x94, region: 0xa2, script: 0x4b},
	{lang: 0x13, region: 0x6a, script: 0x4},
	{lang: 0x232, region: 0x4a, script: 0x4b},
	{lang: 0x94, region: 0x15e, script: 0x4b},
	{lang: 0x94, region: 0x132, script: 0x4b},
	{lang: 0x94, region: 0x132, script: 0x4b},
	{lang: 0x96, region: 0x58, script: 0x4b},
	{lang: 0x2a6, region: 0x52, script: 0x30},
	{lang: 0xd6, region: 0x97, script: 0x1d},
	{lang: 0xeb, region: 0x93, script: 0x4b},
	{lang: 0xf6, region: 0x9c, script: 0x4b},
	{lang: 0x94, region: 0x2e, script: 0x4b},
	{lang: 0x94, region: 0xe4, script: 0x4b},
	{lang: 0x94, region: 0xa5, script: 0x4b},
	{lang: 0x21a, region: 0x13f, script: 0x4b},
	{lang: 0x2a6, region: 0x52, script: 0x30},
	{lang: 0x274, region: 0x134, script: 0x4b},
	{lang: 0x13, region: 0x106, script: 0x4},
	{lang: 0x1f3, region: 0x104, script: 0x1b},
	{lang: 0x1f3, region: 0x104, script: 0x1b},
	{lang: 0x94, region: 0x79, script: 0x4b},
	{lang: 0x7f, region: 0x5f, script: 0x4b},
	{lang: 0x96, region: 0x1e, script: 0x4b},
	{lang: 0x94, region: 0x98, script: 0x4b},
	{lang: 0x94, region: 0x79, script: 0x4b},
}

type mutualIntelligibility struct {
	want   uint16
	have   uint16
	conf   uint8
	oneway bool
}

type scriptIntelligibility struct {
	lang uint16
	want uint8
	have uint8
	conf uint8
}

// matchLang holds pairs of langIDs of base languages that are typically
// mutually intelligible. Each pair is associated with a confidence and
// whether the intelligibility goes one or both ways.
// Size: 708 bytes, 118 elements
var matchLang = [118]mutualIntelligibility{
	{want: 0x225, have: 0x50, conf: 0x2, oneway: false},
	{want: 0x210, have: 0xe2, conf: 0x2, oneway: false},
	{want: 0x225, have: 0xe2, conf: 0x2, oneway: false},
	{want: 0x210, have: 0x225, conf: 0x2, oneway: false},
	{want: 0x1ad, have: 0x1af, conf: 0x2, oneway: false},
	{want: 0xe2, have: 0x50, conf: 0x2, oneway: false},
	{want: 0x210, have: 0x50, conf: 0x2, oneway: false},
	{want: 0x22b, have: 0x1, conf: 0x2, oneway: false},
	{want: 0xc8, have: 0x7f, conf: 0x2, oneway: true},
	{want: 0x145, have: 0x7f, conf: 0x2, oneway: true},
	{want: 0x1ad, have: 0x19d, conf: 0x2, oneway: false},
	{want: 0x18a, have: 0xeb, conf: 0x2, oneway: false},
	{want: 0x7b, have: 0x19d, conf: 0x2, oneway: false},
	{want: 0x7b, have: 0x1af, conf: 0x2, oneway: false},
	{want: 0x6a, have: 0x13, conf: 0x0, oneway: true},
	{want: 0x6b, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x73, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x7a, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x8e, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x95, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x98, have: 0xa1, conf: 0x0, oneway: true},
	{want: 0x9a, have: 0x96, conf: 0x0, oneway: true},
	{want: 0xa5, have: 0x7b, conf: 0x0, oneway: true},
	{want: 0xb0, have: 0x1ab, conf: 0x0, oneway: true},
	{want: 0xb1, have: 0x94, conf: 0x0, oneway: true},
	{want: 0xb2, have: 0x94, conf: 0x0, oneway: true},
	{want: 0xb8, have: 0x94, conf: 0x0, oneway: true},
	{want: 0xbe, have: 0x96, conf: 0x0, oneway: true},
	{want: 0xc0, have: 0x96, conf: 0x0, oneway: true},
	{want: 0xc9, have: 0xd6, conf: 0x0, oneway: true},
	{want: 0xd1, have: 0x94, conf: 0x0, oneway: true},
	{want: 0xd3, have: 0x94, conf: 0x0, oneway: true},
	{want: 0xe5, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0xe7, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0xe9, have: 0x94, conf: 0x0, oneway: true},
	{want: 0xed, have: 0x94, conf: 0x0, oneway: true},
	{want: 0xf5, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x101, have: 0xeb, conf: 0x0, oneway: true},
	{want: 0x103, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x113, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x120, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x124, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x126, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x12e, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x136, have: 0x257, conf: 0x0, oneway: true},
	{want: 0x13e, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x13f, have: 0xf6, conf: 0x0, oneway: true},
	{want: 0x14b, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x155, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x156, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x158, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x15d, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x173, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x174, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x17a, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x17d, have: 0x35, conf: 0x0, oneway: true},
	{want: 0x17e, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x17f, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x186, have: 0xd6, conf: 0x0, oneway: true},
	{want: 0x18a, have: 0xeb, conf: 0x0, oneway: true},
	{want: 0x18b, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x194, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1a2, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1ad, have: 0x19d, conf: 0x0, oneway: true},
	{want: 0x1b6, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1ba, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1bc, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1bd, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x1bf, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1c0, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1c3, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1ca, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1da, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1dd, have: 0x96, conf: 0x0, oneway: true},
	{want: 0x1e8, have: 0x7f, conf: 0x0, oneway: true},
	{want: 0x1ed, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x1f6, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x1f9, have: 0xd6, conf: 0x0, oneway: true},
	{want: 0x206, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x213, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x220, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x222, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x224, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x22c, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x22e, have: 0xeb, conf: 0x0, oneway: true},
	{want: 0x232, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x23a, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x241, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x245, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x24a, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x24d, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x35fc, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x254, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x255, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x25f, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x263, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x26b, have: 0x2a6, conf: 0x0, oneway: true},
	{want: 0x273, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x274, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x288, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x28d, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x29d, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x29e, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x2a8, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x2, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x5, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x9, have: 0x1ab, conf: 0x0, oneway: true},
	{want: 0xb, have: 0x94, conf: 0x0, oneway: true},
	{want: 0xf, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x20, have: 0x96, conf: 0x0, oneway: true},
	{want: 0x21, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x2d, have: 0x1f3, conf: 0x0, oneway: true},
	{want: 0x2e, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x38, have: 0xd6, conf: 0x0, oneway: true},
	{want: 0x47, have: 0x94, conf: 0x0, oneway: true},
	{want: 0x4c, have: 0xa7, conf: 0x0, oneway: true},
	{want: 0x61, have: 0xa2, conf: 0x0, oneway: true},
	{want: 0x67, have: 0x94, conf: 0x0, oneway: true},
}

// matchScript holds pairs of scriptIDs where readers of one script
// can typically also read the other. Each is associated with a confidence.
// Size: 24 bytes, 4 elements
var matchScript = [4]scriptIntelligibility{
	{lang: 0x225, want: 0x4b, have: 0x1b, conf: 0x2},
	{lang: 0x225, want: 0x1b, have: 0x4b, conf: 0x2},
	{lang: 0x0, want: 0x30, have: 0x31, conf: 0x1},
	{lang: 0x0, want: 0x31, have: 0x30, conf: 0x1},
}

// Size: 128 bytes, 32 elements
var regionContainment = [32]uint32{
	4294967295, 1954, 12356, 8, 1077674000, 32, 64, 128, 256, 512, 1024, 536885324,
	4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 1048576, 2097152, 29474816, 8388608,
	16777216, 2650931200, 67108864, 134217728, 268435456, 536879176, 1073741824, 2147483648,
}

// regionInclusion maps region identifiers to sets of regions in regionInclusionBits,
// where each set holds all groupings that are directly connected in a region
// containment graph.
// Size: 355 bytes, 355 elements
var regionInclusion = [355]uint8{
	0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
	11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
	23, 24, 25, 26, 27, 28, 29, 32, 33, 34, 35, 36,
	37, 37, 34, 35, 37, 38, 33, 39, 40, 41, 42, 37,
	43, 35, 34, 37, 36, 41, 44, 45, 35, 46, 44, 37,
	47, 48, 39, 37, 39, 37, 36, 48, 33, 49, 50, 51,
	47, 33, 38, 38, 38, 52, 44, 40, 39, 38, 53, 39,
	33, 51, 34, 32, 37, 44, 37, 33, 54, 45, 52, 41,
	33, 46, 55, 37, 37, 32, 56, 56, 39, 55, 56, 56,
	46, 57, 46, 31, 55, 58, 39, 59, 43, 32, 41, 52,
	38, 55, 37, 35, 39, 43, 44, 34, 47, 44, 44, 37,
	38, 57, 33, 51, 59, 44, 39, 53, 33, 51, 57, 37,
	45, 32, 56, 48, 55, 35, 43, 36, 33, 35, 36, 43,
	57, 43, 37, 35, 53, 32, 46, 60, 48, 59, 46, 37,
	53, 53, 35, 37, 60, 48, 35, 37, 52, 36, 44, 49,
	55, 41, 55, 56, 56, 52, 50, 34, 37, 46, 59, 32,
	34, 44, 48, 53, 53, 59, 37, 44, 37, 57, 46, 36,
	46, 51, 48, 46, 49, 58, 44, 42, 44, 32, 51, 41,
	43, 36, 32, 59, 35, 40, 42, 35, 51, 32, 39, 40,
	58, 48, 36, 45, 47, 40, 37, 35, 57, 32, 59, 39,
	32, 35, 32, 32, 30, 32, 32, 32, 32, 32, 61, 32,
	32, 32, 32, 32, 46, 32, 45, 34, 50, 46, 35, 58,
	46, 56, 55, 48, 44, 57, 43, 45, 44, 34, 44, 46,
	39, 56, 38, 50, 51, 37, 35, 49, 33, 37, 38, 33,
	44, 48, 60, 40, 48, 60, 56, 40, 48, 35, 37, 40,
	53, 46, 50, 46, 32, 33, 47, 39, 60, 34, 37, 32,
	39, 37, 37, 48, 58, 40, 32, 40, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 34, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 35, 35,
	46, 34, 49, 46, 38, 46, 32,
}

// regionInclusionBits is an array of bit vectors where every vector represents
// a set of region groupings.  These sets are used to compute the distance
// between two regions for the purpose of language matching.
// Size: 300 bytes, 75 elements
var regionInclusionBits = [75]uint32{
	37750803, 1955, 14404, 536872968, 1077674001, 34, 536873028, 130, 258, 514, 1026, 536885325,
	6148, 536881156, 4210688, 4227072, 4259840, 33685504, 262160, 524304, 1048592, 2097168, 29474817, 12582912,
	20971520, 2650931201, 100663296, 167772160, 301989888, 536881224, 1073741840, 2181038080, 1, 1073741824, 131072, 16777216,
	32768, 8192, 512, 8, 2097152, 2415919104, 262144, 134217728, 32, 2214592512, 128, 4096,
	65536, 1024, 67108864, 64, 268435456, 16384, 2164260864, 2281701376, 256, 2147614720, 524288, 1048576,
	8388608, 33554432, 4294967295, 37752755, 1115424787, 574634079, 63031315, 2655127571, 2449473536, 2248146944, 2202009600, 2315255808,
	2181169152, 2680406017, 2680408083,
}

// regionInclusionNext marks, for each entry in regionInclusionBits, the set of
// all groups that are reachable from the groups set in the respective entry.
// Size: 75 bytes, 75 elements
var regionInclusionNext = [75]uint8{
	62, 63, 11, 11, 64, 1, 11, 1, 1, 1, 1, 65,
	11, 11, 22, 22, 22, 25, 4, 4, 4, 4, 66, 22,
	22, 67, 25, 25, 25, 11, 4, 25, 0, 30, 17, 24,
	15, 13, 9, 3, 21, 68, 18, 27, 5, 69, 7, 12,
	16, 10, 26, 6, 28, 14, 70, 71, 8, 72, 19, 20,
	23, 25, 62, 62, 62, 62, 62, 62, 25, 25, 73, 25,
	25, 74, 62,
}

type parentRel struct {
	lang       uint16
	script     uint8
	maxScript  uint8
	toRegion   uint16
	fromRegion []uint16
}

// Size: 382 bytes, 5 elements
var parents = [5]parentRel{
	{lang: 0x94, script: 0x0, maxScript: 0x4b, toRegion: 0x1, fromRegion: []uint16{0x24, 0x25, 0x33, 0x3c, 0x41, 0x45, 0x47, 0x49, 0x4f, 0x51, 0x5b, 0x63, 0x6c, 0x71, 0x73, 0x79, 0x7a, 0x7e, 0x81, 0x8a, 0x9e, 0xa2, 0xa5, 0xa7, 0xab, 0xaf, 0xb2, 0xb3, 0xbd, 0xc8, 0xca, 0xcc, 0xce, 0xd0, 0xd3, 0xd4, 0xdb, 0xdd, 0xe4, 0xe5, 0xe9, 0xee, 0x105, 0x107, 0x108, 0x109, 0x110, 0x115, 0x119, 0x11b, 0x11d, 0x123, 0x127, 0x12a, 0x12b, 0x12d, 0x12f, 0x136, 0x13c, 0x13f, 0x15e, 0x15f, 0x161}},
	{lang: 0x94, script: 0x0, maxScript: 0x4b, toRegion: 0x79, fromRegion: []uint16{0x1a, 0x2e, 0x35, 0x60, 0x72, 0x7d, 0x7f, 0x8b, 0x94, 0x96, 0x97, 0x98, 0x9d, 0xc4, 0xc9, 0xde, 0xe6, 0x10b, 0x10c, 0x139}},
	{lang: 0x96, script: 0x0, maxScript: 0x4b, toRegion: 0x1e, fromRegion: []uint16{0x2b, 0x3e, 0x50, 0x53, 0x55, 0x58, 0x64, 0x68, 0x87, 0x8d, 0xcd, 0xd6, 0xe0, 0xe2, 0xea, 0xef, 0x118, 0x132, 0x133, 0x138}},
	{lang: 0x1db, script: 0x0, maxScript: 0x4b, toRegion: 0xec, fromRegion: []uint16{0x29, 0x59, 0x89, 0xc4, 0xcf, 0x116, 0x124}},
	{lang: 0x2a6, script: 0x31, maxScript: 0x31, toRegion: 0x8b, fromRegion: []uint16{0xc4}},
}

// Size: 20.4K (20840 bytes); Check: EDA1C496
