![](Docs/ogre-logo-wetfloor.gif)

## Summary
**OGRE** (Object-Oriented Graphics Rendering Engine) is a
scene-oriented, flexible 3D engine written in C++ designed to make it
easier and more intuitive for developers to produce games and demos
utilising 3D hardware. The class library abstracts all the details of
using the underlying system libraries like Direct3D and OpenGL and
provides an interface based on world objects and other intuitive
classes.

The current CI status on *github* is Ubuntu/ OSX/ Android/ iOS [![Build Status](https://travis-ci.org/OGRECave/ogre.svg?branch=master)](https://travis-ci.org/OGRECave/ogre) MSVC [![Build status](https://ci.appveyor.com/api/projects/status/kcki7y0n1ahrggdw/branch/master?svg=true)](https://ci.appveyor.com/project/paroj/ogre-bsrh7/branch/master)


## Index Of Contents
* [What's New?](Docs/1.10-Notes.md)  
A summary of the new and altered features in this release.
* [Features](http://www.ogre3d.org/about/features)  
A summary of OGRE's main features.
* [Building the core OGRE libraries](BuildingOgre.md)  
If you're using the full source release, this will help you build it. If you're using a precompiled SDK then most of the work has already been done for you, and you should use the sample projects to see how to compile your own code against OGRE.
* [The OGRE Manual](https://ogrecave.github.io/ogre/api/1.10/manual.html)  
A high-level guide to the major parts of the engine and script reference.
* [API Reference](https://ogrecave.github.io/ogre/api/1.10/)  
The full OGRE API documentation, as generated from the (heavily!) commented source.
* [The OGRE Tutorials](https://ogrecave.github.io/ogre/api/1.10/tutorials.html)  
A gold mine of tutorials, tips and code snippets which will help you get up to speed with the engine.

## Contributing
We welcome all contributions to OGRE, be that new
plugins, bugfixes, extensions, tutorials, documentation, example
applications, artwork or pretty much anything else! If you would like
to contribute to the development of OGRE, please create a pull request on [bitbucket](https://bitbucket.org/sinbad/ogre/pull-requests/) or [github](https://github.com/OGRECave/ogre/pulls).

## Getting Support
Please use our [community support forums](http://www.ogre3d.org/forums) if you need help or
think you may have found a bug.

## Licensing
Please see the [full license documentation](Docs/License.md) for details.
