/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "bench_options.h"

BenchOptions::BenchOptions (bool init /* = true */) :
    mOptions (BenchOptions::OptionNum),
    mNotify (BenchOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
BenchOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // initiate_key
    mOptions[BenchOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>F12");
    mOptions[BenchOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[BenchOptions::InitiateKey].value ().action ());

    // fps_limiter_mode
    mOptions[BenchOptions::FpsLimiterMode].setName ("fps_limiter_mode", CompOption::TypeInt);
    mOptions[BenchOptions::FpsLimiterMode].rest ().set (0, 2);
    mOptions[BenchOptions::FpsLimiterMode].value().set((int) 0);

    // output_screen
    mOptions[BenchOptions::OutputScreen].setName ("output_screen", CompOption::TypeBool);
    mOptions[BenchOptions::OutputScreen].value().set(true);

    // position_x
    mOptions[BenchOptions::PositionX].setName ("position_x", CompOption::TypeInt);
    mOptions[BenchOptions::PositionX].rest ().set (0, 4096);
    mOptions[BenchOptions::PositionX].value().set((int) 100);

    // position_y
    mOptions[BenchOptions::PositionY].setName ("position_y", CompOption::TypeInt);
    mOptions[BenchOptions::PositionY].rest ().set (0, 4096);
    mOptions[BenchOptions::PositionY].value().set((int) 50);

    // output_console
    mOptions[BenchOptions::OutputConsole].setName ("output_console", CompOption::TypeBool);
    mOptions[BenchOptions::OutputConsole].value().set(false);

    // console_update_time
    mOptions[BenchOptions::ConsoleUpdateTime].setName ("console_update_time", CompOption::TypeInt);
    mOptions[BenchOptions::ConsoleUpdateTime].rest ().set (1, 60);
    mOptions[BenchOptions::ConsoleUpdateTime].value().set((int) 5);

}

BenchOptions::~BenchOptions ()
{
}


CompOption::Vector &
BenchOptions::getOptions ()
{
    return mOptions;
}

bool
BenchOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case BenchOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[BenchOptions::InitiateKey].empty ())
                    mNotify[BenchOptions::InitiateKey] (o, BenchOptions::InitiateKey);
                return true;
            }
            break;
        case BenchOptions::FpsLimiterMode:
            if (o->set (value))
            {
                if (!mNotify[BenchOptions::FpsLimiterMode].empty ())
                    mNotify[BenchOptions::FpsLimiterMode] (o, BenchOptions::FpsLimiterMode);
                return true;
            }
            break;
        case BenchOptions::OutputScreen:
            if (o->set (value))
            {
                if (!mNotify[BenchOptions::OutputScreen].empty ())
                    mNotify[BenchOptions::OutputScreen] (o, BenchOptions::OutputScreen);
                return true;
            }
            break;
        case BenchOptions::PositionX:
            if (o->set (value))
            {
                if (!mNotify[BenchOptions::PositionX].empty ())
                    mNotify[BenchOptions::PositionX] (o, BenchOptions::PositionX);
                return true;
            }
            break;
        case BenchOptions::PositionY:
            if (o->set (value))
            {
                if (!mNotify[BenchOptions::PositionY].empty ())
                    mNotify[BenchOptions::PositionY] (o, BenchOptions::PositionY);
                return true;
            }
            break;
        case BenchOptions::OutputConsole:
            if (o->set (value))
            {
                if (!mNotify[BenchOptions::OutputConsole].empty ())
                    mNotify[BenchOptions::OutputConsole] (o, BenchOptions::OutputConsole);
                return true;
            }
            break;
        case BenchOptions::ConsoleUpdateTime:
            if (o->set (value))
            {
                if (!mNotify[BenchOptions::ConsoleUpdateTime].empty ())
                    mNotify[BenchOptions::ConsoleUpdateTime] (o, BenchOptions::ConsoleUpdateTime);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

