/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "colorfilter_options.h"

ColorfilterOptions::ColorfilterOptions (bool init /* = true */) :
    mOptions (ColorfilterOptions::OptionNum),
    mNotify (ColorfilterOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ColorfilterOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    CompOption::Value::Vector list;
    CompOption::Value value;

    // toggle_window_key
    mOptions[ColorfilterOptions::ToggleWindowKey].setName ("toggle_window_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>f");
    mOptions[ColorfilterOptions::ToggleWindowKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ColorfilterOptions::ToggleWindowKey].value ().action ());

    // toggle_screen_key
    mOptions[ColorfilterOptions::ToggleScreenKey].setName ("toggle_screen_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>d");
    mOptions[ColorfilterOptions::ToggleScreenKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ColorfilterOptions::ToggleScreenKey].value ().action ());

    // switch_filter_key
    mOptions[ColorfilterOptions::SwitchFilterKey].setName ("switch_filter_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Super>s");
    mOptions[ColorfilterOptions::SwitchFilterKey].value().set (action);
    if (screen) screen->addAction (&mOptions[ColorfilterOptions::SwitchFilterKey].value ().action ());

    // filters
    mOptions[ColorfilterOptions::Filters].setName ("filters", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("negative"));
    list.push_back (value);
    value.set(CompString ("negative-lightness"));
    list.push_back (value);
    value.set(CompString ("negative-green"));
    list.push_back (value);
    value.set(CompString ("blueish-filter"));
    list.push_back (value);
    value.set(CompString ("sepia"));
    list.push_back (value);
    value.set(CompString ("grayscale"));
    list.push_back (value);
    value.set(CompString ("deuteranopia"));
    list.push_back (value);
    value.set(CompString ("protanopia"));
    list.push_back (value);
    mOptions[ColorfilterOptions::Filters].value().set (CompOption::TypeString, list);

    // filter_decorations
    mOptions[ColorfilterOptions::FilterDecorations].setName ("filter_decorations", CompOption::TypeBool);
    mOptions[ColorfilterOptions::FilterDecorations].value().set(false);

    // filter_match
    mOptions[ColorfilterOptions::FilterMatch].setName ("filter_match", CompOption::TypeMatch);
    mOptions[ColorfilterOptions::FilterMatch].value().set(CompMatch ("any"));
    mOptions[ColorfilterOptions::FilterMatch].value().match ().update ();

    // exclude_match
    mOptions[ColorfilterOptions::ExcludeMatch].setName ("exclude_match", CompOption::TypeMatch);
    mOptions[ColorfilterOptions::ExcludeMatch].value().set(CompMatch ("type=Desktop"));
    mOptions[ColorfilterOptions::ExcludeMatch].value().match ().update ();

}

ColorfilterOptions::~ColorfilterOptions ()
{
}


CompOption::Vector &
ColorfilterOptions::getOptions ()
{
    return mOptions;
}

bool
ColorfilterOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ColorfilterOptions::ToggleWindowKey:
            if (o->set (value))
            {
                if (!mNotify[ColorfilterOptions::ToggleWindowKey].empty ())
                    mNotify[ColorfilterOptions::ToggleWindowKey] (o, ColorfilterOptions::ToggleWindowKey);
                return true;
            }
            break;
        case ColorfilterOptions::ToggleScreenKey:
            if (o->set (value))
            {
                if (!mNotify[ColorfilterOptions::ToggleScreenKey].empty ())
                    mNotify[ColorfilterOptions::ToggleScreenKey] (o, ColorfilterOptions::ToggleScreenKey);
                return true;
            }
            break;
        case ColorfilterOptions::SwitchFilterKey:
            if (o->set (value))
            {
                if (!mNotify[ColorfilterOptions::SwitchFilterKey].empty ())
                    mNotify[ColorfilterOptions::SwitchFilterKey] (o, ColorfilterOptions::SwitchFilterKey);
                return true;
            }
            break;
        case ColorfilterOptions::Filters:
            if (o->set (value))
            {
                if (!mNotify[ColorfilterOptions::Filters].empty ())
                    mNotify[ColorfilterOptions::Filters] (o, ColorfilterOptions::Filters);
                return true;
            }
            break;
        case ColorfilterOptions::FilterDecorations:
            if (o->set (value))
            {
                if (!mNotify[ColorfilterOptions::FilterDecorations].empty ())
                    mNotify[ColorfilterOptions::FilterDecorations] (o, ColorfilterOptions::FilterDecorations);
                return true;
            }
            break;
        case ColorfilterOptions::FilterMatch:
            if (o->set (value))
            {
                if (!mNotify[ColorfilterOptions::FilterMatch].empty ())
                    mNotify[ColorfilterOptions::FilterMatch] (o, ColorfilterOptions::FilterMatch);
                return true;
            }
            break;
        case ColorfilterOptions::ExcludeMatch:
            if (o->set (value))
            {
                if (!mNotify[ColorfilterOptions::ExcludeMatch].empty ())
                    mNotify[ColorfilterOptions::ExcludeMatch] (o, ColorfilterOptions::ExcludeMatch);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

