/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "freewins_options.h"

FreewinsOptions::FreewinsOptions (bool init /* = true */) :
    mOptions (FreewinsOptions::OptionNum),
    mNotify (FreewinsOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
FreewinsOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];
    CompOption::Value::Vector list;
    CompOption::Value value;

    // rotate
    mOptions[FreewinsOptions::Rotate].setName ("rotate", CompOption::TypeAction);
    state = CompAction::StateAutoGrab;
    mOptions[FreewinsOptions::Rotate].value().set(CompAction ());
    mOptions[FreewinsOptions::Rotate].value().action ().setState (state);

    // increment_rotate
    mOptions[FreewinsOptions::IncrementRotate].setName ("increment_rotate", CompOption::TypeAction);
    state = CompAction::StateAutoGrab;
    mOptions[FreewinsOptions::IncrementRotate].value().set(CompAction ());
    mOptions[FreewinsOptions::IncrementRotate].value().action ().setState (state);

    // scale
    mOptions[FreewinsOptions::Scale].setName ("scale", CompOption::TypeAction);
    state = CompAction::StateAutoGrab;
    mOptions[FreewinsOptions::Scale].value().set(CompAction ());
    mOptions[FreewinsOptions::Scale].value().action ().setState (state);

    // initiate_rotation_button
    mOptions[FreewinsOptions::InitiateRotationButton].setName ("initiate_rotation_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Control><Shift>Button1");
    mOptions[FreewinsOptions::InitiateRotationButton].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::InitiateRotationButton].value ().action ());

    // initiate_scale_button
    mOptions[FreewinsOptions::InitiateScaleButton].setName ("initiate_scale_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Control><Shift>Button3");
    mOptions[FreewinsOptions::InitiateScaleButton].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::InitiateScaleButton].value ().action ());

    // reset_button
    mOptions[FreewinsOptions::ResetButton].setName ("reset_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Control><Shift>Button2");
    mOptions[FreewinsOptions::ResetButton].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::ResetButton].value ().action ());

    // reset_key
    mOptions[FreewinsOptions::ResetKey].setName ("reset_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>r");
    mOptions[FreewinsOptions::ResetKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::ResetKey].value ().action ());

    // toggle_axis_key
    mOptions[FreewinsOptions::ToggleAxisKey].setName ("toggle_axis_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>h");
    mOptions[FreewinsOptions::ToggleAxisKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::ToggleAxisKey].value ().action ());

    // snap_mods
    mOptions[FreewinsOptions::SnapMods].setName ("snap_mods", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[FreewinsOptions::SnapMods].set (value);
    mOptions[FreewinsOptions::SnapMods].rest ().set (0, 3);

    // invert_mods
    mOptions[FreewinsOptions::InvertMods].setName ("invert_mods", CompOption::TypeList);
    value.set (CompOption::TypeInt, CompOption::Value::Vector (0));
    mOptions[FreewinsOptions::InvertMods].set (value);
    mOptions[FreewinsOptions::InvertMods].rest ().set (0, 3);

    // scale_up_button
    mOptions[FreewinsOptions::ScaleUpButton].setName ("scale_up_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Control><Shift>Button4");
    mOptions[FreewinsOptions::ScaleUpButton].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::ScaleUpButton].value ().action ());

    // scale_down_button
    mOptions[FreewinsOptions::ScaleDownButton].setName ("scale_down_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Control><Shift>Button5");
    mOptions[FreewinsOptions::ScaleDownButton].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::ScaleDownButton].value ().action ());

    // scale_up_key
    mOptions[FreewinsOptions::ScaleUpKey].setName ("scale_up_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>Page_Up");
    mOptions[FreewinsOptions::ScaleUpKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::ScaleUpKey].value ().action ());

    // scale_down_key
    mOptions[FreewinsOptions::ScaleDownKey].setName ("scale_down_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>Page_Down");
    mOptions[FreewinsOptions::ScaleDownKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::ScaleDownKey].value ().action ());

    // rotate_up_key
    mOptions[FreewinsOptions::RotateUpKey].setName ("rotate_up_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>w");
    mOptions[FreewinsOptions::RotateUpKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::RotateUpKey].value ().action ());

    // rotate_down_key
    mOptions[FreewinsOptions::RotateDownKey].setName ("rotate_down_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>s");
    mOptions[FreewinsOptions::RotateDownKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::RotateDownKey].value ().action ());

    // rotate_left_key
    mOptions[FreewinsOptions::RotateLeftKey].setName ("rotate_left_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>d");
    mOptions[FreewinsOptions::RotateLeftKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::RotateLeftKey].value ().action ());

    // rotate_right_key
    mOptions[FreewinsOptions::RotateRightKey].setName ("rotate_right_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>a");
    mOptions[FreewinsOptions::RotateRightKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::RotateRightKey].value ().action ());

    // rotate_c_key
    mOptions[FreewinsOptions::RotateCKey].setName ("rotate_c_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>e");
    mOptions[FreewinsOptions::RotateCKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::RotateCKey].value ().action ());

    // rotate_cc_key
    mOptions[FreewinsOptions::RotateCcKey].setName ("rotate_cc_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Shift>q");
    mOptions[FreewinsOptions::RotateCcKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FreewinsOptions::RotateCcKey].value ().action ());

    // snap
    mOptions[FreewinsOptions::Snap].setName ("snap", CompOption::TypeBool);
    mOptions[FreewinsOptions::Snap].value().set(false);

    // snap_threshold
    mOptions[FreewinsOptions::SnapThreshold].setName ("snap_threshold", CompOption::TypeInt);
    mOptions[FreewinsOptions::SnapThreshold].rest ().set (1, 100);

    // mouse_sensitivity
    mOptions[FreewinsOptions::MouseSensitivity].setName ("mouse_sensitivity", CompOption::TypeFloat);
    mOptions[FreewinsOptions::MouseSensitivity].rest ().set (0.1, 10.0, 0.1f);
    mOptions[FreewinsOptions::MouseSensitivity].value().set((float) 1.0);

    // scale_mode
    mOptions[FreewinsOptions::ScaleMode].setName ("scale_mode", CompOption::TypeInt);
    mOptions[FreewinsOptions::ScaleMode].rest ().set (0, 0);
    mOptions[FreewinsOptions::ScaleMode].value().set((int) 0);

    // allow_negative
    mOptions[FreewinsOptions::AllowNegative].setName ("allow_negative", CompOption::TypeBool);
    mOptions[FreewinsOptions::AllowNegative].value().set(true);

    // scale_uniform
    mOptions[FreewinsOptions::ScaleUniform].setName ("scale_uniform", CompOption::TypeBool);
    mOptions[FreewinsOptions::ScaleUniform].value().set(true);

    // min_scale
    mOptions[FreewinsOptions::MinScale].setName ("min_scale", CompOption::TypeFloat);
    mOptions[FreewinsOptions::MinScale].rest ().set (0.01, 1.0, 0.1f);
    mOptions[FreewinsOptions::MinScale].value().set((float) 0.1);

    // z_axis_rotation
    mOptions[FreewinsOptions::ZAxisRotation].setName ("z_axis_rotation", CompOption::TypeInt);
    mOptions[FreewinsOptions::ZAxisRotation].rest ().set (0, 3);
    mOptions[FreewinsOptions::ZAxisRotation].value().set((int) 2);

    // rotation_axis
    mOptions[FreewinsOptions::RotationAxis].setName ("rotation_axis", CompOption::TypeInt);
    mOptions[FreewinsOptions::RotationAxis].rest ().set (0, 2);
    mOptions[FreewinsOptions::RotationAxis].value().set((int) 0);

    // TD_percent
    mOptions[FreewinsOptions::TdPercent].setName ("TD_percent", CompOption::TypeFloat);
    mOptions[FreewinsOptions::TdPercent].rest ().set (10.0, 90.0, 0.1f);
    mOptions[FreewinsOptions::TdPercent].value().set((float) 35.0);

    // auto_zoom
    mOptions[FreewinsOptions::AutoZoom].setName ("auto_zoom", CompOption::TypeBool);
    mOptions[FreewinsOptions::AutoZoom].value().set(false);

    // disable_on_transformed_screen
    mOptions[FreewinsOptions::DisableOnTransformedScreen].setName ("disable_on_transformed_screen", CompOption::TypeBool);
    mOptions[FreewinsOptions::DisableOnTransformedScreen].value().set(false);

    // speed
    mOptions[FreewinsOptions::Speed].setName ("speed", CompOption::TypeFloat);
    mOptions[FreewinsOptions::Speed].rest ().set (0.1, 15.0, 0.1f);
    mOptions[FreewinsOptions::Speed].value().set((float) 5.0);

    // rotate_increment_amount
    mOptions[FreewinsOptions::RotateIncrementAmount].setName ("rotate_increment_amount", CompOption::TypeFloat);
    mOptions[FreewinsOptions::RotateIncrementAmount].rest ().set (1.0, 100.0, 0.1f);
    mOptions[FreewinsOptions::RotateIncrementAmount].value().set((float) 10.0);

    // scale_increment_amount
    mOptions[FreewinsOptions::ScaleIncrementAmount].setName ("scale_increment_amount", CompOption::TypeFloat);
    mOptions[FreewinsOptions::ScaleIncrementAmount].rest ().set (0.01, 0.5, 0.1f);
    mOptions[FreewinsOptions::ScaleIncrementAmount].value().set((float) 0.3);

    // shape_window_types
    mOptions[FreewinsOptions::ShapeWindowTypes].setName ("shape_window_types", CompOption::TypeMatch);
    mOptions[FreewinsOptions::ShapeWindowTypes].value().set(CompMatch ("(Toolbar | Utility | Dialog | ModalDialog | Normal)"));
    mOptions[FreewinsOptions::ShapeWindowTypes].value().match ().update ();

    // do_shape_input
    mOptions[FreewinsOptions::DoShapeInput].setName ("do_shape_input", CompOption::TypeBool);
    mOptions[FreewinsOptions::DoShapeInput].value().set(true);

    // immediate_moves
    mOptions[FreewinsOptions::ImmediateMoves].setName ("immediate_moves", CompOption::TypeBool);
    mOptions[FreewinsOptions::ImmediateMoves].value().set(true);

    // circle_color
    mOptions[FreewinsOptions::CircleColor].setName ("circle_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x5400));
    color[1] = MAX (0, MIN (0xffff, 0xBE00));
    color[2] = MAX (0, MIN (0xffff, 0xFB00));
    color[3] = MAX (0, MIN (0xffff, 0x8000));
    mOptions[FreewinsOptions::CircleColor].value().set(color);

    // line_color
    mOptions[FreewinsOptions::LineColor].setName ("line_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x1800));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0xFF00));
    color[3] = MAX (0, MIN (0xffff, 0xFFFF));
    mOptions[FreewinsOptions::LineColor].value().set(color);

    // cross_line_color
    mOptions[FreewinsOptions::CrossLineColor].setName ("cross_line_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x1800));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0xFF00));
    color[3] = MAX (0, MIN (0xffff, 0xFFFF));
    mOptions[FreewinsOptions::CrossLineColor].value().set(color);

    // show_circle
    mOptions[FreewinsOptions::ShowCircle].setName ("show_circle", CompOption::TypeBool);
    mOptions[FreewinsOptions::ShowCircle].value().set(true);

    // show_gizmo
    mOptions[FreewinsOptions::ShowGizmo].setName ("show_gizmo", CompOption::TypeBool);
    mOptions[FreewinsOptions::ShowGizmo].value().set(true);

    // show_cross
    mOptions[FreewinsOptions::ShowCross].setName ("show_cross", CompOption::TypeBool);
    mOptions[FreewinsOptions::ShowCross].value().set(true);

    // show_region
    mOptions[FreewinsOptions::ShowRegion].setName ("show_region", CompOption::TypeBool);
    mOptions[FreewinsOptions::ShowRegion].value().set(true);

    mSnapModsMask = 0;
    foreach (CompOption::Value &val, mOptions[FreewinsOptions::SnapMods].value ().list ())
        mSnapModsMask |= (1 << val.i ());

    mInvertModsMask = 0;
    foreach (CompOption::Value &val, mOptions[FreewinsOptions::InvertMods].value ().list ())
        mInvertModsMask |= (1 << val.i ());

}

FreewinsOptions::~FreewinsOptions ()
{
}


CompOption::Vector &
FreewinsOptions::getOptions ()
{
    return mOptions;
}

bool
FreewinsOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case FreewinsOptions::Rotate:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::Rotate].empty ())
                    mNotify[FreewinsOptions::Rotate] (o, FreewinsOptions::Rotate);
                return true;
            }
            break;
        case FreewinsOptions::IncrementRotate:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::IncrementRotate].empty ())
                    mNotify[FreewinsOptions::IncrementRotate] (o, FreewinsOptions::IncrementRotate);
                return true;
            }
            break;
        case FreewinsOptions::Scale:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::Scale].empty ())
                    mNotify[FreewinsOptions::Scale] (o, FreewinsOptions::Scale);
                return true;
            }
            break;
        case FreewinsOptions::InitiateRotationButton:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::InitiateRotationButton].empty ())
                    mNotify[FreewinsOptions::InitiateRotationButton] (o, FreewinsOptions::InitiateRotationButton);
                return true;
            }
            break;
        case FreewinsOptions::InitiateScaleButton:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::InitiateScaleButton].empty ())
                    mNotify[FreewinsOptions::InitiateScaleButton] (o, FreewinsOptions::InitiateScaleButton);
                return true;
            }
            break;
        case FreewinsOptions::ResetButton:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ResetButton].empty ())
                    mNotify[FreewinsOptions::ResetButton] (o, FreewinsOptions::ResetButton);
                return true;
            }
            break;
        case FreewinsOptions::ResetKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ResetKey].empty ())
                    mNotify[FreewinsOptions::ResetKey] (o, FreewinsOptions::ResetKey);
                return true;
            }
            break;
        case FreewinsOptions::ToggleAxisKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ToggleAxisKey].empty ())
                    mNotify[FreewinsOptions::ToggleAxisKey] (o, FreewinsOptions::ToggleAxisKey);
                return true;
            }
            break;
        case FreewinsOptions::SnapMods:
            if (o->set (value))
            {
                mSnapModsMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mSnapModsMask |= (1 << val.i ());
                if (!mNotify[FreewinsOptions::SnapMods].empty ())
                    mNotify[FreewinsOptions::SnapMods] (o, FreewinsOptions::SnapMods);
                return true;
            }
            break;
        case FreewinsOptions::InvertMods:
            if (o->set (value))
            {
                mInvertModsMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mInvertModsMask |= (1 << val.i ());
                if (!mNotify[FreewinsOptions::InvertMods].empty ())
                    mNotify[FreewinsOptions::InvertMods] (o, FreewinsOptions::InvertMods);
                return true;
            }
            break;
        case FreewinsOptions::ScaleUpButton:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ScaleUpButton].empty ())
                    mNotify[FreewinsOptions::ScaleUpButton] (o, FreewinsOptions::ScaleUpButton);
                return true;
            }
            break;
        case FreewinsOptions::ScaleDownButton:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ScaleDownButton].empty ())
                    mNotify[FreewinsOptions::ScaleDownButton] (o, FreewinsOptions::ScaleDownButton);
                return true;
            }
            break;
        case FreewinsOptions::ScaleUpKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ScaleUpKey].empty ())
                    mNotify[FreewinsOptions::ScaleUpKey] (o, FreewinsOptions::ScaleUpKey);
                return true;
            }
            break;
        case FreewinsOptions::ScaleDownKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ScaleDownKey].empty ())
                    mNotify[FreewinsOptions::ScaleDownKey] (o, FreewinsOptions::ScaleDownKey);
                return true;
            }
            break;
        case FreewinsOptions::RotateUpKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::RotateUpKey].empty ())
                    mNotify[FreewinsOptions::RotateUpKey] (o, FreewinsOptions::RotateUpKey);
                return true;
            }
            break;
        case FreewinsOptions::RotateDownKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::RotateDownKey].empty ())
                    mNotify[FreewinsOptions::RotateDownKey] (o, FreewinsOptions::RotateDownKey);
                return true;
            }
            break;
        case FreewinsOptions::RotateLeftKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::RotateLeftKey].empty ())
                    mNotify[FreewinsOptions::RotateLeftKey] (o, FreewinsOptions::RotateLeftKey);
                return true;
            }
            break;
        case FreewinsOptions::RotateRightKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::RotateRightKey].empty ())
                    mNotify[FreewinsOptions::RotateRightKey] (o, FreewinsOptions::RotateRightKey);
                return true;
            }
            break;
        case FreewinsOptions::RotateCKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::RotateCKey].empty ())
                    mNotify[FreewinsOptions::RotateCKey] (o, FreewinsOptions::RotateCKey);
                return true;
            }
            break;
        case FreewinsOptions::RotateCcKey:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::RotateCcKey].empty ())
                    mNotify[FreewinsOptions::RotateCcKey] (o, FreewinsOptions::RotateCcKey);
                return true;
            }
            break;
        case FreewinsOptions::Snap:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::Snap].empty ())
                    mNotify[FreewinsOptions::Snap] (o, FreewinsOptions::Snap);
                return true;
            }
            break;
        case FreewinsOptions::SnapThreshold:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::SnapThreshold].empty ())
                    mNotify[FreewinsOptions::SnapThreshold] (o, FreewinsOptions::SnapThreshold);
                return true;
            }
            break;
        case FreewinsOptions::MouseSensitivity:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::MouseSensitivity].empty ())
                    mNotify[FreewinsOptions::MouseSensitivity] (o, FreewinsOptions::MouseSensitivity);
                return true;
            }
            break;
        case FreewinsOptions::ScaleMode:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ScaleMode].empty ())
                    mNotify[FreewinsOptions::ScaleMode] (o, FreewinsOptions::ScaleMode);
                return true;
            }
            break;
        case FreewinsOptions::AllowNegative:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::AllowNegative].empty ())
                    mNotify[FreewinsOptions::AllowNegative] (o, FreewinsOptions::AllowNegative);
                return true;
            }
            break;
        case FreewinsOptions::ScaleUniform:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ScaleUniform].empty ())
                    mNotify[FreewinsOptions::ScaleUniform] (o, FreewinsOptions::ScaleUniform);
                return true;
            }
            break;
        case FreewinsOptions::MinScale:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::MinScale].empty ())
                    mNotify[FreewinsOptions::MinScale] (o, FreewinsOptions::MinScale);
                return true;
            }
            break;
        case FreewinsOptions::ZAxisRotation:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ZAxisRotation].empty ())
                    mNotify[FreewinsOptions::ZAxisRotation] (o, FreewinsOptions::ZAxisRotation);
                return true;
            }
            break;
        case FreewinsOptions::RotationAxis:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::RotationAxis].empty ())
                    mNotify[FreewinsOptions::RotationAxis] (o, FreewinsOptions::RotationAxis);
                return true;
            }
            break;
        case FreewinsOptions::TdPercent:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::TdPercent].empty ())
                    mNotify[FreewinsOptions::TdPercent] (o, FreewinsOptions::TdPercent);
                return true;
            }
            break;
        case FreewinsOptions::AutoZoom:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::AutoZoom].empty ())
                    mNotify[FreewinsOptions::AutoZoom] (o, FreewinsOptions::AutoZoom);
                return true;
            }
            break;
        case FreewinsOptions::DisableOnTransformedScreen:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::DisableOnTransformedScreen].empty ())
                    mNotify[FreewinsOptions::DisableOnTransformedScreen] (o, FreewinsOptions::DisableOnTransformedScreen);
                return true;
            }
            break;
        case FreewinsOptions::Speed:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::Speed].empty ())
                    mNotify[FreewinsOptions::Speed] (o, FreewinsOptions::Speed);
                return true;
            }
            break;
        case FreewinsOptions::RotateIncrementAmount:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::RotateIncrementAmount].empty ())
                    mNotify[FreewinsOptions::RotateIncrementAmount] (o, FreewinsOptions::RotateIncrementAmount);
                return true;
            }
            break;
        case FreewinsOptions::ScaleIncrementAmount:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ScaleIncrementAmount].empty ())
                    mNotify[FreewinsOptions::ScaleIncrementAmount] (o, FreewinsOptions::ScaleIncrementAmount);
                return true;
            }
            break;
        case FreewinsOptions::ShapeWindowTypes:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ShapeWindowTypes].empty ())
                    mNotify[FreewinsOptions::ShapeWindowTypes] (o, FreewinsOptions::ShapeWindowTypes);
                return true;
            }
            break;
        case FreewinsOptions::DoShapeInput:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::DoShapeInput].empty ())
                    mNotify[FreewinsOptions::DoShapeInput] (o, FreewinsOptions::DoShapeInput);
                return true;
            }
            break;
        case FreewinsOptions::ImmediateMoves:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ImmediateMoves].empty ())
                    mNotify[FreewinsOptions::ImmediateMoves] (o, FreewinsOptions::ImmediateMoves);
                return true;
            }
            break;
        case FreewinsOptions::CircleColor:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::CircleColor].empty ())
                    mNotify[FreewinsOptions::CircleColor] (o, FreewinsOptions::CircleColor);
                return true;
            }
            break;
        case FreewinsOptions::LineColor:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::LineColor].empty ())
                    mNotify[FreewinsOptions::LineColor] (o, FreewinsOptions::LineColor);
                return true;
            }
            break;
        case FreewinsOptions::CrossLineColor:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::CrossLineColor].empty ())
                    mNotify[FreewinsOptions::CrossLineColor] (o, FreewinsOptions::CrossLineColor);
                return true;
            }
            break;
        case FreewinsOptions::ShowCircle:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ShowCircle].empty ())
                    mNotify[FreewinsOptions::ShowCircle] (o, FreewinsOptions::ShowCircle);
                return true;
            }
            break;
        case FreewinsOptions::ShowGizmo:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ShowGizmo].empty ())
                    mNotify[FreewinsOptions::ShowGizmo] (o, FreewinsOptions::ShowGizmo);
                return true;
            }
            break;
        case FreewinsOptions::ShowCross:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ShowCross].empty ())
                    mNotify[FreewinsOptions::ShowCross] (o, FreewinsOptions::ShowCross);
                return true;
            }
            break;
        case FreewinsOptions::ShowRegion:
            if (o->set (value))
            {
                if (!mNotify[FreewinsOptions::ShowRegion].empty ())
                    mNotify[FreewinsOptions::ShowRegion] (o, FreewinsOptions::ShowRegion);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

