/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "mblur_options.h"

MblurOptions::MblurOptions (bool init /* = true */) :
    mOptions (MblurOptions::OptionNum),
    mNotify (MblurOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
MblurOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // initiate_key
    mOptions[MblurOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control>F12");
    mOptions[MblurOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[MblurOptions::InitiateKey].value ().action ());

    // mode
    mOptions[MblurOptions::Mode].setName ("mode", CompOption::TypeInt);
    mOptions[MblurOptions::Mode].rest ().set (0, 1);
    mOptions[MblurOptions::Mode].value().set((int) 0);

    // strength
    mOptions[MblurOptions::Strength].setName ("strength", CompOption::TypeFloat);
    mOptions[MblurOptions::Strength].rest ().set (0.0, 100.0, 0.01);
    mOptions[MblurOptions::Strength].value().set((float) 20.0);

    // on_transformed_screen
    mOptions[MblurOptions::OnTransformedScreen].setName ("on_transformed_screen", CompOption::TypeBool);
    mOptions[MblurOptions::OnTransformedScreen].value().set(false);

}

MblurOptions::~MblurOptions ()
{
}


CompOption::Vector &
MblurOptions::getOptions ()
{
    return mOptions;
}

bool
MblurOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case MblurOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[MblurOptions::InitiateKey].empty ())
                    mNotify[MblurOptions::InitiateKey] (o, MblurOptions::InitiateKey);
                return true;
            }
            break;
        case MblurOptions::Mode:
            if (o->set (value))
            {
                if (!mNotify[MblurOptions::Mode].empty ())
                    mNotify[MblurOptions::Mode] (o, MblurOptions::Mode);
                return true;
            }
            break;
        case MblurOptions::Strength:
            if (o->set (value))
            {
                if (!mNotify[MblurOptions::Strength].empty ())
                    mNotify[MblurOptions::Strength] (o, MblurOptions::Strength);
                return true;
            }
            break;
        case MblurOptions::OnTransformedScreen:
            if (o->set (value))
            {
                if (!mNotify[MblurOptions::OnTransformedScreen].empty ())
                    mNotify[MblurOptions::OnTransformedScreen] (o, MblurOptions::OnTransformedScreen);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

