/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "wobbly_options.h"

WobblyOptions::WobblyOptions (bool init /* = true */) :
    mOptions (WobblyOptions::OptionNum),
    mNotify (WobblyOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
WobblyOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // snap_key
    mOptions[WobblyOptions::SnapKey].setName ("snap_key", CompOption::TypeKey);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Shift>");
    mOptions[WobblyOptions::SnapKey].value().set (action);

    // snap_inverted
    mOptions[WobblyOptions::SnapInverted].setName ("snap_inverted", CompOption::TypeBool);
    mOptions[WobblyOptions::SnapInverted].value().set(false);

    // shiver
    mOptions[WobblyOptions::Shiver].setName ("shiver", CompOption::TypeBell);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitBell);
    mOptions[WobblyOptions::Shiver].value().set (action);
    if (screen) screen->addAction (&mOptions[WobblyOptions::Shiver].value ().action ());

    // friction
    mOptions[WobblyOptions::Friction].setName ("friction", CompOption::TypeFloat);
    mOptions[WobblyOptions::Friction].rest ().set (0.1, 10, 0.1);
    mOptions[WobblyOptions::Friction].value().set((float) 3);

    // spring_k
    mOptions[WobblyOptions::SpringK].setName ("spring_k", CompOption::TypeFloat);
    mOptions[WobblyOptions::SpringK].rest ().set (0.1, 10, 0.1);
    mOptions[WobblyOptions::SpringK].value().set((float) 8);

    // grid_resolution
    mOptions[WobblyOptions::GridResolution].setName ("grid_resolution", CompOption::TypeInt);
    mOptions[WobblyOptions::GridResolution].rest ().set (1, 64);
    mOptions[WobblyOptions::GridResolution].value().set((int) 8);

    // min_grid_size
    mOptions[WobblyOptions::MinGridSize].setName ("min_grid_size", CompOption::TypeInt);
    mOptions[WobblyOptions::MinGridSize].rest ().set (4, 128);
    mOptions[WobblyOptions::MinGridSize].value().set((int) 8);

    // map_effect
    mOptions[WobblyOptions::MapEffect].setName ("map_effect", CompOption::TypeInt);
    mOptions[WobblyOptions::MapEffect].rest ().set (0, 1);
    mOptions[WobblyOptions::MapEffect].value().set((int) 0);

    // focus_effect
    mOptions[WobblyOptions::FocusEffect].setName ("focus_effect", CompOption::TypeInt);
    mOptions[WobblyOptions::FocusEffect].rest ().set (0, 1);
    mOptions[WobblyOptions::FocusEffect].value().set((int) 0);

    // map_window_match
    mOptions[WobblyOptions::MapWindowMatch].setName ("map_window_match", CompOption::TypeMatch);
    mOptions[WobblyOptions::MapWindowMatch].value().set(CompMatch ("Splash | DropdownMenu | PopupMenu | Tooltip | Notification | Combo | Dnd | Unknown"));
    mOptions[WobblyOptions::MapWindowMatch].value().match ().update ();

    // focus_window_match
    mOptions[WobblyOptions::FocusWindowMatch].setName ("focus_window_match", CompOption::TypeMatch);
    mOptions[WobblyOptions::FocusWindowMatch].value().set(CompMatch (""));
    mOptions[WobblyOptions::FocusWindowMatch].value().match ().update ();

    // grab_window_match
    mOptions[WobblyOptions::GrabWindowMatch].setName ("grab_window_match", CompOption::TypeMatch);
    mOptions[WobblyOptions::GrabWindowMatch].value().set(CompMatch (""));
    mOptions[WobblyOptions::GrabWindowMatch].value().match ().update ();

    // move_window_match
    mOptions[WobblyOptions::MoveWindowMatch].setName ("move_window_match", CompOption::TypeMatch);
    mOptions[WobblyOptions::MoveWindowMatch].value().set(CompMatch ("Toolbar | Menu | Utility | Dialog | Normal | Unknown"));
    mOptions[WobblyOptions::MoveWindowMatch].value().match ().update ();

    // maximize_effect
    mOptions[WobblyOptions::MaximizeEffect].setName ("maximize_effect", CompOption::TypeBool);
    mOptions[WobblyOptions::MaximizeEffect].value().set(true);

}

WobblyOptions::~WobblyOptions ()
{
}


CompOption::Vector &
WobblyOptions::getOptions ()
{
    return mOptions;
}

bool
WobblyOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case WobblyOptions::SnapKey:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::SnapKey].empty ())
                    mNotify[WobblyOptions::SnapKey] (o, WobblyOptions::SnapKey);
                return true;
            }
            break;
        case WobblyOptions::SnapInverted:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::SnapInverted].empty ())
                    mNotify[WobblyOptions::SnapInverted] (o, WobblyOptions::SnapInverted);
                return true;
            }
            break;
        case WobblyOptions::Shiver:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::Shiver].empty ())
                    mNotify[WobblyOptions::Shiver] (o, WobblyOptions::Shiver);
                return true;
            }
            break;
        case WobblyOptions::Friction:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::Friction].empty ())
                    mNotify[WobblyOptions::Friction] (o, WobblyOptions::Friction);
                return true;
            }
            break;
        case WobblyOptions::SpringK:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::SpringK].empty ())
                    mNotify[WobblyOptions::SpringK] (o, WobblyOptions::SpringK);
                return true;
            }
            break;
        case WobblyOptions::GridResolution:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::GridResolution].empty ())
                    mNotify[WobblyOptions::GridResolution] (o, WobblyOptions::GridResolution);
                return true;
            }
            break;
        case WobblyOptions::MinGridSize:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::MinGridSize].empty ())
                    mNotify[WobblyOptions::MinGridSize] (o, WobblyOptions::MinGridSize);
                return true;
            }
            break;
        case WobblyOptions::MapEffect:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::MapEffect].empty ())
                    mNotify[WobblyOptions::MapEffect] (o, WobblyOptions::MapEffect);
                return true;
            }
            break;
        case WobblyOptions::FocusEffect:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::FocusEffect].empty ())
                    mNotify[WobblyOptions::FocusEffect] (o, WobblyOptions::FocusEffect);
                return true;
            }
            break;
        case WobblyOptions::MapWindowMatch:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::MapWindowMatch].empty ())
                    mNotify[WobblyOptions::MapWindowMatch] (o, WobblyOptions::MapWindowMatch);
                return true;
            }
            break;
        case WobblyOptions::FocusWindowMatch:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::FocusWindowMatch].empty ())
                    mNotify[WobblyOptions::FocusWindowMatch] (o, WobblyOptions::FocusWindowMatch);
                return true;
            }
            break;
        case WobblyOptions::GrabWindowMatch:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::GrabWindowMatch].empty ())
                    mNotify[WobblyOptions::GrabWindowMatch] (o, WobblyOptions::GrabWindowMatch);
                return true;
            }
            break;
        case WobblyOptions::MoveWindowMatch:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::MoveWindowMatch].empty ())
                    mNotify[WobblyOptions::MoveWindowMatch] (o, WobblyOptions::MoveWindowMatch);
                return true;
            }
            break;
        case WobblyOptions::MaximizeEffect:
            if (o->set (value))
            {
                if (!mNotify[WobblyOptions::MaximizeEffect].empty ())
                    mNotify[WobblyOptions::MaximizeEffect] (o, WobblyOptions::MaximizeEffect);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

