/*
 * Decompiled with CFR 0.152.
 */
package beast.app.seqgen;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Sequence;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.datatype.DataType;
import beast.evolution.sitemodel.SiteModelInterface;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;
import beast.util.XMLProducer;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.List;

@Description(value="An alignment containing sequences randomly generated using agiven site model down a given tree.")
public class SimulatedAlignment
extends Alignment {
    public final Input<Alignment> m_data = new Input("data", "alignment data which specifies datatype and taxa of the beast.tree", Input.Validate.REQUIRED);
    public final Input<Tree> m_treeInput = new Input("tree", "phylogenetic beast.tree with sequence data in the leafs", Input.Validate.REQUIRED);
    public final Input<SiteModelInterface.Base> m_pSiteModelInput = new Input("siteModel", "site model for leafs in the beast.tree", Input.Validate.REQUIRED);
    public final Input<BranchRateModel.Base> m_pBranchRateModelInput = new Input("branchRateModel", "A model describing the rates on the branches of the beast.tree.");
    public final Input<Integer> m_sequenceLengthInput = new Input<Integer>("sequencelength", "nr of samples to generate (default 1000).", 1000);
    public final Input<String> m_outputFileNameInput = new Input("outputFileName", "If provided, simulated alignment is additionally written to this file.");
    protected int m_sequenceLength;
    protected Tree m_tree;
    protected SiteModelInterface.Base m_siteModel;
    protected BranchRateModel m_branchRateModel;
    int m_categoryCount;
    int m_stateCount;
    String m_outputFileName;
    protected double[][] m_probabilities;

    public SimulatedAlignment() {
        this.sequenceInput.setRule(Input.Validate.OPTIONAL);
    }

    @Override
    public void initAndValidate() {
        this.m_tree = this.m_treeInput.get();
        this.m_siteModel = this.m_pSiteModelInput.get();
        this.m_branchRateModel = this.m_pBranchRateModelInput.get();
        this.m_sequenceLength = this.m_sequenceLengthInput.get();
        this.m_stateCount = this.m_data.get().getMaxStateCount();
        this.m_categoryCount = this.m_siteModel.getCategoryCount();
        this.m_probabilities = new double[this.m_categoryCount][this.m_stateCount * this.m_stateCount];
        this.m_outputFileName = this.m_outputFileNameInput.get();
        ((List)this.sequenceInput.get()).clear();
        this.simulate();
        if (this.m_outputFileName != null) {
            try {
                PrintStream printStream = new PrintStream(this.m_outputFileName);
                printStream.println(new XMLProducer().toRawXML(this));
                printStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException(fileNotFoundException.getMessage());
            }
        }
        super.initAndValidate();
    }

    Sequence intArray2Sequence(int[] nArray, Node node) {
        DataType dataType = this.m_data.get().getDataType();
        String string = dataType.state2string(nArray);
        String string2 = this.m_data.get().getTaxaNames().get(node.getNr());
        return new Sequence(string2, string);
    }

    public void simulate() {
        Node node = this.m_tree.getRoot();
        double[] dArray = this.m_siteModel.getCategoryProportions(node);
        int[] nArray = new int[this.m_sequenceLength];
        for (int i = 0; i < this.m_sequenceLength; ++i) {
            nArray[i] = Randomizer.randomChoicePDF(dArray);
        }
        double[] dArray2 = this.m_siteModel.getSubstitutionModel().getFrequencies();
        int[] nArray2 = new int[this.m_sequenceLength];
        for (int i = 0; i < this.m_sequenceLength; ++i) {
            nArray2[i] = Randomizer.randomChoicePDF(dArray2);
        }
        this.traverse(node, nArray2, nArray);
    }

    void traverse(Node node, int[] nArray, int[] nArray2) {
        for (int i = 0; i < 2; ++i) {
            Node node2 = i == 0 ? node.getLeft() : node.getRight();
            for (int j = 0; j < this.m_categoryCount; ++j) {
                this.getTransitionProbabilities(this.m_tree, node2, j, this.m_probabilities[j]);
            }
            int[] nArray3 = new int[this.m_sequenceLength];
            double[] dArray = new double[this.m_stateCount];
            for (int j = 0; j < this.m_sequenceLength; ++j) {
                System.arraycopy(this.m_probabilities[nArray2[j]], nArray[j] * this.m_stateCount, dArray, 0, this.m_stateCount);
                nArray3[j] = Randomizer.randomChoicePDF(dArray);
            }
            if (node2.isLeaf()) {
                this.sequenceInput.setValue(this.intArray2Sequence(nArray3, node2), this);
                continue;
            }
            this.traverse(node2, nArray3, nArray2);
        }
    }

    void getTransitionProbabilities(Tree tree, Node node, int n, double[] dArray) {
        Node node2 = node.getParent();
        double d = this.m_branchRateModel == null ? 1.0 : this.m_branchRateModel.getRateForBranch(node);
        this.m_siteModel.getSubstitutionModel().getTransitionProbabilities(node, node2.getHeight(), node.getHeight(), d *= this.m_siteModel.getRateForCategory(n, node), dArray);
    }
}

