/*
 * Decompiled with CFR 0.152.
 */
package beast.app.treeannotator;

import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class RealNumberField
extends JTextField
implements FocusListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    public static String NaN = "NaN";
    public static String POSITIVE_INFINITY = "+INF";
    public static String NEGATIVE_INFINITY = "-INF";
    public static String MAX_VALUE = "MAX";
    public static String MIN_VALUE = "MIN";
    protected static char MINUS = (char)45;
    protected static char PERIOD = (char)46;
    protected EventListenerList changeListeners = new EventListenerList();
    protected double min;
    protected double max;
    protected final boolean includeMin;
    protected final boolean includeMax;
    protected boolean range_check = false;
    protected boolean range_checked = false;
    protected String label;
    private boolean isValueValid = true;
    protected boolean allowEmpty = false;
    static char[] numberSet = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public RealNumberField() {
        this.setLabel("Value");
        this.includeMin = true;
        this.includeMax = true;
    }

    public RealNumberField(double d, double d2) {
        this(d, d2, "Value");
        this.addFocusListener(this);
    }

    public RealNumberField(double d, double d2, String string) {
        this(d, true, d2, true, string);
    }

    public RealNumberField(double d, boolean bl, double d2, boolean bl2, String string) {
        this.min = d;
        this.max = d2;
        this.includeMin = bl;
        this.includeMax = bl2;
        this.setLabel(string);
        this.range_check = true;
    }

    public void setAllowEmpty(boolean bl) {
        this.allowEmpty = bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.validateField();
    }

    public void validateField() {
        if (this.range_check && !this.range_checked) {
            this.range_checked = true;
            this.isValueValid = this.isValueValid();
            if (!this.isValueValid) {
                this.displayErrorMessage();
                this.requestFocus();
            }
        }
    }

    public boolean isValueValid() {
        if (this.getText().trim().equals("") && this.allowEmpty) {
            return true;
        }
        if (this.range_check) {
            try {
                double d = this.getValue();
                if (d < this.min || d > this.max) {
                    return false;
                }
                if (!this.includeMin && d == this.min) {
                    return false;
                }
                if (!this.includeMax && d == this.max) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public void setText(Double d) {
        if (d == null && this.allowEmpty) {
            this.setText("");
        }
        if (Double.isNaN(d)) {
            this.setText(NaN);
        } else if (d == Double.POSITIVE_INFINITY) {
            this.setText(POSITIVE_INFINITY);
        } else if (d == Double.NEGATIVE_INFINITY) {
            this.setText(NEGATIVE_INFINITY);
        } else if (d == Double.MAX_VALUE) {
            this.setText(MAX_VALUE);
        } else if (d == Double.MIN_VALUE) {
            this.setText(MIN_VALUE);
        } else {
            this.setText(Double.toString(d));
        }
    }

    public void setText(Integer n) {
        this.setText(n.toString());
    }

    public void setText(Long l) {
        this.setText(l.toString());
    }

    public String getErrorMessage() {
        String string = "";
        if (this.min == Double.MIN_VALUE) {
            string = " greater than 0";
        } else if (!Double.isInfinite(this.min) && this.min != -1.7976931348623157E308) {
            string = " greater than " + this.min;
        }
        if (this.max == -4.9E-324) {
            string = " less than 0";
        } else if (!Double.isInfinite(this.max) && this.max != Double.MAX_VALUE) {
            if (string.length() > 0) {
                string = string + " and";
            }
            string = " less than " + this.max;
        }
        return this.label + " must be" + string;
    }

    private void displayErrorMessage() {
        JOptionPane.showMessageDialog(null, this.getErrorMessage(), "Invalid value", 0);
    }

    public void setRange(double d, double d2) {
        this.min = d;
        this.max = d2;
        this.range_check = true;
    }

    public void setValue(double d) {
        if (this.range_check) {
            if (d < this.min || d > this.max) {
                this.displayErrorMessage();
                return;
            }
            if (!this.includeMin && d == this.min) {
                this.displayErrorMessage();
                return;
            }
            if (!this.includeMax && d == this.max) {
                this.displayErrorMessage();
                return;
            }
        }
        this.setText(d);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Double getValue() {
        try {
            if (this.allowEmpty && this.getText().trim().equals("")) {
                return null;
            }
            if (this.getText().equals(POSITIVE_INFINITY)) {
                return Double.POSITIVE_INFINITY;
            }
            if (this.getText().equals(NEGATIVE_INFINITY)) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.getText().equals(MAX_VALUE)) {
                return Double.MAX_VALUE;
            }
            if (this.getText().equals(MIN_VALUE)) {
                return Double.MIN_VALUE;
            }
            if (this.getText().equals(NaN)) {
                return Double.NaN;
            }
            return new Double(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Unable to parse number correctly", "Number Format Exception", 0);
            this.isValueValid = false;
            return null;
        }
    }

    @Override
    protected Document createDefaultModel() {
        RealNumberFieldDocument realNumberFieldDocument = new RealNumberFieldDocument();
        realNumberFieldDocument.addDocumentListener(this);
        return realNumberFieldDocument;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChanged();
    }

    static boolean member(char c, char[] cArray) {
        for (char c2 : cArray) {
            if (c2 != c) continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(ChangeListener.class, changeListener);
    }

    protected void fireChanged() {
        this.range_checked = false;
        this.isValueValid = true;
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ChangeListener changeListener = (ChangeListener)objectArray[i + 1];
            changeListener.stateChanged(changeEvent);
        }
    }

    class RealNumberFieldDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        RealNumberFieldDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == "" || string == null) {
                return;
            }
            if (string.equals("+INF") || string.equals("-INF") || string.equals("NaN") || string.equals("MAX_VALUE") || string.equals("MIN_VALUE")) {
                super.insertString(n, string, attributeSet);
                return;
            }
            string = string.trim();
            int n2 = this.getLength();
            String string2 = this.getText(0, n) + string + this.getText(n, n2 - n);
            char[] cArray = (string2 = string2.trim().toUpperCase()).toCharArray();
            if (cArray.length > 0 && cArray[0] != MINUS && !RealNumberField.member(cArray[0], numberSet) && cArray[0] != PERIOD) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            boolean bl = cArray.length > 0 && cArray[0] == PERIOD;
            boolean bl2 = false;
            int n3 = -1;
            boolean bl3 = false;
            for (int i = 1; i < cArray.length; ++i) {
                if (RealNumberField.member(cArray[i], numberSet)) continue;
                if (!bl && cArray[i] == PERIOD) {
                    bl = true;
                    continue;
                }
                if (!bl2 && cArray[i] == 'E') {
                    bl2 = true;
                    n3 = i;
                    continue;
                }
                if (bl2 && i == n3 + 1 && !bl3 && cArray[i] == '-') {
                    bl3 = true;
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

