/*
 * Decompiled with CFR 0.152.
 */
package beast.core;

import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.Operator;
import beast.core.StateNode;
import beast.core.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Description(value="The state represents the current point in the state space, and maintains values of a set of StateNodes, such as parameters and trees. Furthermore, the state manages which parts of the model need to be stored/restored and notified that recalculation is appropriate.")
public class State
extends BEASTObject {
    public final Input<List<StateNode>> stateNodeInput = new Input("stateNode", "anything that is part of the state", new ArrayList());
    public final Input<Integer> m_storeEvery = new Input<Integer>("storeEvery", "store the state to disk every X number of samples so that we can resume computation later on if the process failed half-way.", -1);
    protected StateNode[] stateNode;
    private int nrOfStateNodes;
    private StateNode[] stateNodeMem;
    private String stateFileName = "state.backup.xml";
    private HashMap<BEASTInterface, List<BEASTInterface>> outputMap;
    private List<CalculationNode>[] stateNodeOutputs;
    private int[] changeStateNodes;
    private int nrOfChangedStateNodes;
    Trie trie;

    public int getNrOfStateNodes() {
        return this.nrOfStateNodes;
    }

    @Override
    public void initAndValidate() {
    }

    public void initialise() {
        this.stateNode = this.stateNodeInput.get().toArray(new StateNode[0]);
        for (int i = 0; i < this.stateNode.length; ++i) {
            this.stateNode[i].index = i;
        }
        for (StateNode stateNode : this.stateNode) {
            stateNode.state = this;
        }
        this.nrOfStateNodes = this.stateNode.length;
        this.stateNodeMem = new StateNode[this.nrOfStateNodes * 2];
        for (int i = 0; i < this.nrOfStateNodes; ++i) {
            this.stateNodeMem[i] = this.stateNode[i];
            this.stateNodeMem[this.nrOfStateNodes + i] = this.stateNodeMem[i].copy();
        }
        this.changeStateNodes = new int[this.stateNode.length];
        this.nrOfChangedStateNodes = 0;
        this.trie = new Trie();
        this.trie.list = new ArrayList<CalculationNode>();
    }

    public StateNode getStateNode(int n) {
        return this.stateNode[n];
    }

    protected StateNode getEditableStateNode(int n, Operator operator) {
        for (int i = 0; i < this.nrOfChangedStateNodes; ++i) {
            if (this.changeStateNodes[i] != n) continue;
            return this.stateNode[n];
        }
        this.changeStateNodes[this.nrOfChangedStateNodes++] = n;
        return this.stateNode[n];
    }

    public void store(int n) {
        this.nrOfChangedStateNodes = 0;
    }

    public void restore() {
        for (int i = 0; i < this.nrOfChangedStateNodes; ++i) {
            this.stateNode[this.changeStateNodes[i]].restore();
        }
    }

    public void storeCalculationNodes() {
        List<CalculationNode> list = this.getCurrentCalculationNodes();
        for (CalculationNode calculationNode : list) {
            calculationNode.store();
        }
    }

    public void checkCalculationNodesDirtiness() {
        List<CalculationNode> list = this.getCurrentCalculationNodes();
        for (CalculationNode calculationNode : list) {
            calculationNode.checkDirtiness();
        }
    }

    public void restoreCalculationNodes() {
        List<CalculationNode> list = this.getCurrentCalculationNodes();
        for (CalculationNode calculationNode : list) {
            calculationNode.restore();
        }
    }

    public void acceptCalculationNodes() {
        List<CalculationNode> list = this.getCurrentCalculationNodes();
        for (CalculationNode calculationNode : list) {
            calculationNode.accept();
        }
    }

    public void setStateFileName(String string) {
        if (string != null) {
            this.stateFileName = string;
        }
    }

    public void storeToFile(int n) {
        try {
            PrintStream printStream = new PrintStream(this.stateFileName + ".new");
            printStream.print(this.toXML(n));
            printStream.close();
            File file = new File(this.stateFileName + ".new");
            File file2 = new File(this.stateFileName);
            file2.delete();
            Files.move(file.toPath(), file2.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toXML(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<itsabeastystatewerein version='2.0' sample='").append(n).append("'>\n");
        for (StateNode stateNode : this.stateNode) {
            stringBuilder.append(stateNode.toXML());
        }
        stringBuilder.append("</itsabeastystatewerein>\n");
        return stringBuilder.toString();
    }

    public void fromXML(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes()));
            document.normalize();
            NodeList nodeList = document.getElementsByTagName("*");
            Node node = nodeList.item(0);
            NodeList nodeList2 = node.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 1) continue;
                String string2 = node2.getAttributes().getNamedItem("id").getNodeValue();
                int n = 0;
                while (!this.stateNode[n].getID().equals(string2)) {
                    ++n;
                }
                StateNode stateNode = this.stateNode[n].copy();
                stateNode.fromXML(node2);
                this.stateNode[n].assignFromFragile(stateNode);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void restoreFromFile() throws SAXException, IOException, ParserConfigurationException {
        Log.info.println("Restoring from file");
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new File(this.stateFileName));
        document.normalize();
        NodeList nodeList = document.getElementsByTagName("*");
        Node node = nodeList.item(0);
        NodeList nodeList2 = node.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node2 = nodeList2.item(i);
            if (node2.getNodeType() != 1) continue;
            Node node3 = node2.getAttributes().getNamedItem("id");
            if (node3 != null) {
                String string = node3.getNodeValue();
                int n = 0;
                while (this.stateNode[n].getID() != null && !this.stateNode[n].getID().equals(string)) {
                    if (++n < this.stateNode.length) continue;
                    Log.warning.println("Cannot restore statenode id " + string + " -- item is ignored");
                    break;
                }
                if (n >= this.stateNode.length) continue;
                StateNode stateNode = this.stateNode[n].copy();
                stateNode.fromXML(node2);
                this.stateNode[n].assignFromFragile(stateNode);
                continue;
            }
            Log.warning.println("Cannot restore statenode without id -- item is ignored");
        }
    }

    @Override
    public String toString() {
        if (this.stateNode == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (StateNode stateNode : this.stateNode) {
            stringBuilder.append(stateNode.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void setEverythingDirty(boolean bl) {
        for (StateNode stateNode : this.stateNode) {
            stateNode.setEverythingDirty(bl);
        }
        if (bl) {
            for (int i = 0; i < this.stateNode.length; ++i) {
                this.changeStateNodes[i] = i;
            }
            this.nrOfChangedStateNodes = this.stateNode.length;
        }
    }

    public void setPosterior(BEASTObject bEASTObject) {
        int n;
        this.outputMap = new HashMap();
        this.outputMap.put(bEASTObject, new ArrayList());
        boolean bl = true;
        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
        arrayList.add(bEASTObject);
        while (bl) {
            bl = false;
            for (n = 0; n < arrayList.size(); ++n) {
                BEASTInterface bEASTInterface = (BEASTInterface)arrayList.get(n);
                try {
                    for (BEASTInterface bEASTInterface2 : bEASTInterface.listActiveBEASTObjects()) {
                        if (!this.outputMap.containsKey(bEASTInterface2)) {
                            this.outputMap.put(bEASTInterface2, new ArrayList());
                            arrayList.add(bEASTInterface2);
                            bl = true;
                        }
                        if (this.outputMap.get(bEASTInterface2).contains(bEASTInterface)) continue;
                        this.outputMap.get(bEASTInterface2).add(bEASTInterface);
                        bl = true;
                    }
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.stateNodeOutputs = new List[this.stateNode.length];
        for (n = 0; n < this.stateNode.length; ++n) {
            this.stateNodeOutputs[n] = new ArrayList<CalculationNode>();
            if (this.outputMap.containsKey(this.stateNode[n])) {
                for (BEASTInterface bEASTInterface : this.outputMap.get(this.stateNode[n])) {
                    if (bEASTInterface instanceof CalculationNode) {
                        this.stateNodeOutputs[n].add((CalculationNode)bEASTInterface);
                        continue;
                    }
                    throw new RuntimeException("DEVELOPER ERROR: output of StateNode (" + this.stateNode[n].getID() + ") should be a CalculationNode, but " + bEASTInterface.getClass().getName() + " is not.");
                }
                continue;
            }
            Log.warning.println("\nWARNING: StateNode (" + this.stateNode[n].getID() + ") found that has no effect on posterior!\n");
        }
    }

    private List<CalculationNode> getCurrentCalculationNodes() {
        List<CalculationNode> list = this.trie.get(this.nrOfChangedStateNodes);
        if (list != null) {
            return list;
        }
        try {
            list = this.calculateCalcNodePath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        this.trie.set(list, this.nrOfChangedStateNodes);
        return list;
    }

    private List<CalculationNode> calculateCalcNodePath() throws IllegalArgumentException, IllegalAccessException {
        CalculationNode calculationNode2;
        int n;
        ArrayList<CalculationNode> arrayList = new ArrayList<CalculationNode>();
        for (n = 0; n < this.nrOfChangedStateNodes; ++n) {
            int n2 = this.changeStateNodes[n];
            boolean bl = false;
            for (CalculationNode calculationNode2 : this.stateNodeOutputs[n2]) {
                if (arrayList.contains(calculationNode2)) continue;
                arrayList.add(calculationNode2);
                bl = true;
            }
            while (bl) {
                bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    calculationNode2 = (CalculationNode)arrayList.get(i);
                    for (BEASTInterface bEASTInterface : this.outputMap.get(calculationNode2)) {
                        if (bEASTInterface instanceof CalculationNode) {
                            CalculationNode calculationNode3 = (CalculationNode)bEASTInterface;
                            if (arrayList.contains(calculationNode3)) continue;
                            arrayList.add(calculationNode3);
                            bl = true;
                            continue;
                        }
                        throw new RuntimeException("DEVELOPER ERROR: found a non-CalculatioNode (" + bEASTInterface.getClass().getName() + ") on path between StateNode and Runnable");
                    }
                }
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            CalculationNode calculationNode4 = (CalculationNode)arrayList.get(n);
            List<BEASTInterface> list = calculationNode4.listActiveBEASTObjects();
            for (int i = arrayList.size() - 1; i > n; --i) {
                if (!list.contains(arrayList.get(i))) continue;
                calculationNode2 = (CalculationNode)arrayList.get(i);
                arrayList.set(i, calculationNode4);
                arrayList.set(n, calculationNode2);
                i = 0;
                --n;
            }
        }
        return arrayList;
    }

    public double robustlyCalcPosterior(Distribution distribution) {
        this.store(-1);
        this.setEverythingDirty(true);
        this.checkCalculationNodesDirtiness();
        double d = distribution.calculateLogP();
        this.setEverythingDirty(false);
        this.acceptCalculationNodes();
        return d;
    }

    public double robustlyCalcNonStochasticPosterior(Distribution distribution) {
        this.store(-1);
        this.setEverythingDirty(true);
        this.storeCalculationNodes();
        this.checkCalculationNodesDirtiness();
        double d = distribution.getNonStochasticLogP();
        this.setEverythingDirty(false);
        this.acceptCalculationNodes();
        return d;
    }

    class Trie {
        List<CalculationNode> list;
        final Trie[] children;

        Trie() {
            this.children = new Trie[State.this.stateNode.length];
        }

        List<CalculationNode> get(int n) {
            if (n == 0) {
                return this.list;
            }
            Trie trie = this.children[State.this.changeStateNodes[n - 1]];
            if (trie == null) {
                return null;
            }
            return trie.get(n - 1);
        }

        void set(List<CalculationNode> list, int n) {
            if (n == 0) {
                this.list = list;
                return;
            }
            Trie trie = this.children[State.this.changeStateNodes[n - 1]];
            if (trie == null) {
                this.children[((State)State.this).changeStateNodes[n - 1]] = trie = new Trie();
            }
            trie.set(list, n - 1);
        }
    }
}

