/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.alignment.distance;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.datatype.DataType;

@Description(value="Provides distance between taxa")
public interface Distance {
    public double pairwiseDistance(int var1, int var2);

    @Description(value="Provides distance between two sequences in an alignment")
    public static class Base
    extends BEASTObject
    implements Distance {
        public static final double MAX_DISTANCE = 5.0;
        protected DataType dataType = null;
        int dimension = 0;
        boolean distancesKnown;
        protected Alignment patterns = null;
        private TaxonSet taxa = null;

        @Override
        public void initAndValidate() {
        }

        public void setPatterns(Alignment alignment) {
            this.taxa = new TaxonSet();
            try {
                this.taxa.alignmentInput.setValue(alignment, this.taxa);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.patterns = alignment;
            this.dimension = alignment.getTaxonCount();
            this.dataType = alignment.getDataType();
            this.distancesKnown = false;
        }

        @Override
        public double pairwiseDistance(int n, int n2) {
            int n3 = this.patterns.getPatternCount();
            double d = 0.0;
            double d2 = 0.0;
            for (int i = 0; i < n3; ++i) {
                int[] nArray = this.patterns.getPattern(i);
                int n4 = nArray[n];
                int n5 = nArray[n2];
                double d3 = this.patterns.getPatternWeight(i);
                if (!this.dataType.isAmbiguousState(n4) && !this.dataType.isAmbiguousState(n5) && n4 != n5) {
                    d += d3;
                }
                d2 += d3;
            }
            double d4 = d / d2;
            return d4;
        }
    }
}

