/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.datatype;

import beast.core.BEASTObject;
import beast.core.Description;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public interface DataType {
    public static final char GAP_CHAR = '-';
    public static final char MISSING_CHAR = '?';

    public int getStateCount();

    public List<Integer> string2state(String var1);

    public String state2string(List<Integer> var1);

    public String state2string(int[] var1);

    public boolean[] getStateSet(int var1);

    public int[] getStatesForCode(int var1);

    public boolean isAmbiguousState(int var1);

    public boolean isStandard();

    public String getTypeDescription();

    public char getChar(int var1);

    public String getCode(int var1);

    @Description(value="Base class bringing class and interfaces together", isInheritable=false)
    public static abstract class Base
    extends BEASTObject
    implements DataType {
        protected int stateCount;
        protected String codeMap;
        protected int codeLength;
        protected int[][] mapCodeToStateSet;

        public String getCodeMap() {
            return this.codeMap;
        }

        @Override
        public void initAndValidate() {
            if (this.mapCodeToStateSet != null && this.mapCodeToStateSet.length != this.codeMap.length() / this.codeLength) {
                throw new IllegalArgumentException("codeMap and mapCodeToStateSet have incompatible lengths");
            }
        }

        @Override
        public int getStateCount() {
            return this.stateCount;
        }

        @Override
        public List<Integer> string2state(String string) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            string = string.replaceAll("\\s", "");
            string = string.toUpperCase();
            if (this.codeMap == null) {
                if (string.contains(",")) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(",")) {
                        try {
                            arrayList.add(Integer.parseInt(string2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            arrayList.add(-1);
                        }
                    }
                } else {
                    block6: for (byte by : string.getBytes()) {
                        switch (by) {
                            case 45: 
                            case 63: {
                                arrayList.add(-1);
                                continue block6;
                            }
                            default: {
                                arrayList.add(Integer.parseInt((char)by + ""));
                            }
                        }
                    }
                }
            } else if (this.codeLength == 1) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    int n = this.codeMap.indexOf(c);
                    if (n < 0) {
                        throw new IllegalArgumentException("Unknown code found in sequence: " + c);
                    }
                    arrayList.add(n);
                }
            } else if (this.codeLength > 1) {
                String string3;
                int n;
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (n = 0; n < this.codeMap.length(); n += this.codeLength) {
                    string3 = this.codeMap.substring(n, n + this.codeLength);
                    hashMap.put(string3, n / this.codeLength);
                }
                for (n = 0; n < string.length(); n += this.codeLength) {
                    string3 = string.substring(n, n + this.codeLength).toUpperCase();
                    if (!hashMap.containsKey(string3)) {
                        throw new IllegalArgumentException("Unknown code found in sequence: " + string3);
                    }
                    arrayList.add((Integer)hashMap.get(string3));
                }
            } else {
                String[] stringArray = this.codeMap.toUpperCase().split(",");
                for (String string4 : string.split(",")) {
                    boolean bl = false;
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!string4.equals(stringArray[i])) continue;
                        arrayList.add(i);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    throw new RuntimeException("Could not find code " + string4 + " in codemap");
                }
            }
            return arrayList;
        }

        @Override
        public String state2string(List<Integer> list) {
            int[] nArray = new int[list.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = list.get(i);
            }
            return this.state2string(nArray);
        }

        @Override
        public String state2string(int[] nArray) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.codeMap != null) {
                for (int n : nArray) {
                    String string = this.codeMap.substring(n * this.codeLength, n * this.codeLength + this.codeLength);
                    stringBuffer.append(string);
                }
            } else {
                for (int i = 0; i < nArray.length - 1; ++i) {
                    stringBuffer.append(nArray[i] + ",");
                }
                stringBuffer.append(nArray[nArray.length - 1] + "");
            }
            return stringBuffer.toString();
        }

        @Override
        public int[] getStatesForCode(int n) {
            return this.mapCodeToStateSet[n];
        }

        @Override
        public boolean[] getStateSet(int n) {
            int[] nArray;
            boolean[] blArray = new boolean[this.stateCount];
            for (int n2 : nArray = this.getStatesForCode(n)) {
                blArray[n2] = true;
            }
            return blArray;
        }

        @Override
        public boolean isAmbiguousState(int n) {
            return n < 0 || n >= this.stateCount;
        }

        @Override
        public boolean isStandard() {
            return true;
        }

        @Override
        public char getChar(int n) {
            return (char)(n + 65);
        }

        @Override
        public String getCode(int n) {
            return String.valueOf(this.getChar(n));
        }

        @Override
        public String toString() {
            return this.getTypeDescription();
        }

        public Integer char2state(String string) {
            return this.string2state(string).get(0);
        }
    }
}

