/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.BooleanParameter;
import beast.util.Randomizer;

@Description(value="Flip one bit in an array of boolean bits. The hastings ratio is designed so that all subsets of vectors with the same number of 'on' bits are equiprobable.")
public class BitFlipOperator
extends Operator {
    public final Input<Boolean> uniformInput = new Input<Boolean>("uniform", "when on, total probability of combinations with k 'on' bits is equal. Otherwise uniform on all combinations (default true)", true);
    public final Input<BooleanParameter> parameterInput = new Input("parameter", "the parameter to operate a flip on.", Input.Validate.REQUIRED);
    private boolean usesPriorOnSum = true;

    @Override
    public void initAndValidate() {
        Boolean bl = this.uniformInput.get();
        if (bl != null) {
            this.usesPriorOnSum = bl;
        }
    }

    @Override
    public double proposal() {
        int n;
        BooleanParameter booleanParameter = this.parameterInput.get(this);
        int n2 = booleanParameter.getDimension();
        double d = 0.0;
        if (this.usesPriorOnSum) {
            for (n = 0; n < n2; ++n) {
                if (!((Boolean)booleanParameter.getValue(n)).booleanValue()) continue;
                d += 1.0;
            }
        }
        n = Randomizer.nextInt(n2);
        boolean bl = (Boolean)booleanParameter.getValue(n);
        double d2 = 0.0;
        if (!bl) {
            booleanParameter.setValue(n, true);
            if (this.usesPriorOnSum) {
                d2 = -Math.log(((double)n2 - d) / (d + 1.0));
            }
        } else {
            booleanParameter.setValue(n, false);
            if (this.usesPriorOnSum) {
                d2 = -Math.log(d / ((double)n2 - d + 1.0));
            }
        }
        return d2;
    }
}

