/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree;

import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.State;
import beast.evolution.tree.TreeInterface;
import beast.evolution.tree.coalescent.TreeIntervals;
import java.util.List;
import java.util.Random;

@Description(value="Distribution on a tree, typically a prior such as Coalescent or Yule")
public class TreeDistribution
extends Distribution {
    public final Input<TreeInterface> treeInput = new Input("tree", "tree over which to calculate a prior or likelihood");
    public final Input<TreeIntervals> treeIntervalsInput = new Input("treeIntervals", "Intervals for a phylogenetic beast tree", Input.Validate.XOR, this.treeInput);

    @Override
    public List<String> getArguments() {
        return null;
    }

    @Override
    public List<String> getConditions() {
        return null;
    }

    @Override
    public void sample(State state, Random random) {
    }

    @Override
    protected boolean requiresRecalculation() {
        TreeIntervals treeIntervals = this.treeIntervalsInput.get();
        if (treeIntervals != null) {
            assert (treeIntervals.isDirtyCalculation());
            return true;
        }
        return this.treeInput.get().somethingIsDirty();
    }

    public boolean canHandleTipDates() {
        return true;
    }
}

