/*
 * Decompiled with CFR 0.152.
 */
package viz.graphics;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import viz.graphics.BranchDrawer;
import viz.graphics.BufferedImageF;

public class TrapeziumBranchDrawer
extends BranchDrawer {
    @Override
    public void draw(BufferedImageF image, int color, Graphics2D g, int x1, int y1, int x2, int y2, float fBottomWidth, float fTopWidth) {
        if (fBottomWidth == 0.0f) {
            super.draw(image, color, g, x1, y1, x2, y2, fBottomWidth, fTopWidth);
            return;
        }
        int nRed = color >> 16 & 0xFF;
        int nGreen = color >> 8 & 0xFF;
        int nBlue = color >> 0 & 0xFF;
        float fAlpha = ((AlphaComposite)g.getComposite()).getAlpha();
        this.lineAA(image, x1, y1, x2, y2, fAlpha, nRed <<= 16, nGreen <<= 16, nBlue <<= 16, fBottomWidth, fTopWidth);
    }

    void lineAA(BufferedImageF image, int x1, int y1, int x2, int y2, float fAlpha, int nRed, int nGreen, int nBlue, float fLineWidth, float fLineWidthTop) {
        int h;
        boolean steep = Math.abs(y2 - y1) > Math.abs(x2 - x1);
        steep = false;
        if (steep) {
            h = x1;
            x1 = y1;
            y1 = h;
            h = x2;
            x2 = y2;
            y2 = h;
        }
        if (x2 < x1) {
            h = x1;
            x1 = x2;
            x2 = h;
            h = y1;
            y1 = y2;
            y2 = h;
            float f = fLineWidth;
            fLineWidth = fLineWidthTop;
            fLineWidthTop = f;
        }
        float dx = x2 - x1;
        float dy = y2 - y1;
        float gradient = dy / dx;
        int xpxl1 = x1;
        float intery = (float)y1 + gradient;
        int xpxl2 = x2;
        int x = xpxl1 + 1;
        while (x < xpxl2) {
            int i;
            int y;
            int nLineWidth = (int)(fLineWidthTop + (fLineWidth - fLineWidthTop) * (float)(x - xpxl1 - 1) / (float)(xpxl2 - xpxl1));
            if (steep) {
                y = (int)intery;
                image.plot(y, x, this.rfpart(intery) * fAlpha, nRed, nGreen, nBlue);
                i = 1;
                while (i < nLineWidth) {
                    image.plot(y + i, x, fAlpha, nRed, nGreen, nBlue);
                    ++i;
                }
                image.plot(y + nLineWidth, x, this.fpart(intery) * fAlpha, nRed, nGreen, nBlue);
            } else {
                y = (int)intery;
                image.plot(x, (int)intery, this.rfpart(intery) * fAlpha, nRed, nGreen, nBlue);
                i = 1;
                while (i < nLineWidth) {
                    image.plot(x, y + i, fAlpha, nRed, nGreen, nBlue);
                    ++i;
                }
                image.plot(x, y + nLineWidth, this.fpart(intery) * fAlpha, nRed, nGreen, nBlue);
            }
            intery += gradient;
            ++x;
        }
    }
}

