/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ClassFileVisitor {
    private boolean checkJars = true;

    public boolean isCheckJars() {
        return this.checkJars;
    }

    public void setCheckJars(boolean bl) {
        this.checkJars = bl;
    }

    public void process(File[] fileArray) throws IOException {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                String string = file.getName();
                String string2 = file2.getName();
                int n = string.length() - string2.length();
                return n != 0 ? n : string.compareTo(string2);
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            this.process(fileArray[i]);
        }
    }

    public void process(File file) throws IOException {
        if (file.isDirectory()) {
            this.processDirectory(file);
        } else if (file.getName().endsWith(".class")) {
            this.processClassFile(file);
        } else if (file.getName().endsWith(".jar") && this.checkJars) {
            this.processJarFile(file);
        }
    }

    protected void processDirectory(File file) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        this.process(fileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(File file) throws IOException {
        try {
            JarFile jarFile = new JarFile(file);
            TreeSet<JarEntry> treeSet = new TreeSet<JarEntry>(new Comparator<JarEntry>(){

                @Override
                public int compare(JarEntry jarEntry, JarEntry jarEntry2) {
                    String string = jarEntry.getName();
                    String string2 = jarEntry2.getName();
                    int n = string.length() - string2.length();
                    return n != 0 ? n : string.compareTo(string2);
                }
            });
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                treeSet.add(jarEntry);
            }
            for (JarEntry jarEntry : treeSet) {
                try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
                    this.process(file.getPath() + ':' + jarEntry.getName(), inputStream);
                }
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException(" failed to process jar " + file.getPath() + " : " + iOException.getMessage());
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClassFile(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.process(file.getPath(), fileInputStream);
        }
    }

    protected abstract void process(String var1, InputStream var2) throws IOException;
}

