/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;

public class ClassNameIdResolver
extends TypeIdResolverBase {
    public ClassNameIdResolver(JavaType javaType, TypeFactory typeFactory) {
        super(javaType, typeFactory);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CLASS;
    }

    public void registerSubtype(Class<?> clazz, String string) {
    }

    @Override
    public String idFromValue(Object object) {
        return this._idFrom(object, object.getClass(), this._typeFactory);
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        return this._idFrom(object, clazz, this._typeFactory);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
        return this._typeFromId(string, databindContext);
    }

    protected JavaType _typeFromId(String string, DatabindContext databindContext) throws IOException {
        Class<?> clazz;
        TypeFactory typeFactory = databindContext.getTypeFactory();
        if (string.indexOf(60) > 0) {
            return typeFactory.constructFromCanonical(string);
        }
        try {
            clazz = typeFactory.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (databindContext instanceof DeserializationContext) {
                DeserializationContext deserializationContext = (DeserializationContext)databindContext;
                return deserializationContext.handleUnknownTypeId(this._baseType, string, this, "no such class found");
            }
            return null;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid type id '" + string + "' (for id type 'Id.class'): " + exception.getMessage(), exception);
        }
        return typeFactory.constructSpecializedType(this._baseType, clazz);
    }

    protected final String _idFrom(Object object, Class<?> clazz, TypeFactory typeFactory) {
        Class<?> clazz2;
        Class<?> clazz3;
        String string;
        if (Enum.class.isAssignableFrom(clazz) && !clazz.isEnum()) {
            clazz = clazz.getSuperclass();
        }
        if ((string = clazz.getName()).startsWith("java.util")) {
            if (object instanceof EnumSet) {
                Class<? extends Enum<?>> clazz4 = ClassUtil.findEnumType((EnumSet)object);
                string = typeFactory.constructCollectionType(EnumSet.class, clazz4).toCanonical();
            } else if (object instanceof EnumMap) {
                Class<? extends Enum<?>> clazz5 = ClassUtil.findEnumType((EnumMap)object);
                Class<Object> clazz6 = Object.class;
                string = typeFactory.constructMapType(EnumMap.class, clazz5, clazz6).toCanonical();
            } else {
                String string2 = string.substring(9);
                if ((string2.startsWith(".Arrays$") || string2.startsWith(".Collections$")) && string.indexOf("List") >= 0) {
                    string = "java.util.ArrayList";
                }
            }
        } else if (string.indexOf(36) >= 0 && (clazz3 = ClassUtil.getOuterClass(clazz)) != null && ClassUtil.getOuterClass(clazz2 = this._baseType.getRawClass()) == null) {
            clazz = this._baseType.getRawClass();
            string = clazz.getName();
        }
        return string;
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "class name used as type id";
    }
}

