/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.io.IOException;
import java.util.List;

@JacksonStdImpl
public final class IndexedListSerializer
extends AsArraySerializerBase<List<?>> {
    private static final long serialVersionUID = 1L;

    public IndexedListSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        super(List.class, javaType, bl, typeSerializer, jsonSerializer);
    }

    public IndexedListSerializer(IndexedListSerializer indexedListSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        super(indexedListSerializer, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    public IndexedListSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        return new IndexedListSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, List<?> list) {
        return list == null || list.isEmpty();
    }

    @Override
    public boolean hasSingleElement(List<?> list) {
        return list.size() == 1;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return new IndexedListSerializer(this, this._property, typeSerializer, this._elementSerializer, this._unwrapSingle);
    }

    @Override
    public final void serialize(List<?> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n = list.size();
        if (n == 1 && (this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(list, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(n);
        this.serializeContents(list, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(List<?> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n;
        if (this._elementSerializer != null) {
            this.serializeContentsUsing(list, jsonGenerator, serializerProvider, this._elementSerializer);
            return;
        }
        if (this._valueTypeSerializer != null) {
            this.serializeTypedContents(list, jsonGenerator, serializerProvider);
            return;
        }
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        try {
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            for (n = 0; n < n2; ++n) {
                Object obj = list.get(n);
                if (obj == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz = obj.getClass();
                JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                    propertySerializerMap = this._dynamicSerializers;
                }
                jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, list, n);
        }
    }

    public void serializeContentsUsing(List<?> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, JsonSerializer<Object> jsonSerializer) throws IOException {
        int n = list.size();
        if (n == 0) {
            return;
        }
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            try {
                if (obj == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                if (typeSerializer == null) {
                    jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
                continue;
            }
            catch (Exception exception) {
                this.wrapAndThrow(serializerProvider, (Throwable)exception, list, i);
            }
        }
    }

    public void serializeTypedContents(List<?> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n;
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        try {
            TypeSerializer typeSerializer = this._valueTypeSerializer;
            PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
            for (n = 0; n < n2; ++n) {
                Object obj = list.get(n);
                if (obj == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                Class<?> clazz = obj.getClass();
                JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
                if (jsonSerializer == null) {
                    jsonSerializer = this._elementType.hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, serializerProvider.constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                    propertySerializerMap = this._dynamicSerializers;
                }
                jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, list, n);
        }
    }
}

