/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.extensions.OrgDepartment;
import com.google.gdata.data.extensions.OrgJobDescription;
import com.google.gdata.data.extensions.OrgName;
import com.google.gdata.data.extensions.OrgSymbol;
import com.google.gdata.data.extensions.OrgTitle;
import com.google.gdata.data.extensions.Where;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.xml.XmlNamespace;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="organization")
public class Organization
extends ExtensionPoint {
    static final String XML_NAME = "organization";
    private static final String LABEL = "label";
    private static final String PRIMARY = "primary";
    private static final String REL = "rel";
    private String label = null;
    private Boolean primary = null;
    private String rel = null;

    public Organization() {
    }

    public Organization(String label, Boolean primary, String rel) {
        this.setLabel(label);
        this.setPrimary(primary);
        this.setRel(rel);
        this.setImmutable(true);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(Organization.class)) {
            return;
        }
        extProfile.declare(Organization.class, OrgDepartment.class);
        extProfile.declare(Organization.class, OrgJobDescription.class);
        extProfile.declare(Organization.class, OrgName.class);
        extProfile.declare(Organization.class, OrgSymbol.class);
        extProfile.declare(Organization.class, OrgTitle.class);
        extProfile.declare(Organization.class, new ExtensionDescription(Where.class, new XmlNamespace("gd", "http://schemas.google.com/g/2005"), "where", false, false, false));
        new Where().declareExtensions(extProfile);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.throwExceptionIfImmutable();
        this.label = label;
    }

    public boolean hasLabel() {
        return this.getLabel() != null;
    }

    public OrgDepartment getOrgDepartment() {
        return this.getExtension(OrgDepartment.class);
    }

    public void setOrgDepartment(OrgDepartment orgDepartment) {
        if (orgDepartment == null) {
            this.removeExtension(OrgDepartment.class);
        } else {
            this.setExtension(orgDepartment);
        }
    }

    public boolean hasOrgDepartment() {
        return this.hasExtension(OrgDepartment.class);
    }

    public OrgJobDescription getOrgJobDescription() {
        return this.getExtension(OrgJobDescription.class);
    }

    public void setOrgJobDescription(OrgJobDescription orgJobDescription) {
        if (orgJobDescription == null) {
            this.removeExtension(OrgJobDescription.class);
        } else {
            this.setExtension(orgJobDescription);
        }
    }

    public boolean hasOrgJobDescription() {
        return this.hasExtension(OrgJobDescription.class);
    }

    public OrgName getOrgName() {
        return this.getExtension(OrgName.class);
    }

    public void setOrgName(OrgName orgName) {
        if (orgName == null) {
            this.removeExtension(OrgName.class);
        } else {
            this.setExtension(orgName);
        }
    }

    public boolean hasOrgName() {
        return this.hasExtension(OrgName.class);
    }

    public OrgSymbol getOrgSymbol() {
        return this.getExtension(OrgSymbol.class);
    }

    public void setOrgSymbol(OrgSymbol orgSymbol) {
        if (orgSymbol == null) {
            this.removeExtension(OrgSymbol.class);
        } else {
            this.setExtension(orgSymbol);
        }
    }

    public boolean hasOrgSymbol() {
        return this.hasExtension(OrgSymbol.class);
    }

    public OrgTitle getOrgTitle() {
        return this.getExtension(OrgTitle.class);
    }

    public void setOrgTitle(OrgTitle orgTitle) {
        if (orgTitle == null) {
            this.removeExtension(OrgTitle.class);
        } else {
            this.setExtension(orgTitle);
        }
    }

    public boolean hasOrgTitle() {
        return this.hasExtension(OrgTitle.class);
    }

    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.throwExceptionIfImmutable();
        this.primary = primary;
    }

    public boolean hasPrimary() {
        return this.getPrimary() != null;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.throwExceptionIfImmutable();
        this.rel = rel;
    }

    public boolean hasRel() {
        return this.getRel() != null;
    }

    public Where getWhere() {
        return this.getExtension(Where.class);
    }

    public void setWhere(Where where) {
        if (where == null) {
            this.removeExtension(Where.class);
        } else {
            this.setExtension(where);
        }
    }

    public boolean hasWhere() {
        return this.hasExtension(Where.class);
    }

    @Override
    protected void validate() {
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Organization.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.put(LABEL, this.label);
        generator.put(PRIMARY, this.primary);
        generator.put(REL, this.rel);
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.label = helper.consume(LABEL, false);
        this.primary = helper.consumeBoolean(PRIMARY, false);
        this.rel = helper.consume(REL, false);
    }

    public String toString() {
        return "{Organization label=" + this.label + " primary=" + this.primary + " rel=" + this.rel + "}";
    }

    public static final class Rel {
        public static final String OTHER = "http://schemas.google.com/g/2005#other";
        public static final String WORK = "http://schemas.google.com/g/2005#work";
    }
}

