/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.metahistory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import net.java.sip.communicator.service.callhistory.CallHistoryService;
import net.java.sip.communicator.service.callhistory.CallPeerRecord;
import net.java.sip.communicator.service.callhistory.CallRecord;
import net.java.sip.communicator.service.callhistory.event.CallHistorySearchProgressListener;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.filehistory.FileHistoryService;
import net.java.sip.communicator.service.filehistory.FileRecord;
import net.java.sip.communicator.service.history.event.HistorySearchProgressListener;
import net.java.sip.communicator.service.metahistory.MetaHistoryService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.msghistory.event.MessageHistorySearchProgressListener;
import net.java.sip.communicator.service.msghistory.event.ProgressEvent;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MetaHistoryServiceImpl
implements MetaHistoryService,
ServiceListener {
    private static final Logger logger = Logger.getLogger(MetaHistoryServiceImpl.class);
    private BundleContext bundleContext = null;
    private Hashtable<String, Object> services = new Hashtable();
    private final List<HistorySearchProgressListener> progressListeners = new ArrayList<HistorySearchProgressListener>();

    @Override
    public Collection<Object> findByStartDate(String[] services, Object descriptor, Date startDate) throws RuntimeException {
        MessageProgressWrapper listenWrapper = new MessageProgressWrapper(services.length);
        TreeSet<Object> result = new TreeSet<Object>(new RecordsComparator());
        for (int i = 0; i < services.length; ++i) {
            String name = services[i];
            Object serv = this.getService(name);
            if (serv instanceof MessageHistoryService) {
                MessageHistoryService mhs = (MessageHistoryService)serv;
                listenWrapper.setIx(i);
                mhs.addSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                if (descriptor instanceof MetaContact) {
                    result.addAll(mhs.findByStartDate((MetaContact)descriptor, startDate));
                } else if (descriptor instanceof ChatRoom) {
                    result.addAll(mhs.findByStartDate((ChatRoom)descriptor, startDate));
                }
                mhs.removeSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                continue;
            }
            if (serv instanceof FileHistoryService && descriptor instanceof MetaContact) {
                result.addAll(((FileHistoryService)serv).findByStartDate((MetaContact)descriptor, startDate));
                continue;
            }
            if (!(serv instanceof CallHistoryService)) continue;
            CallHistoryService chs = (CallHistoryService)serv;
            listenWrapper.setIx(i);
            chs.addSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
            result.addAll(chs.findByStartDate(startDate));
            chs.removeSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
        }
        listenWrapper.fireLastProgress(startDate, null, null);
        return result;
    }

    @Override
    public Collection<Object> findByEndDate(String[] services, Object descriptor, Date endDate) throws RuntimeException {
        MessageProgressWrapper listenWrapper = new MessageProgressWrapper(services.length);
        TreeSet<Object> result = new TreeSet<Object>(new RecordsComparator());
        for (int i = 0; i < services.length; ++i) {
            String name = services[i];
            Object serv = this.getService(name);
            if (serv instanceof MessageHistoryService) {
                MessageHistoryService mhs = (MessageHistoryService)serv;
                listenWrapper.setIx(i);
                mhs.addSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                if (descriptor instanceof MetaContact) {
                    result.addAll(mhs.findByEndDate((MetaContact)descriptor, endDate));
                } else if (descriptor instanceof ChatRoom) {
                    result.addAll(mhs.findByEndDate((ChatRoom)descriptor, endDate));
                }
                mhs.removeSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                continue;
            }
            if (serv instanceof FileHistoryService && descriptor instanceof MetaContact) {
                result.addAll(((FileHistoryService)serv).findByEndDate((MetaContact)descriptor, endDate));
                continue;
            }
            if (!(serv instanceof CallHistoryService)) continue;
            CallHistoryService chs = (CallHistoryService)serv;
            listenWrapper.setIx(i);
            chs.addSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
            result.addAll(chs.findByEndDate(endDate));
            chs.removeSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
        }
        listenWrapper.fireLastProgress(null, endDate, null);
        return result;
    }

    @Override
    public Collection<Object> findByPeriod(String[] services, Object descriptor, Date startDate, Date endDate) throws RuntimeException {
        MessageProgressWrapper listenWrapper = new MessageProgressWrapper(services.length);
        LinkedList<Object> result = new LinkedList<Object>();
        for (int i = 0; i < services.length; ++i) {
            String name = services[i];
            Object serv = this.getService(name);
            if (serv instanceof MessageHistoryService) {
                MessageHistoryService mhs = (MessageHistoryService)serv;
                listenWrapper.setIx(i);
                mhs.addSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                if (descriptor instanceof MetaContact) {
                    result.addAll(mhs.findByPeriod((MetaContact)descriptor, startDate, endDate));
                } else if (descriptor instanceof ChatRoom) {
                    result.addAll(mhs.findByPeriod((ChatRoom)descriptor, startDate, endDate));
                }
                mhs.removeSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                continue;
            }
            if (serv instanceof FileHistoryService && descriptor instanceof MetaContact) {
                result.addAll(((FileHistoryService)serv).findByPeriod((MetaContact)descriptor, startDate, endDate));
                continue;
            }
            if (!(serv instanceof CallHistoryService)) continue;
            CallHistoryService chs = (CallHistoryService)serv;
            listenWrapper.setIx(i);
            chs.addSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
            result.addAll(chs.findByPeriod(startDate, endDate));
            chs.removeSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
        }
        listenWrapper.fireLastProgress(startDate, endDate, null);
        Collections.sort(result, new RecordsComparator());
        return result;
    }

    @Override
    public Collection<Object> findByPeriod(String[] services, Object descriptor, Date startDate, Date endDate, String[] keywords) throws RuntimeException {
        return this.findByPeriod(services, descriptor, startDate, endDate, keywords, false);
    }

    @Override
    public Collection<Object> findByPeriod(String[] services, Object descriptor, Date startDate, Date endDate, String[] keywords, boolean caseSensitive) throws RuntimeException {
        MessageProgressWrapper listenWrapper = new MessageProgressWrapper(services.length);
        TreeSet<Object> result = new TreeSet<Object>(new RecordsComparator());
        for (int i = 0; i < services.length; ++i) {
            String name = services[i];
            Object serv = this.getService(name);
            if (serv instanceof MessageHistoryService) {
                MessageHistoryService mhs = (MessageHistoryService)serv;
                listenWrapper.setIx(i);
                mhs.addSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                if (descriptor instanceof MetaContact) {
                    result.addAll(mhs.findByPeriod((MetaContact)descriptor, startDate, endDate, keywords, caseSensitive));
                } else if (descriptor instanceof ChatRoom) {
                    result.addAll(mhs.findByPeriod((ChatRoom)descriptor, startDate, endDate, keywords, caseSensitive));
                }
                mhs.removeSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                continue;
            }
            if (serv instanceof FileHistoryService && descriptor instanceof MetaContact) {
                result.addAll(((FileHistoryService)serv).findByPeriod((MetaContact)descriptor, startDate, endDate, keywords, caseSensitive));
                continue;
            }
            if (!(serv instanceof CallHistoryService)) continue;
            CallHistoryService chs = (CallHistoryService)serv;
            listenWrapper.setIx(i);
            chs.addSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
            Collection cs = chs.findByPeriod(startDate, endDate);
            for (CallRecord callRecord : cs) {
                if (!this.matchCallPeer(callRecord.getPeerRecords(), keywords, caseSensitive)) continue;
                result.add(callRecord);
            }
            chs.removeSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
        }
        listenWrapper.fireLastProgress(startDate, endDate, keywords);
        return result;
    }

    @Override
    public Collection<Object> findByKeyword(String[] services, Object descriptor, String keyword) throws RuntimeException {
        return this.findByKeyword(services, descriptor, keyword, false);
    }

    @Override
    public Collection<Object> findByKeyword(String[] services, Object descriptor, String keyword, boolean caseSensitive) throws RuntimeException {
        return this.findByKeywords(services, descriptor, new String[]{keyword}, caseSensitive);
    }

    @Override
    public Collection<Object> findByKeywords(String[] services, Object descriptor, String[] keywords) throws RuntimeException {
        return this.findByKeywords(services, descriptor, keywords, false);
    }

    @Override
    public Collection<Object> findByKeywords(String[] services, Object descriptor, String[] keywords, boolean caseSensitive) throws RuntimeException {
        MessageProgressWrapper listenWrapper = new MessageProgressWrapper(services.length);
        TreeSet<Object> result = new TreeSet<Object>(new RecordsComparator());
        for (int i = 0; i < services.length; ++i) {
            String name = services[i];
            Object serv = this.getService(name);
            if (serv instanceof MessageHistoryService) {
                MessageHistoryService mhs = (MessageHistoryService)serv;
                listenWrapper.setIx(i);
                mhs.addSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                if (descriptor instanceof MetaContact) {
                    result.addAll(mhs.findByKeywords((MetaContact)descriptor, keywords, caseSensitive));
                } else if (descriptor instanceof ChatRoom) {
                    result.addAll(mhs.findByKeywords((ChatRoom)descriptor, keywords, caseSensitive));
                }
                mhs.removeSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                continue;
            }
            if (serv instanceof FileHistoryService && descriptor instanceof MetaContact) {
                result.addAll(((FileHistoryService)serv).findByKeywords((MetaContact)descriptor, keywords, caseSensitive));
                continue;
            }
            if (!(serv instanceof CallHistoryService)) continue;
            CallHistoryService chs = (CallHistoryService)serv;
            listenWrapper.setIx(i);
            chs.addSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
            Collection cs = chs.findByEndDate(new Date());
            for (CallRecord callRecord : cs) {
                if (!this.matchCallPeer(callRecord.getPeerRecords(), keywords, caseSensitive)) continue;
                result.add(callRecord);
            }
            chs.removeSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
        }
        listenWrapper.fireLastProgress(null, null, keywords);
        return result;
    }

    @Override
    public Collection<Object> findLast(String[] services, Object descriptor, int count) throws RuntimeException {
        MessageProgressWrapper listenWrapper = new MessageProgressWrapper(services.length);
        TreeSet<Object> result = new TreeSet<Object>(new RecordsComparator());
        for (int i = 0; i < services.length; ++i) {
            String name = services[i];
            Object serv = this.getService(name);
            if (serv instanceof MessageHistoryService) {
                MessageHistoryService mhs = (MessageHistoryService)serv;
                listenWrapper.setIx(i);
                mhs.addSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                if (descriptor instanceof MetaContact) {
                    result.addAll(mhs.findLast((MetaContact)descriptor, count));
                } else if (descriptor instanceof ChatRoom) {
                    result.addAll(mhs.findLast((ChatRoom)descriptor, count));
                }
                mhs.removeSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                continue;
            }
            if (serv instanceof FileHistoryService && descriptor instanceof MetaContact) {
                result.addAll(((FileHistoryService)serv).findLast((MetaContact)descriptor, count));
                continue;
            }
            if (!(serv instanceof CallHistoryService)) continue;
            CallHistoryService chs = (CallHistoryService)serv;
            listenWrapper.setIx(i);
            chs.addSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
            result.addAll(chs.findLast(count));
            chs.removeSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
        }
        listenWrapper.fireLastProgress(null, null, null);
        LinkedList<Object> resultAsList = new LinkedList<Object>(result);
        int startIndex = resultAsList.size() - count;
        if (startIndex < 0) {
            startIndex = 0;
        }
        return resultAsList.subList(startIndex, resultAsList.size());
    }

    @Override
    public Collection<Object> findFirstMessagesAfter(String[] services, Object descriptor, Date date, int count) throws RuntimeException {
        MessageProgressWrapper listenWrapper = new MessageProgressWrapper(services.length);
        TreeSet<Object> result = new TreeSet<Object>(new RecordsComparator());
        for (int i = 0; i < services.length; ++i) {
            String name = services[i];
            Object serv = this.getService(name);
            if (serv instanceof MessageHistoryService) {
                MessageHistoryService mhs = (MessageHistoryService)serv;
                listenWrapper.setIx(i);
                mhs.addSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                if (descriptor instanceof MetaContact) {
                    result.addAll(mhs.findFirstMessagesAfter((MetaContact)descriptor, date, count));
                } else if (descriptor instanceof ChatRoom) {
                    result.addAll(mhs.findFirstMessagesAfter((ChatRoom)descriptor, date, count));
                }
                mhs.removeSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                continue;
            }
            if (serv instanceof FileHistoryService && descriptor instanceof MetaContact) {
                result.addAll(((FileHistoryService)serv).findFirstRecordsAfter((MetaContact)descriptor, date, count));
                continue;
            }
            if (!(serv instanceof CallHistoryService)) continue;
            CallHistoryService chs = (CallHistoryService)serv;
            listenWrapper.setIx(i);
            chs.addSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
            Collection col = chs.findByStartDate(date);
            if (col.size() > count) {
                LinkedList l = new LinkedList(col);
                Collections.sort(l, new RecordsComparator());
                result.addAll(l.subList(0, count));
            } else {
                result.addAll(col);
            }
            chs.removeSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
        }
        listenWrapper.fireLastProgress(date, null, null);
        LinkedList<Object> resultAsList = new LinkedList<Object>(result);
        int toIndex = count;
        if (toIndex > resultAsList.size()) {
            toIndex = resultAsList.size();
        }
        return resultAsList.subList(0, toIndex);
    }

    @Override
    public Collection<Object> findLastMessagesBefore(String[] services, Object descriptor, Date date, int count) throws RuntimeException {
        MessageProgressWrapper listenWrapper = new MessageProgressWrapper(services.length);
        TreeSet<Object> result = new TreeSet<Object>(new RecordsComparator());
        for (int i = 0; i < services.length; ++i) {
            String name = services[i];
            Object serv = this.getService(name);
            if (serv instanceof MessageHistoryService) {
                MessageHistoryService mhs = (MessageHistoryService)serv;
                listenWrapper.setIx(i);
                mhs.addSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                if (descriptor instanceof MetaContact) {
                    result.addAll(mhs.findLastMessagesBefore((MetaContact)descriptor, date, count));
                } else if (descriptor instanceof ChatRoom) {
                    result.addAll(mhs.findLastMessagesBefore((ChatRoom)descriptor, date, count));
                }
                mhs.removeSearchProgressListener((MessageHistorySearchProgressListener)listenWrapper);
                continue;
            }
            if (serv instanceof FileHistoryService && descriptor instanceof MetaContact) {
                result.addAll(((FileHistoryService)serv).findLastRecordsBefore((MetaContact)descriptor, date, count));
                continue;
            }
            if (!(serv instanceof CallHistoryService)) continue;
            CallHistoryService chs = (CallHistoryService)serv;
            listenWrapper.setIx(i);
            chs.addSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
            Collection col = chs.findByEndDate(date);
            if (col.size() > count) {
                LinkedList l = new LinkedList(col);
                result.addAll(l.subList(l.size() - count, l.size()));
            } else {
                result.addAll(col);
            }
            chs.removeSearchProgressListener((CallHistorySearchProgressListener)listenWrapper);
        }
        listenWrapper.fireLastProgress(date, null, null);
        LinkedList<Object> resultAsList = new LinkedList<Object>(result);
        int startIndex = resultAsList.size() - count;
        if (startIndex < 0) {
            startIndex = 0;
        }
        return resultAsList.subList(startIndex, resultAsList.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSearchProgressListener(HistorySearchProgressListener listener) {
        List<HistorySearchProgressListener> list = this.progressListeners;
        synchronized (list) {
            if (!this.progressListeners.contains(listener)) {
                this.progressListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSearchProgressListener(HistorySearchProgressListener listener) {
        List<HistorySearchProgressListener> list = this.progressListeners;
        synchronized (list) {
            this.progressListeners.remove(listener);
        }
    }

    private Object getService(String name) {
        Object serv = this.services.get(name);
        if (serv == null) {
            ServiceReference refHistory = this.bundleContext.getServiceReference(name);
            serv = this.bundleContext.getService(refHistory);
        }
        return serv;
    }

    private boolean matchAnyCallPeer(List<CallPeerRecord> cps, String[] keywords, boolean caseSensitive) {
        for (CallPeerRecord callPeer : cps) {
            for (String k : keywords) {
                if (caseSensitive && callPeer.getPeerAddress().contains(k)) {
                    return true;
                }
                if (!callPeer.getPeerAddress().toLowerCase().contains(k.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchCallPeer(List<CallPeerRecord> cps, String[] keywords, boolean caseSensitive) {
        Iterator<CallPeerRecord> iter = cps.iterator();
        while (iter.hasNext()) {
            boolean match = false;
            CallPeerRecord callPeer = iter.next();
            for (int i = 0; i < keywords.length; ++i) {
                String k = keywords[i];
                if (caseSensitive) {
                    if (callPeer.getPeerAddress().contains(k)) {
                        match = true;
                        continue;
                    }
                    match = false;
                    break;
                }
                if (callPeer.getPeerAddress().toLowerCase().contains(k.toLowerCase())) {
                    match = true;
                    continue;
                }
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        if (serviceEvent.getType() == 4) {
            Object sService = this.bundleContext.getService(serviceEvent.getServiceReference());
            this.services.remove(sService.getClass().getName());
        }
    }

    public void start(BundleContext bc) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting the call history implementation.");
        }
        this.bundleContext = bc;
        this.services.clear();
        bc.addServiceListener((ServiceListener)this);
    }

    public void stop(BundleContext bc) {
        bc.removeServiceListener((ServiceListener)this);
        this.services.clear();
    }

    private class MessageProgressWrapper
    implements MessageHistorySearchProgressListener,
    CallHistorySearchProgressListener {
        private final int count;
        private int ix;

        public MessageProgressWrapper(int count) {
            this.count = count;
        }

        public void setIx(int ix) {
            this.ix = ix;
        }

        private void fireProgress(int origProgress, int maxVal, Date startDate, Date endDate, String[] keywords) {
            net.java.sip.communicator.service.history.event.ProgressEvent ev = new net.java.sip.communicator.service.history.event.ProgressEvent((Object)MetaHistoryServiceImpl.this, startDate, endDate, keywords);
            double part1 = (double)origProgress / ((double)maxVal * (double)this.count);
            double convProgress = part1 * 1000.0 + (double)(this.ix * 1000 / this.count);
            ev.setProgress((int)convProgress);
            this.fireEvent(ev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireEvent(net.java.sip.communicator.service.history.event.ProgressEvent ev) {
            ArrayList listeners;
            List list = MetaHistoryServiceImpl.this.progressListeners;
            synchronized (list) {
                listeners = new ArrayList(MetaHistoryServiceImpl.this.progressListeners);
            }
            for (HistorySearchProgressListener listener : listeners) {
                listener.progressChanged(ev);
            }
        }

        public void fireLastProgress(Date startDate, Date endDate, String[] keywords) {
            net.java.sip.communicator.service.history.event.ProgressEvent ev = new net.java.sip.communicator.service.history.event.ProgressEvent((Object)MetaHistoryServiceImpl.this, startDate, endDate, keywords);
            ev.setProgress(1000);
            this.fireEvent(ev);
        }

        public void progressChanged(ProgressEvent evt) {
            this.fireProgress(evt.getProgress(), 1000, evt.getStartDate(), evt.getEndDate(), evt.getKeywords());
        }

        public void progressChanged(net.java.sip.communicator.service.callhistory.event.ProgressEvent evt) {
            this.fireProgress(evt.getProgress(), 1000, evt.getStartDate(), evt.getEndDate(), null);
        }
    }

    private static class RecordsComparator
    implements Comparator<Object> {
        private RecordsComparator() {
        }

        private Date getDate(Object o) {
            Date date = new Date(0L);
            if (o instanceof MessageDeliveredEvent) {
                date = ((MessageDeliveredEvent)o).getTimestamp();
            } else if (o instanceof MessageReceivedEvent) {
                date = ((MessageReceivedEvent)o).getTimestamp();
            } else if (o instanceof ChatRoomMessageDeliveredEvent) {
                date = ((ChatRoomMessageDeliveredEvent)o).getTimestamp();
            } else if (o instanceof ChatRoomMessageReceivedEvent) {
                date = ((ChatRoomMessageReceivedEvent)o).getTimestamp();
            } else if (o instanceof CallRecord) {
                date = ((CallRecord)o).getStartTime();
            } else if (o instanceof FileRecord) {
                date = ((FileRecord)o).getDate();
            }
            return date;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Date date1 = this.getDate(o1);
            Date date2 = this.getDate(o2);
            return date1.compareTo(date2);
        }
    }
}

