/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.otr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.java.sip.communicator.plugin.otr.OtrActivator;
import org.bouncycastle.util.encoders.Base64;

public class OtrConfigurator {
    private String getXmlFriendlyString(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        if (Character.isDigit(s.charAt(0))) {
            s = "p" + s;
        }
        char[] cId = new char[s.length()];
        for (int i = 0; i < cId.length; ++i) {
            int c = s.charAt(i);
            cId[i] = Character.isLetterOrDigit((char)c) ? c : 95;
        }
        return new String(cId);
    }

    private String getID(String id) {
        return "net.java.sip.communicator.plugin.otr." + this.getXmlFriendlyString(id);
    }

    public byte[] getPropertyBytes(String id) {
        String value = OtrActivator.configService.getString(this.getID(id));
        return value == null ? null : Base64.decode((byte[])value.getBytes());
    }

    public boolean getPropertyBoolean(String id, boolean defaultValue) {
        return OtrActivator.configService.getBoolean(this.getID(id), defaultValue);
    }

    public void setProperty(String id, byte[] value) {
        String valueToStore = new String(Base64.encode((byte[])value));
        OtrActivator.configService.setProperty(this.getID(id), (Object)valueToStore);
    }

    public void setProperty(String id, Object value) {
        OtrActivator.configService.setProperty(this.getID(id), value);
    }

    public void removeProperty(String id) {
        OtrActivator.configService.removeProperty(this.getID(id));
    }

    public int getPropertyInt(String id, int defaultValue) {
        return OtrActivator.configService.getInt(this.getID(id), defaultValue);
    }

    public void appendProperty(String id, Object value) {
        Object oldValue = OtrActivator.configService.getProperty(this.getID(id));
        String newValue = oldValue == null ? value.toString() : oldValue + "," + value;
        this.setProperty(id, newValue);
    }

    public List<String> getAppendedProperties(String id) {
        String listProperties = (String)OtrActivator.configService.getProperty(this.getID(id));
        if (listProperties == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(listProperties.split(","));
    }
}

