/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.twitpic;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;

public class ReplacementServiceTwitpicImpl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceTwitpicImpl.class);
    public static final String TWITPIC_PATTERN = "http:\\/\\/(?:www\\.)?twitpic\\.com\\/([^\\/<]*)";
    public static final String TWITPIC_CONFIG_LABEL = "TwitPic";
    public static final String SOURCE_NAME = "TWITPIC";

    public ReplacementServiceTwitpicImpl() {
        logger.trace((Object)"Creating a Twitpic Source.");
    }

    public String getReplacement(String sourceString) {
        Pattern p = Pattern.compile("\\.com\\/([^\\/<]*)", 34);
        Matcher m = p.matcher(sourceString);
        String thumbUrl = sourceString;
        while (m.find()) {
            thumbUrl = "http://twitpic.com/show/thumb/" + m.group(1);
        }
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(thumbUrl).openConnection();
            con.setInstanceFollowRedirects(false);
            con.connect();
            int responseCode = con.getResponseCode();
            if (responseCode == 302 || responseCode == 301) {
                return con.getHeaderField("Location");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return thumbUrl;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return TWITPIC_PATTERN;
    }
}

