/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smackx.packet.PrivateData;

public class DefaultPrivateData
implements PrivateData {
    private String elementName;
    private String namespace;
    private Map map;

    public DefaultPrivateData(String elementName, String namespace) {
        this.elementName = elementName;
        this.namespace = namespace;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.elementName).append(" xmlns=\"").append(this.namespace).append("\">");
        Iterator i = this.getNames();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = this.getValue(name);
            buf.append("<").append(name).append(">");
            buf.append(value);
            buf.append("</").append(name).append(">");
        }
        buf.append("</").append(this.elementName).append(">");
        return buf.toString();
    }

    public synchronized Iterator getNames() {
        if (this.map == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return Collections.unmodifiableMap(new HashMap(this.map)).keySet().iterator();
    }

    public synchronized String getValue(String name) {
        if (this.map == null) {
            return null;
        }
        return (String)this.map.get(name);
    }

    public synchronized void setValue(String name, String value) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(name, value);
    }
}

