/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;

public class TransparentBackground
extends JComponent {
    private static final long serialVersionUID = 1L;
    private BufferedImage background;
    private final Robot robot;
    private final Window window;

    public TransparentBackground(Window window) {
        Robot rbt;
        this.window = window;
        try {
            rbt = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
            rbt = null;
        }
        this.robot = rbt;
    }

    public void updateBackground(int x, int y) {
        this.background = this.robot.createScreenCapture(new Rectangle(x, y, x + this.window.getWidth(), y + this.window.getHeight()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        g = g.create();
        try {
            AntialiasingManager.activateAntialiasing((Graphics)g);
            Graphics2D g2 = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            g2.drawImage((Image)this.background, 0, 0, null);
            g2.setColor(new Color(255, 255, 255, 180));
            g2.fillRoundRect(0, 0, width, height, 10, 10);
            g2.setColor(Constants.BORDER_COLOR);
            g2.drawRoundRect(0, 0, width - 1, height - 1, 10, 10);
        }
        finally {
            g.dispose();
        }
    }
}

