/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public class DNSCache
extends AbstractMap<String, List<? extends DNSEntry>> {
    private transient Set<Map.Entry<String, List<? extends DNSEntry>>> _entrySet = null;
    public static final DNSCache EmptyCache = new _EmptyCache();

    public DNSCache() {
        this(1024);
    }

    public DNSCache(DNSCache dNSCache) {
        this(dNSCache != null ? dNSCache.size() : 1024);
        if (dNSCache != null) {
            this.putAll(dNSCache);
        }
    }

    public DNSCache(int n) {
        this._entrySet = new HashSet<Map.Entry<String, List<? extends DNSEntry>>>(n);
    }

    @Override
    public Set<Map.Entry<String, List<? extends DNSEntry>>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new HashSet<Map.Entry<String, List<? extends DNSEntry>>>();
        }
        return this._entrySet;
    }

    protected Map.Entry<String, List<? extends DNSEntry>> getEntry(String string) {
        String string2 = string != null ? string.trim().toLowerCase() : null;
        for (Map.Entry<String, List<? extends DNSEntry>> entry : this.entrySet()) {
            if (!(string2 != null ? string2.equals(entry.getKey()) : entry.getKey() == null)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends DNSEntry> put(String string, List<? extends DNSEntry> list) {
        DNSCache dNSCache = this;
        synchronized (dNSCache) {
            List<? extends DNSEntry> list2 = null;
            Map.Entry<String, List<? extends DNSEntry>> entry = this.getEntry(string);
            if (entry != null) {
                list2 = entry.setValue(list);
            } else {
                this.entrySet().add(new _CacheEntry(string, list));
            }
            return list2;
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new DNSCache(this);
    }

    public synchronized Collection<DNSEntry> allValues() {
        ArrayList<DNSEntry> arrayList = new ArrayList<DNSEntry>();
        for (List list : this.values()) {
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public synchronized Collection<? extends DNSEntry> getDNSEntryList(String string) {
        Collection<? extends DNSEntry> collection = this._getDNSEntryList(string);
        collection = collection != null ? new ArrayList<DNSEntry>(collection) : Collections.emptyList();
        return collection;
    }

    private Collection<? extends DNSEntry> _getDNSEntryList(String string) {
        return (Collection)this.get(string != null ? string.toLowerCase() : null);
    }

    public synchronized DNSEntry getDNSEntry(DNSEntry dNSEntry) {
        Collection<? extends DNSEntry> collection;
        DNSEntry dNSEntry2 = null;
        if (dNSEntry != null && (collection = this._getDNSEntryList(dNSEntry.getKey())) != null) {
            for (DNSEntry dNSEntry3 : collection) {
                if (!dNSEntry3.isSameEntry(dNSEntry)) continue;
                dNSEntry2 = dNSEntry3;
                break;
            }
        }
        return dNSEntry2;
    }

    public synchronized DNSEntry getDNSEntry(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass) {
        DNSEntry dNSEntry = null;
        Collection<? extends DNSEntry> collection = this._getDNSEntryList(string);
        if (collection != null) {
            for (DNSEntry dNSEntry2 : collection) {
                if (!dNSEntry2.getRecordType().equals((Object)dNSRecordType) || DNSRecordClass.CLASS_ANY != dNSRecordClass && !dNSEntry2.getRecordClass().equals((Object)dNSRecordClass)) continue;
                dNSEntry = dNSEntry2;
                break;
            }
        }
        return dNSEntry;
    }

    public synchronized Collection<? extends DNSEntry> getDNSEntryList(String string, DNSRecordType dNSRecordType, DNSRecordClass dNSRecordClass) {
        Collection<? extends DNSEntry> collection = this._getDNSEntryList(string);
        if (collection != null) {
            collection = new ArrayList<DNSEntry>(collection);
            Iterator<? extends DNSEntry> iterator = collection.iterator();
            while (iterator.hasNext()) {
                DNSEntry dNSEntry = iterator.next();
                if (dNSEntry.getRecordType().equals((Object)dNSRecordType) && (DNSRecordClass.CLASS_ANY == dNSRecordClass || dNSEntry.getRecordClass().equals((Object)dNSRecordClass))) continue;
                iterator.remove();
            }
        } else {
            collection = Collections.emptyList();
        }
        return collection;
    }

    public synchronized boolean addDNSEntry(DNSEntry dNSEntry) {
        boolean bl = false;
        if (dNSEntry != null) {
            Map.Entry<String, List<? extends DNSEntry>> entry = this.getEntry(dNSEntry.getKey());
            ArrayList<DNSEntry> arrayList = null;
            arrayList = entry != null ? new ArrayList(entry.getValue()) : new ArrayList<DNSEntry>();
            arrayList.add(dNSEntry);
            if (entry != null) {
                entry.setValue(arrayList);
            } else {
                this.entrySet().add(new _CacheEntry(dNSEntry.getKey(), arrayList));
            }
            bl = true;
        }
        return bl;
    }

    public synchronized boolean removeDNSEntry(DNSEntry dNSEntry) {
        Map.Entry<String, List<? extends DNSEntry>> entry;
        boolean bl = false;
        if (dNSEntry != null && (entry = this.getEntry(dNSEntry.getKey())) != null) {
            bl = entry.getValue().remove(dNSEntry);
            if (entry.getValue().isEmpty()) {
                this.entrySet().remove(entry);
            }
        }
        return bl;
    }

    public synchronized boolean replaceDNSEntry(DNSEntry dNSEntry, DNSEntry dNSEntry2) {
        boolean bl = false;
        if (dNSEntry != null && dNSEntry2 != null && dNSEntry.getKey().equals(dNSEntry2.getKey())) {
            Map.Entry<String, List<? extends DNSEntry>> entry = this.getEntry(dNSEntry.getKey());
            ArrayList<DNSEntry> arrayList = null;
            arrayList = entry != null ? new ArrayList(entry.getValue()) : new ArrayList<DNSEntry>();
            arrayList.remove(dNSEntry2);
            arrayList.add(dNSEntry);
            if (entry != null) {
                entry.setValue(arrayList);
            } else {
                this.entrySet().add(new _CacheEntry(dNSEntry.getKey(), arrayList));
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("\t---- cache ----");
        for (Map.Entry<String, List<? extends DNSEntry>> entry : this.entrySet()) {
            stringBuffer.append("\n\t\t");
            stringBuffer.append(entry.toString());
        }
        return stringBuffer.toString();
    }

    protected static class _CacheEntry
    implements Map.Entry<String, List<? extends DNSEntry>> {
        private List<? extends DNSEntry> _value;
        private String _key;

        protected _CacheEntry(String string, List<? extends DNSEntry> list) {
            this._key = string != null ? string.trim().toLowerCase() : null;
            this._value = list;
        }

        protected _CacheEntry(Map.Entry<String, List<? extends DNSEntry>> entry) {
            if (entry instanceof _CacheEntry) {
                this._key = ((_CacheEntry)entry).getKey();
                this._value = ((_CacheEntry)entry).getValue();
            }
        }

        @Override
        public String getKey() {
            return this._key != null ? this._key : "";
        }

        @Override
        public List<? extends DNSEntry> getValue() {
            return this._value;
        }

        @Override
        public List<? extends DNSEntry> setValue(List<? extends DNSEntry> list) {
            List<? extends DNSEntry> list2 = this._value;
            this._value = list;
            return list2;
        }

        public boolean isEmpty() {
            return this.getValue().isEmpty();
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return this.getKey().equals(((Map.Entry)object).getKey()) && this.getValue().equals(((Map.Entry)object).getValue());
        }

        @Override
        public int hashCode() {
            return this._key == null ? 0 : this._key.hashCode();
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("\n\t\tname '");
            stringBuffer.append(this._key);
            stringBuffer.append("' ");
            if (this._value != null && !this._value.isEmpty()) {
                for (DNSEntry dNSEntry : this._value) {
                    stringBuffer.append("\n\t\t\t");
                    stringBuffer.append(dNSEntry.toString());
                }
            } else {
                stringBuffer.append(" no entries");
            }
            return stringBuffer.toString();
        }
    }

    static final class _EmptyCache
    extends DNSCache {
        _EmptyCache() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object object) {
            return false;
        }

        @Override
        public boolean containsValue(Object object) {
            return false;
        }

        @Override
        public List<DNSEntry> get(Object object) {
            return null;
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<List<? extends DNSEntry>> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<String, List<? extends DNSEntry>>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Map && ((Map)object).size() == 0;
        }

        @Override
        public List<? extends DNSEntry> put(String string, List<? extends DNSEntry> list) {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

