/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import lcmc.data.Host;
import lcmc.gui.dialog.ConfigDialog;
import lcmc.gui.resources.Info;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

class Logs
extends ConfigDialog {
    private static final long serialVersionUID = 1L;
    private final JTextPane logTextArea = new JTextPane();
    private final Map<String, JCheckBox> checkBoxMap = new HashMap<String, JCheckBox>();
    private final MyButton refreshBtn = new MyButton(Tools.getString("Dialog.Logs.RefreshButton"));
    private final Lock mRefreshLock = new ReentrantLock();

    Logs() {
    }

    protected String logFileCommand() {
        return "Logs.hbLog";
    }

    protected final String grepPattern() {
        StringBuilder pattern = new StringBuilder(40);
        pattern.append('\'');
        Map<String, String> patternMap = this.getPatternMap();
        boolean first = true;
        for (String name : patternMap.keySet()) {
            if (!this.checkBoxMap.get(name).isSelected()) continue;
            if (!first) {
                pattern.append(".*");
            }
            pattern.append(patternMap.get(name));
            first = false;
        }
        pattern.append('\'');
        return pattern.toString();
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableAllComponents(false);
        this.refreshLogsThread();
    }

    private void refreshLogsThread() {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!Logs.this.mRefreshLock.tryLock()) {
                    return;
                }
                try {
                    Logs.this.refreshLogs();
                }
                finally {
                    Logs.this.mRefreshLock.unlock();
                }
            }
        });
        thread.start();
    }

    protected Host[] getHosts() {
        return new Host[0];
    }

    private void enableAllComponents(final boolean enable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Logs.this.refreshBtn.setEnabled(enable);
                for (String name : Logs.this.checkBoxMap.keySet()) {
                    ((JCheckBox)Logs.this.checkBoxMap.get(name)).setEnabled(enable);
                }
            }
        });
    }

    protected final void refreshLogs() {
        this.enableAllComponents(false);
        Host[] hosts = this.getHosts();
        Thread[] threads = new Thread[hosts.length];
        final String[] texts = new String[hosts.length];
        HashMap<String, String> replaceHash = new HashMap<String, String>();
        replaceHash.put("@GREPPATTERN@", this.grepPattern());
        int i = 0;
        final String stacktrace = Tools.getStackTrace();
        for (final Host host : hosts) {
            final int index = i++;
            final String command = host.getDistCommand(this.logFileCommand(), replaceHash);
            threads[index] = host.execCommandRaw(command, null, new ExecCallback(){

                @Override
                public void done(String ans) {
                    texts[index] = ans;
                }

                @Override
                public void doneError(String ans, int exitCode) {
                    texts[index] = host.getName() + ": " + ans + "\n";
                    Tools.sshError(host, command, ans, stacktrace, exitCode);
                }
            }, false, false, 30000);
        }
        i = 0;
        StringBuilder ans = new StringBuilder("");
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ans.append(texts[i]);
            ++i;
        }
        String[] output = ans.toString().split("\r\n");
        String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        final Pattern p = Pattern.compile("(" + Tools.join("|", months) + ") +(\\d+) +(\\d+):(\\d+):(\\d+).*");
        final HashMap<String, Integer> monthsHash = new HashMap<String, Integer>();
        i = 0;
        for (String m : months) {
            monthsHash.put(m, i);
            ++i;
        }
        Arrays.sort(output, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Matcher m1 = p.matcher(o1);
                Matcher m2 = p.matcher(o2);
                if (m1.matches() && m2.matches()) {
                    int month1 = (Integer)monthsHash.get(m1.group(1));
                    int month2 = (Integer)monthsHash.get(m2.group(1));
                    int day1 = Integer.valueOf(m1.group(2));
                    int day2 = Integer.valueOf(m2.group(2));
                    int hour1 = Integer.valueOf(m1.group(3));
                    int hour2 = Integer.valueOf(m2.group(3));
                    int min1 = Integer.valueOf(m1.group(4));
                    int min2 = Integer.valueOf(m2.group(4));
                    int sec1 = Integer.valueOf(m1.group(5));
                    int sec2 = Integer.valueOf(m2.group(5));
                    if (month1 != month2) {
                        return month1 < month2 ? -1 : 1;
                    }
                    if (day1 != day2) {
                        return day1 < day2 ? -1 : 1;
                    }
                    if (hour1 != hour2) {
                        return hour1 < hour2 ? -1 : 1;
                    }
                    if (min1 != min2) {
                        return min1 < min2 ? -1 : 1;
                    }
                    if (sec1 != sec2) {
                        return sec1 < sec2 ? -1 : 1;
                    }
                }
                return 0;
            }
        });
        this.logTextArea.setText("");
        StyledDocument doc = this.logTextArea.getStyledDocument();
        SimpleAttributeSet color1 = new SimpleAttributeSet();
        SimpleAttributeSet color2 = new SimpleAttributeSet();
        StyleConstants.setForeground(color1, Color.BLACK);
        StyleConstants.setForeground(color2, Color.BLUE);
        SimpleAttributeSet color = null;
        int start = 0;
        int a = 0;
        String prevHost = "";
        for (String line : output) {
            String[] tok = line.split("\\s+");
            if (tok.length > 3) {
                String host = tok[3];
                if (!host.equals(prevHost)) {
                    if (a == 0) {
                        ++a;
                        color = color1;
                    } else {
                        --a;
                        color = color2;
                    }
                }
                prevHost = host;
            }
            SimpleAttributeSet color0 = color;
            int start0 = start;
            try {
                doc.insertString(start0, line + "\n", color0);
            }
            catch (Exception e) {
                Tools.appError("Could not insert line", e);
            }
            this.logTextArea.setCaretPosition(this.logTextArea.getDocument().getLength());
            start = start + line.length() + 1;
        }
        this.enableComponents();
        this.enableAllComponents(true);
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.ClusterLogs.Title");
    }

    @Override
    protected final String getDescription() {
        return "";
    }

    protected final String wordBoundary(String w) {
        return "\\\\<" + w + "\\\\>";
    }

    protected Map<String, String> getPatternMap() {
        return new LinkedHashMap<String, String>();
    }

    protected Set<String> getSelectedSet() {
        return new HashSet<String>();
    }

    private JPanel getGrepChoicesPane() {
        JPanel pane = new JPanel(new FlowLayout(0));
        pane.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Dark"));
        Map<String, String> patternMap = this.getPatternMap();
        for (String name : patternMap.keySet()) {
            JCheckBox cb = new JCheckBox(name, this.getSelectedSet().contains(name));
            cb.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Dark"));
            this.checkBoxMap.put(name, cb);
            cb.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Logs.this.refreshLogsThread();
                }
            });
            pane.add(cb);
        }
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Logs.this.refreshLogsThread();
            }
        });
        pane.add(this.refreshBtn);
        return pane;
    }

    @Override
    protected final JComponent getInputPane() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.setBackground(Tools.getDefaultColor("ConfigDialog.Background.Dark"));
        this.logTextArea.setEditable(false);
        this.logTextArea.setText("loading...");
        pane.add(this.getGrepChoicesPane());
        JScrollPane sp = new JScrollPane(this.logTextArea);
        sp.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        pane.add(sp);
        pane.setMaximumSize(new Dimension(Short.MAX_VALUE, pane.getPreferredSize().height));
        return pane;
    }

    @Override
    protected final ImageIcon icon() {
        return Info.LOGFILE_ICON;
    }
}

