/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.ProxyCheckInstallation;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.DRBD;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

final class ProxyInst
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;
    private final DrbdVolumeInfo drbdVolumeInfo;
    private final WizardDialog origDialog;

    ProxyInst(WizardDialog previousDialog, Host host, DrbdVolumeInfo drbdVolumeInfo, WizardDialog origDialog) {
        super(previousDialog, host);
        this.drbdVolumeInfo = drbdVolumeInfo;
        this.origDialog = origDialog;
    }

    void checkAnswer(String ans, String installMethod) {
        this.nextDialogObject = new ProxyCheckInstallation(this.getPreviousDialog().getPreviousDialog(), this.getHost(), this.drbdVolumeInfo, this.origDialog);
        DRBD.startProxy(this.getHost(), false);
        this.progressBarDone();
        this.answerPaneSetText(Tools.getString("Dialog.Host.ProxyInst.InstOk"));
        this.enableComponents(new JComponent[]{this.buttonClass(this.backButton())});
        this.buttonClass(this.nextButton()).requestFocus();
        if (Tools.getConfigData().getAutoOptionHost("hbinst") != null) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.installProxy();
    }

    private void installProxy() {
        String arch = this.getHost().getDistString("ProxyInst.install." + this.getHost().getArch());
        if (arch == null) {
            arch = this.getHost().getArch();
        }
        final String archString = arch.replaceAll("i686", "i386");
        String installCommand = "ProxyInst.install";
        final String installMethod = this.getHost().getProxyInstallMethod();
        if (installMethod != null) {
            installCommand = "ProxyInst.install." + installMethod;
        }
        this.getHost().execCommandInBash(installCommand, this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                ProxyInst.this.checkAnswer(ans, installMethod);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                ProxyInst.this.printErrorAndRetry(Tools.getString("Dialog.Host.ProxyInst.InstError"), ans, exitCode);
            }
        }, new ConvertCmdCallback(){

            @Override
            public String convert(String command) {
                return command.replaceAll("@ARCH@", archString);
            }
        }, true, SSH.DEFAULT_COMMAND_TIMEOUT_LONG);
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.nextDialogObject == null) {
            return new ProxyCheckInstallation(this, this.getHost(), this.drbdVolumeInfo, this.origDialog);
        }
        return this.nextDialogObject;
    }

    @Override
    protected void finishDialog() {
        super.finishDialog();
        if (this.isPressedFinishButton()) {
            if (this.origDialog != null) {
                this.nextDialogObject = this.origDialog;
                this.setPressedButton(this.nextButton());
            }
            this.getHost().getCluster().addProxyHost(this.getHost());
            if (this.drbdVolumeInfo != null) {
                this.drbdVolumeInfo.getDrbdResourceInfo().resetDrbdResourcePanel();
                this.drbdVolumeInfo.getDrbdInfo().addProxyHostNode(this.getHost());
            }
        }
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.ProxyInst.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.ProxyInst.Description");
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.ProxyInst.Executing")));
        SpringUtilities.makeCompactGrid(pane, 2, 1, 0, 0, 0, 0);
        return pane;
    }

    @Override
    protected final WizardDialog dialogAfterCancel() {
        return this.origDialog;
    }
}

