/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.CheckInstallation;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.gui.dialog.host.DrbdAvailFiles;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public class DrbdLinbitAvailPackages
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private Widget drbdDistCombo = null;
    private Widget drbdKernelDirCombo = null;
    private Widget drbdArchCombo = null;
    private List<String> drbdDistItems = null;
    private List<String> drbdKernelDirItems = null;
    private List<String> drbdArchItems = null;
    private static final String NO_MATCH_STRING = "No Match";
    private static final String NEWLINE = "\\r?\\n";
    private static final int CHOICE_BOX_HEIGHT = 30;

    public DrbdLinbitAvailPackages(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    protected final void availVersions() {
        this.drbdDistCombo.setEnabled(false);
        this.drbdKernelDirCombo.setEnabled(false);
        this.drbdArchCombo.setEnabled(false);
        this.getProgressBar().start(20000);
        SSH.ExecCommandThread t = this.getHost().execCommand("DrbdAvailVersions", null, new ExecCallback(){

            @Override
            public void done(String ans) {
                String[] items = ans.split(DrbdLinbitAvailPackages.NEWLINE);
                DrbdLinbitAvailPackages.this.getHost().setDrbdVersionToInstall(Tools.shellList(items));
                DrbdLinbitAvailPackages.this.availDistributions();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdLinbitAvailPackages.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.NoVersions"), ans, exitCode);
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        this.setCommandThread(t);
    }

    protected final void availDistributions() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DrbdLinbitAvailPackages.this.drbdKernelDirCombo.setEnabled(false);
                DrbdLinbitAvailPackages.this.drbdArchCombo.setEnabled(false);
            }
        });
        SSH.ExecCommandThread t = this.getHost().execCommand("DrbdAvailDistributions", null, new ExecCallback(){

            @Override
            public void done(String ans) {
                ans = "No Match\n" + ans;
                final String[] items = ans.split(DrbdLinbitAvailPackages.NEWLINE);
                DrbdLinbitAvailPackages.this.drbdDistItems = Arrays.asList(items);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdLinbitAvailPackages.this.drbdDistCombo.reloadComboBox(DrbdLinbitAvailPackages.this.getHost().getDistVersion(), items);
                        DrbdLinbitAvailPackages.this.drbdDistCombo.setEnabled(true);
                    }
                });
                DrbdLinbitAvailPackages.this.availKernels();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdLinbitAvailPackages.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.NoDistributions"), ans, exitCode);
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        this.setCommandThread(t);
    }

    protected final void availKernels() {
        String distVersion = this.getHost().getDistVersion();
        if (this.drbdDistItems == null || !this.drbdDistItems.contains(distVersion)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DrbdLinbitAvailPackages.this.drbdKernelDirCombo.reloadComboBox(null, new String[]{DrbdLinbitAvailPackages.NO_MATCH_STRING});
                }
            });
            this.availArchs();
            return;
        }
        SSH.ExecCommandThread t = this.getHost().execCommand("DrbdAvailKernels", null, new ExecCallback(){

            @Override
            public void done(String ans) {
                ans = "No Match\n" + ans;
                final String[] items = ans.split(DrbdLinbitAvailPackages.NEWLINE);
                DrbdLinbitAvailPackages.this.drbdKernelDirItems = Arrays.asList(items);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdLinbitAvailPackages.this.drbdKernelDirCombo.reloadComboBox(DrbdLinbitAvailPackages.this.getHost().getKernelVersion(), items);
                        DrbdLinbitAvailPackages.this.drbdKernelDirCombo.setEnabled(true);
                    }
                });
                DrbdLinbitAvailPackages.this.availArchs();
            }

            @Override
            public void doneError(String ans, int exitCode) {
                Tools.debug(this, "doneError");
                DrbdLinbitAvailPackages.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.NoKernels"), ans, exitCode);
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        this.setCommandThread(t);
    }

    protected final void availArchs() {
        String kernelVersion = this.getHost().getKernelVersion();
        final String arch = this.getHost().getArch();
        if (this.drbdDistItems == null || this.drbdKernelDirItems == null || arch == null || !this.drbdDistItems.contains(this.getHost().getDistVersion()) || !this.drbdKernelDirItems.contains(kernelVersion)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DrbdLinbitAvailPackages.this.drbdArchCombo.reloadComboBox(null, new String[]{DrbdLinbitAvailPackages.NO_MATCH_STRING});
                    DrbdLinbitAvailPackages.this.drbdArchCombo.setEnabled(false);
                }
            });
            this.allDone(null);
            return;
        }
        SSH.ExecCommandThread t = this.getHost().execCommand("DrbdAvailArchs", null, new ExecCallback(){

            @Override
            public void done(String ans) {
                ans = "No Match\n" + ans;
                final String[] items = ans.split(DrbdLinbitAvailPackages.NEWLINE);
                DrbdLinbitAvailPackages.this.drbdArchItems = Arrays.asList(items);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdLinbitAvailPackages.this.drbdArchCombo.reloadComboBox(arch, items);
                        DrbdLinbitAvailPackages.this.drbdArchCombo.setEnabled(true);
                    }
                });
                if (DrbdLinbitAvailPackages.this.drbdArchItems == null) {
                    DrbdLinbitAvailPackages.this.allDone(null);
                } else {
                    DrbdLinbitAvailPackages.this.availVersionsForDist();
                }
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdLinbitAvailPackages.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.NoArchs"), ans, exitCode);
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        this.setCommandThread(t);
    }

    protected final void availVersionsForDist() {
        SSH.ExecCommandThread t = this.getHost().execCommand("DrbdAvailVersionsForDist", null, new ExecCallback(){

            @Override
            public void done(String ans) {
                DrbdLinbitAvailPackages.this.allDone(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdLinbitAvailPackages.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.NoArchs"), ans, exitCode);
            }
        }, null, false, SSH.DEFAULT_COMMAND_TIMEOUT);
        this.setCommandThread(t);
    }

    protected final void allDone(String ans) {
        this.progressBarDone();
        this.enableComponents();
        if (ans == null) {
            StringBuilder errorText = new StringBuilder(80);
            String dist = this.getHost().getDistVersion();
            String kernel = this.getHost().getKernelVersion();
            String arch = this.getHost().getArch();
            if (this.drbdDistItems == null || !this.drbdDistItems.contains(dist)) {
                errorText.append(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.NotAvailable.Dist"));
            } else if (this.drbdKernelDirItems == null || !this.drbdKernelDirItems.contains(kernel)) {
                errorText.append(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.NotAvailable.Kernel"));
            } else if (this.drbdArchItems == null || !this.drbdArchItems.contains(arch)) {
                errorText.append(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.NotAvailable.Arch"));
            }
            errorText.append("\n\n");
            errorText.append(dist);
            errorText.append('\n');
            errorText.append(kernel);
            errorText.append('\n');
            errorText.append(arch);
            this.printErrorAndRetry(errorText.toString());
        } else {
            String[] versions = ans.split(NEWLINE);
            this.getHost().setAvailableDrbdVersions(versions);
            this.answerPaneSetText(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.AvailVersions") + " " + Tools.join(", ", versions));
            if (Tools.getConfigData().getAutoOptionHost("drbdinst") != null) {
                Tools.sleep(1000);
                this.pressNextButton();
            }
        }
        this.addListeners();
    }

    @Override
    protected final void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.availVersions();
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.getHost().isDrbdUpgraded()) {
            return new CheckInstallation(this, this.getHost());
        }
        return new DrbdAvailFiles(this, this.getHost());
    }

    @Override
    protected final String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.Title");
    }

    @Override
    protected final String getDescription() {
        return Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.Description");
    }

    protected final JPanel getChoiceBoxes() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        int maxX = (int)pane.getMaximumSize().getWidth();
        pane.setMaximumSize(new Dimension(maxX, 30));
        this.drbdDistCombo = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, Widget.NO_ITEMS, Widget.NO_REGEXP, 0, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.drbdDistCombo.setEnabled(false);
        pane.add(this.drbdDistCombo);
        this.drbdKernelDirCombo = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, Widget.NO_ITEMS, Widget.NO_REGEXP, 0, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.drbdKernelDirCombo.setEnabled(false);
        pane.add(this.drbdKernelDirCombo);
        this.drbdArchCombo = WidgetFactory.createInstance(Widget.Type.COMBOBOX, Widget.NO_DEFAULT, Widget.NO_ITEMS, Widget.NO_REGEXP, 0, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.drbdArchCombo.setEnabled(false);
        pane.add(this.drbdArchCombo);
        pane.add(Box.createHorizontalGlue());
        pane.add(Box.createRigidArea(new Dimension(10, 0)));
        return pane;
    }

    private void addListeners() {
        this.drbdDistCombo.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                String v = DrbdLinbitAvailPackages.this.getHost().getDistVersion();
                if (DrbdLinbitAvailPackages.this.drbdDistItems == null || !DrbdLinbitAvailPackages.this.drbdDistItems.contains(v)) {
                    v = DrbdLinbitAvailPackages.NO_MATCH_STRING;
                }
                DrbdLinbitAvailPackages.this.drbdDistCombo.setValue(v);
            }
        });
        this.drbdKernelDirCombo.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                String v = DrbdLinbitAvailPackages.this.getHost().getKernelVersion();
                if (DrbdLinbitAvailPackages.this.drbdKernelDirItems == null || !DrbdLinbitAvailPackages.this.drbdKernelDirItems.contains(v)) {
                    v = DrbdLinbitAvailPackages.NO_MATCH_STRING;
                }
                DrbdLinbitAvailPackages.this.drbdKernelDirCombo.setValue(v);
            }
        });
        this.drbdArchCombo.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                DrbdLinbitAvailPackages.this.enableComponentsLater(new JComponent[]{DrbdLinbitAvailPackages.this.buttonClass(DrbdLinbitAvailPackages.this.nextButton())});
                DrbdLinbitAvailPackages.this.getHost().setArch(DrbdLinbitAvailPackages.this.drbdArchCombo.getStringValue());
                DrbdLinbitAvailPackages.this.availVersionsForDist();
            }
        });
    }

    @Override
    protected final JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        JPanel labelP = new JPanel(new FlowLayout(0));
        labelP.setPreferredSize(new Dimension(0, 0));
        labelP.add(new JLabel(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.AvailablePackages")));
        pane.add(labelP);
        pane.add(this.getChoiceBoxes());
        JPanel progrPane = this.getProgressBarPane();
        pane.add(progrPane);
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.DrbdLinbitAvailPackages.Executing")));
        SpringUtilities.makeCompactGrid(pane, 4, 1, 0, 0, 0, 0);
        return pane;
    }
}

