/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lcmc.AddHostDialog;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.TerminalPanel;
import lcmc.gui.resources.Info;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public final class AllHostsInfo
extends Info {
    private final Host host = null;
    private JPanel infoPanel = null;
    private final Map<Cluster, JCheckBox> allCheckboxes = new HashMap<Cluster, JCheckBox>();
    private final Map<Cluster, MyButton> allLoadButtons = new HashMap<Cluster, MyButton>();
    private final Map<Cluster, JPanel> clusterBackgrounds = new HashMap<Cluster, JPanel>();
    private final JPanel mainPanel = new JPanel(new GridBagLayout());
    private final GridBagConstraints c = new GridBagConstraints();
    private static final ImageIcon CLUSTER_ICON = Tools.createImageIcon(Tools.getDefault("ClusterTab.ClusterIcon"));
    private static final String QUICK_CLUSTER_TITLE = Tools.getString("AllHostsInfo.QuickCluster");
    private static final String CLUSTER_NAME_PH = "cluster name...";
    private static final String DEFAULT_CLUSTER_NAME = "default";
    private final MyButton loadMarkedClustersBtn = new MyButton(Tools.getString("EmptyBrowser.LoadMarkedClusters"), CLUSTER_ICON, Tools.getString("EmptyBrowser.LoadMarkedClusters.ToolTip"));
    private final MyButton unloadMarkedClustersBtn = new MyButton(Tools.getString("EmptyBrowser.UnloadMarkedClusters"), CLUSTER_ICON, Tools.getString("EmptyBrowser.UnloadMarkedClusters.ToolTip"));
    private final MyButton removeMarkedClustersBtn = new MyButton(Tools.getString("EmptyBrowser.RemoveMarkedClusters"), CLUSTER_ICON, Tools.getString("EmptyBrowser.RemoveMarkedClusters.ToolTip"));
    private static final ImageIcon HOST_ICON = Tools.createImageIcon(Tools.getDefault("EmptyBrowser.HostIcon"));

    public AllHostsInfo(Browser browser) {
        super(Tools.getString("ClusterBrowser.AllHosts"), browser);
    }

    private void removeMarkedClusters() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList<Cluster> selectedRunningClusters = new ArrayList<Cluster>();
                final ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
                ArrayList<String> clusterNames = new ArrayList<String>();
                Set<Cluster> clusters = Tools.getConfigData().getClusters().getClusterSet();
                for (Cluster cluster : clusters) {
                    JCheckBox wi = (JCheckBox)AllHostsInfo.this.allCheckboxes.get(cluster);
                    if (!wi.isSelected()) continue;
                    selectedClusters.add(cluster);
                    clusterNames.add(cluster.getName());
                    if (cluster.getClusterTab() == null) continue;
                    selectedRunningClusters.add(cluster);
                }
                String clustersString = Tools.join(", ", clusterNames.toArray(new String[clusterNames.size()]));
                if (!Tools.confirmDialog(Tools.getString("EmptyBrowser.confirmRemoveMarkedClusters.Title"), Tools.getString("EmptyBrowser.confirmRemoveMarkedClusters.Desc").replaceAll("@CLUSTERS@", Matcher.quoteReplacement(clustersString)), Tools.getString("EmptyBrowser.confirmRemoveMarkedClusters.Yes"), Tools.getString("EmptyBrowser.confirmRemoveMarkedClusters.No"))) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AllHostsInfo.this.removeMarkedClustersBtn.setEnabled(false);
                        AllHostsInfo.this.loadMarkedClustersBtn.setEnabled(false);
                        AllHostsInfo.this.unloadMarkedClustersBtn.setEnabled(false);
                    }
                });
                Tools.stopClusters(selectedRunningClusters);
                Tools.removeClusters(selectedClusters);
                String saveFile = Tools.getConfigData().getSaveFile();
                Tools.save(saveFile, false);
                AllHostsInfo.this.mainPanel.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (Cluster cluster : selectedClusters) {
                            JPanel p = (JPanel)AllHostsInfo.this.clusterBackgrounds.get(cluster);
                            if (p == null) continue;
                            AllHostsInfo.this.clusterBackgrounds.remove(cluster);
                            AllHostsInfo.this.allCheckboxes.remove(cluster);
                            AllHostsInfo.this.allLoadButtons.remove(cluster);
                            AllHostsInfo.this.mainPanel.remove(p);
                            AllHostsInfo.this.getBrowser().reload(AllHostsInfo.this.getNode(), false);
                            AllHostsInfo.this.getBrowser().repaintTree();
                        }
                    }
                });
            }
        });
        t.start();
    }

    @Override
    public JComponent getInfoPanel() {
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        this.infoPanel = new JPanel();
        this.infoPanel.setLayout(new BoxLayout(this.infoPanel, 1));
        this.infoPanel.setBackground(Browser.PANEL_BACKGROUND);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.insets = new Insets(3, 3, 0, 0);
        this.mainPanel.setBackground(Browser.PANEL_BACKGROUND);
        this.mainPanel.setBackground(Color.WHITE);
        final Set<Cluster> clusters = Tools.getConfigData().getClusters().getClusterSet();
        if (clusters != null) {
            JPanel bPanel = new JPanel(new BorderLayout());
            bPanel.setMaximumSize(new Dimension(10000, 60));
            JPanel markedPanel = new JPanel(new FlowLayout(0));
            markedPanel.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
            this.loadMarkedClustersBtn.setEnabled(false);
            markedPanel.add(this.loadMarkedClustersBtn);
            this.unloadMarkedClustersBtn.setEnabled(false);
            markedPanel.add(this.unloadMarkedClustersBtn);
            this.removeMarkedClustersBtn.setEnabled(false);
            markedPanel.add(this.removeMarkedClustersBtn);
            bPanel.add((Component)markedPanel, "Center");
            bPanel.add((Component)this.getActionsButton(), "East");
            this.infoPanel.add(bPanel);
            for (Cluster cluster : clusters) {
                this.addClusterBox(cluster);
            }
            this.addQuickClusterBox();
            this.loadMarkedClustersBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            AllHostsInfo.this.loadMarkedClusters(clusters);
                        }
                    });
                    t.start();
                }
            });
            this.unloadMarkedClustersBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            AllHostsInfo.this.unloadMarkedClusters(clusters);
                        }
                    });
                    t.start();
                }
            });
            this.removeMarkedClustersBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AllHostsInfo.this.removeMarkedClusters();
                }
            });
            for (Cluster cluster : clusters) {
                this.addCheckboxListener(cluster);
            }
        }
        JPanel mPanel = new JPanel(new FlowLayout(0));
        mPanel.add(this.mainPanel);
        mPanel.setBackground(Color.WHITE);
        JScrollPane clustersPane = new JScrollPane(mPanel, 20, 30);
        this.infoPanel.add(clustersPane);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Tools.sleep(3000);
                if (Tools.getConfigData().getAutoHosts().isEmpty() && !Tools.getConfigData().getAutoClusters().isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (Cluster cl : AllHostsInfo.this.allLoadButtons.keySet()) {
                                if (cl.getClusterTab() != null || !Tools.getConfigData().getAutoClusters().contains(cl.getName())) continue;
                                ((MyButton)AllHostsInfo.this.allLoadButtons.get(cl)).pressButton();
                            }
                        }
                    });
                }
            }
        });
        t.start();
        return this.infoPanel;
    }

    public void addClusterBox(Cluster cluster) {
        JPanel label = new JPanel();
        label.setBackground(Browser.PANEL_BACKGROUND);
        label.setLayout(new BoxLayout(label, 1));
        label.add(new JLabel(cluster.getName()));
        for (Host host : cluster.getHosts()) {
            StringBuilder hostLabel = new StringBuilder();
            if (!host.isRoot()) {
                hostLabel.append(host.getUsername());
                hostLabel.append('@');
            }
            hostLabel.append(host.getName());
            String port = host.getSSHPort();
            if (port != null && !"22".equals(port)) {
                hostLabel.append(':');
                hostLabel.append(port);
            }
            JLabel nl = new JLabel("   " + hostLabel);
            Font font = nl.getFont();
            Font newFont = font.deriveFont(0, (float)((double)font.getSize() / 1.2));
            nl.setFont(newFont);
            label.add(nl);
        }
        JPanel startPanel = new JPanel(new BorderLayout());
        startPanel.setBackground(Browser.PANEL_BACKGROUND);
        this.clusterBackgrounds.put(cluster, startPanel);
        startPanel.setBorder(new LineBorder(Tools.getDefaultColor("EmptyBrowser.StartPanelTitleBorder")));
        JPanel left = new JPanel();
        left.setBackground(Browser.PANEL_BACKGROUND);
        this.clusterBackgrounds.put(cluster, startPanel);
        JCheckBox markWi = new JCheckBox();
        markWi.setBackground(Browser.PANEL_BACKGROUND);
        this.allCheckboxes.put(cluster, markWi);
        left.add(markWi);
        left.add(label);
        startPanel.add((Component)left, "Before");
        MyButton loadClusterBtn = this.loadClusterButton(cluster, markWi);
        startPanel.add((Component)loadClusterBtn, "After");
        this.c.fill = 2;
        this.mainPanel.add((Component)startPanel, this.c);
        ++this.c.gridx;
        if (this.c.gridx > 2) {
            this.c.gridx = 0;
            ++this.c.gridy;
        }
    }

    private MyButton loadClusterButton(final Cluster cluster, final JCheckBox markWi) {
        final MyButton loadClusterBtn = new MyButton(Tools.getString("EmptyBrowser.LoadClusterButton"));
        this.allLoadButtons.put(cluster, loadClusterBtn);
        loadClusterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                loadClusterBtn.setEnabled(false);
                            }
                        });
                        ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
                        selectedClusters.add(cluster);
                        Tools.startClusters(selectedClusters);
                        if (cluster.getClusterTab() == null) {
                            loadClusterBtn.setEnabled(true);
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((JPanel)AllHostsInfo.this.clusterBackgrounds.get(cluster)).setBackground(Color.GREEN);
                                    markWi.setSelected(false);
                                }
                            });
                        }
                    }
                });
                t.start();
            }
        });
        return loadClusterBtn;
    }

    public void addQuickClusterBox() {
        JPanel label = new JPanel();
        label.setBackground(Browser.PANEL_BACKGROUND);
        label.setLayout(new BoxLayout(label, 1));
        Widget.MTextField clusterTF = new Widget.MTextField(CLUSTER_NAME_PH);
        label.add(clusterTF);
        ArrayList<JTextField> hostsTF = new ArrayList<JTextField>();
        for (int i = 1; i < 3; ++i) {
            Widget.MTextField nl = new Widget.MTextField("node" + i + "...", 15);
            nl.setToolTipText("<html><b>enter the node name or ip</b><br>node" + i + "<br>or ...<br>" + System.getProperty("user.name") + "@node" + i + ":22..." + "<br>");
            hostsTF.add(nl);
            nl.selectAll();
            Font font = nl.getFont();
            Font newFont = font.deriveFont(0, (float)((double)font.getSize() / 1.2));
            nl.setFont(newFont);
            label.add(nl);
        }
        JPanel startPanel = new JPanel(new BorderLayout());
        startPanel.setBackground(Browser.PANEL_BACKGROUND);
        TitledBorder titleBorder = Tools.getBorder(QUICK_CLUSTER_TITLE);
        startPanel.setBorder(titleBorder);
        JPanel left = new JPanel();
        left.setBackground(Browser.PANEL_BACKGROUND);
        left.add(label);
        startPanel.add((Component)left, "Before");
        MyButton loadClusterBtn = this.quickClusterButton(clusterTF, hostsTF);
        startPanel.add((Component)loadClusterBtn, "After");
        this.c.fill = 2;
        if (this.c.gridx != 0) {
            this.c.gridx = 0;
            ++this.c.gridy;
        }
        this.mainPanel.add((Component)startPanel, this.c);
    }

    private MyButton quickClusterButton(final JTextField clusterTF, final List<JTextField> hostsTF) {
        MyButton quickClusterBtn = new MyButton(Tools.getString("EmptyBrowser.LoadClusterButton"));
        quickClusterBtn.setEnabled(false);
        quickClusterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        String clusterName = clusterTF.getText();
                        ArrayList hostNames = new ArrayList();
                        Cluster cluster = new Cluster();
                        if (AllHostsInfo.CLUSTER_NAME_PH.equals(clusterName)) {
                            cluster.setName(AllHostsInfo.DEFAULT_CLUSTER_NAME);
                        } else {
                            cluster.setName(clusterName);
                        }
                        Tools.getConfigData().addClusterToClusters(cluster);
                        for (JTextField hostTF : hostsTF) {
                            String entered = hostTF.getText();
                            String hostName = null;
                            String username = null;
                            String port = null;
                            int a = entered.indexOf(64);
                            if (a > 0) {
                                username = entered.substring(0, a);
                                hostName = entered.substring(a + 1, entered.length());
                            } else {
                                hostName = entered;
                            }
                            int p = hostName.indexOf(58);
                            if (p > 0) {
                                port = hostName.substring(p + 1, hostName.length());
                                hostName = hostName.substring(0, p);
                            }
                            Host host = new Host(hostName);
                            if (username == null) {
                                host.setUsername("root");
                            } else {
                                host.setUseSudo(true);
                                host.setUsername(username);
                            }
                            if (port == null) {
                                host.setSSHPort("22");
                            } else {
                                host.setSSHPort(port);
                            }
                            new TerminalPanel(host);
                            host.setCluster(cluster);
                            host.setHostname(hostName);
                            cluster.addHost(host);
                            Tools.getConfigData().addHostToHosts(host);
                            Tools.getGUIData().allHostsUpdate();
                        }
                        Tools.getConfigData().addClusterToClusters(cluster);
                        ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
                        selectedClusters.add(cluster);
                        Tools.startClusters(selectedClusters);
                    }
                });
                t.start();
            }
        });
        this.textfieldListener(clusterTF, quickClusterBtn);
        for (JTextField htf : hostsTF) {
            this.textfieldListener(htf, quickClusterBtn);
        }
        return quickClusterBtn;
    }

    private void textfieldListener(JTextField textfield, final MyButton button) {
        textfield.getDocument().addDocumentListener(new DocumentListener(){

            private void check() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        button.setEnabled(true);
                    }
                });
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.check();
            }
        });
    }

    public void setConnected(final Cluster cluster) {
        final MyButton loadButton = this.allLoadButtons.get(cluster);
        if (loadButton == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                loadButton.setEnabled(false);
                ((JPanel)AllHostsInfo.this.clusterBackgrounds.get(cluster)).setBackground(Color.GREEN);
            }
        });
    }

    public void setDisconnected(Cluster cluster) {
        final MyButton loadButton = this.allLoadButtons.get(cluster);
        if (loadButton != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    loadButton.setEnabled(true);
                }
            });
        }
    }

    public void addCheckboxListener(Cluster cluster) {
        final JCheckBox wi = this.allCheckboxes.get(cluster);
        wi.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Set<Cluster> clusters = Tools.getConfigData().getClusters().getClusterSet();
                        AllHostsInfo.this.allCheckboxesListener(clusters, wi);
                    }
                });
                thread.start();
            }
        });
    }

    private void loadMarkedClusters(final Set<Cluster> clusters) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AllHostsInfo.this.loadMarkedClustersBtn.setEnabled(false);
            }
        });
        final ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
        for (Cluster cluster : clusters) {
            MyButton loadButton;
            if (cluster.getClusterTab() != null) continue;
            JCheckBox wi = this.allCheckboxes.get(cluster);
            if (wi.isSelected()) {
                selectedClusters.add(cluster);
                this.setConnected(cluster);
                continue;
            }
            if (cluster.getClusterTab() != null || (loadButton = this.allLoadButtons.get(cluster)) == null) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    loadButton.setEnabled(true);
                }
            });
        }
        Tools.startClusters(selectedClusters);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Cluster cluster : clusters) {
                    if (!selectedClusters.contains(cluster)) continue;
                    ((JCheckBox)AllHostsInfo.this.allCheckboxes.get(cluster)).setSelected(false);
                }
            }
        });
    }

    private void unloadMarkedClusters(Set<Cluster> clusters) {
        Tools.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                AllHostsInfo.this.unloadMarkedClustersBtn.setEnabled(false);
            }
        });
        ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
        for (final Cluster cluster : clusters) {
            JCheckBox wi;
            if (cluster.getClusterTab() == null || !(wi = this.allCheckboxes.get(cluster)).isSelected()) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JPanel)AllHostsInfo.this.clusterBackgrounds.get(cluster)).setBackground(Color.WHITE);
                    ((JCheckBox)AllHostsInfo.this.allCheckboxes.get(cluster)).setSelected(false);
                }
            });
            selectedClusters.add(cluster);
        }
        Tools.stopClusters(selectedClusters);
    }

    private void allCheckboxesListener(final Set<Cluster> clusters, JCheckBox wi) {
        int rc = 0;
        int nrc = 0;
        int ac = 0;
        for (Cluster cluster : clusters) {
            ++ac;
            if (!this.allCheckboxes.get(cluster).isSelected()) continue;
            if (cluster.getClusterTab() == null) {
                ++nrc;
                continue;
            }
            ++rc;
        }
        final int runningCount = rc;
        final int notRunningCount = nrc;
        int allCount = ac;
        if (wi.isSelected()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (notRunningCount >= 1) {
                        for (Cluster cluster : clusters) {
                            MyButton loadButton = (MyButton)AllHostsInfo.this.allLoadButtons.get(cluster);
                            if (loadButton == null) continue;
                            loadButton.setEnabled(false);
                        }
                        AllHostsInfo.this.loadMarkedClustersBtn.setEnabled(runningCount == 0);
                    }
                    if (runningCount >= 1) {
                        AllHostsInfo.this.unloadMarkedClustersBtn.setEnabled(notRunningCount == 0);
                    }
                    AllHostsInfo.this.removeMarkedClustersBtn.setEnabled(true);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (notRunningCount == 0) {
                        for (Cluster cluster : clusters) {
                            MyButton loadButton = (MyButton)AllHostsInfo.this.allLoadButtons.get(cluster);
                            if (loadButton == null || cluster.getClusterTab() != null) continue;
                            loadButton.setEnabled(true);
                        }
                        AllHostsInfo.this.loadMarkedClustersBtn.setEnabled(false);
                        if (runningCount > 0) {
                            AllHostsInfo.this.unloadMarkedClustersBtn.setEnabled(true);
                        }
                    }
                    if (runningCount == 0) {
                        AllHostsInfo.this.unloadMarkedClustersBtn.setEnabled(false);
                        if (notRunningCount > 0) {
                            AllHostsInfo.this.loadMarkedClustersBtn.setEnabled(true);
                        }
                    }
                    if (runningCount + notRunningCount == 0) {
                        AllHostsInfo.this.removeMarkedClustersBtn.setEnabled(false);
                    }
                }
            });
        }
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        MyMenuItem newHostWizardItem = new MyMenuItem(Tools.getString("EmptyBrowser.NewHostWizard"), HOST_ICON, null, new AccessMode(ConfigData.AccessType.RO, false), new AccessMode(ConfigData.AccessType.RO, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                return null;
            }

            @Override
            public void action() {
                AddHostDialog dialog = new AddHostDialog(new Host());
                dialog.showDialogs();
            }
        };
        items.add(newHostWizardItem);
        Tools.getGUIData().registerAddHostButton(newHostWizardItem);
        return items;
    }
}

