/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import lcmc.data.AccessMode;
import lcmc.data.ClusterStatus;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.PtestData;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.resources.EditableInfo;
import lcmc.gui.resources.GroupInfo;
import lcmc.gui.resources.HbColocationInfo;
import lcmc.gui.resources.HbConstraintInterface;
import lcmc.gui.resources.HbOrderInfo;
import lcmc.gui.resources.Info;
import lcmc.gui.resources.ServiceInfo;
import lcmc.utilities.ButtonCallback;
import lcmc.utilities.CRM;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.Tools;
import lcmc.utilities.UpdatableItem;

public class HbConnectionInfo
extends EditableInfo {
    private JComponent infoPanel = null;
    private final List<HbConstraintInterface> constraints = new ArrayList<HbConstraintInterface>();
    private final ReadWriteLock mConstraintsLock = new ReentrantReadWriteLock();
    private final Lock mConstraintsReadLock = this.mConstraintsLock.readLock();
    private final Lock mConstraintsWriteLock = this.mConstraintsLock.writeLock();
    private ServiceInfo lastServiceInfoRsc = null;
    private ServiceInfo lastServiceInfoWithRsc = null;
    private ServiceInfo lastServiceInfoParent = null;
    private ServiceInfo lastServiceInfoChild = null;
    private final Map<String, HbColocationInfo> colocationIds = new LinkedHashMap<String, HbColocationInfo>();
    private final Map<String, HbOrderInfo> orderIds = new LinkedHashMap<String, HbOrderInfo>();

    public HbConnectionInfo(Browser browser) {
        super("HbConnectionInfo", browser);
    }

    @Override
    protected final ClusterBrowser getBrowser() {
        return (ClusterBrowser)super.getBrowser();
    }

    public final boolean isNew() {
        return this.lastServiceInfoRsc != null && this.lastServiceInfoRsc.getService().isNew() || this.lastServiceInfoWithRsc != null && this.lastServiceInfoWithRsc.getService().isNew() || this.lastServiceInfoParent != null && this.lastServiceInfoParent.getService().isNew() || this.lastServiceInfoChild != null && this.lastServiceInfoChild.getService().isNew();
    }

    @Override
    protected final String getParamLongDesc(String param) {
        return null;
    }

    @Override
    protected final String getParamShortDesc(String param) {
        return null;
    }

    @Override
    protected final boolean checkParam(String param, String newValue) {
        return false;
    }

    @Override
    protected final String getParamDefault(String param) {
        return null;
    }

    @Override
    protected final String getParamPreferred(String param) {
        return null;
    }

    @Override
    public final String[] getParametersFromXML() {
        return null;
    }

    @Override
    protected final Object[] getParamPossibleChoices(String param) {
        return null;
    }

    @Override
    protected final String getParamType(String param) {
        return null;
    }

    @Override
    protected final String getSection(String param) {
        return null;
    }

    @Override
    protected final boolean isCheckBox(String param) {
        return false;
    }

    @Override
    protected final boolean isTimeType(String param) {
        return false;
    }

    @Override
    protected final boolean isInteger(String param) {
        return false;
    }

    @Override
    protected final boolean isLabel(String param) {
        return false;
    }

    @Override
    protected final boolean isRequired(String param) {
        return true;
    }

    public final ServiceInfo getLastServiceInfoParent() {
        return this.lastServiceInfoParent;
    }

    public final ServiceInfo getLastServiceInfoChild() {
        return this.lastServiceInfoChild;
    }

    public final ServiceInfo getLastServiceInfoRsc() {
        return this.lastServiceInfoRsc;
    }

    public final ServiceInfo getLastServiceInfoWithRsc() {
        return this.lastServiceInfoWithRsc;
    }

    @Override
    public final JPanel getGraphicalView() {
        return this.getBrowser().getCRMGraph().getGraphPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(Host dcHost, boolean testOnly) {
        if (!testOnly) {
            Tools.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    HbConnectionInfo.this.getApplyButton().setEnabled(false);
                    HbConnectionInfo.this.getRevertButton().setEnabled(false);
                    HbConnectionInfo.this.getApplyButton().setToolTipText(null);
                }
            });
        }
        ArrayList<HbConstraintInterface> constraintsCopy = new ArrayList<HbConstraintInterface>();
        this.mConstraintsReadLock.lock();
        try {
            for (HbConstraintInterface c : this.constraints) {
                constraintsCopy.add(c);
            }
        }
        finally {
            this.mConstraintsReadLock.unlock();
        }
        for (HbConstraintInterface c : constraintsCopy) {
            c.apply(dcHost, testOnly);
        }
        if (!testOnly) {
            this.setApplyButtons(null, null);
            this.getBrowser().setRightComponentInView(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean checkResourceFieldsCorrect(String param, String[] params) {
        boolean correct = true;
        this.mConstraintsReadLock.lock();
        try {
            for (HbConstraintInterface c : this.constraints) {
                boolean cor = c.checkResourceFieldsCorrect(param, c.getParametersFromXML(), true);
                if (cor) continue;
                correct = false;
                break;
            }
        }
        finally {
            this.mConstraintsReadLock.unlock();
        }
        return correct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkResourceFieldsChanged(String param, String[] params) {
        boolean changed = false;
        this.mConstraintsReadLock.lock();
        try {
            for (HbConstraintInterface c : this.constraints) {
                boolean chg = c.checkResourceFieldsChanged(param, c.getParametersFromXML(), true);
                if (!chg) continue;
                changed = true;
                break;
            }
        }
        finally {
            this.mConstraintsReadLock.unlock();
        }
        return changed;
    }

    protected JPanel getLabels(HbConstraintInterface c) {
        JPanel panel = this.getParamPanel(c.getName());
        panel.setLayout(new SpringLayout());
        int rows = 3;
        int height = Tools.getDefaultSize("Browser.LabelFieldHeight");
        c.addLabelField(panel, Tools.getString("ClusterBrowser.HeartbeatId"), c.getService().getHeartbeatId(), ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH, height);
        c.addLabelField(panel, c.getRsc1Name(), c.getRsc1(), ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH, height);
        c.addLabelField(panel, c.getRsc2Name(), c.getRsc2(), ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH, height);
        SpringUtilities.makeCompactGrid(panel, 3, 2, 1, 1, 1, 1);
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JComponent getInfoPanel() {
        if (this.infoPanel != null) {
            return this.infoPanel;
        }
        HbConnectionInfo thisClass = this;
        ButtonCallback buttonCallback = new ButtonCallback(){
            private volatile boolean mouseStillOver = false;

            @Override
            public final boolean isEnabled() {
                Host dcHost = HbConnectionInfo.this.getBrowser().getDCHost();
                if (dcHost == null) {
                    return false;
                }
                return !Tools.versionBeforePacemaker(dcHost);
            }

            @Override
            public final void mouseOut() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = false;
                HbConnectionInfo.this.getBrowser().getCRMGraph().stopTestAnimation(HbConnectionInfo.this.getApplyButton());
                HbConnectionInfo.this.getApplyButton().setToolTipText(null);
            }

            @Override
            public final void mouseOver() {
                if (!this.isEnabled()) {
                    return;
                }
                this.mouseStillOver = true;
                HbConnectionInfo.this.getApplyButton().setToolTipText(ClusterBrowser.STARTING_PTEST_TOOLTIP);
                HbConnectionInfo.this.getApplyButton().setToolTipBackground(Tools.getDefaultColor("ClusterBrowser.Test.Tooltip.Background"));
                Tools.sleep(250);
                if (!this.mouseStillOver) {
                    return;
                }
                this.mouseStillOver = false;
                CountDownLatch startTestLatch = new CountDownLatch(1);
                HbConnectionInfo.this.getBrowser().getCRMGraph().startTestAnimation(HbConnectionInfo.this.getApplyButton(), startTestLatch);
                Host dcHost = HbConnectionInfo.this.getBrowser().getDCHost();
                HbConnectionInfo.this.getBrowser().ptestLockAcquire();
                ClusterStatus clStatus = HbConnectionInfo.this.getBrowser().getClusterStatus();
                clStatus.setPtestData(null);
                HbConnectionInfo.this.apply(dcHost, true);
                PtestData ptestData = new PtestData(CRM.getPtest(dcHost));
                HbConnectionInfo.this.getApplyButton().setToolTipText(ptestData.getToolTip());
                clStatus.setPtestData(ptestData);
                HbConnectionInfo.this.getBrowser().ptestLockRelease();
                startTestLatch.countDown();
            }
        };
        this.initApplyButton(buttonCallback);
        for (String col : this.colocationIds.keySet()) {
            this.colocationIds.get(col).setApplyButton(this.getApplyButton());
            this.colocationIds.get(col).setRevertButton(this.getRevertButton());
        }
        for (String ord : this.orderIds.keySet()) {
            this.orderIds.get(ord).setApplyButton(this.getApplyButton());
            this.orderIds.get(ord).setRevertButton(this.getRevertButton());
        }
        JPanel mainPanel = new JPanel();
        mainPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setBackground(ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        buttonPanel.setMinimumSize(new Dimension(0, 50));
        buttonPanel.setPreferredSize(new Dimension(0, 50));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentX(0.0f);
        mainPanel.add(buttonPanel);
        buttonPanel.add((Component)this.getActionsButton(), "East");
        EditableInfo firstConstraint = null;
        this.mConstraintsReadLock.lock();
        try {
            for (HbConstraintInterface c : this.constraints) {
                if (firstConstraint == null) {
                    firstConstraint = (EditableInfo)((Object)c);
                }
                String[] params = c.getParametersFromXML();
                JPanel panel = this.getLabels(c);
                optionsPanel.add(panel);
                c.addParams(optionsPanel, params, ClusterBrowser.SERVICE_LABEL_WIDTH, ClusterBrowser.SERVICE_FIELD_WIDTH, null);
            }
        }
        finally {
            this.mConstraintsReadLock.unlock();
        }
        this.getApplyButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HbConnectionInfo.this.getBrowser().clStatusLock();
                        HbConnectionInfo.this.apply(HbConnectionInfo.this.getBrowser().getDCHost(), false);
                        HbConnectionInfo.this.getBrowser().clStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.getRevertButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        HbConnectionInfo.this.getBrowser().clStatusLock();
                        HbConnectionInfo.this.revert();
                        HbConnectionInfo.this.getBrowser().clStatusUnlock();
                    }
                });
                thread.start();
            }
        });
        this.addApplyButton(buttonPanel);
        this.addRevertButton(buttonPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HbConnectionInfo.this.setApplyButtons(null, null);
            }
        });
        mainPanel.add(optionsPanel);
        JPanel newPanel = new JPanel();
        newPanel.setBackground(ClusterBrowser.PANEL_BACKGROUND);
        newPanel.setLayout(new BoxLayout(newPanel, 1));
        newPanel.add(buttonPanel);
        if (firstConstraint != null) {
            newPanel.add(firstConstraint.getMoreOptionsPanel(ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH + 4));
        }
        newPanel.add(new JScrollPane(mainPanel));
        newPanel.setMinimumSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        newPanel.setPreferredSize(new Dimension(Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Width"), Tools.getDefaultSize("HostBrowser.ResourceInfoArea.Height")));
        this.infoPanel = newPanel;
        this.infoPanelDone();
        return this.infoPanel;
    }

    @Override
    public List<UpdatableItem> createPopup() {
        ArrayList<UpdatableItem> items = new ArrayList<UpdatableItem>();
        final HbConnectionInfo thisClass = this;
        boolean testOnly = false;
        MyMenuItem removeEdgeItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.RemoveEdge"), ClusterBrowser.REMOVE_ICON, Tools.getString("ClusterBrowser.Hb.RemoveEdge.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public final String enablePredicate() {
                if (HbConnectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public final void action() {
                HbConnectionInfo.this.getBrowser().getCRMGraph().removeConnection(thisClass, HbConnectionInfo.this.getBrowser().getDCHost(), false);
            }
        };
        ClusterBrowser clusterBrowser = this.getBrowser();
        clusterBrowser.getClass();
        ClusterBrowser.ClMenuItemCallback removeEdgeCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser, removeEdgeItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public final boolean isEnabled() {
                return super.isEnabled() && !HbConnectionInfo.this.isNew();
            }

            @Override
            public void action(Host dcHost) {
                if (!HbConnectionInfo.this.isNew()) {
                    HbConnectionInfo.this.getBrowser().getCRMGraph().removeConnection(thisClass, dcHost, true);
                }
            }
        };
        this.addMouseOverListener(removeEdgeItem, removeEdgeCallback);
        items.add(removeEdgeItem);
        MyMenuItem removeOrderItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.RemoveOrder"), ClusterBrowser.REMOVE_ICON, Tools.getString("ClusterBrowser.Hb.RemoveOrder.ToolTip"), Tools.getString("ClusterBrowser.Hb.AddOrder"), null, Tools.getString("ClusterBrowser.Hb.AddOrder.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public final boolean predicate() {
                return HbConnectionInfo.this.getBrowser().getCRMGraph().isOrder(thisClass);
            }

            @Override
            public final String enablePredicate() {
                if (HbConnectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public final void action() {
                if (this.getText().equals(Tools.getString("ClusterBrowser.Hb.RemoveOrder"))) {
                    HbConnectionInfo.this.getBrowser().getCRMGraph().removeOrder(thisClass, HbConnectionInfo.this.getBrowser().getDCHost(), false);
                } else {
                    HbConnectionInfo.this.addOrder(null, HbConnectionInfo.this.getLastServiceInfoRsc(), HbConnectionInfo.this.getLastServiceInfoWithRsc());
                    HbConnectionInfo.this.getBrowser().getCRMGraph().addOrder(thisClass, HbConnectionInfo.this.getBrowser().getDCHost(), false);
                }
            }
        };
        ClusterBrowser clusterBrowser2 = this.getBrowser();
        clusterBrowser2.getClass();
        ClusterBrowser.ClMenuItemCallback removeOrderCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser2, removeOrderItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public final boolean isEnabled() {
                return super.isEnabled() && !HbConnectionInfo.this.isNew();
            }

            @Override
            public void action(Host dcHost) {
                if (!HbConnectionInfo.this.isNew()) {
                    if (HbConnectionInfo.this.getBrowser().getCRMGraph().isOrder(thisClass)) {
                        HbConnectionInfo.this.getBrowser().getCRMGraph().removeOrder(thisClass, dcHost, true);
                    } else {
                        HbConnectionInfo.this.addOrder(null, HbConnectionInfo.this.getLastServiceInfoRsc(), HbConnectionInfo.this.getLastServiceInfoWithRsc());
                        HbConnectionInfo.this.getBrowser().getCRMGraph().addOrder(thisClass, dcHost, true);
                    }
                }
            }
        };
        this.addMouseOverListener(removeOrderItem, removeOrderCallback);
        items.add(removeOrderItem);
        MyMenuItem removeColocationItem = new MyMenuItem(Tools.getString("ClusterBrowser.Hb.RemoveColocation"), ClusterBrowser.REMOVE_ICON, Tools.getString("ClusterBrowser.Hb.RemoveColocation.ToolTip"), Tools.getString("ClusterBrowser.Hb.AddColocation"), null, Tools.getString("ClusterBrowser.Hb.AddColocation.ToolTip"), new AccessMode(ConfigData.AccessType.ADMIN, false), new AccessMode(ConfigData.AccessType.OP, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public final boolean predicate() {
                return HbConnectionInfo.this.getBrowser().getCRMGraph().isColocation(thisClass);
            }

            @Override
            public final String enablePredicate() {
                if (HbConnectionInfo.this.getBrowser().clStatusFailed()) {
                    return "unknown cluster status";
                }
                return null;
            }

            @Override
            public final void action() {
                if (this.getText().equals(Tools.getString("ClusterBrowser.Hb.RemoveColocation"))) {
                    HbConnectionInfo.this.getBrowser().getCRMGraph().removeColocation(thisClass, HbConnectionInfo.this.getBrowser().getDCHost(), false);
                } else {
                    HbConnectionInfo.this.addColocation(null, HbConnectionInfo.this.getLastServiceInfoParent(), HbConnectionInfo.this.getLastServiceInfoChild());
                    HbConnectionInfo.this.getBrowser().getCRMGraph().addColocation(thisClass, HbConnectionInfo.this.getBrowser().getDCHost(), false);
                }
            }
        };
        ClusterBrowser clusterBrowser3 = this.getBrowser();
        clusterBrowser3.getClass();
        ClusterBrowser.ClMenuItemCallback removeColocationCallback = new ClusterBrowser.ClMenuItemCallback(clusterBrowser3, removeColocationItem, null){
            {
                ClusterBrowser clusterBrowser = x0;
                clusterBrowser.getClass();
                super(x1, x2);
            }

            @Override
            public final boolean isEnabled() {
                return super.isEnabled() && !HbConnectionInfo.this.isNew();
            }

            @Override
            public final void action(Host dcHost) {
                if (!HbConnectionInfo.this.isNew()) {
                    if (HbConnectionInfo.this.getBrowser().getCRMGraph().isColocation(thisClass)) {
                        HbConnectionInfo.this.getBrowser().getCRMGraph().removeColocation(thisClass, dcHost, true);
                    } else {
                        HbConnectionInfo.this.addColocation(null, HbConnectionInfo.this.getLastServiceInfoParent(), HbConnectionInfo.this.getLastServiceInfoChild());
                        HbConnectionInfo.this.getBrowser().getCRMGraph().addColocation(thisClass, dcHost, true);
                    }
                }
            }
        };
        this.addMouseOverListener(removeColocationItem, removeColocationCallback);
        items.add(removeColocationItem);
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOrdersOrColocations(boolean isOrder) {
        ArrayList<HbConstraintInterface> constraintsToRemove = new ArrayList<HbConstraintInterface>();
        boolean changed = false;
        this.mConstraintsWriteLock.lock();
        try {
            for (HbConstraintInterface c : this.constraints) {
                if (c.isOrder() != isOrder) continue;
                constraintsToRemove.add(c);
                changed = true;
            }
            for (HbConstraintInterface c : constraintsToRemove) {
                if (isOrder) {
                    this.orderIds.remove(c.getService().getHeartbeatId());
                } else {
                    this.colocationIds.remove(c.getService().getHeartbeatId());
                }
                this.constraints.remove(c);
            }
        }
        finally {
            this.mConstraintsWriteLock.unlock();
        }
        if (changed) {
            this.infoPanel = null;
            this.selectMyself();
        }
    }

    public final void removeOrders() {
        this.removeOrdersOrColocations(true);
    }

    public final void removeColocations() {
        this.removeOrdersOrColocations(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addOrder(String ordId, ServiceInfo serviceInfoParent, ServiceInfo serviceInfoChild) {
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        this.lastServiceInfoParent = serviceInfoParent;
        this.lastServiceInfoChild = serviceInfoChild;
        if (ordId == null) {
            return;
        }
        if (this.orderIds.containsKey(ordId)) {
            HbOrderInfo hoi = this.orderIds.get(ordId);
            hoi.setServiceInfoParent(serviceInfoParent);
            hoi.setServiceInfoChild(serviceInfoChild);
            hoi.setParameters();
            return;
        }
        HbOrderInfo oi = new HbOrderInfo(this, serviceInfoParent, serviceInfoChild, this.getBrowser());
        oi.setApplyButton(this.getApplyButton());
        oi.setRevertButton(this.getRevertButton());
        this.orderIds.put(ordId, oi);
        oi.getService().setHeartbeatId(ordId);
        oi.setParameters();
        this.mConstraintsWriteLock.lock();
        try {
            this.constraints.add(oi);
        }
        finally {
            this.mConstraintsWriteLock.unlock();
        }
        this.infoPanel = null;
        this.selectMyself();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addColocation(String colId, ServiceInfo serviceInfoRsc, ServiceInfo serviceInfoWithRsc) {
        ClusterStatus clStatus = this.getBrowser().getClusterStatus();
        this.lastServiceInfoRsc = serviceInfoRsc;
        this.lastServiceInfoWithRsc = serviceInfoWithRsc;
        if (colId == null) {
            return;
        }
        if (this.colocationIds.containsKey(colId)) {
            HbColocationInfo hci = this.colocationIds.get(colId);
            hci.setServiceInfoRsc(serviceInfoRsc);
            hci.setServiceInfoWithRsc(serviceInfoWithRsc);
            hci.setParameters();
            return;
        }
        HbColocationInfo ci = new HbColocationInfo(this, serviceInfoRsc, serviceInfoWithRsc, this.getBrowser());
        ci.setApplyButton(this.getApplyButton());
        ci.setRevertButton(this.getRevertButton());
        this.colocationIds.put(colId, ci);
        ci.getService().setHeartbeatId(colId);
        ci.setParameters();
        this.mConstraintsWriteLock.lock();
        try {
            this.constraints.add(ci);
        }
        finally {
            this.mConstraintsWriteLock.unlock();
        }
        this.infoPanel = null;
        this.selectMyself();
    }

    public final ColScoreType getColocationScoreType(ServiceInfo rsc1, ServiceInfo rsc2) {
        int score = 0;
        boolean plusInf = false;
        boolean minusInf = false;
        for (String colId : this.colocationIds.keySet()) {
            HbColocationInfo hbci = this.colocationIds.get(colId);
            if (hbci == null || rsc1 != null && rsc2 != null && (hbci.getRscInfo1() != rsc1 || hbci.getRscInfo2() != rsc2) && (hbci.getRscInfo1() != rsc2 || hbci.getRscInfo2() != rsc1)) continue;
            int s = hbci.getScore();
            if (s == 1000000) {
                plusInf = true;
            } else if (s == -1000000) {
                minusInf = true;
            }
            score += s;
        }
        if (plusInf && minusInf || this.colocationIds.isEmpty()) {
            return ColScoreType.MIXED;
        }
        if (plusInf) {
            return ColScoreType.INFINITY;
        }
        if (minusInf) {
            return ColScoreType.MINUS_INFINITY;
        }
        if (score == 0) {
            return ColScoreType.IS_NULL;
        }
        if (score < 0) {
            return ColScoreType.NEGATIVE;
        }
        return ColScoreType.POSITIVE;
    }

    public final boolean isOrdScoreNull(ServiceInfo first, ServiceInfo then) {
        if (this.isNew() || this.orderIds.isEmpty()) {
            return false;
        }
        int score = 0;
        for (String ordId : this.orderIds.keySet()) {
            HbOrderInfo hoi = this.orderIds.get(ordId);
            if (hoi == null || first != null && hoi.getRscInfo1() != first || then != null && hoi.getRscInfo2() != then) continue;
            int s = hoi.getScore();
            if (s < 0) {
                s = 0;
            }
            score += s;
        }
        return score == 0;
    }

    @Override
    public final void selectMyself() {
        super.selectMyself();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getBrowser().getTree().getLastSelectedPathComponent();
        if (node != null) {
            Info prev = (Info)node.getUserObject();
            this.getBrowser().setRightComponentInView(this);
            this.getBrowser().setRightComponentInView(prev);
        }
    }

    @Override
    protected final boolean isAdvanced(String param) {
        return false;
    }

    @Override
    protected final ConfigData.AccessType getAccessType(String param) {
        return ConfigData.AccessType.ADMIN;
    }

    @Override
    protected final String isEnabled(String param) {
        return null;
    }

    @Override
    protected final boolean isEnabledOnlyInAdvancedMode(String param) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateAdvancedPanels() {
        super.updateAdvancedPanels();
        this.mConstraintsReadLock.lock();
        try {
            for (HbConstraintInterface c : this.constraints) {
                c.updateAdvancedPanels();
            }
        }
        finally {
            this.mConstraintsReadLock.unlock();
        }
    }

    public final boolean isWithRsc(ServiceInfo si) {
        this.mConstraintsReadLock.lock();
        for (HbConstraintInterface c : this.constraints) {
            if (c.isOrder()) continue;
            ServiceInfo rsc2 = ((HbColocationInfo)c).getRscInfo2();
            GroupInfo gi = rsc2.getGroupInfo();
            if (gi != null) {
                rsc2 = gi;
            }
            if (!rsc2.equals(si)) continue;
            this.mConstraintsReadLock.unlock();
            return true;
        }
        this.mConstraintsReadLock.unlock();
        return true;
    }

    private boolean isTwoDirections(boolean isOrder) {
        ServiceInfo allRsc1 = null;
        ServiceInfo allRsc2 = null;
        this.mConstraintsReadLock.lock();
        for (HbConstraintInterface c : this.constraints) {
            GroupInfo gi2;
            if (c.isOrder() != isOrder) continue;
            ServiceInfo rsc1 = c.getRscInfo1();
            ServiceInfo rsc2 = c.getRscInfo2();
            GroupInfo gi1 = rsc1.getGroupInfo();
            if (gi1 != null) {
                rsc1 = gi1;
            }
            if ((gi2 = rsc2.getGroupInfo()) != null) {
                rsc2 = gi2;
            }
            if (allRsc1 == null) {
                allRsc1 = rsc1;
            } else if (!rsc1.equals(allRsc1)) {
                this.mConstraintsReadLock.unlock();
                return true;
            }
            if (allRsc2 == null) {
                allRsc2 = rsc2;
                continue;
            }
            if (rsc2.equals(allRsc2)) continue;
            this.mConstraintsReadLock.unlock();
            return true;
        }
        this.mConstraintsReadLock.unlock();
        return false;
    }

    public final boolean isOrderTwoDirections() {
        return this.isTwoDirections(true);
    }

    public final boolean isColocationTwoDirections() {
        return this.isTwoDirections(false);
    }

    final boolean hasColocationOrOrder(ServiceInfo si) {
        this.mConstraintsReadLock.lock();
        for (HbConstraintInterface c : this.constraints) {
            ServiceInfo rsc1 = c.getRscInfo1();
            ServiceInfo rsc2 = c.getRscInfo2();
            if (!si.equals(rsc1) && !si.equals(rsc2)) continue;
            this.mConstraintsReadLock.unlock();
            return true;
        }
        this.mConstraintsReadLock.unlock();
        return false;
    }

    final Map<String, String> getColocationAttributes(String colId) {
        HbColocationInfo hci = this.colocationIds.get(colId);
        if (hci != null) {
            return hci.getAttributes();
        }
        return null;
    }

    final Map<String, String> getOrderAttributes(String ordId) {
        HbOrderInfo hoi = this.orderIds.get(ordId);
        if (hoi != null) {
            return hoi.getAttributes();
        }
        return null;
    }

    @Override
    public final void revert() {
        super.revert();
        ArrayList<HbConstraintInterface> constraintsCopy = new ArrayList<HbConstraintInterface>();
        this.mConstraintsReadLock.lock();
        for (HbConstraintInterface c : this.constraints) {
            constraintsCopy.add(c);
        }
        this.mConstraintsReadLock.unlock();
        for (HbConstraintInterface c : constraintsCopy) {
            c.revert();
        }
    }

    public static enum ColScoreType {
        MIXED,
        INFINITY,
        MINUS_INFINITY,
        IS_NULL,
        NEGATIVE,
        POSITIVE;

    }
}

