/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.resources;

import java.util.Map;
import lcmc.data.Host;
import lcmc.data.ResourceAgent;
import lcmc.gui.Browser;
import lcmc.gui.resources.DrbdResourceInfo;
import lcmc.gui.resources.ServiceInfo;

final class LinbitDrbdInfo
extends ServiceInfo {
    LinbitDrbdInfo(String name, ResourceAgent ra, Browser browser) {
        super(name, ra, browser);
    }

    LinbitDrbdInfo(String name, ResourceAgent ra, String hbId, Map<String, String> resourceNode, Browser browser) {
        super(name, ra, hbId, resourceNode, browser);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(30);
        String provider = this.getResourceAgent().getProvider();
        if (!"heartbeat".equals(provider) && !"".equals(provider)) {
            s.append(provider);
            s.append(':');
        }
        s.append(this.getName());
        String string = this.getParamSaved("drbd_resource");
        if (string == null) {
            s.insert(0, "new ");
        } else if (!"".equals(string)) {
            s.append(" (");
            s.append(string);
            s.append(')');
        }
        return s.toString();
    }

    String getResourceName() {
        return this.getParamSaved("drbd_resource");
    }

    void setResourceName(String resourceName) {
        this.getResource().setValue("drbd_resource", resourceName);
    }

    @Override
    public void removeMyselfNoConfirm(Host dcHost, boolean testOnly) {
        DrbdResourceInfo dri = this.getBrowser().getDrbdResHash().get(this.getResourceName());
        this.getBrowser().putDrbdResHash();
        super.removeMyselfNoConfirm(dcHost, testOnly);
        if (dri != null) {
            dri.setUsedByCRM(null);
        }
    }

    @Override
    void setParameters(Map<String, String> resourceNode) {
        super.setParameters(resourceNode);
        DrbdResourceInfo dri = this.getBrowser().getDrbdResHash().get(this.getResourceName());
        this.getBrowser().putDrbdResHash();
        if (dri != null) {
            if (this.isManaged(false) && !this.getService().isOrphaned()) {
                dri.setUsedByCRM(this);
            } else {
                dri.setUsedByCRM(null);
            }
        }
    }
}

