/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.widget;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import lcmc.data.AccessMode;
import lcmc.gui.widget.Widget;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public class Checkbox
extends Widget {
    private static final long serialVersionUID = 1L;
    private String checkBoxTrue = Tools.getString("Boolean.True");
    private String checkBoxFalse = Tools.getString("Boolean.False");

    public Checkbox(String selectedValue, Object[] items, String regexp, int width, AccessMode enableAccessMode, MyButton fieldButton) {
        super(regexp, enableAccessMode, fieldButton);
        if (items != null && items.length == 2) {
            this.checkBoxTrue = (String)items[0];
            this.checkBoxFalse = (String)items[1];
        }
        this.addComponent(this.getCheckBox(selectedValue), width);
    }

    private JComponent getCheckBox(String selectedValue) {
        JCheckBox cb = new JCheckBox();
        if (selectedValue != null) {
            cb.setSelected(selectedValue.equals(this.checkBoxTrue));
        }
        return cb;
    }

    @Override
    public String getStringValue() {
        Object o = this.getValue();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    @Override
    protected Object getValueInternal() {
        JCheckBox cbox = (JCheckBox)this.getComponent();
        String value = cbox.getSelectedObjects() == null ? this.checkBoxFalse : this.checkBoxTrue;
        if (NOTHING_SELECTED_DISPLAY.equals(value)) {
            return null;
        }
        return value;
    }

    @Override
    boolean isEditable() {
        return false;
    }

    @Override
    protected void setValueAndWait0(Object item) {
        if (item != null) {
            ((JCheckBox)this.getComponent()).setSelected(item.equals(this.checkBoxTrue));
        }
    }

    @Override
    public Document getDocument() {
        return null;
    }

    @Override
    public void addListeners(WidgetListener wl) {
        this.getWidgetListeners().add(wl);
        ((JCheckBox)this.getComponent()).addItemListener(this.getItemListener(wl));
    }

    @Override
    protected void setComponentBackground(Color backgroundColor, Color compColor) {
        this.getComponent().setBackground(backgroundColor);
    }

    @Override
    public void setBackgroundColor(final Color bg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Checkbox.this.setBackground(bg);
                Checkbox.this.getComponent().setBackground(bg);
            }
        });
    }

    @Override
    Object getItemAt(int i) {
        return this.getComponent();
    }

    @Override
    public void cleanup() {
        this.getWidgetListeners().clear();
        for (ItemListener il : ((JCheckBox)this.getComponent()).getItemListeners()) {
            ((JCheckBox)this.getComponent()).removeItemListener(il);
        }
    }

    @Override
    protected ItemListener getItemListener(final WidgetListener wl) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (wl.isEnabled()) {
                    final Object value = e.getItem();
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            wl.check(value);
                        }
                    });
                    t.start();
                }
            }
        };
    }
}

