/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.LinkedList;
import java.util.List;
import org.mockito.internal.invocation.InvocationMatcher;
import org.mockito.internal.util.collections.ListUtil;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;

public class InvocationsFinder {
    public List<Invocation> findInvocations(List<Invocation> list, InvocationMatcher invocationMatcher) {
        return ListUtil.filter(list, new RemoveNotMatching(invocationMatcher));
    }

    public List<Invocation> findAllMatchingUnverifiedChunks(List<Invocation> list, InvocationMatcher invocationMatcher, InOrderContext inOrderContext) {
        List<Invocation> list2 = this.removeVerifiedInOrder(list, inOrderContext);
        return ListUtil.filter(list2, new RemoveNotMatching(invocationMatcher));
    }

    public List<Invocation> findMatchingChunk(List<Invocation> list, InvocationMatcher invocationMatcher, int n, InOrderContext inOrderContext) {
        List<Invocation> list2 = this.removeVerifiedInOrder(list, inOrderContext);
        List<Invocation> list3 = this.getFirstMatchingChunk(invocationMatcher, list2);
        if (n != list3.size()) {
            return this.findAllMatchingUnverifiedChunks(list, invocationMatcher, inOrderContext);
        }
        return list3;
    }

    private List<Invocation> getFirstMatchingChunk(InvocationMatcher invocationMatcher, List<Invocation> list) {
        LinkedList<Invocation> linkedList = new LinkedList<Invocation>();
        for (Invocation invocation : list) {
            if (invocationMatcher.matches(invocation)) {
                linkedList.add(invocation);
                continue;
            }
            if (linkedList.isEmpty()) continue;
            break;
        }
        return linkedList;
    }

    public Invocation findFirstMatchingUnverifiedInvocation(List<Invocation> list, InvocationMatcher invocationMatcher, InOrderContext inOrderContext) {
        for (Invocation invocation : this.removeVerifiedInOrder(list, inOrderContext)) {
            if (!invocationMatcher.matches(invocation)) continue;
            return invocation;
        }
        return null;
    }

    public Invocation findSimilarInvocation(List<Invocation> list, InvocationMatcher invocationMatcher) {
        Invocation invocation = null;
        for (Invocation invocation2 : list) {
            if (!invocationMatcher.hasSimilarMethod(invocation2)) continue;
            if (invocation == null) {
                invocation = invocation2;
            }
            if (!invocationMatcher.hasSameMethod(invocation2)) continue;
            return invocation2;
        }
        return invocation;
    }

    public Invocation findFirstUnverified(List<Invocation> list) {
        return this.findFirstUnverified(list, null);
    }

    Invocation findFirstUnverified(List<Invocation> list, Object object) {
        for (Invocation invocation : list) {
            boolean bl;
            boolean bl2 = bl = object == null || object == invocation.getMock();
            if (invocation.isVerified() || !bl) continue;
            return invocation;
        }
        return null;
    }

    public Location getLastLocation(List<Invocation> list) {
        if (list.isEmpty()) {
            return null;
        }
        Invocation invocation = list.get(list.size() - 1);
        return invocation.getLocation();
    }

    public Invocation findPreviousVerifiedInOrder(List<Invocation> list, InOrderContext inOrderContext) {
        LinkedList<Invocation> linkedList = ListUtil.filter(list, new RemoveUnverifiedInOrder(inOrderContext));
        if (linkedList.isEmpty()) {
            return null;
        }
        return linkedList.getLast();
    }

    private List<Invocation> removeVerifiedInOrder(List<Invocation> list, InOrderContext inOrderContext) {
        LinkedList<Invocation> linkedList = new LinkedList<Invocation>();
        for (Invocation invocation : list) {
            if (inOrderContext.isVerified(invocation)) {
                linkedList.clear();
                continue;
            }
            linkedList.add(invocation);
        }
        return linkedList;
    }

    public Invocation findFirstUnverifiedInOrder(InOrderContext inOrderContext, List<Invocation> list) {
        Invocation invocation = null;
        for (Invocation invocation2 : list) {
            if (!inOrderContext.isVerified(invocation2)) {
                invocation = invocation != null ? invocation : invocation2;
                continue;
            }
            invocation = null;
        }
        return invocation;
    }

    private static class RemoveUnverifiedInOrder
    implements ListUtil.Filter<Invocation> {
        private final InOrderContext orderingContext;

        public RemoveUnverifiedInOrder(InOrderContext inOrderContext) {
            this.orderingContext = inOrderContext;
        }

        @Override
        public boolean isOut(Invocation invocation) {
            return !this.orderingContext.isVerified(invocation);
        }
    }

    private static class RemoveNotMatching
    implements ListUtil.Filter<Invocation> {
        private final InvocationMatcher wanted;

        private RemoveNotMatching(InvocationMatcher invocationMatcher) {
            this.wanted = invocationMatcher;
        }

        @Override
        public boolean isOut(Invocation invocation) {
            return !this.wanted.matches(invocation);
        }
    }
}

