/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Description;
import org.mockito.ArgumentMatcher;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.matchers.CapturesArguments;
import org.mockito.internal.matchers.VarargMatcher;

public class VarargCapturingMatcher<T>
extends ArgumentMatcher<T>
implements CapturesArguments,
VarargMatcher,
Serializable {
    private static final long serialVersionUID = 4057053345838026645L;
    private final LinkedList<List<T>> arguments = new LinkedList();

    @Override
    public boolean matches(Object object) {
        return true;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("<Capturing variable argument>");
    }

    public List<T> getLastVarargs() {
        if (this.arguments.isEmpty()) {
            new Reporter().noArgumentValueWasCaptured();
            return null;
        }
        return this.arguments.getLast();
    }

    public List<List<T>> getAllVarargs() {
        return this.arguments;
    }

    @Override
    public void captureFrom(Object object) {
        List<T> list = this.unpackAsList(object);
        this.arguments.add(list);
    }

    private List<T> unpackAsList(Object object) {
        if (object instanceof Object[]) {
            return Arrays.asList((Object[])object);
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = new Object[Array.getLength(object)];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = Array.get(object, i);
            }
            return Arrays.asList(objectArray);
        }
        return Collections.singletonList(object);
    }
}

