/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;

final class RopeByteString
extends ByteString {
    private static final int[] minLengthByDepth;
    private final int totalLength;
    private final ByteString left;
    private final ByteString right;
    private final int leftLength;
    private final int treeDepth;
    private static final long serialVersionUID = 1L;

    private RopeByteString(ByteString byteString, ByteString byteString2) {
        this.left = byteString;
        this.right = byteString2;
        this.leftLength = byteString.size();
        this.totalLength = this.leftLength + byteString2.size();
        this.treeDepth = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1;
    }

    static ByteString concatenate(ByteString byteString, ByteString byteString2) {
        int n;
        if (byteString2.size() == 0) {
            return byteString;
        }
        if (byteString.size() == 0) {
            return byteString2;
        }
        int n2 = byteString.size() + byteString2.size();
        if (n2 < 128) {
            return RopeByteString.concatenateBytes(byteString, byteString2);
        }
        if (byteString instanceof RopeByteString) {
            RopeByteString ropeByteString = (RopeByteString)byteString;
            if (ropeByteString.right.size() + byteString2.size() < 128) {
                ByteString byteString3 = RopeByteString.concatenateBytes(ropeByteString.right, byteString2);
                return new RopeByteString(ropeByteString.left, byteString3);
            }
            if (ropeByteString.left.getTreeDepth() > ropeByteString.right.getTreeDepth() && ropeByteString.getTreeDepth() > byteString2.getTreeDepth()) {
                RopeByteString ropeByteString2 = new RopeByteString(ropeByteString.right, byteString2);
                return new RopeByteString(ropeByteString.left, ropeByteString2);
            }
        }
        if (n2 >= minLengthByDepth[n = Math.max(byteString.getTreeDepth(), byteString2.getTreeDepth()) + 1]) {
            return new RopeByteString(byteString, byteString2);
        }
        return new Balancer().balance(byteString, byteString2);
    }

    private static ByteString concatenateBytes(ByteString byteString, ByteString byteString2) {
        int n = byteString.size();
        int n2 = byteString2.size();
        byte[] byArray = new byte[n + n2];
        byteString.copyTo(byArray, 0, 0, n);
        byteString2.copyTo(byArray, 0, n, n2);
        return ByteString.wrap(byArray);
    }

    static RopeByteString newInstanceForTest(ByteString byteString, ByteString byteString2) {
        return new RopeByteString(byteString, byteString2);
    }

    @Override
    public byte byteAt(int n) {
        RopeByteString.checkIndex(n, this.totalLength);
        if (n < this.leftLength) {
            return this.left.byteAt(n);
        }
        return this.right.byteAt(n - this.leftLength);
    }

    @Override
    public int size() {
        return this.totalLength;
    }

    @Override
    protected int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected boolean isBalanced() {
        return this.totalLength >= minLengthByDepth[this.treeDepth];
    }

    @Override
    public ByteString substring(int n, int n2) {
        int n3 = RopeByteString.checkRange(n, n2, this.totalLength);
        if (n3 == 0) {
            return ByteString.EMPTY;
        }
        if (n3 == this.totalLength) {
            return this;
        }
        if (n2 <= this.leftLength) {
            return this.left.substring(n, n2);
        }
        if (n >= this.leftLength) {
            return this.right.substring(n - this.leftLength, n2 - this.leftLength);
        }
        ByteString byteString = this.left.substring(n);
        ByteString byteString2 = this.right.substring(0, n2 - this.leftLength);
        return new RopeByteString(byteString, byteString2);
    }

    @Override
    protected void copyToInternal(byte[] byArray, int n, int n2, int n3) {
        if (n + n3 <= this.leftLength) {
            this.left.copyToInternal(byArray, n, n2, n3);
        } else if (n >= this.leftLength) {
            this.right.copyToInternal(byArray, n - this.leftLength, n2, n3);
        } else {
            int n4 = this.leftLength - n;
            this.left.copyToInternal(byArray, n, n2, n4);
            this.right.copyToInternal(byArray, 0, n2 + n4, n3 - n4);
        }
    }

    @Override
    public void copyTo(ByteBuffer byteBuffer) {
        this.left.copyTo(byteBuffer);
        this.right.copyTo(byteBuffer);
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray());
        return byteBuffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
        PieceIterator pieceIterator = new PieceIterator(this);
        while (pieceIterator.hasNext()) {
            ByteString.LeafByteString leafByteString = pieceIterator.next();
            arrayList.add(leafByteString.asReadOnlyByteBuffer());
        }
        return arrayList;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.left.writeTo(outputStream);
        this.right.writeTo(outputStream);
    }

    @Override
    void writeToInternal(OutputStream outputStream, int n, int n2) throws IOException {
        if (n + n2 <= this.leftLength) {
            this.left.writeToInternal(outputStream, n, n2);
        } else if (n >= this.leftLength) {
            this.right.writeToInternal(outputStream, n - this.leftLength, n2);
        } else {
            int n3 = this.leftLength - n;
            this.left.writeToInternal(outputStream, n, n3);
            this.right.writeToInternal(outputStream, 0, n2 - n3);
        }
    }

    @Override
    void writeTo(ByteOutput byteOutput) throws IOException {
        this.left.writeTo(byteOutput);
        this.right.writeTo(byteOutput);
    }

    @Override
    protected String toStringInternal(Charset charset) {
        return new String(this.toByteArray(), charset);
    }

    @Override
    public boolean isValidUtf8() {
        int n = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        int n2 = this.right.partialIsValidUtf8(n, 0, this.right.size());
        return n2 == 0;
    }

    @Override
    protected int partialIsValidUtf8(int n, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= this.leftLength) {
            return this.left.partialIsValidUtf8(n, n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.partialIsValidUtf8(n, n2 - this.leftLength, n3);
        }
        int n5 = this.leftLength - n2;
        int n6 = this.left.partialIsValidUtf8(n, n2, n5);
        return this.right.partialIsValidUtf8(n6, 0, n3 - n5);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ByteString)) {
            return false;
        }
        ByteString byteString = (ByteString)object;
        if (this.totalLength != byteString.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        int n = this.peekCachedHashCode();
        int n2 = byteString.peekCachedHashCode();
        if (n != 0 && n2 != 0 && n != n2) {
            return false;
        }
        return this.equalsFragments(byteString);
    }

    private boolean equalsFragments(ByteString byteString) {
        int n = 0;
        PieceIterator pieceIterator = new PieceIterator(this);
        ByteString.LeafByteString leafByteString = (ByteString.LeafByteString)pieceIterator.next();
        int n2 = 0;
        PieceIterator pieceIterator2 = new PieceIterator(byteString);
        ByteString.LeafByteString leafByteString2 = (ByteString.LeafByteString)pieceIterator2.next();
        int n3 = 0;
        while (true) {
            boolean bl;
            int n4 = leafByteString.size() - n;
            int n5 = leafByteString2.size() - n2;
            int n6 = Math.min(n4, n5);
            boolean bl2 = bl = n == 0 ? leafByteString.equalsRange(leafByteString2, n2, n6) : leafByteString2.equalsRange(leafByteString, n, n6);
            if (!bl) {
                return false;
            }
            if ((n3 += n6) >= this.totalLength) {
                if (n3 == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (n6 == n4) {
                n = 0;
                leafByteString = (ByteString.LeafByteString)pieceIterator.next();
            } else {
                n += n6;
            }
            if (n6 == n5) {
                n2 = 0;
                leafByteString2 = (ByteString.LeafByteString)pieceIterator2.next();
                continue;
            }
            n2 += n6;
        }
    }

    @Override
    protected int partialHash(int n, int n2, int n3) {
        int n4 = n2 + n3;
        if (n4 <= this.leftLength) {
            return this.left.partialHash(n, n2, n3);
        }
        if (n2 >= this.leftLength) {
            return this.right.partialHash(n, n2 - this.leftLength, n3);
        }
        int n5 = this.leftLength - n2;
        int n6 = this.left.partialHash(n, n2, n5);
        return this.right.partialHash(n6, 0, n3 - n5);
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(new RopeInputStream());
    }

    @Override
    public InputStream newInput() {
        return new RopeInputStream();
    }

    Object writeReplace() {
        return ByteString.wrap(this.toByteArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("RopeByteStream instances are not to be serialized directly");
    }

    static {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = 1;
        int n3 = 1;
        while (n3 > 0) {
            arrayList.add(n3);
            n = n2 + n3;
            n2 = n3;
            n3 = n;
        }
        arrayList.add(Integer.MAX_VALUE);
        minLengthByDepth = new int[arrayList.size()];
        for (n = 0; n < minLengthByDepth.length; ++n) {
            RopeByteString.minLengthByDepth[n] = (Integer)arrayList.get(n);
        }
    }

    private class RopeInputStream
    extends InputStream {
        private PieceIterator pieceIterator;
        private ByteString.LeafByteString currentPiece;
        private int currentPieceSize;
        private int currentPieceIndex;
        private int currentPieceOffsetInRope;
        private int mark;

        public RopeInputStream() {
            this.initialize();
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                throw new IndexOutOfBoundsException();
            }
            return this.readSkipInternal(byArray, n, n2);
        }

        @Override
        public long skip(long l) {
            if (l < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            return this.readSkipInternal(null, 0, (int)l);
        }

        private int readSkipInternal(byte[] byArray, int n, int n2) {
            int n3;
            int n4;
            for (n3 = n2; n3 > 0; n3 -= n4) {
                this.advanceIfCurrentPieceFullyRead();
                if (this.currentPiece == null) {
                    if (n3 != n2) break;
                    return -1;
                }
                int n5 = this.currentPieceSize - this.currentPieceIndex;
                n4 = Math.min(n5, n3);
                if (byArray != null) {
                    this.currentPiece.copyTo(byArray, this.currentPieceIndex, n, n4);
                    n += n4;
                }
                this.currentPieceIndex += n4;
            }
            return n2 - n3;
        }

        @Override
        public int read() throws IOException {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                return -1;
            }
            return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
        }

        @Override
        public int available() throws IOException {
            int n = this.currentPieceOffsetInRope + this.currentPieceIndex;
            return RopeByteString.this.size() - n;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int n) {
            this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
        }

        @Override
        public synchronized void reset() {
            this.initialize();
            this.readSkipInternal(null, 0, this.mark);
        }

        private void initialize() {
            this.pieceIterator = new PieceIterator(RopeByteString.this);
            this.currentPiece = this.pieceIterator.next();
            this.currentPieceSize = this.currentPiece.size();
            this.currentPieceIndex = 0;
            this.currentPieceOffsetInRope = 0;
        }

        private void advanceIfCurrentPieceFullyRead() {
            if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
                this.currentPieceOffsetInRope += this.currentPieceSize;
                this.currentPieceIndex = 0;
                if (this.pieceIterator.hasNext()) {
                    this.currentPiece = this.pieceIterator.next();
                    this.currentPieceSize = this.currentPiece.size();
                } else {
                    this.currentPiece = null;
                    this.currentPieceSize = 0;
                }
            }
        }
    }

    private static class PieceIterator
    implements Iterator<ByteString.LeafByteString> {
        private final Stack<RopeByteString> breadCrumbs = new Stack();
        private ByteString.LeafByteString next;

        private PieceIterator(ByteString byteString) {
            this.next = this.getLeafByLeft(byteString);
        }

        private ByteString.LeafByteString getLeafByLeft(ByteString byteString) {
            ByteString byteString2 = byteString;
            while (byteString2 instanceof RopeByteString) {
                RopeByteString ropeByteString = (RopeByteString)byteString2;
                this.breadCrumbs.push(ropeByteString);
                byteString2 = ropeByteString.left;
            }
            return (ByteString.LeafByteString)byteString2;
        }

        private ByteString.LeafByteString getNextNonEmptyLeaf() {
            ByteString.LeafByteString leafByteString;
            do {
                if (!this.breadCrumbs.isEmpty()) continue;
                return null;
            } while ((leafByteString = this.getLeafByLeft(this.breadCrumbs.pop().right)).isEmpty());
            return leafByteString;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ByteString.LeafByteString next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ByteString.LeafByteString leafByteString = this.next;
            this.next = this.getNextNonEmptyLeaf();
            return leafByteString;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Balancer {
        private final Stack<ByteString> prefixesStack = new Stack();

        private Balancer() {
        }

        private ByteString balance(ByteString byteString, ByteString byteString2) {
            this.doBalance(byteString);
            this.doBalance(byteString2);
            ByteString byteString3 = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty()) {
                ByteString byteString4 = this.prefixesStack.pop();
                byteString3 = new RopeByteString(byteString4, byteString3);
            }
            return byteString3;
        }

        private void doBalance(ByteString byteString) {
            if (byteString.isBalanced()) {
                this.insert(byteString);
            } else if (byteString instanceof RopeByteString) {
                RopeByteString ropeByteString = (RopeByteString)byteString;
                this.doBalance(ropeByteString.left);
                this.doBalance(ropeByteString.right);
            } else {
                throw new IllegalArgumentException("Has a new type of ByteString been created? Found " + byteString.getClass());
            }
        }

        private void insert(ByteString byteString) {
            int n = this.getDepthBinForLength(byteString.size());
            int n2 = minLengthByDepth[n + 1];
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= n2) {
                this.prefixesStack.push(byteString);
            } else {
                ByteString byteString2;
                int n3 = minLengthByDepth[n];
                ByteString byteString3 = this.prefixesStack.pop();
                while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < n3) {
                    byteString2 = this.prefixesStack.pop();
                    byteString3 = new RopeByteString(byteString2, byteString3);
                }
                byteString3 = new RopeByteString(byteString3, byteString);
                while (!this.prefixesStack.isEmpty()) {
                    n = this.getDepthBinForLength(byteString3.size());
                    n2 = minLengthByDepth[n + 1];
                    if (this.prefixesStack.peek().size() >= n2) break;
                    byteString2 = this.prefixesStack.pop();
                    byteString3 = new RopeByteString(byteString2, byteString3);
                }
                this.prefixesStack.push(byteString3);
            }
        }

        private int getDepthBinForLength(int n) {
            int n2 = Arrays.binarySearch(minLengthByDepth, n);
            if (n2 < 0) {
                int n3 = -(n2 + 1);
                n2 = n3 - 1;
            }
            return n2;
        }
    }
}

